<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" indent="yes" />

	<!-- Suche den Wurzelknoten -->
	<xsl:template match="/">
		<!-- baue erst einmal einen ordentlichen Header -->
		<html>
			<head>
				<xsl:comment>Tabelle </xsl:comment>
				<xsl:comment>automatisch generiert durch XSL-Stylesheet </xsl:comment>
				<xsl:comment>von Benjamin Benz (bbe@heise.de)</xsl:comment>
				<title>Tabellen-Demo: 8. XSL-Vodoo</title>
				<!-- Binde Java-Script und CSS-Stylesheet ein -->
				<script src="tabelle.js" type="text/javascript"></script>
				<link rel="stylesheet" type="text/css" href="tabelle.css"/>		
			</head>
			
			<!-- baue einen Body -->
			<body>
			
				<a href="tabelle_01.html">1. Vorbereitung</a><br/>
				<a href="tabelle_02.html">2. Festgezurrt</a><br/>
				<a href="tabelle_03.html">3. Bewegung</a><br/>
				<a href="tabelle_04.html">4. Feinschliff</a><br/>
				<a href="tabelle_05.html">5. Verschwindezauber</a><br/>
				<a href="tabelle_06.html">6. Erscheinungszauber</a><br/>
				<a href="tabelle_07.html">7. Schönheitsoperation</a><br/>
				<a href="tabelle_08.xml">8. XSL-Vodoo</a><br/>

				<h1>8. XSL-Vodoo</h1>
					
			  <!-- Nun suche nach der ersten Tabelle in der xml-Datei und Parse sie -->
				<xsl:apply-templates select="//table[1]"/>
			</body>
		</html>
  </xsl:template>
			
	<!-- Dieses Template parst eine Tabelle -->
  <xsl:template match="table">
				<xsl:comment>Sicherheitshalber einen globalen Container um alles, der kann spaeter die Groesse festlegen </xsl:comment>
				<div id="container" class="container">
					<table>
						<xsl:comment> Container-Zeile fuer die Kopfzeile </xsl:comment>
						<tr>
							<xsl:comment> Zelle 0/0 in Kopfzeile (unbeweglich) mit Hilfsevent, um Tabelle neu zu formatieren</xsl:comment>
							<td>
								<div id="corner" class="innerDiv" onclick="reset()">
									<xsl:comment> Inhalt von Zelle 0/0 </xsl:comment> 
									<!-- Zelleninhalt kopieren -->
									<xsl:value-of select=".//tr[1]/td[1]"/>
								</div>
							</td>
							<xsl:comment>Container-Zelle fuer bewegliche Spaltenkoepfe</xsl:comment>
							<td>
								<xsl:comment>Horizontal scrollbarer Container</xsl:comment>
								<div id="columnHeads" class="columns">	
									<xsl:comment> Rest der Kopfzeile in einer eigenen Sub-Tabelle(horizontal beweglich) </xsl:comment> 
									<table class="inner">		
										<tr>
											<xsl:comment> TDs der Zeile mit den Spaltenkoepfen, inkl div-Tags und toggleColumn </xsl:comment>
											<!-- Schleife ueber alle Elemente der ersten Zeile der Quell-Tabelle -->
											<xsl:for-each select=".//tr[1]/td[position()>1]">
												<td>
													<div class="innerDiv" onclick="toggleColumn({position()-1})">
														<!-- Zelleninhalt kopieren -->
														<xsl:value-of select="."/>
													</div>
												</td>
											</xsl:for-each>
										</tr>	
									</table>
								</div>
							</td>
						</tr>
						
						<xsl:comment>Container-Zeile fuer alle weiteren Zellen</xsl:comment>
						<tr>
							<xsl:comment> Container-Zelle fuer Zeilenkoepfe </xsl:comment>
							<td>
								<xsl:comment> Die Zeilenkoepfe in einer eigenen Sub-Tabelle (vertikal beweglich) </xsl:comment>
								<div id="rowHeads" class="rows">
									<table class="inner">
										<xsl:comment> TRs der Spalte mit den Zeilenkoepfen, inkl div-Tags und toggleRow </xsl:comment>
										<!-- Schleife ueber alle Zeilen der Quell-Tabelle -->
										<xsl:for-each select=".//tr[position()>1]">
											<!-- Erste Zeile auslassen, die ist schon erledigt-->
											<tr>
												<td><div class="innerDiv" onclick="toggleRow({position()-1})">
													<!-- Zelleninhalt kopieren -->
													<xsl:value-of select="./td[1]"/>
												</div></td>
											</tr>
										</xsl:for-each>
									</table>
								</div>
							</td>

							<xsl:comment> Container-Zelle fuer alle uebrigen Daten-Zellen </xsl:comment>
							<td>
								<xsl:comment> Scrollbare Sektion in der Container-Zelle </xsl:comment>
								<div id="data" class="data" onscroll="scrollData()" >
									<xsl:comment> Sub-Tabelle mit den restlichen Zellen (vertikal und horizontal scrollbar) </xsl:comment>
									<table class="inner">
										<xsl:comment> Daten mit div-Tags </xsl:comment>
										<!-- Erste Zeile auslassen, die ist schon erledigt-->
										<xsl:apply-templates select=".//tr[position()>1]" />
									</table>
								</div>
							</td>
						</tr>
					</table>
				</div>	
  </xsl:template>

  <xsl:template match="tr">
		<tr>
			<!-- jeweils die erste Spalte auslassen, die ist schon erledigt-->
			<xsl:apply-templates select="./td[position()>1]"/>
		</tr>
  </xsl:template>
  
  <xsl:template match="td">
		<td>
			<div class="innerDiv">
				<!-- Zelleninhalt kopieren -->
				<xsl:value-of select="."/>				
			</div>
		</td>
  </xsl:template>
</xsl:stylesheet>
