unit gmUnit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, TeEngine, Series, TeeProcs, Chart, Menus,
  ComCtrls;

type tMySimThread =class (TThread)
     private
     protected
     procedure execute; override;
     public
     event:Cardinal;
     end;

Type tMyCTRLThread =class (TThread)
     private
     protected
     procedure execute; override;
     public
     event:Cardinal;
     end;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    lCommstr1: TLabel;
    lCommstr2: TLabel;
    lCommstr0: TLabel;
    lModemStatus: TLabel;
    Chart1: TChart;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    Beenden1: TMenuItem;
    N1: TMenuItem;
    Druckereinrichtung1: TMenuItem;
    Drucken1: TMenuItem;
    N2: TMenuItem;
    Speichernunter1: TMenuItem;
    Speichern1: TMenuItem;
    ffnen1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    OpenDialog2: TOpenDialog;
    Timer1: TTimer;
    RS1: TMenuItem;
    StatusBar1: TStatusBar;
    cLog: TCheckBox;
    bReset: TButton;
    bLogCtl: TButton;
    GroupBox1: TGroupBox;
    cDTR: TCheckBox;
    cRTS: TCheckBox;
    cBreak: TCheckBox;
    Series1: TBarSeries;
    eCOM: TLabeledEdit;
    eIntervall: TLabeledEdit;
    procedure FormCreate(Sender: TObject);
    procedure showEventMask;
    procedure showmodstat;
    procedure ffnen1Click(Sender: TObject);
    function  logindata (ab,anz:integer):integer;
    procedure Loaddata (const filename:string);
    procedure Init;
    procedure Timer1Timer(Sender: TObject);
    procedure LoginCom (const comchar:string);
    Procedure ShowCom;
    procedure Speichern1Click(Sender: TObject);
    procedure Speichernunter1Click(Sender: TObject);
    procedure bResetClick(Sender: TObject);
    procedure bLogCtlClick(Sender: TObject);
    procedure cDTRClick(Sender: TObject);
    procedure cRTSClick(Sender: TObject);
    procedure cBreakClick(Sender: TObject);
    Procedure showEvent(var aMessage:TMessage); message WM_USER;
    procedure eCOMKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private

    timeout:boolean;
    stop:boolean;
    initok:boolean;
    mcount:integer;
    { Private-Deklarationen }
  public

    { Public-Deklarationen }
  end;

type TLED= record
           ison:boolean;
           name:string;
           end;
type
 tmypanel = class(TPanel)
    constructor create (aOwner:TWinControl;LEDs:integer; Pcolor:Tcolor);
    private
    FOnPaint: TNotifyEvent;
  protected
    procedure Paint; override;
  public
     LEDarray:array of TLED;

    property Canvas;
  published
    property OnPaint: TNotifyEvent read FOnPaint write FOnPaint;

  end;


var
  Form1: TForm1;
  modstatus:Tmypanel;
  LastPower:double=0.0;
  inputcount:integer=0;
  lastcount:integer=0;
  runtime:double;
  intervall:integer;

  const fBinary  =31;
  const fParity  =30;
  const fOutxCtsFlow  =29;
  const fOutxDsrFlow  =28;
  const fDtrControl  =26; //+27
  const fDsrSensitivity  =25;
  const fTXContinueOnXoff  =24;
  const fOutX  =23;
  const fInX  =22;
  const fErrorChar  =21;
  const fNull  =20;
  const fRtsControl  =18; //+19
  const fAbortOnError  =17;
  const fDummy2  =0;




implementation

{$R *.dfm}
Type string5=string[5];
var


  curr_cts:integer=0;
  curr_dsr:integer=0;
  curr_ring:integer=0;
  curr_rlsd:integer=0;
  aparity:char='N';
  aStopbits:string[3]='?';
var
  linefeed:string=#$0A;
var
   hcom:Thandle;
   currentCOM:string[1];
   lpmodstat:longword;
   Baudindex:integer;
   DCB:TDCB;
   eventmask:Cardinal;
   ComStat: TComStat;
   Errors: dword;

var  SimThread:TmySimThread;
var  CtrlThread:TmyCtrlThread;

const EnumBaudrate:array[0..13] of Cardinal=
 (110,300,600,1200,2400,4800,9600,14400,19200,38400,56000,57600,128000,256000);

const ev_timer=0; ev_count=1;ev_perfa=2; ev_perfe=3;
var qe,qa,qf:int64;

Procedure TmySimThread.execute;
 begin
  repeat
  //sleep(Random(3000));
  sleep (10);
  queryperformancecounter(qa);
  sendMessage (Form1.handle,WM_User+0,ev_perfa,longword(qa));
  setCommBreak(hCOM);
  sleep (10);
  ClearCommBreak(hCOM);
  until terminated;
 end;

const tmin=20e-6;




Procedure TmyCTRLThread.execute;

var toggle:boolean;
var status:boolean;
 begin
  toggle:=true;
  repeat
  status:=waitcommevent (hcom,event,nil);
  if not status then exit;
   if ((event and EV_CTS) > 0) then
    begin
    if toggle then
     begin
     queryperformancecounter(qe);
    //sendmessage (Form1.Handle,WM_COMEVENT,EV_CTS,0);
     inc (inputcount);
     sendMessage (Form1.handle,WM_User+0,ev_count,inputcount);
     end
    else
     begin
     queryperformancecounter(qa);
     sendMessage (Form1.handle,WM_User+0,ev_perfa,longword(qa));
     end;
    toggle:=not toggle;
    end;
  until terminated;
 end;



procedure TMyPanel.Paint;
var i:integer;
begin
  inherited Paint;
  if Assigned(FOnPaint) then FOnPaint(Self);


  Canvas.Pen.Color:=clblack;
  for i:=0 to length(LEDarray)-1 do with LEDarray[i] do
   begin
   if ison then  Canvas.Brush.Color:=clgreen
           else  Canvas.Brush.Color:=clwhite;
   Canvas.Ellipse( 5, 5+20*i, 15, 15+20*i);
   Canvas.Brush.Color:=Color;
   Canvas.TextOut(18,3+20*i,name);
   end;
end;

constructor TMyPanel.Create (aOwner:TWinControl; LEDs:integer;PColor:Tcolor);
 begin
 Inherited Create (aOwner);
 setLength(LEDarray,LEDs);
 top:=Form1.lModemstatus.top+Form1.lModemstatus.height+2;
 left:=Form1.lModemStatus.left;
 width:=60;
 height:=LEDs*20;
 Color:=Pcolor;
 parent:=aOwner;
 end;

Procedure TForm1.showEventMask;

begin
GetCommmask (hcom,eventmask);
lCommstr2.Caption:=lCommstr2.Caption+' evtmsk:'+inttohex (eventmask,8);
end;

procedure TForm1.showmodstat;
begin
if not GetCommModemStatus (hcom,lpmodstat) then
 begin
  showmessage ('Fehler beim Modemstatus');
 end;
if (lpmodstat and MS_CTS_ON) >0 then curr_cts:=1 else curr_cts:=0;
if (lpmodstat and MS_DSR_ON) >0 then curr_dsr:=1 else curr_dsr:=0;
if (lpmodstat and MS_RING_ON) >0 then curr_ring:=1 else curr_ring:=0;
if (lpmodstat and MS_RLSD_ON) >0 then curr_rlsd:=1 else curr_rlsd:=0;
Modstatus.LEDarray[0].ison:=curr_cts=1;
Modstatus.LEDarray[1].ison:=curr_dsr=1;
Modstatus.LEDarray[2].ison:=curr_ring=1;
Modstatus.LEDarray[3].ison:=curr_rlsd=1;
Modstatus.refresh;
end;


function SetupCOMPort (RxBufferSize, TxBufferSize:integer) : Boolean;
  
var

  CommTimeouts: TCommTimeouts;
begin
   { We assume that the setup to configure the setup works fine.
     Otherwise the function returns false.

     wir gehen davon aus das das Einstellen des COM Ports funktioniert.
     sollte dies fehlschlagen wird der Rckgabewert auf "FALSE" gesetzt.
   }

  Result := True;

  if not SetupComm(hCOM, RxBufferSize, TxBufferSize) then
    Result := False;

 (*
  Config := 'baud=9600 parity=n data=8 stop=1';

  if not BuildCommDCB(@Config[1], DCB) then
    Result := False;

  if not SetCommState(ComFile, DCB) then
    Result := False;

  *)

  with CommTimeouts do
  begin
    ReadIntervalTimeout         := MAXDWORD;
    ReadTotalTimeoutMultiplier  := 0;
    ReadTotalTimeoutConstant    := 0;
    WriteTotalTimeoutMultiplier := 10;
    WriteTotalTimeoutConstant   := 50;
  end;

  if not SetCommTimeouts(hCom, CommTimeouts) then
    Result := False;
end;



Procedure Tform1.LoginCom (const comchar:string);
var comstr:string;
begin
  comstr:='COM'+comchar+':';
  hcom:=CreateFile (Pchar(Comstr), GENERIC_READ or GENERIC_WRITE,0, Nil,open_existing,FILE_FLAG_OVERLAPPED,0);
 If hcom=INVALID_HANDLE_VALUE then
 begin
  showmessage ('Kann Comport '+comstr+' nicht ffnen');
  currentCOM:='x';
 end
 else currentCOM:=comchar;

end;

Procedure TForm1.ShowCom;
var i:integer;
begin

if not GetCommState (hcom,DCB) then
 begin
 showmessage ('Fehler beim GetCommState');
 end;

Baudindex:=-1;

For i:=0 to high (EnumBaudRate) do
 if DCB.BaudRate=EnumBaudRate[i] then begin Baudindex:=i; break; end;


case DCB.Parity of
    0:aparity:='N';
    1:aparity:='O';
    2:aparity:='E';
    3:aparity:='M';
    4:aparity:='S';
    end;

case DCB.stopbits of
     0:astopbits:='1';
     1:astopbits:='1.5';
     2:astopbits:='2';
     end;



 with dcb do
 begin
 lcommstr0.caption:= 'COM'+eCOM.Text;
 lcommstr1.caption:= Format ('Baudrate %d flags=%x XonLim=%x XoffLim=%x size=%d Parity=%s Stopbits=%s res1=%x res2=%x',
  [Baudrate,flags,XonLim,XoffLim,Bytesize,aParity,aStopbits,wReserved,wReserved1]);
  lcommstr2.Caption:=Format ('characters: Xon=$%x,Xoff=$%x,Error=$%x,Eof=$%x,Evt=$%x',
  [byte (XonChar), byte(XoffChar), byte(Errorchar), byte(EofChar), byte(EvtChar)]);

 end;


 With Modstatus do
  begin
   LEDarray[0].name:='CTS';
   LEDarray[1].name:='DSR';
   LEDarray[2].name:='Ring';
   LEDarray[3].name:='RLSD';
  end;


 showEventMask;
 showmodstat;
end;




procedure TForm1.FormCreate(Sender: TObject);
var para,value:string;
var i,p:integer;
 begin
 Form1.width:=800; if screen.Width>= 1048 then width:=1024;
 for i:=1 to paramcount do
 begin
 para:=uppercase(paramstr(i));
 if (para[1]='/') or (para[1]='-') and (length(para) > 1) then
  begin
   p:=pos('=',para);
   if p> 0 then begin value:=copy (para,p+1,length(para)); para:=uppercase (copy (para,2,p-2)); end;
   if copy (para,2,3)='COM'  then begin if para[5] in ['1'..'9'] then ecom.text:=para[5] end
   else if para='DATA' then loaddata (value);
  end;
 end;
 queryPerformanceFrequency(qf);
 LoginCom (ecom.text);
 Modstatus:=Tmypanel.Create(self,4,ClSkyBlue);
 init;
end;

Procedure GetComStat;
begin
 FillChar( ComStat, SizeOf( ComStat ), #0 );
 ClearCommError(hCOM, Errors, @ComStat );
end;

procedure CloseCOMPort;
begin
  // finally close the COM Port!
  // nicht vergessen den COM Port wieder zu schliessen!
  CloseHandle(hcom);
end;


Function TForm1.Logindata(ab,anz:integer):integer;
var Wert:double;
var Wertstr:string;
var i,p,res:integer;

begin
series1.Clear;
result:=0;
for i:=ab to memo1.lines.Count-1 do
 begin

  wertstr:=trim(memo1.lines[i]);
  p:=pos(' ',wertstr);
  if p=0 then p:=length(wertstr);
  wertstr:=trim(copy (wertstr,1,p));
  p:=pos (',',wertstr);
  if p > 0 then wertstr[p]:='.';
  val (wertstr,wert,res);
  if res <> 0 then
   begin
   showmessage ('oops, wrong value in data');
   Result:=memo1.lines.Count;
   exit;
   end;
   series1.Addy(wert);
  end;
  Result:=memo1.lines.count-ab;
end;



procedure TForm1.Loaddata (const filename:string);
var i:integer;
begin
 opendialog1.filename:=filename;
 memo1.Lines.LoadFromFile(filename);
 chart1.visible:=true;
 if Form1.Width < 1048 then
  begin
  if screen.Width> 1048 then Form1.Width:=1048 else Form1.Width:=Screen.width;
  end;


 i:=0;
 while i < memo1.lines.Count do
  begin
  if memo1.lines[i]='[DATA]' then inc (i,logindata (i+1,1))
  else inc (i);
  end;
with chart1.title.Text do
 begin
 clear;
 add ('data');
 end;
end;




procedure TForm1.ffnen1Click(Sender: TObject);
begin
 if opendialog1.Execute then Loaddata (opendialog1.filename);
end;







procedure TForm1.Init;
begin
 Memo1.Lines.Clear;
 if (hcom=0) then Logincom (ecom.text);
 SetupComPort (128,128);
 Showcom;
 setCOMMBreak (hcom);
 sleep (500);
 ClearCOMMBreak (hcom);
end;





procedure TForm1.Speichern1Click(Sender: TObject);
begin
 memo1.Lines.SaveToFile('log.txt');
end;

procedure TForm1.Speichernunter1Click(Sender: TObject);
begin
if saveDialog1.Execute then
 begin
  memo1.Lines.SaveToFile(SaveDialog1.FileName);
 end;
end;

procedure TForm1.bResetClick(Sender: TObject);
begin
 Memo1.Lines.Clear;
 series1.Clear;
 inputcount:=0;
 lastcount:=0;
 runtime:=0.0;
 intervall:=0;
 Chart1.BottomAxis.DateTimeFormat := 'hh:mm:ss';
 series1.AddXY(Gettime +strtoint(eIntervall.Text)/86400/2000,0);
end;



procedure TForm1.bLogCtlClick(Sender: TObject);
var qf:int64;
begin
if bLogCtl.tag=1 then
 begin
 CtrlThread.Terminate;
 SetCommMask (hcom,0); // generates commevent with event=0;
 WaitforsingleObject (CTrlThread.Handle,3000);
 CtrlThread.Destroy;
 bLogCtl.Caption:='run';
 bLogCtl.tag:=0;
 timer1.enabled:=false;
 end
else
 begin
 chart1.visible:=true;
 cDTR.checked:=false;
 cRTS.checked:=true;
 series1.XValues.DateTime:=true;
 bresetclick(self);
 if not SetCommMask (hcom,EV_CTS) then  begin Form1.memo1.lines.add ('oops, Error setting EventMask'); exit end;
 CTRLThread:=TMyCTRLThread.create (false);
 timer1.enabled:=true;
 timer1.Interval:=strtoint(eIntervall.Text);
 bLogCtl.Caption:='stopp';
 blogCtl.tag:=1;
 end;
end;

Procedure Tform1.showEvent(var aMessage:TMessage);
begin
 showmodstat;

 case aMessage.WParamLo of
 ev_timer:
  begin
  inc (intervall);
  memo1.lines.add (inttostr(intervall)+':'+inttostr(inputcount)+' '+inttostr(aMessage.LParam));
  if runtime < 500000 then Chart1.BottomAxis.DateTimeFormat := 'hh:mm:ss'
  else   Chart1.BottomAxis.DateTimeFormat := 'hh:mm';
  series1.AddXY(Gettime +strtoint(eIntervall.Text)/86400/2000,0);
  end;
 ev_count:
  begin
  if cLog.Checked then
   begin
   series1.yValue[series1.Count-1]:=series1.yValue[series1.Count-1]+0.01;
   memo1.lines.Add(inttostr(inputcount)+' '+floattostr((qe-qa)*1.0/(qf*1.0)));
   end;
  //beep;
  end;
 ev_perfa:
  begin

  end;
 ev_perfe:
  begin

  end;

 end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
 Timer1.Enabled:=true;
 runtime:=runtime+strtoint(eIntervall.Text);
 sendMessage (handle,WM_User+0,ev_timer,inputcount-lastcount);
 lastcount:=inputcount;
end;


procedure TForm1.cDTRClick(Sender: TObject);
begin
if cDTR.Checked then  EscapeCommFunction (hCOM,SETDTR) else  EscapeCommFunction (hCOM,CLRDTR);
ShowModstat;
end;


procedure TForm1.cRTSClick(Sender: TObject);
begin
if cRTS.Checked then  EscapeCommFunction (hCOM,SETRTS) else  EscapeCommFunction (hCOM,CLRRTS);
ShowModstat;
end;


procedure TForm1.cBreakClick(Sender: TObject);
begin
if cBreak.CHecked then setCommBreak(hCOM) else ClearCommBreak(hCOM);
ShowModstat;
end;




procedure TForm1.eCOMKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if ecom.text='' then exit;
 if ecom.text=currentcom then exit;
 if currentcom <> 'x' then CloseCOMPort;
 Logincom(ecom.text);
 showcom;
end;



end.
