{***************************************************************************}
{*******         INCLUDE - DATEI fr TOPTEXT-Setup                   *******}
{***************************************************************************}

{***************************************************************************}
Procedure savesetup;
CONST SetupName = 'setup.vtx';
VAR 
  setupdat : text;
  SHelp    : string;
BEGIN
  assign (setupdat, Setupname);
{$I-}
  REWRITE (setupdat);
{$I+}
  IF IOResult <> 0 THEN BEGIN
    Fehler (46,8,StrKannSetupNichtAbspeichern);
    Halt(1);
  end
  ELSE BEGIN
    writeln (setupdat, teledir);
    str (timeout, SHELP);
    writeln (setupdat, SHelp);
    str (timeouttop, SHelp);
    writeln (setupdat, SHELP);
    str (timeoutUPs, SHelp);
    writeln (setupdat, SHELP);
    str (TOPTime DIV 60, SHelp);
    writeln (setupdat, SHelp);
    str (TOPTEXTcct, SHelp);
    writeln (setupdat, SHELP);
    str (Abstand, SHelp);
    writeln (setupdat, SHELP);
    str (Verzoegerung, SHelp);
    writeln (setupdat, SHELP);
    str (SenderOutTime, SHelp);
    writeln (setupdat, SHELP);
    IF parity THEN SHELP := 'J'
              else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF cct0freigabe THEN SHELP := 'J'
                    else SHelp := 'N';
    writeln (setupdat, SHELP);
    str (AnzSubPageSoll, SHelp);
    writeln (setupdat, SHELP);
    IF ADIPSortieren  THEN SHELP := 'J'
                      else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF Videotextzeichen THEN SHELP := 'J'
                        else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF Videotextfarben THEN SHELP := 'J'
                       else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF Zeichen8x16 THEN SHELP := 'J'
                   else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF Seitenkontrolle THEN SHELP := 'J'
                       else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF Multitask THEN SHELP := 'J'
                 else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF Nowait THEN SHELP := 'J'
              else SHelp := 'N';
    writeln (setupdat, SHELP);
    IF ELVDekoder THEN SHelp := 'ELV'
    ELSE IF LPTDekoder THEN SHelp := 'LPT'
    ELSE IF CTDekoder THEN SHelp := 'CT'
    ELSE SHelp:= 'PORT';
    writeln (setupdat, SHELP);
    str (I2CBasis, SHelp);
    writeln (setupdat, SHELP);
    str (SDAADDR, SHelp);
    writeln (setupdat, SHELP);
    str (SDAMASKE, SHelp);
    writeln (setupdat, SHELP);
    IF SDAINV=0 THEN SHelp:='J'
                ELSE SHelp:='N';
    writeln (setupdat, SHELP);
    str (SDAINADDR, SHelp);
    writeln (setupdat, SHELP);
    str (SDAINMASKE, SHelp);
    writeln (setupdat, SHELP);
    IF SDAININV<>0 THEN SHelp:='J'
                   ELSE SHelp:='N';
    writeln (setupdat, SHELP);
    str (SCLADDR, SHelp);
    writeln (setupdat, SHELP);
    str (SCLMASKE, SHelp);
    writeln (setupdat, SHELP);
    IF SCLINV=0 THEN SHelp:='J'
                ELSE SHelp:='N';
    writeln (setupdat, SHELP);
    close (setupdat);
  END;
END;

{***************************************************************************}
Procedure loadsetup;
CONST  SetupName = 'setup.vtx';
VAR
  setupdat : text;
  ok       : word;
  SHelp    : string;
BEGIN
  assign (setupdat, Setupname);
{$I-}
  RESET (setupdat);
{$I+}
  IF IOResult <> 0 THEN BEGIN
    NoSetupdatei := True;
    GetDir(0,teleDir);
    AnzSubPageSoll   := 24;
    TOPTime          := 10 * 60;  {Sekunden}
    TimeoutTOP       := 70;       {Sekunden}
    TimeoutUPs       := 70;       {Sekunden}
    TopTextcct       := 1;        {cct-1}
    timeout          := 45;       {Sekunden}
    abstand          := 20;       {Abstand zur Seitensuche }
    verzoegerung     := 15;       {Verzgerung der SCLL und SCLH-Routinen}
    SenderOutTime    := 15;       {berwachungsverzgerung Meldung Senderprfung}
    parity           := false;
    cct0freigabe     := true;
    ADIPSortieren    := true;
    Videotextzeichen := false;
    Videotextfarben  := false;
    Zeichen8x16      := false;
    Seitenkontrolle  := false;
    Multitask        := false;
    Nowait           := false;
    LPTDekoder       := true;
    CTDekoder        := false;
    ELVDekoder       := false;
    PortDekoder      := false;
    I2CBasis         := $300;
    SDAADDR          := 0;
    SDAMASKE         := 0;
    SDAINV           := 0;
    SCLADDR          := 0;
    SCLMASKE         := 0;
    SCLINV           := 0;
    SDAINADDR        := 0;
    SDAINMASKE       := 0;
    SDAININV         := 0;
    savesetup;
  end
  ELSE BEGIN
    NoSetupdatei := false;
    readln (setupdat, teledir);
    readln (setupdat, SHelp);
    val (SHelp, timeout, ok);
    readln (setupdat, SHelp);
    val (SHelp, timeoutTOP, ok);
    readln (setupdat, SHelp);
    val (SHelp, timeoutUPs, ok);
    readln (setupdat, SHelp);
    val (shelp, TOPTime, ok);
    TOPTime := TOPTime * 60;
    readln (setupdat, SHelp);
    val (SHelp, Toptextcct, ok);
    readln (setupdat, SHelp);
    val (SHelp, Abstand, ok);
    readln (setupdat, SHelp);
    val (SHelp, verzoegerung, ok);
    readln (setupdat, Shelp);
    val (SHelp, SenderOutTime, ok);
    readln (setupdat, Shelp);
    parity := (SHelp = 'J');
    readln (setupdat, Shelp);
    cct0freigabe := (SHelp = 'J');
    readln (setupdat, Shelp);
    val (SHelp, AnzSubPageSoll,ok);
    If AnzsubpageSoll < 12 THEN AnzSubPageSoll := 12;
    readln (setupdat, Shelp);
    ADIPSortieren := (SHelp = 'J');
    readln (setupdat, Shelp);
    Videotextzeichen := (SHelp = 'J');
    readln (setupdat, Shelp);
    Zeichen8x16 := (SHelp = 'J');
    readln (setupdat, Shelp);
    VideotextFarben := (SHelp = 'J');
    readln (setupdat, Shelp);
    Seitenkontrolle := (SHelp = 'J');
    readln (setupdat, Shelp);
    Multitask := (SHelp = 'J');
    readln (setupdat, Shelp);
    Nowait := (SHelp = 'J');
    Readln (setupDat, Shelp);
    LPTDekoder  := (SHelp = 'LPT');
    ELVDekoder  := (SHelp = 'ELV');
    CTDekoder   := (SHelp = 'CT');
    PortDekoder := (SHelp = 'PORT');
    readln (setupdat, SHelp);
    IF not LPTDekoder THEN
      val (SHelp, I2CBASIS, ok);
    readln (setupdat, SHelp);
    val (SHelp, SDAADDR, ok);
    readln (setupdat, SHelp);
    val (SHelp, SDAMASKE, ok);
    readln (setupdat, SHelp);
    IF SHelp='J' THEN SDAINV := 0
                 ELSE SDAINV := SDAMASKE;
    readln (setupdat, SHelp);
    val (SHelp, SDAINADDR, ok);
    readln (setupdat, SHelp);
    val (SHelp, SDAINMASKE, ok);
    readln (setupdat, SHelp);
    IF SHelp='J' THEN SDAININV := SDAINMASKE
                 ELSE SDAININV := 0;
    readln (setupdat, SHelp);
    val (SHelp, SCLADDR, ok);
    readln (setupdat, SHelp);
    val (SHelp, SCLMASKE, ok);
    readln (setupdat, SHelp);
    IF SHelp='J' THEN SCLINV := 0
                 ELSE SCLINV := SCLMASKE;
    close(setupdat);
    getdir (0, SHelp);
{$I-}
    chdir (teledir);
{$I+}
    IF ioresult <> 0 then
      getdir(0,teledir);
    chdir (SHelp);
  END;
  Senderkontrolle := SenderOutTime > 0;
END;

{***************************************************************************}
{*********                 SETUP- MEN                            **********}
{***************************************************************************}
procedure setup;
Var
  Testdat       : text;
  x, y, Wineing : word;
  Setupmenue    : word;
  Dauermenue    : word;
  Menuepos,MWin : word;
  Umenuepos,
  cctmenue      : word;
  IHelp,Lauf    : Integer;
  SHelp,Shelp1  : string;
  freig         : array [0..3] of Boolean;
  Menuestr      : array [0..3] of String[80];
  rc,urc,urc1   : t_staste;

{***************************************************************************}
procedure VGAVorgaben;
Var
  x,y                 : word;
  menue               : Word;
  Menuepos            : word;
  rc                  : t_staste;

Begin
  PUSHHelp ('VGAEINST.Hel');
  InitMenue (Menue,34,4,omitte,umitte,Menuetext[StrVGAEinstellungen],
                                      Menuetext[StrVGAEinstellungen+1]);
  x := 45;
  y := 13;
  OpenMenue (x,y,0,1,white,green,black,lightgray,Menue,
            links,doppelt);
  setmenueText(Menue,4,MenueText[StrVGAEinstellungen+5]);
  repeat
    IF Videotextzeichen THEN SHelp := MenueText[StrJa]
                        ELSE SHelp := MenueText[STrNein];
    setmenuetext(Menue,1,MenueText[StrVGaEinstellungen+2]+ SHelp);
    IF Zeichen8x16 THEN SHelp := MenueText[StrJa]
                   ELSE SHelp := MenueText[STrNein];
    setmenuetext(Menue,2,MenueText[StrVGaEinstellungen+3]+ SHelp);
    IF Videotextfarben THEN SHelp := MenueText[StrJa]
                       ELSE SHelp := MenueText[STrNein];
    setmenuetext(Menue,3,MenueText[StrVGaEinstellungen+4]+ SHelp);
    Getmenuepos (Menue,[cr,esc],Menuepos,rc);
    IF rc = cr THEN BEGIN
      CASE Menuepos of
        1: begin
             VideotextZeichen := NOT VideotextZeichen;
             If Videotextzeichen THEN
               SetzeVideotextzeichensatz
             else
               SetzeAsciiZeichensatz;
           end;
        2: begin
             Zeichen8x16:= NOT Zeichen8x16;
             If Zeichen8x16 THEN
               Setze8x16Matrix
             else
               Setze9x16Matrix;
           end;
        3: begin
             Videotextfarben := NOT Videotextfarben;
             If Videotextfarben THEN
               SetzeVideotextFarben
             else
               SetzeVGAFarben;
           end;
        4: Help(8,3,18);
      end;
    end; {rc = cr}
  until rc = esc;
  clearmenue(Menue);
  POPHelp;
END;

{***************************************************************************}
procedure getWinAddr (x,y,s:Word; VAR a:Word);
VAR
  i         : Word;
  Win       : Word;
  SHelp     : String;
  RC        : t_staste;
  EingabeOk : Boolean;
  IHelp     : Word;
BEGIN
  openwindow(x,y,28,3,white,blue,links,doppelt,win);
  Titelwindow(win,omitte,Menuetext[s]);
  REPEAT
    SHelp := '$'+ DecHex(a);
    GetwinCSelect (Win,1,4,yellow,['$',' ','0'..'9','A'..'F','a'..'f'],
                   SHelp,RC);
    For i := 1 to 4 DO
      Shelp[i] := UPCASE (SHelp[I]);
    IF RC = cr THEN BEGIN
      i := LENGTH (SHelp);
      While (SHelp[i] = ' ') AND (i > 0) DO BEGIN
        Dec (i);
        SHelp[0] := CHR(i);
      END;
      IF SHelp[1] = '$' THEN BEGIN
        EingabeOK := i = 4;
        IF EingabeOK THEN IHelp := HexDec(copy(SHelp,2,3));
      END
      ELSE BEGIN
        Val (SHelp, IHelp,i);
        EingabeOK := i = 0;
      END;
      IF NOT EingabeOK THEN
        Fehler (46,8,StrUngueltigeEingabe);
    END
    ELSE
      EingabeOK := true;
  UNTIL EingabeOK;
  IF RC = cr THEN a := IHelp;
  CLOSEWindow (Win);
END;

{***************************************************************************}
procedure getWinByte (x,y,s:Word; VAR b:Byte);
VAR
  i         : Word;
  Win       : Word;
  SHelp     : String;
  RC        : t_staste;
  EingabeOk : Boolean;
  IHelp     : Word;
BEGIN
  openwindow(x,y,28,3,white,blue,links,doppelt,win);
  Titelwindow(win,omitte,Menuetext[s]);
  REPEAT
    SHelp := '$'+ Copy(DecHex(b),2,2);
    GetwinCSelect (Win,1,3,yellow,['$',' ','0'..'9','A'..'F','a'..'f'],
                   SHelp,RC);
    For i := 1 to 3 DO
      Shelp[i] := UPCASE (SHelp[I]);
    IF RC = cr THEN BEGIN
      i := LENGTH (SHelp);
      While (SHelp[i] = ' ') AND (i > 0) DO BEGIN
        Dec (i);
        SHelp[0] := CHR(i);
      END;
      IF SHelp[1] = '$' THEN BEGIN
        EingabeOK := i = 3;
        IF EingabeOK THEN IHelp := HexDec('0'+copy(SHelp,2,2));
      END
      ELSE BEGIN
        Val (SHelp, IHelp,i);
        EingabeOK := i = 0;
      END;
      IF NOT IHelp IN [$01,$02,$04,$08,$10,$20,$40,$80]
        THEN Eingabeok := false;
      IF NOT EingabeOK THEN
        Fehler (46,8,StrUngueltigeEingabe);
    END
    ELSE
      EingabeOK := true;
  UNTIL EingabeOK;
  IF RC = cr THEN b := IHelp;
  CLOSEWindow (Win);
END;

{***************************************************************************}
procedure PortEinstellungen;
VAR
  x,y                 : word;
  Menue               : word;
  Menuepos            : word;
  rc                  : t_staste;
  BHelp               : Boolean;
BEGIN
  SetMenue (Menue, 26, 9, StrPortEinstellungenMenue);
  x := 51;
  y := 12;
  OpenMenue (x,y,0,1,white,magenta,black,lightgray,Menue,
            links,doppelt);
  REPEAT
    Getmenuepos (Menue,[cr,esc],Menuepos,rc);
    IF rc = cr THEN BEGIN
      CASE Menuepos OF
        1 : getWinAddr(x-1,y+4,StrSdaAdresse,SDAADDR);
        2 : getWinByte(x-1,y+4,StrSdaMaske,SDAMASKE);
        3 : BEGIN
              BHelp := Bestaetigen (x-1,y+4,white,blue,black,lightgray,
                links,doppelt,(SDAINV=0), MenueText[StrSdaInvertiert]);
              IF BHelp THEN SDAINV := 0
                       ELSE SDAINV := SDAMASKE;
            END;
        4 : getWinAddr(x-1,y+4,StrSdaInAdresse,SDAINADDR);
        5 : getWinByte(x-1,y+4,StrSdaInMaske,SDAINMASKE);
        6 : BEGIN
              BHelp := Bestaetigen (x-1,y+4,white,blue,black,lightgray,
                links,doppelt,(SDAININV<>0), MenueText[StrSdaInInvertiert]);
              IF BHelp THEN SDAININV := SDAINMASKE
                       ELSE SDAININV := 0;
            END;
        7 : getWinAddr(x-1,y+4,StrSclAdresse,SCLADDR);
        8 : getWinByte(x-1,y+4,StrSclMaske,SCLMASKE);
        9 : BEGIN
              BHelp := Bestaetigen (x-1,y+4,white,blue,black,lightgray,
                links,doppelt,(SCLINV=0), MenueText[StrSclInvertiert]);
              IF BHelp THEN SCLINV := 0
                       ELSE SCLINV := SCLMASKE;
            END;
      END;
    END;
  UNTIL rc = esc;
  clearmenue(Menue);
END;

{***************************************************************************}
procedure hardware;
Var
  x,y,i               : word;
  menue,menue1,menue2 : Word;
  Menuepos,menuepos1  : word;
  menuepos2           : word;
  wineing             : Word;
  rc,rc1,rc2          : t_staste;
  EingabeOK           : Boolean;
  IHelpBasis          : Word;
  SHelp               : String;

Begin
  PUSHHelp ('Hardware.Hel');
  Setmenue (Menue, 28,5,StrHardwaremenue);
  x := 48;
  y := 10;
  OpenMenue (x,y,0,1,yellow,cyan,black,lightgray,Menue,
            links,doppelt);
  repeat
    Getmenuepos (Menue,[cr,esc],Menuepos,rc);
    IF rc = cr THEN BEGIN
      CASE Menuepos of
        1: begin
             SetMenue (Menue1, 28, 4, StrDekodermenue);
             If CTDekoder THEN Menuepos1 := 1
             ELSE IF LPTDekoder THEN MenuePos1 := 2
             ELSE IF ELVDekoder THEN MenuePos1 := 3
             ELSE MenuePos1 := 4;
             OpenMenue (x-1,y+5,0,Menuepos1,white,green,black,lightgray,Menue1,
                        links,doppelt);
             repeat
               Getmenuepos (Menue1,[cr,esc],Menuepos1,rc1);
               IF rc1 = cr THEN BEGIN
                 IF Menuepos1 in [1,3] THEN BEGIN { LPTErkennung automatisch}
                   getWinAddr(x+1,y+11,StrAdresse,I2CBasis);
                 end
                 else IF Menuepos1 = 4 THEN PortEinstellungen;
                 CTDekoder   := Menuepos1 = 1;
                 LPTDekoder  := MenuePos1 = 2;
                 ELVDekoder  := MenuePos1 = 3;
                 PortDekoder := MenuePos1 = 4;
                 IF not inittele (false) THEN begin
                   Mainstatus := telenoanswer;
                   Fehler(20, 11,StrRegisterinitialisierungfehler);
                 end
               end;
             until RC1 = esc;
             ClearMenue (Menue1);
           end;
        2: VGAVorgaben;
        3: BEGIN
             IHelp := Verzoegerung;
             openwindow(49,21,25,3,white,blue,links,doppelt,wineing);
             titelwindow(Wineing,omitte,MenueText[StrCCTClock]);
             Titelwindow(wineing,umitte,MenueText[StrCCTClock+1] +' 1..99');
             GetwinCinteger (Wineing,1,2,white,false,IHelp,uRC);
             IF IHelp > 0 THEN Verzoegerung := IHelp;
             Closewindow(wineing);
           end;
        4: parity := Bestaetigen (43,20,white, blue,black,lightgray,
                      links,doppelt,parity, MenueText[StrCCTParity]);
        5: Help(8,3,18);
      end;
    end; {rc = cr}
  until rc = esc;
  clearmenue(Menue);
  POPHelp;
END;

{****************************  M A I N *******************************}
Begin
  PushHelp ('Setup.hel');
  setmenue (Setupmenue, 33, 15, StrSetupmenue);
  Initmenue(cctmenue,24,4,omitte,umitte,MenueText[StrTOPTextCctSpeicher],
                                        Menuetext[StrWeiterMitESC]);
  For IHelp := 0 TO 3 DO BEGIN
    Str (IHelp:2, SHelp);
    MenueStr[IHelp] := Menuetext[StrCctSpeicher_] + SHelp;
  END;
  x := 44;
  y := 1;
  OpenMenue (x,y,0,1,white,blue,black,lightgray,setupmenue,
            links,Blockmagenta);
  repeat
    Getmenuepos (Setupmenue,[cr, esc],Menuepos,rc);
    IF rc = cr THEN BEGIN
      CASE Menuepos of
        1: BEGIN
             SHelp := teledir;
             openwindow(x,y+20,36,3,yellow,cyan,links,doppelt,wineing);
             titelwindow(Wineing,omitte,MenueText[StrVerzeichnis]);
             Titelwindow(wineing,umitte,MenueText[StrVerzeichnis+1]);
             GetwinCstring (Wineing,1,32,white,SHelp,uRC);
             if urc = cr THEN BEGIN
               getdir(0,shelp1);
               iHelp := length(Shelp)+1;
               repeat
                 dec (iHelp);
               UNTIL (SHelp[iHelp] <> ' ') or (iHelp = 1);
               IF iHelp = 1 THEN
                 SHElp := ''
               ELSE
                 SHelp := copy (SHelp,1,iHelp);
{$I-}
               chdir(SHelp);
{$I+}
               if ioresult = 0 THEN BEGIN
                 IF Teledir <> SHelp THEN begin
                   cleardisk('');
                   teledir := SHelp;
                 end;
               end
               else
                 Fehler (x+2,y+10,StrVerzeichnisNichtVorhanden);
               chdir (shelp1);
             end;
             closewindow (Wineing);
           end;
        2: Hardware;
        3: Nowait := NOT Bestaetigen (x+2,y+19,yellow, cyan,black,lightgray,
                                      links,doppelt,not nowait, MenueText[StrAufSeiteWarten]);
        4: BEGIN
             IHelp := AnzSubPageSoll;
             openwindow(x+4,y+19,28,3,yellow,cyan,links,doppelt,wineing);
             titelwindow(Wineing,omitte,MenueText[StrMaxUnterseiten]);
             Str (Maxupages,SHelp);
             Titelwindow(wineing,umitte,'12 .. '+SHelp);
             Repeat
               GetwinCinteger (Wineing,1,2,white,false,IHelp,uRC);
               IF uRC = CR THEN BEGIN
                 if IHelp in [12..MaxUpages] THEN BEGIN
                   FOR Lauf := 0 TO 3 DO BEGIN {Keine Parallelverarbeitung}
                     freig[Lauf] := auftrag[Lauf].freigabe;
                     cctfreigabe (Lauf, false);
                     FreeMem (seiteptr[Lauf],AnzSubPage*Seitenlaenge);
                   end;
                   FreeMem (seiteptrakt,AnzSubpage * Seitenlaenge);
                   FreeMem (Seiteptrvergl, AnzSubPage * Seitenlaenge);
                   AnzSubPageSoll := IHelp;
                   GetpageMem;
                   For lauf := 0 TO 3 DO
                     cctfreigabe (lauf,freig[lauf]);
                 end
                 else BEGIN
                   Fehler (x+2,y+10,StrUngueltigeEingabe);
                 END;
               END;
             UNTIL (IHelp in [12..MaxUpages]) OR (uRC = ESC);
             Closewindow(wineing);
           end;
        5: Seitenkontrolle := Bestaetigen (x+5,y+19,yellow, cyan,black,lightgray,
                      links,doppelt,Seitenkontrolle, MenueText[StrSeitenkontrolle]);
        6: cct0freigabe := Bestaetigen (x+2,y+19,yellow, cyan,black,lightgray,
                           links,doppelt,cct0freigabe, MenueText[StrAutoSuchecct0]);
        7: BEGIN
             OpenMenue (x+4,y+16,0,Toptextcct+1,yellow,cyan,black,lightgray,cctmenue,
                        links,Blockgreen);
             Repeat
               For IHelp := 0 TO 3 DO BEGIN
                 IF IHelp = TOPTextcct THEN SHelp := ' TOPText'
                                       ELSE SHelp := '';
                 setmenuetext (cctmenue, IHelp+1, ' , ' + menuestr[Ihelp]+SHelp);
               end;
                 Getmenuepos (cctmenue,[cr,esc], Umenuepos,urc);
               IF urc = cr THEN WITH Auftrag[UMenuepos-1] DO
                 TOPTextcct := UmenuePos-1;
             until urc = esc;
             Closemenue(cctmenue);
           end;
        8: BEGIN
             ihelp := Abstand;
             openwindow(x+4,y+19,30,3,yellow,cyan,links,doppelt,wineing);
             titelwindow(Wineing,omitte,MenueText[StrSeitenabstand]);
             Titelwindow(wineing,umitte,MenueText[StrSeitenabstand+1]);
             GetwinCinteger (Wineing,1,2,white,false,ihelp,uRC);
             IF IHelp in [11..40] THEN
               Abstand := Ihelp
             Else
               Fehler(x+3,y+10,StrUngueltigeEingabe);
             Closewindow(wineing);
           end;
        9: BEGIN
             ihelp := SenderOutTime;
             openwindow(x+2,y+19,31,3,yellow,cyan,links,doppelt,wineing);
             titelwindow(Wineing,omitte,MenueText[StrMeldeverzoegerung]);
             Titelwindow(wineing,umitte,'3 .. 60 s, 0 = '+MenueText[StrAUS]);
             GetwinCinteger (Wineing,1,2,white,false,ihelp,uRC);
             IF uRC = CR THEN BEGIN
               IF IHelp in [0, 3..60] THEN BEGIN
                 SenderOutTime := Ihelp;
                 Senderkontrolle := SenderOuttime > 0;
                 Watchdog := Longtime;
               END
               Else
                 Fehler(x+3,y+10,StrUngueltigeEingabe);
             END;
             Closewindow(wineing);
           end;
       10: BEGIN
             setMenue (DauerMenue, 20, 3, StrSuchdauerMenue);
             OpenMenue (x+6,y+16,0,1,yellow,cyan,black,lightgray,dauermenue,
                        links,Blockgreen);
             Repeat
               Getmenuepos (dauermenue,[cr,esc], Umenuepos,urc);
               IF urc = cr THEN BEGIN
                 CASE UMenuepos of
                   1: BEGIN
                        SHelp := MenueText[StrHauptseiten];
                        IHelp := Timeout;
                      END;
                   2: BEGIN
                        SHELP := MenueText[StrUnterseiten];
                        IHelp := TimeOutUPs;
                      END;
                   3: BEGIN
                        SHELP := MenueText[StrTOPTEXTSeiten];
                        IHelp := TimeOutTOP;
                      END;
                 END;
                 openwindow(x+8,y+20,18,3,white,blue,links,doppelt,wineing);
                 titelwindow(Wineing,omitte,SHelp);
                 Titelwindow(wineing,umitte,'15 .. 99 s');
                 GetwinCinteger (Wineing,1,2,yellow,false,IHelp,urc1);
                 if IHelp in [15..99] THEN
                   CASE UMenuepos of
                     1: Timeout     := IHelp;
                     2: TimeoutUPs  := IHelp;
                     3: TimeoutTOP  := IHelp;
                   END
                 else
                   Fehler(x+5,y+10,StrMindesten15Sekunden);
                 Closewindow(wineing);
               end; {if cr}
             until urc = esc;
             Clearmenue(dauermenue);
           end;
       11: BEGIN
             IHelp := TOPtime DIV 60;
             openwindow(x+4,y+19,25,3,yellow,cyan,links,doppelt,wineing);
             titelwindow(Wineing,omitte,MenueText[StrIntervallInMinuten]);
             Titelwindow(wineing,umitte,'0(='+Menuetext[StrAUS]+ ') .. 99 min');
             GetwinCinteger (Wineing,1,2,white,false,IHelp,uRC);
             IF IHelp = 0 THEN TOPtime := 24*60*60 {Intevall 1 Tag=nicht lesen}
                          ELSE TOPtime := 60 * IHelp;
             Closewindow(wineing);
           end;
       12: ADIPSortieren := Bestaetigen (x+2,y+19,yellow, cyan,black,lightgray,
                           links,doppelt,ADIPSortieren, MenueText[StrADIPsortieren]);
       13: Multitask := Bestaetigen (x+5,y+19,yellow, cyan,black,lightgray,
                      links,doppelt,Multitask, MenueText[StrMultitasking]);
       14: SaveSetup;
       15: BEGIN
             UPDateSperre := True;
             Help (8,3,18);
             UPDateSperre := False;
          END;
      end;
    end; {rc = cr}
  until rc = esc;
  clearmenue(setupmenue);
  clearmenue(cctmenue);
  POPHelp;
END;

