Attribute VB_Name = "VCapture"
'   Stand: 13.06.1999 angepat fr c't/as
'   ----------------------------------------------------------------------
'
'   NoAd: Keine Werbung auf dem Videorecorder: PC Steuerung
'   Copyright (C) 1999 Peter Richert (Richert@FH-Muenster.DE)
'
'   Telefon +49 2551 9-62125, Fax -62391
'
'   Fachhochschule Mnster, Fachbereich Elektrotechnik
'   eLKaTe - Labor Kommunikationstechnik
'   Stegerwaldstrasse 39, 48565 Steinfurt, GERMANY
'
'   ----------------------------------------------------------------------
'   This program is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License as published by
'   the Free Software Foundation; either version 2 of the License, or
'   (at your option) any later version.
'
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'   ----------------------------------------------------------------------
'

'Konstanten
Const VK_SNAPSHOT As Byte = &H2C

Private Type PALETTEENTRY
       peRed As Byte
       peGreen As Byte
       peBlue As Byte
       peFlags As Byte
End Type

Private Type LOGPALETTE
       palVersion As Integer
       palNumEntries As Integer
       palPalEntry(255) As PALETTEENTRY ' Enough for 256 colors
End Type

Private Type GUID
       Data1 As Long
       Data2 As Integer
       Data3 As Integer
       Data4(7) As Byte
End Type

Private Const RASTERCAPS As Long = 38
       Private Const RC_PALETTE As Long = &H100
       Private Const SIZEPALETTE As Long = 104

Private Type RECT
       Left As Long
       Top As Long
       Right As Long
       Bottom As Long
End Type

Private Type PicBmp
       Size As Long

Type As Long
       hBmp As Long
       hPal As Long
       Reserved As Long
End Type

Private Declare Function OleCreatePictureIndirect Lib "olepro32.dll" (PicDesc As PicBmp, RefIID As GUID, ByVal fPictureOwnsHandle As Long, IPic As IPicture) As Long
Private Declare Function CreateCompatibleDC Lib "GDI32" (ByVal hDC As Long) As Long
Private Declare Function CreateBitMap Lib "GDI32" (ByVal Width As Long, ByVal Height As Long, ByVal Planes As Long, ByVal BitsperPel As Long, lpvbits As Long) As Long
Private Declare Function CreateCompatibleBitmap Lib "GDI32" (ByVal hDC As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Private Declare Function GetDeviceCaps Lib "GDI32" (ByVal hDC As Long, ByVal iCapabilitiy As Long) As Long
Private Declare Function GetSystemPaletteEntries Lib "GDI32" (ByVal hDC As Long, ByVal wStartIndex As Long, ByVal wNumEntries As Long, lpPaletteEntries As PALETTEENTRY) As Long
Private Declare Function CreatePalette Lib "GDI32" (lpLogPalette As LOGPALETTE) As Long
Private Declare Function SelectObject Lib "GDI32" (ByVal hDC As Long, ByVal hObject As Long) As Long
Private Declare Function BitBlt Lib "GDI32" (ByVal hDCDest As Long, ByVal XDest As Long, ByVal YDest As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hDCSrc As Long, ByVal XSrc As Long, ByVal YSrc As Long, ByVal dwRop As Long) As Long
Private Declare Function DeleteDC Lib "GDI32" (ByVal hDC As Long) As Long
Public Declare Function GetForegroundWindow Lib "user32" () As Long
Private Declare Function SelectPalette Lib "GDI32" (ByVal hDC As Long, ByVal hPalette As Long, ByVal bForceBackground As Long) As Long
Private Declare Function RealizePalette Lib "GDI32" (ByVal hDC As Long) As Long
Public Declare Function GetWindowDC Lib "user32" (ByVal hWnd As Long) As Long
Public Declare Function GetDC Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function GetWindowRect Lib "user32" (ByVal hWnd As Long, lpRect As RECT) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hWnd As Long, ByVal hDC As Long) As Long
Private Declare Function GetDesktopWindow Lib "user32" () As Long
Private Declare Function SystemParametersInfo Lib "user32" Alias "SystemParametersInfoA" (ByVal uAction As Long, ByVal uParam As Long, ByVal lpvParam As Boolean, ByVal fuWinIni As Long) As Long

Type bitmap
      bmType As Integer
      bmWidth As Integer
      bmHeight As Integer
      bmWidthBytes As Integer
      bmPlanes As String * 1
      bmBitsPixel As String * 1
      bmBits As Long
End Type


Private Declare Function SetBkColor Lib "GDI32" (ByVal hDC As Long, ByVal cColor As Long) As Long
Private Declare Function DeleteObject Lib "GDI32" (ByVal hObject As Long) As Long
Private Declare Function GetObj Lib "GDI32" Alias "GetObject" (ByVal hObject As Long, ByVal nCount As Long, bmp As Any) As Long
Const SRCCOPY = &HCC0020
Const SRCAND = &H8800C6
Const SRCPAINT = &HEE0086
Const NOTSRCCOPY = &H330008

Public Function CreateBitmapPicture(ByVal hBmp As Long, ByVal hPal As Long) As Picture
Dim r As Long

Dim Pic As PicBmp
'     ' IPicture requires a reference to "Standard OLE Types"
Dim IPic As IPicture
Dim IID_IDispatch As GUID
'     ' Fill in with IDispatch Interface ID
With IID_IDispatch
.Data1 = &H20400
.Data4(0) = &HC0
.Data4(7) = &H46
End With

'     ' Fill Pic with necessary parts
With Pic
.Size = Len(Pic) ' Length of structure
.Type = vbPicTypeBitmap ' Type of Picture (bitmap)
.hBmp = hBmp ' Handle to bitmap
.hPal = hPal ' Handle to palette (may be null)
End With

'     ' Create Picture object
r = OleCreatePictureIndirect(Pic, IID_IDispatch, 1, IPic)
'     ' Return the new Picture object
Set CreateBitmapPicture = IPic
End Function
Public Function CaptureWindow(ByVal hWndSrc As Long, ByVal Client As Boolean, ByVal LeftSrc As Long, _
       ByVal TopSrc As Long, ByVal WidthSrc As Long, ByVal HeightSrc As Long) As Picture
       Dim hDCMemory As Long
       Dim hBmp As Long
       Dim hBmpPrev As Long
       Dim r As Long
       Dim hDCSrc As Long
       Dim hPal As Long
       Dim hPalPrev As Long
       Dim RasterCapsScrn As Long
       Dim HasPaletteScrn As Long
       Dim PaletteSizeScrn As Long

Dim LogPal As LOGPALETTE
' Depending on the value of Client get the proper device con
'     text

If Client Then
       hDCSrc = GetDC(hWndSrc) ' Get device context for client area
Else
       hDCSrc = GetWindowDC(hWndSrc) ' Get device context for entire window
End If

'     ' Create a memory device context for the copy process
hDCMemory = CreateCompatibleDC(hDCSrc)
'     ' Create a bitmap and place it in the memory DC
hBmp = CreateCompatibleBitmap(hDCSrc, WidthSrc, HeightSrc)
hBmpPrev = SelectObject(hDCMemory, hBmp)
'     ' Get screen properties
RasterCapsScrn = GetDeviceCaps(hDCSrc, RASTERCAPS) ' Raster capabilities
HasPaletteScrn = RasterCapsScrn And RC_PALETTE ' Palette support
PaletteSizeScrn = GetDeviceCaps(hDCSrc, SIZEPALETTE) ' Size of palette
'     ' If the screen has a palette make a copy and realize it

If HasPaletteScrn And (PaletteSizeScrn = 256) Then
       '     ' Create a copy of the system palette
       LogPal.palVersion = &H300
       LogPal.palNumEntries = 256
       r = GetSystemPaletteEntries(hDCSrc, 0, 256, LogPal.palPalEntry(0))
       hPal = CreatePalette(LogPal)
       '     ' Select the new palette into the memory DC and realize it
       hPalPrev = SelectPalette(hDCMemory, hPal, 0)
       r = RealizePalette(hDCMemory)
End If

'     ' Copy the on-screen image in   to the memory DC
r = BitBlt(hDCMemory, 0, 0, WidthSrc, HeightSrc, hDCSrc, _
LeftSrc, TopSrc, vbSrcCopy)
'     ' Remove the new copy of the the on-screen image
hBmp = SelectObject(hDCMemory, hBmpPrev)
' If the screen has a palette get back the palette that was
'     selected
'     ' in previously

If HasPaletteScrn And (PaletteSizeScrn = 256) Then
       hPal = SelectPalette(hDCMemory, hPalPrev, 0)
End If

'     ' Release the device context resources back to the system
r = DeleteDC(hDCMemory)
r = ReleaseDC(hWndSrc, hDCSrc)
' Call CreateBitmapPicture to create a picture object from t
'     he bitmap
' and palette handles. Then return the resulting picture obj
'     ect.
Set CaptureWindow = CreateBitmapPicture(hBmp, hPal)

End Function

Sub TransparentBlt(dest As Control, ByVal srcBmp As Integer, ByVal destX As Integer, ByVal destY As Integer, ByVal TransColor As Long)
      Const PIXEL = 3
      Dim destScale As Integer
      Dim srcDC As Integer  'source bitmap (color)
      Dim saveDC As Integer 'backup copy of source bitmap
      Dim maskDC As Integer 'mask bitmap (monochrome)
      Dim invDC As Integer  'inverse of mask bitmap (monochrome)
      Dim resultDC As Integer 'combination of source bitmap & background
      Dim bmp As bitmap 'description of the source bitmap
      Dim hResultBmp As Integer 'Bitmap combination of source & background
      Dim hSaveBmp As Integer 'Bitmap stores backup copy of source bitmap
      Dim hMaskBmp As Integer 'Bitmap stores mask (monochrome)
      Dim hInvBmp As Integer  'Bitmap holds inverse of mask (monochrome)
      Dim hPrevBmp As Integer 'Bitmap holds previous bitmap selected in DC
      Dim hSrcPrevBmp As Integer  'Holds previous bitmap in source DC
      Dim hSavePrevBmp As Integer 'Holds previous bitmap in saved DC
      Dim hDestPrevBmp As Integer 'Holds previous bitmap in destination DC
      Dim hMaskPrevBmp As Integer 'Holds previous bitmap in the mask DC
      Dim hInvPrevBmp As Integer 'Holds previous bitmap in inverted mask DC
      Dim OrigColor As Long 'Holds original background color from source DC
      Dim Success As Integer 'Stores result of call to Windows API
      If TypeOf dest Is PictureBox Then 'Ensure objects are picture boxes
        destScale = dest.ScaleMode 'Store ScaleMode to restore later
        dest.ScaleMode = PIXEL 'Set ScaleMode to pixels for Windows GDI
        'Retrieve bitmap to get width (bmp.bmWidth) & height (bmp.bmHeight)
        Success = GetObj(srcBmp, Len(bmp), bmp)
        srcDC = CreateCompatibleDC(dest.hDC)    'Create DC to hold stage
        saveDC = CreateCompatibleDC(dest.hDC)   'Create DC to hold stage
        maskDC = CreateCompatibleDC(dest.hDC)   'Create DC to hold stage
        invDC = CreateCompatibleDC(dest.hDC)    'Create DC to hold stage
        resultDC = CreateCompatibleDC(dest.hDC) 'Create DC to hold stage
        'Create monochrome bitmaps for the mask-related bitmaps:
        hMaskBmp = CreateBitMap(bmp.bmWidth, bmp.bmHeight, 1, 1, ByVal 0&)
        hInvBmp = CreateBitMap(bmp.bmWidth, bmp.bmHeight, 1, 1, ByVal 0&)
        'Create color bitmaps for final result & stored copy of source
        hResultBmp = CreateCompatibleBitmap(dest.hDC, bmp.bmWidth, bmp.bmHeight)
        hSaveBmp = CreateCompatibleBitmap(dest.hDC, bmp.bmWidth, bmp.bmHeight)
        hSrcPrevBmp = SelectObject(srcDC, srcBmp)     'Select bitmap in DC
        hSavePrevBmp = SelectObject(saveDC, hSaveBmp) 'Select bitmap in DC
        hMaskPrevBmp = SelectObject(maskDC, hMaskBmp) 'Select bitmap in DC
        hInvPrevBmp = SelectObject(invDC, hInvBmp)    'Select bitmap in DC
        hDestPrevBmp = SelectObject(resultDC, hResultBmp) 'Select bitmap
        Success = BitBlt(saveDC, 0, 0, bmp.bmWidth, bmp.bmHeight, srcDC, 0, 0, SRCCOPY) 'Make backup of source bitmap to restore later
        'Create mask: set background color of source to transparent color.
        OrigColor = SetBkColor(srcDC, TransColor)
        Success = BitBlt(maskDC, 0, 0, bmp.bmWidth, bmp.bmHeight, srcDC, 0, 0, SRCCOPY)
        TransColor = SetBkColor(srcDC, OrigColor)
        'Create inverse of mask to AND w/ source & combine w/ background.
        Success = BitBlt(invDC, 0, 0, bmp.bmWidth, bmp.bmHeight, maskDC, 0, 0, NOTSRCCOPY)
        'Copy background bitmap to result & create final transparent bitmap
        Success = BitBlt(resultDC, 0, 0, bmp.bmWidth, bmp.bmHeight, dest.hDC, destX, destY, SRCCOPY)
        'AND mask bitmap w/ result DC to punch hole in the background by
        'painting black area for non-transparent portion of source bitmap.
        Success = BitBlt(resultDC, 0, 0, bmp.bmWidth, bmp.bmHeight, maskDC, 0, 0, SRCAND)
        'AND inverse mask w/ source bitmap to turn off bits associated
        'with transparent area of source bitmap by making it black.
        Success = BitBlt(srcDC, 0, 0, bmp.bmWidth, bmp.bmHeight, invDC, 0, 0, SRCAND)
        'XOR result w/ source bitmap to make background show through.
        Success = BitBlt(resultDC, 0, 0, bmp.bmWidth, bmp.bmHeight, srcDC, 0, 0, SRCPAINT)
        Success = BitBlt(dest.hDC, destX, destY, bmp.bmWidth, bmp.bmHeight, resultDC, 0, 0, SRCCOPY) 'Display transparent bitmap on backgrnd
        Success = BitBlt(srcDC, 0, 0, bmp.bmWidth, bmp.bmHeight, saveDC, 0, 0, SRCCOPY) 'Restore backup of bitmap.
        hPrevBmp = SelectObject(srcDC, hSrcPrevBmp) 'Select orig object
        hPrevBmp = SelectObject(saveDC, hSavePrevBmp) 'Select orig object
        hPrevBmp = SelectObject(resultDC, hDestPrevBmp) 'Select orig object
        hPrevBmp = SelectObject(maskDC, hMaskPrevBmp) 'Select orig object
        hPrevBmp = SelectObject(invDC, hInvPrevBmp) 'Select orig object
        Success = DeleteObject(hSaveBmp)   'Deallocate system resources.
        Success = DeleteObject(hMaskBmp)   'Deallocate system resources.
        Success = DeleteObject(hInvBmp)    'Deallocate system resources.
        Success = DeleteObject(hResultBmp) 'Deallocate system resources.
        Success = DeleteDC(srcDC)          'Deallocate system resources.
        Success = DeleteDC(saveDC)         'Deallocate system resources.
        Success = DeleteDC(invDC)          'Deallocate system resources.
        Success = DeleteDC(maskDC)         'Deallocate system resources.
        Success = DeleteDC(resultDC)       'Deallocate system resources.
        dest.ScaleMode = destScale 'Restore ScaleMode of destination.
      End If
   End Sub


