Attribute VB_Name = "Main"
'   Stand: 23.06.1999, angepat fr ct
'   ----------------------------------------------------------------------
'
'   NoAd: Keine Werbung auf dem Videorecorder: PC Steuerung
'   Copyright (C) 1999 Peter Richert (Richert@FH-Muenster.DE)
'
'   Telefon +49 2551 9-62125, Fax -62391
'
'   Fachhochschule Mnster, Fachbereich Elektrotechnik
'   eLKaTe - Labor Kommunikationstechnik
'   Stegerwaldstrasse 39, 48565 Steinfurt, GERMANY
'
'   ----------------------------------------------------------------------
'   This program is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License as published by
'   the Free Software Foundation; either version 2 of the License, or
'   (at your option) any later version.
'
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'   ----------------------------------------------------------------------
'

Option Explicit

'Allgemeine Konstanten
Public Const Shift8 As Long = 256
Public Const Shift16 As Long = 65536
Public Const Verkleinerungsfaktor = 10


'Die Koordinaten der oberen-linken Ecke der Fernsehbildes
'in der Hauppauge-Applikation
Public Const TV_X As Byte = 135
Public Const TV_Y As Byte = 115
'Hinw.: Gilt nur fr die maximierte Hauppauge-Applikation

Global Logo_X, Logo_Y As Long 'die oberen-linken X/Y Koordinaten des Logo im Fernsehbild
Global Logobreite, Logohhe As Byte 'Breite und Hhe des Logos

Global Handlewintv As Long  'enthlt die HandleNr. der Hauppauge-Applikation
Global DC As Long           'enthlt den Device Contest von Hauppauge

Global Freigabe_Austastzeilen As Boolean 'Freigabe, ob schw. Austastzeilen erkannt werden sollen
Global Freigabe_Logo_identifizieren As Boolean 'Ist die Freigabe, ob nach das Logo identifiziert werden soll
Global Freigabe_Logo_finden As Boolean
Global Freigabe_Eigenschaften_ermitteln As Boolean
Global Freigabe_Mepunkte_ermitteln As Boolean
Global Werbung As Boolean ' Vom Wert dieser Variable ist abhngig, ob der Video aufnimmt oder stoppt

' ### Privat INI-Datei-Funktionen zugefgt ###

Global TVpath$
Global TVappname$
Global TVhandle
Global TVpaus$
Global INIFileName$
Global IRMethode$
Global IRCode$
Global IRInit$
Global IRPlay$
Global IRRec$
Global IRStopp$

Global Com$, Comsettings$, ComDTR$, ComxRTS$
  
 
 Declare Function apiGetPrivateProfileString Lib "kernel32" _
         Alias "GetPrivateProfileStringA" (ByVal lpApplicationName _
         As String, ByVal lpKeyName As Any, ByVal lpDefault As _
         String, ByVal lpReturnedString As String, ByVal nSize As _
         Long, ByVal lpFileName As String) As Long


 Declare Function apiGetPrivateProfileSection Lib "kernel32" _
         Alias "GetPrivateProfileSectionA" (ByVal lpApplicationName _
         As String, ByVal lpReturnedString As String, ByVal nSize As _
         Long, ByVal lpFileName As String) As Long

          
Declare Function apiWritePrivateProfileString Lib _
         "kernel32" Alias "WritePrivateProfileStringA" _
         (ByVal lpApplicationName As String, ByVal lpKeyName _
         As Any, ByVal lpString As Any, ByVal lpFileName As _
         String) As Long



' Die Pixelbreite/-hhe, auf die das Fernsehbild komprimiert wird
Public Const Suchbreite As Byte = 75
Public Const Suchhhe As Byte = 55

'Enthalten das farbige Bild
Global Rot2(100, 100) As Byte
Global Grn2(100, 100) As Byte
Global Blau2(100, 100) As Byte

'geben die mittleren Farbanteile von RGB an
Global mhr As Byte
Global mhg As Byte
Global mhb As Byte

Global Mepunkt_Rot_X(3000) As Byte
Global Mepunkt_Grn_X(3000) As Byte
Global Mepunkt_Blau_X(3000) As Byte

Global Mepunkt_Rot_Y(3000) As Byte
Global Mepunkt_Grn_Y(3000) As Byte
Global Mepunkt_Blau_Y(3000) As Byte

Global Referenzpunkt_X(3000) As Byte
Global Referenzpunkt_Y(3000) As Byte

Global Lauf_M As Long 'Gibt die Anzahl der Me- und Referenzpunkte an
Global Helligkeitstoleranz As Byte  'in %; gibt an, um wieviel sich der
                                    'Me- vom Referenzpunkt unterscheiden mu
Global Farbtoleranz As Byte         'in %
Global Helles_Logo As Byte  'ist 1 wenn das Logo heller als der Hintergrund,
                            'und 0 wenn es dunkler ist

Global SB_unten As Byte 'SB_xxx geben an, an welcher Y-Koordinate die sw-Austastzeilen enden
Global SB_oben As Byte
Global LetzterSender$
Global INIexists As Boolean
Dim TVKanalwahl$

Public Function ReadInistring$(Section$, Key$, Default$)
     Dim lpReturnString$, sendstr$
     Dim Size%, Valid%
     lpReturnString$ = Space$(128)
     Size% = Len(lpReturnString$)
     Valid% = apiGetPrivateProfileString(Section$, Key$, Default$, lpReturnString$, Size%, INIFileName$)
     ReadInistring$ = Left$(lpReturnString$, Valid%)
 End Function
 Public Sub WriteInistring(Section$, Key$, wert$)

   Dim Valid%
   Valid% = apiWritePrivateProfileString(Section$, Key$, wert$, INIFileName$)
     
 End Sub
Public Sub ActivateTV()
On Error GoTo TVWindow
Dim aktwin As Long

 'aktwin = GetForegroundWindow()
'If aktwin <> Handlewintv Then
AppActivate TVappname$
Exit Sub
TVWindow:
        MsgBox "Fehler bei TV-Window", 16
        Resume Next
End Sub
Public Sub Kanalwahl(ByVal Sender$)
     Dim Kanalnr$, p%, sendstr$
     
     LetzterSender$ = Sender$
     Kanalnr$ = ReadInistring("KANAL", Sender$, "")
     Form1.CommonDialog1.FileName = Sender$
     p% = InStr(TVKanalwahl$, "_?_")
     sendstr$ = Left$(TVKanalwahl$, p% - 1) + Kanalnr$ + Mid$(TVKanalwahl$, p% + 3)
     ActivateTV
     SendKeys sendstr$, True
End Sub

Public Sub LiesKanaele()
         Dim lpReturnString$
         Dim Size%, Valid%, p%
         Dim Kanallist$, Kanalname$
         lpReturnString$ = Space$(500)
         Size% = Len(lpReturnString$)
         Form2.Kanaele.Clear
         If Not INIexists Then: Exit Sub
         Valid% = apiGetPrivateProfileSection("KANAL", lpReturnString$, Size%, INIFileName$)
          Kanallist$ = Left$(lpReturnString$, Valid%)
       
         Do
         p% = InStr(Kanallist$, Chr(0))
         If p% <> 0 Then
          Kanalname$ = Left$(Kanallist$, p%)
          Form2.Kanaele.AddItem (Kanalname$)
          Kanallist$ = Mid$(Kanallist, p% + 1)
         End If
          
         Loop Until p% = 0
          
End Sub
Private Sub SetControls()
   Dim x, Y As Integer
   Dim Maxx, Maxy As Integer
   Maxx = Screen.Width
   Maxy = Screen.Height

   x = Screen.TwipsPerPixelX
   Y = Screen.TwipsPerPixelY
   Debug.Print Maxx / x, Maxy / Y
     Form1.Top = Maxy - Form1.Height - Y
   Form1.Left = 0
   Form4.Top = 0
   Form4.Left = Maxx - Form4.Width - x
   Form3.Top = Maxy - Form3.Height - Y
   Form3.Left = Maxx - Form3.Width - x

   Form1.Picture3.Visible = True
   Form1.Show
   If (Maxx / x) < 1024 Or (Maxy / Y) < 768 Then
    Call MsgBox("Videoauflsung zu klein, 1024 x786 empfohlen", 16)
   End If

End Sub

Public Sub StartTVapp(Sender$)
On Error GoTo TVerror
 TVhandle = Shell(TVpath$, vbMaximizedFocus) 'TV-Applikation  starten<
 On Error GoTo TVWindow
 AppActivate TVappname$
 Handlewintv = GetForegroundWindow()
 DC = GetWindowDC(Handlewintv)
 'Wahlweise grabbt NoAD vom FullScreen (DC=0) oder via HandlewinTV (DC=irgendwas)
 If ReadInistring("NOAD", "DC", "WINTV") = "0" Then: Handlewintv = 0  ' Capture vom Screen

 If Sender$ <> "" Then Kanalwahl (Sender$)
 Exit Sub
TVerror:
        MsgBox "Fehler bei TV-Applikation:" & TVpath$, 16
        End
        ' Resume Next
TVWindow:
        MsgBox "Fehler bei TV-Window:" & TVappname$, 16
        End
        ' Resume Next
End Sub

Public Sub Initialisierung()
         
      '* This is the path and name of the NoAD.INI file.
         INIFileName$ = App.Path & "\NoAd.ini"
         INIexists = Dir(INIFileName$) <> ""
         If Not INIexists Then: MsgBox "NOAD.INI nicht gefunden=> DefaultWerte", 16, "NoAD"
        
         TVpath$ = ReadInistring$("TVAPP", "PATH", "C:\Programme\wintv\wintv.exe")
         If TVpath$ <> "" Then
         TVappname$ = ReadInistring$("TVAPP", "APPNAME", "Hauppauge Win/TV")
         TVKanalwahl$ = ReadInistring$("TVAPP", "KANALWAHL", "%(AK)_?_{ENTER}")
         TVpaus$ = ReadInistring("TVAPP", "PAUSE", "%(AS){ENTER}")
         LiesKanaele
         End If
         
         IRMethode$ = ReadInistring$("INFRAROT", "METHODE", "CS8310")
         IRCode$ = ReadInistring$("INFRAROT", "CODE", "RC-5")
         IRInit$ = ReadInistring("INFRAROT", "INIT", "")
         IRPlay$ = ReadInistring$("INFRAROT", "PLAY", "")
         IRRec$ = ReadInistring$("INFRAROT", "REC", "")
         IRStopp$ = ReadInistring$("INFRAROT", "STOPP", "")
         
         Com$ = ReadInistring$("SIO", "COM", "")
         Comsettings$ = ReadInistring$("SIO", "COMSETTINGS", "9600,n,8,1")
         ComDTR$ = ReadInistring$("SIO", "DTR", 0)
         ComxRTS$ = ReadInistring$("SIO", "RTS", 1)
         
         
         If (Com$ <> "") And (IRMethode$ <> "IRDEO") Then
         
          'CommPort wird geffnet und initialisiert
          On Error GoTo COMerror
          Form1.MSComm1.CommPort = Val(Com$)
          Form1.MSComm1.DTREnable = (ComDTR$ = 1) 'Recording-Taste; Default auf false
          Form1.MSComm1.RTSEnable = (ComxRTS$ = 1) 'Default auf true; Stop-Taste
          Form1.MSComm1.Settings = Comsettings$
          Form1.MSComm1.PortOpen = True
         
         End If
       
       
If TVpath$ <> "" Then
 StartTVapp ("ARD")
 Form1.Programme.Enabled = True
 Form1.Senderlogos.Enabled = True
 Form1.Austastzeilen.Enabled = True
 Else
  Form1.Austastzeilen.Enabled = False
  Form1.Programme.Enabled = False
  Form1.Senderlogos.Enabled = False
End If

On Error GoTo 0
Call SetControls
Form1.Picture3.Visible = True
Form1.Show
Freigabe_Logo_identifizieren = False
Freigabe_Austastzeilen = False



Aufnahmestart_Uhrzeit = 999999
Aufnahmestop_Uhrzeit = 999999
On Error GoTo 0
InitBeftab 'Befehlstabelle mit Namen und RC-5 Codes vorbesetzen
Select Case IRMethode$
 Case "CS8130": InitCS8130
 Case "IRDEO": InitIRdeo
 Case "BATCH": InitBatch
 Case "ASCII": InitAscii
End Select
Exit Sub
        
FileError:
         MsgBox "Can't find file", 16, "Error lpReturnString"
         Resume Next
         
COMerror:
         MsgBox "Can't open COM", 16
         Resume Next

End Sub



Public Function Long_Helligkeit(ByVal Longwert As Long) As Byte
'Diese Funktion gibt die Helligkeit eines Pixels[0..255] zurueck

Dim r, g, B As Byte

r = (Longwert And &HFF&)
g = (Longwert And &HFF00&) / Shift8
B = (Longwert And &HFF0000) / Shift16

Long_Helligkeit = CByte((r + g + B) / 3)

End Function

Public Function Helligkeit_Long(ByVal Bytewert As Byte) As Long
'Diese Funftion wandelt aus einer 8-Bit Helligkeit ein 24-Bit Farbwert
Dim r, g, B As Byte
r = CByte(Bytewert)
g = CByte(Bytewert)
B = CByte(Bytewert)

Helligkeit_Long = CLng(r + Shift8 * g + Shift16 * B)

End Function

Public Sub Logo_finden()

'Die Logo_finden-Routine ermittelt die Koordinaten des Senderlogos innerhalb des Fernsehbildes
'dazu ermittelt sie ueber mehrere Bilder den Mittelwert jedes einzelnen Bildpunktes
'Um die Anzahl dieser Punkte gering zu halten, wurde das Bild um den Verkleinerungsfaktor verringert
'-> nicht 750x550(=412500), sondern nur 75x55(=4125) Bildpunkte

'Initialisierung
Dim Fensterrand, n, m, Max_Differenz, Max_Differenz_X_Koordinate, Max_Differenz_Y_Koordinate As Byte
Dim Helligkeit As Long
Dim mh, Zhler1 As Long
Dim Punkt(100, 100) As Long
Dim Punkt2(100, 100) As Byte
Dim x, Y As Long

Fensterrand = 15    'Gibt an, wie weit das Logo von linken bzw. rechten Rand entfern sein darf

With Form1.Picture3
    .Width = Suchbreite
    .Height = Suchhhe
    .Visible = True
    .Left = 22
    .Top = 290
End With

'Der oberste-linke Punkt eines Picture-Objects in VB hat die Koordinaten (0,0)
'Daher wird nur bis Suchbreite,-hhe -1 der Mittelwert gebildet
'(=die Gesamtzahl ist dann wieder Suchbreite * Suchhhe !)

While (n < 80 And Freigabe_Logo_finden = True)

    DoEvents 'Die Kontrolle wird whrend der Schleife an das Betriebssystem gegeben
    
        n = n + 1 '
        
        Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
        
        'vom aktuellen Fernsehbild wird der SW-Wert ermittelt
        'und mit dem errechneten Mittelwert aktualisiert
    
        For x = 0 To Suchbreite - 1
            DoEvents
        
            For Y = 0 To Suchhhe - 1
                DoEvents
                'Routine zur Ermittlung des sw-Wertes
                Helligkeit = Long_Helligkeit(Form1.Picture3.Point(x, Y))
                Punkt(x, Y) = Punkt(x, Y) + Helligkeit
                'der neue Mittelwert des aktuellen XY-Punktes wird in die Punkt2 Matrix
                Punkt2(x, Y) = CByte(Punkt(x, Y) / n)
                
                'Die mittlere Helligkeit des gesamten Bildes wird ermittelt
                mh = mh + Helligkeit
                Zhler1 = Zhler1 + 1
                m = CByte(mh / Zhler1) 'm beinhaltet die durchschnittliche Helligkeit
                
                ' Die Koordinaten des aufflligsten Punktes werden nach der Mittelwertbildung ermittelt
                
                If ((x > Fensterrand) And (x < (Suchbreite - Fensterrand))) Then
                    ' Es werden keine Helligkeitswerte im "inneren Fenster" ermittelt
                Else
                
                    'Wenn der aktuelle Mepunkt "aufflliger" ist als der Bisherige werden seine
                    'Helligkeit und seine Koordinaten gespeichert
                    If (Abs(Punkt2(x, Y) - m) > Max_Differenz) Then
                        
                        Max_Differenz = Abs(Punkt2(x, Y) - m)
                        Max_Differenz_X_Koordinate = x
                        Max_Differenz_Y_Koordinate = Y
                        If (Punkt2(x, Y) > m) Then
                            Helles_Logo = 1
                        Else
                            Helles_Logo = 0
                        End If
                        
                    End If
                    
                End If 'vom hellsten Punkt suchen
            
            Next Y
        
        Next x
        
        If Helles_Logo = 1 Then
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &HFFFFFF
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &HFFFFFF
        Else
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &H0&
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &H0&
        End If
        
        Max_Differenz = 1
    
        'Die Start/Stop-Koordinaten werden wieder um den Faktor 10 gestreckt
        'Lag der aufflligste Punkt zu nah am Rand wird LogoX/Y gleich Null gesetzt
        Logo_X = (Max_Differenz_X_Koordinate * 10) - 30
        If Logo_X < 0 Then Logo_X = 0
        Logo_Y = (Max_Differenz_Y_Koordinate * 10) - 50
        If Logo_Y < 0 Then Logo_Y = 0
        
Wend ' von Freigabe_Logo_finden

' An dieser Stelle ist die Mittelwertbildung der Fernsehbilder abgeschloen
Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Eigenschaften.Enabled = True

End Sub

Public Sub Austastzeilen_messen()

'Dies Funktion gibt die Position der Austastzeilen an
Dim x, Y As Long
Dim n As Byte


Dim Gesamte_Helligkeit, Helligkeit As Long
Dim Hilfspunkt(100, 100) As Long
Const m = 5 'Gibt an, wie viele Fernsehbilder zu Mittelwertbildung herangezogen werden

With Form1.Picture3
    .Visible = True
    .Width = Suchbreite
    .Height = Suchhhe
    .Top = 290
    .Left = 22
End With

For n = 1 To m

    DoEvents
    
    Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
    
    For x = 0 To Suchbreite - 1
        DoEvents
        For Y = 0 To Suchhhe - 1
        DoEvents
        Hilfspunkt(x, Y) = Hilfspunkt(x, Y) + Long_Helligkeit(Form1.Picture3.Point(x, Y))
        Next Y
    Next x
Next n

For x = 0 To Suchbreite - 1
    For Y = 0 To Suchhhe - 1
    Hilfspunkt(x, Y) = CByte(Hilfspunkt(x, Y) / m)
    Form1.Picture3.PSet (x, Y), Helligkeit_Long(Hilfspunkt(x, Y))
    Next Y
Next x

SB_oben = 0
'von oben kommend wird das Fernsehbild so lange abgetastet bis die gesamte
'Helligkeit einer Bildzeile grer als der eingestellte Grenzwert wird

For Y = 0 To Int(Suchhhe / 2)
    Gesamte_Helligkeit = 0
    For x = 0 To Suchbreite
        Gesamte_Helligkeit = Gesamte_Helligkeit + Long_Helligkeit(Form1.Picture3.Point(x, Y))
    Next x
    If ((Gesamte_Helligkeit < 2000) And (Y > SB_oben)) Then
        SB_oben = Y
    End If
Next Y

SB_unten = Suchhhe
'von unten kommend wird das Fernsehbild so lange abgetastet bis die gesamte
'Helligkeit einer Bildzeile grer als der eingestellte Grenzwert wird

For Y = Suchhhe To Int(Suchhhe / 2) Step -1
    Gesamte_Helligkeit = 0
    For x = 0 To Suchbreite
        Gesamte_Helligkeit = Gesamte_Helligkeit + Long_Helligkeit(Form1.Picture3.Point(x, Y))
    Next x
    If ((Gesamte_Helligkeit < 2000) And (Y < SB_unten)) Then
        SB_unten = Y
    End If
Next Y

Form1.Picture3.Visible = False

If ((SB_oben <> 0) And (SB_unten <> Suchhhe)) Then
    Freigabe_Austastzeilen = True
    Call Austastzeilen__identifizieren
Else
'Es sind keine Austastzeilen vorhanden, daher wird die Aufnahmesteuerung durch das Vorhandensein
    'des Senderlogos bestimmt
Call Logo_identifizieren

End If

End Sub

Public Sub Austastzeilen__identifizieren()
'Diese Funktion stellt fest, ob die Austastzeilen vorhanden sind

Dim x As Byte
Dim a, B, c, d As Long
Dim ab$

With Form1
    .Command2.Visible = True
    .Picture3.Visible = True
    .Picture3.Width = Suchbreite
    .Picture3.Height = Suchhhe
End With
    
While (Freigabe_Austastzeilen = True)
    DoEvents
    a = 0
    B = 0
    c = 0
    d = 0
    
    Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
    
    For x = 0 To Suchbreite Step 2
        DoEvents
        a = a + Long_Helligkeit(Form1.Picture3.Point(x, SB_oben - 1))
        B = B + Long_Helligkeit(Form1.Picture3.Point(x, SB_oben + 1))
        c = c + Long_Helligkeit(Form1.Picture3.Point(x, SB_unten + 1))
        d = d + Long_Helligkeit(Form1.Picture3.Point(x, SB_unten - 1))
    Next x

    If ((B > 1000) And (d > 1000)) Then
        'Die Zeilen unter- und oberhalb der Austastzeilen sind hell genug
        If ((a < 1000) And (c < 1000)) Then
            'Austastzeilen vorhanden
            'Aussage "A-Zeilen vorhanden" muss zweimal hintereinander erfolgen
            If Form1.Frame2.BackColor = &H0& Then Werbung = False
            'Der Rahmen wird schwarz, die Schrift wei
            Form1.Frame2.BackColor = &H0&
            Form1.Frame2.ForeColor = &HFFFFFF
        Else
            'keine Austastzeilen vorhanden
            'Aussage "A-Zeilen nicht vorhanden" muss zweimal hintereinander erfolgen
            If Form1.Frame2.BackColor = &HC0C0C0 Then Werbung = True
            'Der Rahmen wird grau, die Schrift schwarz
            Form1.Frame2.BackColor = &HC0C0C0
            Form1.Frame2.ForeColor = &H0&
        End If
    Else
        'Keine Aussage mglich
        'Der Rahmen wird rot, die Schrift schwarz
        Form1.Frame2.BackColor = &HFF&
        Form1.Frame2.ForeColor = &H0&
    End If
    
    Call Aufnahmesteuerung
    
Wend

Form1.Picture3.Visible = False
Form1.Command2.Visible = False

End Sub

Public Sub Eigenschaften_ermitteln()

'Initialisierung
Dim r, g, B As Byte
Dim rot(100, 100), grn(100, 100), blau(100, 100) As Single
Dim PixelFarbe As Long
Dim mh_r, mh_g, mh_b, Zhler2 As Single
Dim n As Byte
Dim x, Y As Long
Dim mhh As Byte
'Ein Rechteck wird um den hellsten Punkt aufgespannt
'Die Breite/Hhe wird mit 100 angenommen
Logobreite = 100
Logohhe = 100

With Form1.Picture3
    .Width = Logobreite
    .Height = Logohhe
    .Visible = True
    .Top = 272
    .Left = 8
End With

   
While (n < 50 And Freigabe_Eigenschaften_ermitteln = True)

    DoEvents
        
        n = n + 1
    
        'Das ungefhre Logo wird in Picture3 geschrieben
        Form1.Picture3 = CaptureWindow(Handlewintv, False, _
        TV_X + Logo_X, TV_Y + Logo_Y, Logobreite, Logohhe)
        
        'vom Logo wird von jedem Punkt der Farbwert ermittelt
        'und mit dem bereits errecheneten Mittelwert aktualisiert
        
        For Y = 0 To Logohhe - 1
        
            For x = 0 To Logobreite - 1
                
                'Funktion zu Ermittlung des Farbwertes
                PixelFarbe = Form1.Picture3.Point(x, Y)
                
                'ermitteln die Grundfarbenanteile
                r = (PixelFarbe And &HFF&)
                g = (PixelFarbe And &HFF00&) / Shift8
                B = (PixelFarbe And &HFF0000) / Shift16
                
                'Die Grundfarbenanteile des Logobildes werden aufsummiert
                mh_r = mh_r + r
                mh_g = mh_g + g
                mh_b = mh_b + B
                Zhler2 = Zhler2 + 1
                
                'Die Grundfarbenanteile der einzelnen Pixel werden aufsummiert
                rot(x, Y) = rot(x, Y) + r
                grn(x, Y) = grn(x, Y) + g
                blau(x, Y) = blau(x, Y) + B
                
                'Die Grundfarbenanteile des Mittelwertbildes werden ermittelt
                Rot2(x, Y) = CByte(rot(x, Y) / n)
                Grn2(x, Y) = CByte(grn(x, Y) / n)
                Blau2(x, Y) = CByte(blau(x, Y) / n)
                'Form1.Picture4.PSet (X, Y), Rot2(X, Y) + Shift8 * Grn2(X, Y) + Shift16 * Blau2(X, Y)
                
            Next x
                           
        Next Y
        
        mhr = CByte(mh_r / Zhler2) ' global gemerkt
        mhg = CByte(mh_g / Zhler2) ' global gemerkt
        mhb = CByte(mh_b / Zhler2) ' global gemerkt
        ' wird nur fr Debug-Zwecke gebraucht
        r = mhr
        g = mhg
        B = mhb
        mhh = CByte((r + g + B) / 3)
        ' ***************************
Wend 'Freigabe_Eigenschaften_ermitteln
' An dieser Stelle ist die Mittelwertbildung des Logos abgeschloen


Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Mepunkte_ermitteln.Enabled = True

End Sub

Public Sub Logo_identifizieren()

Dim r, g, B, ref_r, ref_g, ref_b As Byte
Dim Logo_vorhanden, Logo_nichtvorhanden, Anzahl_Messpunkte As Integer
Dim ft As Single
Dim n As Long

With Form1.Picture3
    .Width = Logobreite
    .Height = Logohhe
    .Visible = True
    .Top = 272
    .Left = 8
End With

With Form1
    .Frame1.Caption = "Logo identifizieren"
    .Command1.Visible = True
    .Label1.Visible = True
End With
    
Freigabe_Logo_identifizieren = True
ActivateTV
While (Freigabe_Logo_identifizieren = True)
    
    Logo_vorhanden = 0
    Logo_nichtvorhanden = 0
    Anzahl_Messpunkte = 0
    
    'Das Logo in Picture 3 schreiben
    Form1.Picture3 = CaptureWindow(Handlewintv, False, _
        TV_X + Logo_X, TV_Y + Logo_Y, Logobreite, Logohhe)
    
    'Die Farbtoleranz wird beim Identifizieren nur halb so gro gewhlt wie beim Mepunkt ermitteln
    'Grund: Die Mepunkte sind unter "idealeren" Bedingungen ermittelt worden
    ft = (Farbtoleranz / 200)
    
    For n = 1 To Lauf_M
        
        DoEvents
        
        'Die RGB-Komponenten werden von den jeweiligen Mepunkten ermittelt
        r = ((Form1.Picture3.Point(Mepunkt_Rot_X(n), Mepunkt_Rot_Y(n))) And &HFF&)
        g = (((Form1.Picture3.Point(Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n))) And &HFF00&) / Shift8)
        B = (((Form1.Picture3.Point(Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n))) And &HFF0000) / Shift16)
         
        'Die zur Messung herangezogenen Punkte werden eingezeichnet
        
        'Die Referenz RGB-Werte werden ermittelt und angezeigt
        ref_r = ((Form1.Picture3.Point(Referenzpunkt_X(n), Referenzpunkt_Y(n))) And &HFF&)
        ref_g = (((Form1.Picture3.Point(Referenzpunkt_X(n), Referenzpunkt_Y(n))) And &HFF00&) / Shift8)
        ref_b = (((Form1.Picture3.Point(Referenzpunkt_X(n), Referenzpunkt_Y(n))) And &HFF0000) / Shift16)
        
        
        If (Helles_Logo = 1) Then

            If (((ref_r + ref_g + ref_b) > 480)) Then
                'Bei einem hellen Logo ist der Referenzpunkt zu hell(>3x180)
            Else
                Anzahl_Messpunkte = Anzahl_Messpunkte + 1
                Form1.Picture3.PSet (Referenzpunkt_X(n), Referenzpunkt_Y(n)), &H808080
                
                'Ist der Mepunkt ein gltiger ?
                If ((Mepunkt_Rot_X(n) <> 0) And (Mepunkt_Rot_Y(n) <> 0)) Then
                    'berschreitet seine Helligkeit die erforderliche Grenze
                    If (r > (ref_r * (1 + ft))) Then
                            'Falls ja ist er wahrscheinlich ein Punkt des Logos
                            Logo_vorhanden = Logo_vorhanden + 1
                            Form1.Picture3.PSet (Mepunkt_Rot_X(n), Mepunkt_Rot_Y(n)), &HFF&
                        Else
                            'Ist der Me- dem referenzpunkt zu hnlich
                            Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                        
                End If
                    
                If ((Mepunkt_Grn_X(n) <> 0) And (Mepunkt_Grn_Y(n) <> 0)) Then
                    If (g > (ref_g * (1 + ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n)), (&HFF00& Or (Form1.Picture3.Point(Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n))))
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                
                End If
                    
                If ((Mepunkt_Blau_X(n) <> 0) And (Mepunkt_Blau_Y(n) <> 0)) Then
                    If (B > (ref_b * (1 + ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n)), (&HFF0000 Or (Form1.Picture3.Point(Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n))))
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
            
            End If
                
        Else 'Helles/dunkles Logo

            If (((ref_r + ref_g + ref_b) < 300)) Then
                'bei einem dunkelen Logo ist der Referenzpunkt zu dunkel (< 3x100)
            Else
                Form1.Picture3.PSet (Referenzpunkt_X(n), Referenzpunkt_Y(n)), &H808080
                Anzahl_Messpunkte = Anzahl_Messpunkte + 1
                
                If ((Mepunkt_Rot_X(n) <> 0) And (Mepunkt_Rot_Y(n) <> 0)) Then
                    If (r < (ref_r * (1 - ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Rot_X(n), Mepunkt_Rot_Y(n)), &HFF&
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
                        
                If ((Mepunkt_Grn_X(n) <> 0) And (Mepunkt_Grn_Y(n) <> 0)) Then
                    If (g < (ref_g * (1 - ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n)), (&HFF00& Or (Form1.Picture3.Point(Mepunkt_Grn_X(n), Mepunkt_Grn_Y(n))))
                    Else
                        Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
                        
                If ((Mepunkt_Blau_X(n) <> 0) And (Mepunkt_Blau_Y(n) <> 0)) Then
                    If (B < (ref_b * (1 - ft))) Then
                        Logo_vorhanden = Logo_vorhanden + 1
                        Form1.Picture3.PSet (Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n)), (&HFF0000 Or (Form1.Picture3.Point(Mepunkt_Blau_X(n), Mepunkt_Blau_Y(n))))
                    Else
                         Logo_nichtvorhanden = Logo_nichtvorhanden + 1
                    End If
                End If
            End If
        End If
        
    Next n
    
    If (Anzahl_Messpunkte < (Lauf_M / 3)) Then
        'nicht gengend Messpunkte zur Verfgung
        'Keine Aussage mglich
        Form1.Label1.Caption = "?"
        
    Else
        If (Logo_vorhanden > (3 * Logo_nichtvorhanden)) Then
            'Sollten die gemessenen Farbwerte deutlich(Faktor 3) sich von den Referenzpunkten
            'unterscheiden wird es sich um das Senderlogo handeln
            'Entscheidung "Logo vorhanden" muss zweimal hintereinander erfolgen
            If (Form1.Label1.Caption = "L") Then Werbung = False
            Form1.Label1.Caption = "L"
            
        End If
        
        If (Logo_nichtvorhanden > Logo_vorhanden) Then
            'Statistisch haben Me und Referenzpunkte bei nicht vorhandenem Logo
            'die gleichen Farbwerte, daher reicht
            'fr die Aussage "kein Logo vorhanden" die obere Bedingung
            'Entscheidung "Keine Logo vorhanden muss zweimal hintereinander folgen
            If (Form1.Label1.Caption = " ") Then Werbung = True
            Form1.Label1.Caption = " "
            
        End If
        
    End If
    
    Call Aufnahmesteuerung ' Ist der Videorecorder programmiert wird jetzt festgestellt,
    'ob die Aufnahme aungehalten werden mu oder nicht

Wend 'Logo_identifizieren


Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Label1.Visible = False

End Sub

Public Function Schon_benutzt(ByVal Farbe As Long) As Boolean
'Mepunkte knnen sich sowohl in einer als uch in mehreren Farben
'von Ihrer umgebung unterscheiden.
'Damit zur einer XY-Koordinate auch nur ein Referenzpunkt bentigt wird, kann mit Hilfe
'dieser Funktion festgestellt werden, ob der Punkt bereits benutzt wird
If ( _
    (Farbe = &HFF&) Or _
    (Farbe = &HFF00&) Or _
    (Farbe = &HFF0000) Or _
    (Farbe = &HFFFF&) Or _
    (Farbe = &HFF00FF) Or _
    (Farbe = &HFFFF00) Or _
    (Farbe = &HFFFFFF) Or _
    (Farbe = &H808080) _
) Then
    Schon_benutzt = True
Else
    Schon_benutzt = False
End If

End Function

Public Sub Messpunkte_ermitteln()

'Nach Ablauf dieser Routine sind die Variabelen der Me- und Referenzpunkte
'festgestellt worden

Dim r, g, B, n, SummeMittelwertFarben, HelligkeitPixel As Byte
Dim oben, unten, links, rechts As Byte
Dim m, PixelFarbe As Long
Dim ht, ft As Single
Dim x, Y As Long
Dim Farbe As Long
Dim AnzMesspunkte As Long

         
AnzMesspunkte = Val(ReadInistring$("NOAD", "MESSPUNKTE", "3000"))
         



For m = 0 To AnzMesspunkte
    Mepunkt_Rot_X(m) = 0
    Mepunkt_Rot_Y(m) = 0
    Mepunkt_Grn_X(m) = 0
    Mepunkt_Grn_Y(m) = 0
    Mepunkt_Blau_X(m) = 0
    Mepunkt_Blau_Y(m) = 0
Next m

Form1.Picture3.Visible = True

'Die Mae des Logos werden ersteinmal in die Mitte des Bildes gelegt.
oben = Logohhe / 2
unten = Logohhe / 2
links = Logobreite / 2
rechts = Logobreite / 2

r = mhr
g = mhg
B = mhb
m = 1

         
Helligkeitstoleranz = Val(ReadInistring$("NOAD", "HTOL", "51"))
'Gibt an, um wieviel sich der Farbwert einen Punktes
'von seinem Referenzpunkt unterscheiden mu, in %

SummeMittelwertFarben = CByte((r + g + B) / 3)
ht = (Helligkeitstoleranz / 100)

While ((m < 2000) And (ht > 0.2) And (Freigabe_Mepunkte_ermitteln = True))
    
    ht = ht - 0.01
    
    ft = ht
    
    DoEvents

    For x = 0 To Logobreite - 1

        For Y = 0 To Logohhe - 1
            
            'Anzeige des Mittelwertbildes
            r = Rot2(x, Y)
            g = Grn2(x, Y)
            B = Blau2(x, Y)
            HelligkeitPixel = CByte((r + g + B) / 3)
            PixelFarbe = Rot2(x, Y) + Shift8 * Grn2(x, Y) + Shift16 * Blau2(x, Y)
            Form1.Picture3.PSet (x, Y), PixelFarbe
            
            If ( _
                    (HelligkeitPixel < 40) _
                ) Then
                'zu dunkel, evtl. Austastzeilen
            Else
                
                If Helles_Logo = 1 Then
                    'Bei einem hellen Logo mssen seine Werte hher als die seiner Nachbarn liegen
                    If ( _
                        (HelligkeitPixel > ((1 + ht) * SummeMittelwertFarben)) _
                    ) Then
                        m = m + 1 'mehr als 1000 Mepunkte werden nicht bentigt
                        'Liegen Mepunkte auerhalb der Bildmitte werden Ihre Mae (re, li, ob, un) durch Neue ersetzt
                        If x > rechts Then rechts = x
                        If x < links Then links = x
                        If Y < oben Then oben = Y
                        If Y > unten Then unten = Y
                            
                        'Ein Punkt hat eine hellere Farbe als der Durchschnitt
                        If ( _
                            (Rot2(x, Y) > ((1 + ft) * mhr)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF&
                        End If
                        
                        If ( _
                            (Grn2(x, Y) > ((1 + ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF00&
                        End If
                        
                        If ( _
                            (Blau2(x, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF0000
                        End If
                        
                        'Ein Punkt unterscheidet sich in zwei Farben vom Normalbild
                        If ( _
                            (Rot2(x, Y) > ((1 + ft) * mhr)) And _
                            (Grn2(x, Y) > ((1 + ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFFFF&
                        End If
                        
                        If ( _
                            (Rot2(x, Y) > ((1 + ft) * mhr)) And _
                            (Blau2(x, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF00FF
                        End If
                        
                        If ( _
                            (Grn2(x, Y) > ((1 + ft) * mhg)) And _
                            (Blau2(x, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFFFF00
                        End If
                        
                        'Ein Punkt unterscheidet sich in allen Farben vom Normalbild(wei bzw. wei-transparent)
                        If ( _
                            (Rot2(x, Y) > ((1 + ft) * mhr)) And _
                            (Grn2(x, Y) > ((1 + ft) * mhg)) And _
                            (Blau2(x, Y) > ((1 + ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFFFFFF
                        End If
                        
                    End If
                    
                Else 'Wenn es ich um ein dunkles Logo handelt
                    
                    'seine Helligkeit und seine Farbwerte men dunkler
                    'als der Bilddurchschnitt sein
                    If ( _
                        (HelligkeitPixel < ((1 - ht) * SummeMittelwertFarben)) _
                    ) Then
                        m = m + 1 'mehr als 1000 Mepunkte werden nicht bentigt
                        If x > rechts Then rechts = x
                        If x < links Then links = x
                        If Y < oben Then oben = Y
                        If Y > unten Then unten = Y
                            
                        If ( _
                            (Rot2(x, Y) < ((1 - ft) * mhr)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF&
                        End If
                        
                        If ( _
                            (Grn2(x, Y) < ((1 - ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF00&
                        End If
                        
                        If ( _
                            (Blau2(x, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF0000
                        End If
                        
                        If ( _
                            (Rot2(x, Y) < ((1 - ft) * mhr)) And _
                            (Grn2(x, Y) < ((1 - ft) * mhg)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFFFF&
                        End If
                        
                        'zwei dunkle Mepunkte
                        If ( _
                            (Rot2(x, Y) < ((1 - ft) * mhr)) And _
                            (Blau2(x, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFF00FF
                        End If
                        
                        If ( _
                            (Grn2(x, Y) < ((1 - ft) * mhg)) And _
                            (Blau2(x, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFFFF00
                        End If
                        
                        'Alle Farben sind dunkler als der Durchschnitt, schwarzer Punkt
                        If ( _
                            (Rot2(x, Y) < ((1 - ft) * mhr)) And _
                            (Grn2(x, Y) < ((1 - ft) * mhg)) And _
                            (Blau2(x, Y) < ((1 - ft) * mhb)) _
                        ) Then
                            Form1.Picture3.PSet (x, Y), &HFFFFFF
                        End If
                    End If
                End If
            End If
        Next Y
    Next x
Wend 'Freigabe_Mepunkte_ermitteln

'Die Mepunkte wurden oben eingezeichnet, hier werden ihre Koordinaten in die
'Variablen geschrieben

For x = 0 To Logobreite - 1
    For Y = 0 To Logohhe - 1
        Farbe = Form1.Picture3.Point(x, Y)
        DoEvents
        If (Schon_benutzt(Farbe) = True) Then
            n = n + 1
            If ((Farbe And &HFF&) = &HFF&) Then
                Mepunkt_Rot_X(n) = x
                Mepunkt_Rot_Y(n) = Y
            End If
            If ((Farbe And &HFF00&) = &HFF00&) Then
                Mepunkt_Grn_X(n) = x
                Mepunkt_Grn_Y(n) = Y
            End If
            If ((Farbe And &HFF0000) = &HFF0000) Then
                Mepunkt_Blau_X(n) = x
                Mepunkt_Blau_Y(n) = Y
            End If
        End If
    Next Y
Next x

m = 0
While m < n     'Solange die Anzahl der Referenzpunkte kleiner ist als die Zahl der
                'Mepunkte wird die Schleife durchlaufen
    x = links + (rechts - links) / 2
    Y = oben + (unten - oben) / 2
    
    'Es werden nur Referenzpunkte zugelassen, die sich auerhalb des Logo befinden
    While _
    (x > links And _
    x < rechts And _
    Y > oben And _
    Y < unten)
    
        DoEvents
        x = (links / 2) + Int((2 * (rechts - links)) * Rnd)
        Y = (oben / 2) + Int((3 * (unten - oben)) * Rnd)
    Wend
    
    DoEvents
    If (Schon_benutzt(Form1.Picture3.Point(x, Y))) Then
        'der zufllige Punkt wird schon als Me/Referenzpunkt benutzt
    Else
        m = m + 1
        Referenzpunkt_X(m) = x
        Referenzpunkt_Y(m) = Y
        Form1.Picture3.PSet (x, Y), &H808080
    End If
Wend

Lauf_M = m 'Beinhaltet nun die Anzahl der Me/Referenzpunkte
Helligkeitstoleranz = CByte(100 * ht) 'Wird wieder umgewandelt in %
Farbtoleranz = CByte(100 * ft) 'Wird wieder umgewandelt in %

Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.speichern.Enabled = True
Form1.identifizieren.Enabled = True

End Sub


Public Sub finde()
'Die Logo_finden-Routine ermittelt die Koordinaten des Senderlogos innerhalb des Fernsehbildes
'dazu ermittelt sie ueber mehrere Bilder den Mittelwert jedes einzelnen Bildpunktes
'Um die Anzahl dieser Punkte gering zu halten, wurde das Bild um den Verkleinerungsfaktor verringert
'-> nicht 750x550(=412500), sondern nur 75x55(=4125) Bildpunkte

'Initialisierung
Dim Fensterrand, n, m, Max_Differenz, Max_Differenz_X_Koordinate, Max_Differenz_Y_Koordinate As Byte
Dim Helligkeit As Long
Dim mh, Zhler1 As Long
Dim Punkt(100, 100) As Long
Dim Punkt2(100, 100) As Byte
Dim x, Y As Long

Fensterrand = 15    'Gibt an, wie weit das Logo von linken bzw. rechten Rand entfern sein darf

With Form1.Picture3
    .Width = Suchbreite
    .Height = Suchhhe
    .Visible = True
    .Left = 22
    .Top = 290
End With

'Der oberste-linke Punkt eines Picture-Objects in VB hat die Koordinaten (0,0)
'Daher wird nur bis Suchbreite,-hhe -1 der Mittelwert gebildet
'(=die Gesamtzahl ist dann wieder Suchbreite * Suchhhe !)

While (n < 80 And Freigabe_Logo_finden = True)

    DoEvents 'Die Kontrolle wird whrend der Schleife an das Betriebssystem gegeben
    
        n = n + 1 '
        
        Call Verkleinertes_Fernsehbild_anzeigen(Suchbreite, Suchhhe)
        
        'vom aktuellen Fernsehbild wird der SW-Wert ermittelt
        'und mit dem errechneten Mittelwert aktualisiert
    
        For x = 0 To Suchbreite - 1
            DoEvents
        
            For Y = 0 To Suchhhe - 1
                DoEvents
                'Routine zur Ermittlung des sw-Wertes
                Helligkeit = Long_Helligkeit(Form1.Picture3.Point(x, Y))
                Punkt(x, Y) = Punkt(x, Y) + Helligkeit
                'der neue Mittelwert des aktuellen XY-Punktes wird in die Punkt2 Matrix
                Punkt2(x, Y) = CByte(Punkt(x, Y) / n)
                
                'Die mittlere Helligkeit des gesamten Bildes wird ermittelt
                mh = mh + Helligkeit
                Zhler1 = Zhler1 + 1
                m = CByte(mh / Zhler1) 'm beinhaltet die durchschnittliche Helligkeit
                
                ' Die Koordinaten des aufflligsten Punktes werden nach der Mittelwertbildung ermittelt
                
                If ((x > Fensterrand) And (x < (Suchbreite - Fensterrand))) Then
                    ' Es werden keine Helligkeitswerte im "inneren Fenster" ermittelt
                Else
                
                    'Wenn der aktuelle Mepunkt "aufflliger" ist als der Bisherige werden seine
                    'Helligkeit und seine Koordinaten gespeichert
                    If (Abs(Punkt2(x, Y) - m) > Max_Differenz) Then
                        
                        Max_Differenz = Abs(Punkt2(x, Y) - m)
                        Max_Differenz_X_Koordinate = x
                        Max_Differenz_Y_Koordinate = Y
                        If (Punkt2(x, Y) > m) Then
                            Helles_Logo = 1
                        Else
                            Helles_Logo = 0
                        End If
                        
                    End If
                    
                End If 'vom hellsten Punkt suchen
            
            Next Y
        
        Next x
        
        If Helles_Logo = 1 Then
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &HFFFFFF
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &HFFFFFF
        Else
            Form1.Picture3.Line (0, Max_Differenz_Y_Koordinate)-(Suchbreite - 1, Max_Differenz_Y_Koordinate), &H0&
            Form1.Picture3.Line (Max_Differenz_X_Koordinate, 0)-(Max_Differenz_X_Koordinate, Suchhhe - 1), &H0&
        End If
        
        Max_Differenz = 1
    
        'Die Start/Stop-Koordinaten werden wieder um den Faktor 10 gestreckt
        'Lag der aufflligste Punkt zu nah am Rand wird LogoX/Y gleich Null gesetzt
        Logo_X = (Max_Differenz_X_Koordinate * 10) - 30
        If Logo_X < 0 Then Logo_X = 0
        Logo_Y = (Max_Differenz_Y_Koordinate * 10) - 50
        If Logo_Y < 0 Then Logo_Y = 0
        
Wend ' von Freigabe_Logo_finden

' An dieser Stelle ist die Mittelwertbildung der Fernsehbilder abgeschloen
Form1.Command1.Visible = False
Form1.Picture3.Visible = False
Form1.Eigenschaften.Enabled = True

End Sub

Public Sub Verkleinertes_Fernsehbild_anzeigen(Breite, Hhe)

'Das vollstndige Fernsehbild wird in Picture2 geschrieben, allerdings nicht
'angezeigt (picture2.visible=false)
Form1.Picture2 = CaptureWindow(Handlewintv, False, TV_X, TV_Y, Breite * Verkleinerungsfaktor, Hhe * Verkleinerungsfaktor)
Form1.Picture3.PaintPicture Form1.Picture2, 0, 0, Breite, Hhe

End Sub

Public Sub TVpause()
If TVpath$ = "" Then Exit Sub
ActivateTV
SendKeys TVpaus$, True
Form1.Show
End Sub
