Attribute VB_Name = "Fernsteuerung"
'   Stand: 01.06.1999 ; verndert von ct/as
'   ----------------------------------------------------------------------
'
'   NoAd: Keine Werbung auf dem Videorekorder: PC Steuerung
'   Copyright (C) 1999 Peter Richert (Richert@FH-Muenster.DE)
'
'   Telefon +49 2551 9-62125, Fax -62391
'
'   Fachhochschule Mnster, Fachbereich Elektrotechnik
'   eLKaTe - Labor Kommunikationstechnik
'   Stegerwaldstrasse 39, 48565 Steinfurt, GERMANY
'
'   ----------------------------------------------------------------------
'   This program is free software; you can redistribute it and/or modify
'   it under the terms of the GNU General Public License as published by
'   the Free Software Foundation; either version 2 of the License, or
'   (at your option) any later version.
'
'   This program is distributed in the hope that it will be useful,
'   but WITHOUT ANY WARRANTY; without even the implied warranty of
'   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'   GNU General Public License for more details.
'
'   You should have received a copy of the GNU General Public License
'   along with this program; if not, write to the Free Software
'   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'   ----------------------------------------------------------------------
'



'Konstanten der Fernsteuerungen
Public Const Video$ = "00101"
Public Const Fernseher$ = "00000"
Global Taste_gedrckt$


Public Sub InitFernsteuerung()
Taste_gedrckt$ = "01"

'Komando-Modus im Infrarotsender einschalten
Call Kommando_Mode_an_IC(True)

'Die Register im Infrarotsender werden initialisiert
Call Kommando_an_IC_senden("11010000")  'Shadow-Bit rcksetzen im Control Register #3
                                            'Register 0-15 werden angesprochen
    
'ControlRegister #1
Call Kommando_an_IC_senden("00001001") 'Transmitter enabled, Echo enabled
    
'Transmit Mode Register #1
Call Kommando_an_IC_senden("00100101")  'TV remote mode enabled,Amplitude modulated carrier modulation
    
'Transmit Mode Register #2
Call Kommando_an_IC_senden("00110110")  'Bits are trandmitted based on TxD, 8 Bits
    
'Output Power Register
Call Kommando_an_IC_senden("01000011")  'Both LED1C and LED2C enabled
    
'Modulator Divider Register #1 & #2
Call Kommando_an_IC_senden("10100101")  'LSB
Call Kommando_an_IC_senden("10110110")  'MSB ;auf 36 kHz einstellen
    
Call Kommando_an_IC_senden("11010001")  'Shadow bit setzen im Control Register #3
                                            'Register 16-31 werden angesprochen
    
'TV Remote Transmit Bit Rate Divider Register #1 & #2
Call Kommando_an_IC_senden("00111101") '
Call Kommando_an_IC_senden("01001100") '1120 bps
    
'Control Register #4
'Call Kommando_an_IC_senden("01010010")  'If crystal ist used, disable clock output driver (Hi-Z)
                                               'Nur Sicherheitshalber, um berschwinger zu vermeiden
    
Call Kommando_an_IC_senden("11010000")  'Shadow-Bit rcksetzen im Control Register #3
                                                'Register 0-15 werden angesprochen
'Programmierung des IC's beendet
'Komando-Modus im Infrarotsender ausschalten

Call Kommando_Mode_an_IC(False)
End Sub



Public Function Time_Long(ByVal Zeit$) As Long

'Um die Start/Stopzeit zu erkennen werden zwei Long-Zahlen
Time_Long = Val(Mid$(Zeit$, 1, 1)) * 100000 + Val(Mid$(Zeit$, 2, 1)) * 10000 + Val(Mid$(Zeit$, 4, 1)) * 1000 + Val(Mid$(Zeit$, 5, 1)) * 100 + Val(Mid$(Zeit$, 7, 1)) * 10 + Val(Mid$(Zeit$, 8, 1)) * 1

End Function

Public Function Long_Time(ByVal Zeit As Long) As String

Long_Time = Mid$(Zeit, 1, 2) & ":" & Mid$(Zeit, 3, 2) & ":" & Mid$(Zeit, 5, 2)

End Function




Public Sub Kommando_an_Fernbedienung_senden(ByVal Steuerbit$, ByVal Video_Fernseh$, ByVal Kommando$)

'eine gesendete "1" schaltet die LED aus, whrend eine "0" die LED zum Leuchetn bringt
'Daher mu die Bitfolge noch invertiert werden

'Zur Unterscheidung, ob eine Taste zweimal gedrckt wurde oder die gleiche
'Taste nur lange gedrckt wurde, wechselt das dritte Bit nach dem Loslassen immer
'den Wert.
Dim Taste_Gedrckt_Bi$
Dim Steuerbit_Bi$

If Taste_gedrckt$ = "1" Then
    Taste_gedrckt$ = "0"
    Taste_Gedrckt_Bi$ = "01" '01 ist ok
    Steuerbit_Bi$ = "10"
Else
    Taste_gedrckt$ = "1"
    Taste_Gedrckt_Bi$ = "10"
    Steuerbit_Bi$ = "10"
End If

If Steuerbit$ = "1" Then
    Steuerbit_Bi$ = "10"
Else
    Steuerbit_Bi$ = "01"
End If

Dim Video_Fernseh_Bi$
If Video_Fernseh = "00101" Then
    Video_Fernseh_Bi$ = "0101100110" '=00101
Else
    Video_Fernseh_Bi$ = "0101010101" '=00000
End If

Dim Bit(5) As Byte
Dim Bit_Bi$(5)
Dim Kommando_Bi$

'Kommando_Bi$ = 1

For n = 0 To 5
    Bit(n) = Val(Mid$(Kommando$, 6 - n, 1))
    If Bit(n) = 1 Then
        'invertiert
        Bit_Bi$(n) = "10"
    Else
        Bit_Bi$(n) = "01"
    End If
    
    Kommando_Bi$ = Bit_Bi$(n) & Kommando_Bi$
Next n

'enthlt 28 Bit (Biphase codierte 14 Bit !)+ 4x"1111" zum Auffllen = 32 Zeichen
Befehl$ = "10" & Steuerbit_Bi$ & Taste_Gedrckt_Bi$ & Video_Fernseh_Bi$ & Kommando_Bi$ & "1111"
'Befehl$ = "1010" & Taste_Gedrckt_Bi$ & Video_Fernseh_Bi$ & Kommando_Bi$ & "1111"

Dim a(3)


    For m = 0 To 3

        a(m) = 0
        For n = 0 To 7
          a(m) = a(m) + (Val(Mid$(Befehl$, n + 1 + (8 * m), 1)) * (2 ^ n))
'          a = a + (Val(Mid$(Befehl$, n + 1 + (8 * m), 1)) * (2 ^ (7 - n)))
        Next n
    
    Next m
        
    For Anzahl_Sendungen = 1 To 2
        
        Form1.MSComm1.Output = Chr$(a(0)) + Chr$(a(1)) + Chr$(a(2)) + Chr$(a(3))
    
    Next Anzahl_Sendungen


End Sub

Public Sub Kommando_Mode_an_IC(ByVal Status As Boolean)

If (Status) Then
    Form1.MSComm1.RTSEnable = True ' Chip Reset setzen
    Form1.MSComm1.RTSEnable = False ' Chip Normal Operation setzen
    
    Form1.MSComm1.DTREnable = True ' Chip auf Steuerempfang (D/C_ auf low) setzen
Else
    ' Zeitschleife damit das Signal DTR nicht zu frh wechselt
    Y = 0
    For X = 0 To 1000
        Y = Y + 1
    Next X
    
    Form1.MSComm1.DTREnable = False  ' Chip auf Datenempfang (D/C_ auf high) setzen
End If

End Sub
Public Sub Kommando_an_IC_senden(ByVal Kommando$)

Dim Bit(7) As Byte
Dim Summe As Byte

For n = 0 To 7
    Bit(n) = ((Val(Mid$(Kommando$, (8 - n), 1))) * (2 ^ n))
    Summe = Summe + Bit(n)
Next n

'Form1.MSComm1.DTREnable = False ' Chip auf Steuerempfang (D/C_ auf low) setzen
Form1.MSComm1.Output = Chr$(Summe)
'Form1.MSComm1.DTREnable = True  ' Chip auf Datenempfang (D/C_ auf high) setzen

End Sub

Public Sub Recording()

    'REC
    Call Kommando_an_Fernbedienung_senden("1", Video, "110111")
    
    'Form1.MSComm1.DTREnable = True
    'For n = 1 To 10000
    '    DoEvents
    'Next n
    'Form1.MSComm1.DTREnable = False

End Sub

Public Sub Stopp()
    
    'Stop
    Call Kommando_an_Fernbedienung_senden("1", Video, "110110")

    'Form1.MSComm1.RTSEnable = False
    'For n = 1 To 10000
    '    DoEvents
    'Next n
    'Form1.MSComm1.RTSEnable = True

End Sub

