#ifndef _PARAMS
#define _PARAMS

#define TRUE 		1
#define FALSE 		0
#define SUCCESS  	0
#define FAIL    	-1

#define byte unsigned char
#define bool byte

/* Control Register Bits (Read/Write) */
#define STROBE 0x01   	/* Bit 0	(Strobe) */
#define AUTOLF 0x02   	/* Bit 1	(Auto Linfeed) */
#define INIT   0x04   	/* Bit 2	(Initialize Printer) */
#define SELECT 0x08   	/* Bit 3	(Select Printer) */
#define EACK   0x10  	/* Bit 4	(Enable IRQ Via Ack Line) */
#define BIDIR  0x20  	/* Bit 5	(Enable bi-directional Port) */

/* Status Register Bits (Read Only) */
#define IRQ    0x04   	/* Bit 2	(IRQ (Not)) */
#define ERROR  0x08   	/* Bit 3	(Error) */
#define SELIN  0x10  	/* Bit 4	(Select In) */
#define PAPER  0x20	 	/* Bit 5	(Paper Out) */
#define ACK    0x40	 	/* Bit 6	(Ack) */
#define BUSY   0x80	 	/* Bit 7	(Busy) */

/* ATMEL register access codes for R/W */
#define WR_MP3			0  	/* AUTOLF+SELECT */
#define WR_INP_SEL   1		/* AUTOLF */
#define WR_LCD_CMD	2		/* INIT+AUTOLF+SELECT */
#define WR_LCD_CHAR	3		/* INIT+AUTOLF */
#define RD_INP_STAT	0  	/* AUTOLF+INIT+SELECT+BIDIR */
#define RD_INP_VAL	1		/* AUTOLF+INIT+BIDIR */

#define GET_KEY_INP	0x12	/* Get key state */
#define GET_IR_DATA	0x10	/* Get IR code data byte */
#define GET_IR_ADR	0x11	/* Get IR code adr byte */
#define GET_KNOP_INP	0x14	/* Get rotation knop input */

#define RD_STAT_MASK	0x3c  /* Mask to eval input status after read */

/* Interrupt controller registers */
#define INT_MASTER_CTRL	0x20	/* Control register for master INTs */
#define INT_SLAVE_CTRL	0xa0	/* Control register for slave INTs */
#define EOI					0x20	/* End of INT indicator */
#define MASK_REG_OFFSET	0x01	/* Relative address offset mask register */

#endif
