#ifndef _MPFILEIO
#define _MPFILEIO

#define MP3_STAT_PLAY	1	/* Normale Wiedergabe ueber INT-Handler */
#define MP3_STAT_PAUSE	2	/* Wiedergabe unterbrochen durch Sperren des INT */
#define MP3_STAT_STOP	3	/* Wiedergabe vorbereiten, INT freigeben */
#define MP3_STAT_END		4  /* Behandlung eines Pufferunterlaufs */
#define MP3_STAT_RESTRT	5	/* Wiedergabe nach Pufferunterlauf wieder aufn. */

#define FILEEND	2			/* Flag zur Dateiendeerkennung */
#define BUFLEN		50000U	/* Groesse des MP3-Daterpuffers */

/* Struktur zur aktuell behandelten Datei */
typedef struct tagMP3FILEParams
{
	FILE				*fh;						/* Zeiger auf geoeffnete Datei */
	char				*fn;						/* Name der geoeffneten Datei */
	char				stat;						/* Status bei der Dateiwiedergabe */
	long				fSize;					/* Groesse der aktuellen Datei (Bytes) */
	long				curPos;					/* Derzeitige Ausleseposition in Datei */
	char				buf[BUFLEN];			/* Programmint. Puffer fuer MP3-Daten */
	unsigned int	rb_start, rb_end;		/* Zeiger des Ringpuffers */
	unsigned int	rb_full, rb_refill;	/* Status des Ringpuffers */
	int				burst_length;			/* Laenge des Burste beim Nachladen */
	int				buffer_limit;			/* Fuellstandsgrenze zum Nachfuellen */
} MP3FILEPARAMS;

void MPFile_Init(void);		/* Initialsierung der Variablen */
int MPFile_Play(char*);		/* Routine liefert MP3-Daten an MAS und muss daher */
									/* im Hauptprogramm zykl. gepollt werden */
void MPFile_Stop(void);		/* Direkter Stop durch INT-Freigabe und Schliessen */
									/* der entspr. Datei */
void MPFile_Pause(void);	/* Pausenfunktion bei der MP3-Wiedergabe wird d. */
									/* Aktivierung und Freigabe des INTs geregelt */
#endif
