#ifndef _FILEIO
#define _FILEIO

#define PATH_LENGTH					256
#define FILE_STRUCT_CHUNK_SIZE 	600

/* Flags fuer erkannten Dateityp auf gewaehltem Medium */
#define FILETYPE_UNKNOWN	0
#define FILETYPE_MP3DISK	1
#define FILETYPE_NOMP3DISK	2

/* Info zu jedem (ausgewaehlten) Laufwerk */
typedef struct tagDriveInfoEntry
{
	char letter;		/* Laufwerksbuchstabe */
	char type;			/* Dateityp auf Laufwerk */
} DriveInfoEntry;

/* Info zu jeder gefundenen MP3-Datei */
typedef struct tagFileEntry
{
	char* fpath;				/* Pfad zu gefundener Datei */
	char* fname;				/* Name der gefundenen Datei */
	char* fdname;				/* Dateiname fuer LCD-Ausgabe */
	unsigned char tagged;	/* Flag fuer ausgewaehlte Datei */
	unsigned char played;	/* Flag fuer bereits gespielte Datei */
	int dirId;					/* Zaehler fuer ausgewaehltes Verzeichnis */
} FileEntry;

int GetFileList(char*);			/* Dateinamen rekursiv von Laufwerk aufbauen */
int CheckDrives(void);			/* Laufwerke des Systems ermitteln */
char GetCurLetter(void);		/* Wrapper fuer Laufwerksbuchstaben */
char *GetFirstMp3(void);		/* Ersten MP3-Dateinamen holen */
char *GetNextMp3(void);			/* Eine Datei weiter skippen */
char *GetPrevMp3(void);			/* Eine Datei zurueck skippen */
void ClearFileList(void);		/* Speicher freigeben */
void SetCurDriveType(int);		/* Wrapper zum Laufwerkstyp */
int DumpDrives(int ,int );		/* Scrollfunktion-Laufwerksmenu */
char *GetNextMp3Dir(void);		/* Ein Verzeichnis vorwaerts skippen */
char *GetPrevMp3Dir(void);		/* Ein Verzeichnis zurueck skippen */
int GenerateDirEntries(void);	/* Dateinamen nach Verzeichnissen gruppieren */
										/* und Zeiger fuer Kurzdarstellung setzen */
int DumpFiles(int,int);			/* Scrollfunktion-Dateinamensmenu */
void ToggleFile(void);			/* Datei fuer Wiedergabe De/Selektieren */
void ToggleTagFlag(void);		/* Globales LW Tagging togglen */
char *GetLCDName(void);			/* Gekuerzten Dateinamen fuer LCD liefern */

#endif