/* Basic File-IO Routines for the CT-Player-Project,version 1.0.

	Copyright (C) 1999 Marcus Schwatke; Peter Santo [GetFileList()]

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2, or (at your option)
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <bios.h>
#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include<string.h>
#include<stdlib.h>
#include <conio.h>

#include "parms.h"
#include "fileio.h"
#include "display.h"

FileEntry fileList[FILE_STRUCT_CHUNK_SIZE];	/* List of rec. found files */
int fileListSize=0;									/* Number of files found */
int fileListCur=0;									/* Current position in file list */

DriveInfoEntry *DriveInfo;	/* Properties of current drive*/
int DriveInfoCnt=0; 			/* Number of drives found */
int DriveInfoCur=0; 			/* Current drive */

char pretagged;				/* Global tagging flag */

/*
Function    : Get filenames recursively.
Arguments   : start_path: Path where the search begins.
Return Value: Number of files found.
Comments    : The findfirst()/findnext() are handy and fast under DOS
				  but do not port well. Sorry, but you *ix freaks out
				  there will have to use opendir(), readdir() and stat()
				  instead.
*/
int GetFileList(char *start_path)
{
	char search_path[PATH_LENGTH];
	char next_path[PATH_LENGTH];
	char mp3_entry[PATH_LENGTH];
	struct ffblk ffblk;
	int done;

	sprintf(search_path, "%s*.*", start_path);
	done = findfirst(search_path, &ffblk,FA_NORMAL | FA_RDONLY | FA_HIDDEN
																	| FA_DIREC | FA_ARCH);
	while(!done)
	{
		if((ffblk.ff_attrib == FA_DIREC) && (*(ffblk.ff_name) != '.'))
		{
			sprintf(next_path, "%s%s\\", start_path, ffblk.ff_name);
			GetFileList(next_path);
		}
		else
		{
			if(!strcmp(ffblk.ff_name + strlen(ffblk.ff_name) - 3, "MP3"))
			{
				if(fileListSize<FILE_STRUCT_CHUNK_SIZE)
				{
					sprintf(mp3_entry, "%s%s", start_path, ffblk.ff_name);
					fileList[fileListSize].fpath
					= (char*)malloc((strlen(mp3_entry)+1) * sizeof(char));
					strcpy(fileList[fileListSize].fpath, mp3_entry);
					fileList[fileListSize].tagged = pretagged;
					fileList[fileListSize].played = TRUE;
					fileList[fileListSize].dirId = 0;
					fileListSize++;
				}
			}
		}
		done = findnext(&ffblk);
	}
	return fileListSize;
}

/* Get first MP3-name from file list */
char * GetFirstMp3()
{
	fileListCur=0;
	while((fileList[fileListCur].tagged==FALSE)&&(fileListCur<fileListSize))
		fileListCur++;
	return fileList[fileListCur].fpath;
}

/* Get next MP3-name from file list */
char * GetNextMp3()
{
	if(fileListCur<(fileListSize-1))
	{
		fileList[fileListCur++].played=TRUE;
		while((fileList[fileListCur].tagged==FALSE)&&(fileListCur<(fileListSize-1)))
			fileListCur++;
	}
	return fileList[fileListCur].fpath;
}

/* Get last MP3-name from file list */
char * GetPrevMp3()
{
	if(fileListCur>0)
	{
		fileList[fileListCur--].played=TRUE;
		while((fileList[fileListCur].tagged==FALSE)&&(fileListCur>0))
			fileListCur--;
	}
	return fileList[fileListCur].fpath;
}

/* Return file name abbreviation for LCD */
char *GetLCDName()
{
	return  fileList[fileListCur].fdname;
}

/* Get last directory */
char* GetPrevMp3Dir()
{
	int cnt=0;
	fileList[fileListCur].played=TRUE;
	if(fileListCur>0)
	{
		do
		{
			fileListCur--;
		}
		while(((fileList[fileListCur].tagged==FALSE)&&(fileListCur>0)) ||
				((fileList[fileListCur].dirId==fileList[fileListCur+1].dirId)&&
				(fileListCur>0))||((cnt++==0)&&(fileListCur>0)));
		if(fileList[fileListCur].dirId!=fileList[fileListCur+1].dirId)
			fileListCur++;
	}
	return fileList[fileListCur].fpath;
}

/* Get next directory */
char* GetNextMp3Dir()
{
	fileList[fileListCur].played=TRUE;
	if(fileListCur<(fileListSize-1))
	{
		do
		{
			fileListCur++;
		}
		while(((fileList[fileListCur-1].tagged==FALSE)
				&&(fileListCur<fileListSize))||((fileList[fileListCur].dirId==
				fileList[fileListCur-1].dirId)&&(fileListCur<fileListSize)));
	}
	return fileList[fileListCur].fpath;
}

/* Output drive menu */
void DumpLine(char letter, char tag, int line, int type)
{
	char out[17];
	switch(type)
	{
		case  FILETYPE_UNKNOWN:
			if(line==0)
				sprintf(out,"*LW:%c[???]     ",letter);
			else
				sprintf(out," LW:%c[???]     ",letter);
			break;
		case FILETYPE_MP3DISK:
			if(line==0)
				sprintf(out,"*LW:%c[MP3]     ",letter);
			else
				sprintf(out," LW:%c[MP3]     ",letter);
			break;
		case FILETYPE_NOMP3DISK:
			if(line==0)
				sprintf(out,"*LW:%c[NOMP3]   ",letter);
			else
				sprintf(out," LW:%c[NOMP3]   ",letter);
			break;
	}
	if(tag==TRUE)		/* Display tag default behaviour */
		strcat(out,"+");
	else
		strcat(out,"-");
	Display_String(line,out);
}

/* (De-)Select files for playing by tagging them individually */
void ToggleFile()
{
	if(fileList[fileListCur].tagged == TRUE)
		fileList[fileListCur].tagged = FALSE;
	else
		fileList[fileListCur].tagged = TRUE;
}

/* (Dis-)Enable global tag flag */
void ToggleTagFlag()
{
	if(pretagged == TRUE)
		pretagged = FALSE;
	else
		pretagged = TRUE;
}

/* Output one line file name */
int DumpFileLine(char*path,int i,int line ,int tagged)
{
	char out[200];
	int cnt;

	if(tagged==TRUE)
	{
		if(line==0)
			cnt=sprintf(out,"*+:%03d:%s",i+line+1,path);
		else
			cnt=sprintf(out," +:%03d:%s",i+line+1,path);
	}
	else
	{
		if(line==0)
			cnt=sprintf(out,"*-:%03d:%s",i+line+1,path);
		else
			cnt=sprintf(out," -:%03d:%s",i+line+1,path);
	}
	if(cnt>16)
		out[15]=0;

	Display_String(line,out);
	return TRUE;
}

/* Scroll lines of file names */
int DumpFiles(int scroll,int lines)
{
	int i;
	if(scroll==0)
	{
		for(i =0;i<lines;i++)
			if((i+fileListCur)<fileListSize)
				DumpFileLine(fileList[fileListCur+i].fname,fileListCur,i,
									fileList[fileListCur+i].tagged);
			else
				Display_String(i,"                ");
		return fileListCur;
	}
	if(scroll>0)
	{
		if((fileListCur+1)<fileListSize)
		{
			fileListCur++;
			for(i=0;i<lines;i++)
				if((i+fileListCur)<fileListSize)
					DumpFileLine(fileList[fileListCur+i].fname,fileListCur,i,
										fileList[fileListCur+i].tagged);
				else
					Display_String(i,"                ");
		}
		return fileListCur;
	}
	if(scroll<0)
	{
		if(fileListCur>0)
		{
			fileListCur--;
			for(i=0;i<lines;i++)
				if((i+fileListCur)<fileListSize)
					DumpFileLine(fileList[fileListCur+i].fname,fileListCur,i,
										fileList[fileListCur+i].tagged);
				else
					Display_String(i,"                ");
		}
		return fileListCur;
	}
	return 0;
}

/* Scroll lines of drive names */
int DumpDrives(int scroll,int lines)
{
	int i;
	if(scroll==0)
	{
		for(i =0;i<lines;i++)
			if((i+DriveInfoCur)<DriveInfoCnt)
			 DumpLine(DriveInfo[DriveInfoCur+i].letter,pretagged,i,
							DriveInfo[DriveInfoCur+i].type);
			else
			{
				Display_String(i,"                ");
			}
		return DriveInfoCur;
	}
	if(scroll>0)
	{
		if((DriveInfoCur+1)<DriveInfoCnt)
		{
			DriveInfoCur++;
			for(i=0;i<lines;i++)
				if((i+DriveInfoCur)<DriveInfoCnt)
					DumpLine(DriveInfo[DriveInfoCur+i].letter,pretagged,i,
									DriveInfo[DriveInfoCur+i].type);
				else
				{
					Display_String(i,"                ");
				}
		}
		return DriveInfoCur;
	}
	if(scroll<0)
	{
		if(DriveInfoCur>0)
		{
			DriveInfoCur--;
			for(i=0;i<lines;i++)
				if((i+DriveInfoCur)<DriveInfoCnt)
					DumpLine(DriveInfo[DriveInfoCur+i].letter,pretagged,i,
									DriveInfo[DriveInfoCur+i].type);
				else
				{
					Display_String(i,"                ");
				}
		}
		return DriveInfoCur;
	}
	return 0;
}

/* Locate all installed drives */
int CheckDrives(void)
{
	int save, disk,i,j;
	bool letters[26];

	/* altes LW merken */
	save = getdisk();

	letters[0] = FALSE;
	letters[1] = FALSE;
	for (disk = 2;disk < 26;++disk)
	{
		setdisk(disk);
		if (disk == getdisk())
	  {
		  letters[disk] = TRUE;
		  DriveInfoCnt++;
	  }
	  else
		  letters[disk] = FALSE;
	}
	setdisk(save);

	if((DriveInfo=(DriveInfoEntry*) malloc ( sizeof(DriveInfoEntry)
															*DriveInfoCnt))==NULL)
		return FALSE;

	pretagged = TRUE;

	for(i=0,j=0;i<26;i++)
			if(letters[i]==TRUE)
		{
			DriveInfo[j].letter=i + 'A';
			DriveInfo[j].type = FILETYPE_UNKNOWN;
			j++;
		}

	return DriveInfoCnt;
}

/* Group files after names and directories in list */
int GenerateDirEntries()
{
	int i=0,dirs=0;
	char frstDir[200],scndDir[200];
	char tmp[200];
	char fname[200];

	while(i<fileListSize)
	{
		fnsplit(fileList[i].fpath, tmp,frstDir,fname,tmp);
		fnsplit(fileList[i+1].fpath, tmp,scndDir,tmp,tmp);
		fileList[i].fname
		= &fileList[i].fpath[strlen(fileList[i].fpath)-strlen(fname)-4];
		fileList[i].fdname = &fileList[i].fpath[strlen(fileList[i].fpath)-20];

		if(strcmp(frstDir,scndDir)!=0)
		{
			fileList[i+1].dirId = fileList[i].dirId+1;
			dirs++;
		}
		else
			fileList[i+1].dirId = fileList[i].dirId;
		i++;
	}
	return TRUE;
}

/* Clear memory from file list */
void ClearFileList(void)
{
	int i;

	for(i=0;i<fileListSize;i++)
	{
		if(fileList[i].fpath!=NULL)
		{
			free(fileList[i].fpath);
			fileList[i].fpath=0;
		}
		fileList[i].fname=0;
		fileList[i].fdname=0;
	}
	fileListSize=0;
	fileListCur=0;
}

/* Return current drive letter */
char GetCurLetter()
{
	return  DriveInfo[DriveInfoCur].letter;
}

/* Return current drive type */
void SetCurDriveType(int type)
{
	DriveInfo[DriveInfoCur].type = type;
}

