unit CMCdec;

interface
uses TPCrt, TPmouse, TPEdit, Dos, TPWindow, TpPick, CMCDef;

function luhnCS(sIn:String):integer;
function exorCS(sIn:String):integer;
procedure showcardData(DecStr:String; BitsPerInch:Integer);


implementation


function luhnCS(sIn:String): integer;
{ Checksummenberechnung nach Luhn }
var
  i,j,k,n,m,luhn0,luhn1,err:integer;
  z:char;
begin
  n:=length(sIn);
  luhn0:=0;
  m:= n mod 2;  { gerade/ungerade Anzahl Ziffern }
  for i:=1 to n do
  begin
    val(sIn[i],j,err);
    if err=0 then
    begin
      k:=j*((m mod 2)+1);     { * ...21212121 }
      if k>9 then k:=k div 10 + k mod 10;
      luhn0:=luhn0+k;
      m:=m+1;
    end;
  end;
  luhn1:=10*(luhn0 div 10 + luhn0 mod 10);
  luhnCS:=(luhn1-luhn0) mod 10;
end;

function exorCS(sIn:String): integer;
{ Checksummenberechnung straight XOR }
var
  i,j,k,n,m,exor0,err:integer;
  z:char;
begin
  n:=length(sIn);
  exor0:=0;
  for i:=1 to n do
  begin
    val(sIn[i],j,err);
    if err=0 then
    begin
      exor0:=exor0 xor j;
    end;
  end;
  exorCS:=exor0;
end;

procedure showcardData(DecStr:String; BitsPerInch:Integer);
var
  i,l,n,pos1,pos2,pos3,pos4,len1,len2,len3,
  luhn,exor,err:integer;
  data1,data2,data3,data4,data5,data6: String[64];
  lcode,blz,kto,cardnr,expy,expm: String[16];
  aStr: String;
  ch:char;
  luhncard,luhncomp:integer;

  function findDlm(start:integer; dlm:char):Integer;
  var n: integer;
  begin
    l:=length(DecStr);
    findDlm:=l;
    for n:=start to l do
      if (DecStr[n] = dlm) or (DecStr[n] = '?') then
        begin
          findDlm:=n;
          exit;
        end;
  end;

begin
  textattr := c1e;
  writeln(DecStr);
  textattr := c1f;
  writeln;
  case DecStr[1] of
    ';':
      if BitsPerInch < 150 then
        begin { mittlere Spur 5-Bit ISO }
          write('Spur 2 mit 75 BpI, 5-Bit-ISO');
          if copy(DecStr,pos1,2) = '59' then
            begin
              writeln(' (Kundenkarte)');
              writeln;
            end
          else
            begin
              writeln(' (EC- oder Kreditkarte)');
              writeln;
              pos1:=2;
              pos2:=1+findDlm(pos1,'=');
              len1:=pos2-pos1-1;
              pos3:=1+findDlm(pos2,'=');
              len2:=pos3-pos2-1;
              pos4:=1+findDlm(pos3,'=');
              len3:=pos4-pos3-1;
              data1:=copy(DecStr,pos1,len1);
              data2:=copy(DecStr,pos2,len2);
              data3:=copy(DecStr,pos3,len3);
              textattr := c1f;
              write('Kartennummer: ');
              textattr := c1a;
              writeln(data1);
              textattr := c1f;
              write('Errechnete Luhn-Prfziffer: ');
              writeln(luhnCS(copy(data1,1,len1-1)));
              write('Gltig bis Jahr/Monat: ');
              textattr := c1a;
              writeln(copy(data2,1,4));
              textattr := c1f;
              write('Serice-Code: ');
              textattr := c1a;
              writeln(copy(data2,5,3));
              textattr := c1f;
              case data2[5] of
                '1': write('(international, ');
                '2': write('(international/alternativ, ');
                '5': write('(national, ');
                '6': write('(national/alternativ, ');
                '7': write('(privat, ');
              else
                write('(nicht vergeben, ');
              end;
              case data2[6] of
                '0': write('normales Limit, ');
                '1': write('niedriges Limit, ');
                '2': write('Autorisierung erforderlich, ');
                '3': write('hohes Limit, ');
                '4': write('spezielle Vereinbarung, ');
              else
                write('nicht vergeben, ');
              end;
              case data2[7] of
                '0': writeln('PIN erforderlich)');
                '1': writeln('keine Restriktionen)');
                '2': writeln('nur Waren und Leistungen)');
                '3': writeln('nur Bargeld mit PIN)');
                '4': writeln('nur Bargeld)');
                '5': writeln('nur Waren und Leistungen mit PIN)');
              else
                writeln('nicht vergeben)');
              end;
              textattr := c1f;
              write('Diskrete Daten: ');
              textattr := c1a;
              writeln(copy(data2,9,99));
            end;
          ;
        end
      else
        begin { Spur 3 mit 5-Bit ISO (EC-Karte) }
          textattr := c1f;
          writeln('Spur 3 mit 210 BpI, 5-Bit-ISO (EC-Karte):');
          writeln;
          write('Format-Code: ');
          textattr := c1a;
          write(copy(DecStr,2,2),' (');
          if DecStr[3] = '1' then
            write('inter');
          write('nationale Karte)');
          textattr := c1f;
          write(', Branchenschlssel: ');
          textattr := c1a;
          writeln(copy(DecStr,4,2));
          textattr := c1f;
          write('Bankleitzahl: ');
          textattr := c1a;
          write(copy(DecStr,6,8));
          textattr := c1f;
          write(', Kontonummer: ');
          textattr := c1a;
          write(copy(DecStr,15,10));
          textattr := c1f;
          write(', PAN-Prfziffer: ');
          textattr := c1a;
          writeln(copy(DecStr,25,1));
          textattr := c1f;
          write('Lnder-Schlssel: ');
          textattr := c1a;
          write(copy(DecStr,27,3));
          textattr := c1f;
          write(' (280=Deutschland)');
          write(', Whrung: ');
          textattr := c1a;
          write(copy(DecStr,30,3));
          textattr := c1f;
          write(' (954=DM), Exponent: ');
          textattr := c1a;
          writeln(copy(DecStr,33,1));
          textattr := c1f;
          write('Verfgung pro Zyklus: ');
          textattr := c1a;
          write(copy(DecStr,34,4));
          textattr := c1f;
          write(', Rest pro Zyklus: ');
          textattr := c1a;
          writeln(copy(DecStr,38,4));
          textattr := c1f;
          write('Ausstellung oder Zyklusbeginn Jahr/Tag: 9');
          textattr := c1a;
          write(copy(DecStr,42,1),' ',copy(DecStr,43,3));
          textattr := c1f;
          write(', Lnge: ');
          textattr := c1a;
          writeln(copy(DecStr,46,2));
          textattr := c1f;
          write('Fehlbedienungszhler: ');
          textattr := c1a;
          write(copy(DecStr,48,1));
          textattr := c1f;
          write(', Algorithmus: ');
          textattr := c1a;
          write(copy(DecStr,49,2));
          textattr := c1f;
          write(' (01=DES), Offset 1: ');
          textattr := c1a;
          writeln(copy(DecStr,51,4));
          textattr := c1f;
          write('Freizgigkeit: ');
          textattr := c1a;
          write(copy(DecStr,55,1));
          textattr := c1f;
          writeln(' (0=EC, 6=Bank-Card, 2=S-Card)');
          write('Kontoart: ');
          textattr := c1a;
          write(copy(DecStr,56,1));
          textattr := c1f;
          write(', Einschrnkungen: ');
          textattr := c1a;
          write(copy(DecStr,57,5));
          textattr := c1f;
          write(', Gltig bis Jahr/Monat: ');
          textattr := c1a;
          writeln(copy(DecStr,62,4));
          textattr := c1f;
          write('Kartenfolgenummer: ');
          textattr := c1a;
          write(copy(DecStr,66,1));
          textattr := c1f;
          write(', EAN-Code: ');
          textattr := c1a;
          write(copy(DecStr,67,1));
          textattr := c1f;
          write(', MM-Verfahren: ');
          textattr := c1a;
          writeln(copy(DecStr,68,8));
          textattr := c1f;
          write('Letzte Verfgung Jahr/Tag: 9');
          textattr := c1a;
          writeln(copy(DecStr,80,1),' ',copy(DecStr,81,3));
          textattr := c1f;
          write('Offset 2: ');
          textattr := c1a;
          write(copy(DecStr,84,4));
          textattr := c1f;
          write(', Offset 3: ');
          textattr := c1a;
          writeln(copy(DecStr,88,4));
          textattr := c1f;
          textattr := c1f;
          write('EC-Sprachcode: ');
          textattr := c1a;
          writeln(copy(DecStr,92,1));
          textattr := c1f;
        end;
    '%':
      begin
        writeln('Spur 1 mit 210 BpI, 7-Bit ISO (Kreditkarte IATA)');
        writeln;
        pos1:=3;
        pos2:=1+findDlm(pos1,'^');
        len1:=pos2-pos1-1;
        pos3:=1+findDlm(pos2,'^');
        len2:=pos3-pos2-1;
        pos4:=1+findDlm(pos3,'^');
        len3:=pos4-pos3-1;
        data1:=copy(DecStr,pos1,len1);
        data2:=copy(DecStr,pos2,len2);
        data3:=copy(DecStr,pos3,len3);
        ;
        textattr := c1f;
        write('Kartennummer: ');
        textattr := c1e;
        writeln(data1);
        textattr := c1f;
        write('Errechnete Luhn-Prfziffer: ');
        writeln(luhnCS(copy(data1,1,len1-1)));
        write('Nachname/Vorname: ');
        textattr := c1e;
        writeln(data2);
        textattr := c1f;
        write('Gltig bis Jahr/Monat: ');
        textattr := c1e;
        writeln(copy(data3,1,4));
        textattr := c1f;
        write('Serice-Code: ');
        textattr := c1e;
        writeln(copy(data3,5,3));
        textattr := c1f;
        case data3[5] of
          '1': write('(international, ');
          '2': write('(international/alternativ, ');
          '5': write('(national, ');
          '6': write('(national/alternativ, ');
          '7': write('(privat, ');
        else
          write('(nicht vergeben, ');
        end;
        case data3[6] of
          '0': write('normales Limit, ');
          '1': write('niedriges Limit, ');
          '2': write('Autorisierung erforderlich, ');
          '3': write('hohes Limit, ');
          '4': write('spezielle Vereinbarung, ');
        else
          write('nicht vergeben, ');
        end;
        case data3[7] of
          '0': writeln('PIN erforderlich)');
          '1': writeln('keine Restriktionen)');
          '2': writeln('nur Waren und Leistungen)');
          '3': writeln('nur Bargeld mit PIN)');
          '4': writeln('nur Bargeld)');
          '5': writeln('nur Waren und Leistungen mit PIN)');
        else
          writeln('nicht vergeben)');
        end;
        textattr := c1f;
        write('Diskrete Daten: ');
        textattr := c1e;
        writeln(copy(data3,9,99));
      end;
    else
      begin
        writeln('Keine ISO-gerechte Spur. Bitte Dekodierbeginn');
        writeln('auf erstes Datenbit setzen.');
      end;
  end;
end;

end.