#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_UseUpx=n
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
; ---------------------------------------------------------------------
; c't-CD-Patcher Version 1.0, 11.12.08
; Autor: Karsten Violka, kav@ctmagazin.de
; ---------------------------------------------------------------------

#include <EditConstants.au3>
#include <WindowsConstants.au3>
#include <GuiConstantsEx.au3>

AutoItSetOption("GUIOnEventMode", 1)

$Form2 = GUICreate("c't-Software-Kollektion 8/08 aktualisieren", 480, 320, 10, 10)
GUICtrlSetFont(-1, 20, 400, 0, "Arial")
$btnSearch = GUICtrlCreateButton("CD suchen", 20, 20, 140, 25)

$btnStart = GUICtrlCreateButton("Auslesen und aktualisieren", 170, 20, 140, 25)
$btnBurn = GUICtrlCreateButton("Neue CD brennen", 320, 20, 140, 25)

$edtOutput = GUICtrlCreateEdit("",16,70,445,230, $ES_READONLY + $ES_MULTILINE + $WS_VSCROLL + $ES_AUTOVSCROLL)

GUISetState(@SW_SHOW)
; ----------------------------------------------------

GUISetOnEvent($GUI_EVENT_CLOSE, "evtClose")
GUICtrlSetOnEvent ($btnSearch, "evtSearch")
GUICtrlSetOnEvent ($btnStart, "evtStart")
GUICtrlSetOnEvent ($btnBurn, "evtBurn")

GUISetState(@SW_SHOW)

$DefaultWorkingDir = @WorkingDir
$CDROM =""
init()

While 1
 Sleep(1000)   ; Warteschleife fr GUI
WEnd

Func init()
	enableInput()
	evtSearch()
EndFunc

Func evtSearch()
	$CDROM = getCDROM()
	If $CDROM Then
		print ("Software-Kollektion gefunden in Laufwerk " & $CDROM)
	Else
		print ('Bitte legen Sie die Heft-CD ein und klicken Sie auf "CD suchen"')
	EndIf
EndFunc

Func evtClose()
  ;Note: at this point @GUI_CTRLID would equal $GUI_EVENT_CLOSE,
  ;and @GUI_WINHANDLE would equal $mainwindow
  ; MsgBox(0, "GUI Event", "You clicked CLOSE! Exiting...")
  Exit
EndFunc

Func getCDROM()
	$var = DriveGetDrive("cdrom")
	If Not @error Then
		For $i = 1 to $var[0]
			If DriveGetLabel($var[$i]) == "ctsw0808" Then
				GUICtrlSetState($btnStart, $GUI_ENABLE)
				Return StringUpper($var[$i])
			EndIf
		Next
	EndIf
	Return ""
EndFunc

Func disableInput()
	GUICtrlSetState($btnSearch, $GUI_DISABLE)
	GUICtrlSetState($btnStart, $GUI_DISABLE)
	GUICtrlSetState($btnBurn, $GUI_DISABLE)
EndFunc

Func enableInput()
	GUICtrlSetState($btnSearch, $GUI_ENABLE)
	IF $CDROM Then
		GUICtrlSetState($btnStart, $GUI_ENABLE)
	Else
		GUICtrlSetState($btnStart, $GUI_DISABLE)
	EndIf
	
	If FileExists("ctcd_neu.iso") And FileGetSize("ctcd_neu.iso") == 712167424 Then
		GUICtrlSetState($btnBurn, $GUI_ENABLE)
	Else
		GUICtrlSetState($btnBurn, $GUI_DISABLE)
	EndIf
EndFunc

Func evtStart()	
disableInput()
GUISetCursor(15,1)

RegWrite("HKEY_CURRENT_USER\Software\ImgBurn", "GENERAL_Language", "REG_DWORD", 1031)
RegWrite("HKEY_CURRENT_USER\Software\ImgBurn", "LogWindowOpen", "REG_DWORD", 0)

print("CD auslesen...")
$cmd = 'imgburn /MODE ISOREAD /SRC ' & $CDROM & ' /DEST ctcd.iso /START /EJECT YES /CLOSE'
$result = RunWait(@ComSpec & ' /c ' & $cmd, "", @SW_HIDE);
;print ("imgburn " & $result)

If Not (FileExists("ctcd.iso") And FileGetSize("ctcd.iso") == 712476672) Then
	print("Das Auslesen der CD hat nicht geklappt.")
	GUISetCursor(2)
	enableInput()
	Return
EndIf

If Not (FileExists("ctcd_neu.iso") And FileGetSize("ctcd_neu.iso") == 712167424) Then
	print("Image aktualisieren...")
	$cmd = 'rdiff patch ctcd.iso ctsw0808.rdiff ctcd_neu.iso'
	$result = RunWait(@ComSpec & ' /c ' & $cmd, "", @SW_HIDE);
	burn()
Else
	print("Image-Date ist bereits aktualisiert")
EndIf
print ("-- fertig")
GUISetCursor(2)
enableInput()
EndFunc

Func evtBurn()
	disableInput()
	GUISetCursor(15,1)
	burn()
	print ("fertig!")
	GUISetCursor(2)
	enableInput()
EndFunc

; ----- Hilfsfunktionen

Func burn()
	If checkISO() Then
		print("Bitte legen Sie einen Rohling ins Laufwerk")
		print("CD mit ImgBurn brennen...")
		$cmd = 'imgburn /MODE ISOWRITE /SRC ctcd_neu.iso'
		$result = RunWait(@ComSpec & ' /c ' & $cmd, "", @SW_HIDE);
	Else
		print("Die Prfsumme des aktualisierten CD-Image stimmt nicht.")
	EndIf
EndFunc

Func checkISO()
	If FileExists("ctcd_neu.iso") Then
		print ("Image berprfen...")
		$cmd = 'md5sum ctcd_neu.iso > md5.txt'
		$result = RunWait(@ComSpec & ' /c ' & $cmd, "", @SW_HIDE);
		If FileExists("md5.txt") Then
			$md5 = FileReadLine("md5.txt")
			If $md5 == "ae669fe2736f42093da4cb1c1046e59b *ctcd_neu.iso" Then
				Return True
			EndIf
		EndIf
	EndIf
	Return False
EndFunc

Func print($text)
	GUICtrlSetData ($edtOutput, GUICtrlRead($edtOutput) & $text & @CRLF)
EndFunc