     page          132,60,3,3,
;
;     u_memtst.asm - unified memory test for 56002
;
;       uses internal P:RAM to test Y: memory
;
;    12 June 90 - RLR: started...
;    13 June 90 - RLR: added polish
;    24 July 90 - RLR: more polish
;    04 Sept 92 - RLR: changes for PC-Media Bd (Rev. 1)
;    16 Apr  93 - RLR: changes for PC-Media Bd (Rev. 2.0)
;    04 Oct  93 - RLR: added pattern update to host
;
BCR      equ     $FFFE                 ;Bus Control Register
PLLCTL   equ     $FFFD                 ;PLL Control Register
PCC      equ     $FFE1                 ;port C control register
PCDDR    equ     $FFE3                 ;port C data direction
PCD      equ     $FFE5                 ;port C data
SCR      equ     $FFF0                 ;SCI Control Register
SSR      equ     $FFF1                 ;SCI status
SCCR     equ     $FFF2                 ;SCI Clock Control Register
STXH     equ     $FFF6                 ;SCI Tx Register, High byte 
STXL     equ     $FFF4                 ;SCI Tx Register, Low  byte


        org     x:0
MEM_FAIL_ADDR		ds      1
MEM_FAIL_EXPECT		ds      1
MEM_FAIL_RECEIVED_0	ds      1
MEM_FAIL_RECEIVED_1	ds      1
MEM_PASS_CNT		ds      1
dummy                   ds      3
PLL_0                   dc      $261009
PLL_1                   dc      $26100A
PLL_2                   dc      $261009
PLL_3                   dc      $26100A


;---------------------------------------------------------------------
	org     P:0
        jmp     $40


        org     p:$40
u_memtst
                                  ;starting address in N1
                                  ;memory size      in N0
	movep   #$261009,x:PLLCTL          ;set PLL for MPY of 10x
	movep   #$0000,x:BCR            ; number of wait states
        move    #$0240,n1
	move    #$3E40,n0
	movep	#$0,X:PCC                  ;disable SCI, SSI
	movec	#0,SP                      ;reset stack pointer
	move	#$FFFF,m0		;take no chances...
	bclr    #2,OMR			;disable DATA ROMs
	clr	b	#0,r5		;clear loop counter
	move	b,X:MEM_FAIL_ADDR
	move	b,X:MEM_FAIL_EXPECT
	move	b,X:MEM_FAIL_RECEIVED_0
	move	b,X:MEM_FAIL_RECEIVED_1
	move	b,X:MEM_PASS_CNT

        move    #PLL_0,r2       ;R2 points to top of PLL setting list
        move    #$3,m2          ;modulo 4 for 4 different values of PLL settings
			  	;get test parameters from OnCE
        nop
;
mem_main
;-----------------------------------------------------------------------------
;--- fill L:memory with initial pattern                                    ---
;-----------------------------------------------------------------------------
	move    #YPATT,r3		;r3 points to L: test patterns
	move    n1,r0			;load starting address
        movep   x:(r2)+,x:PLLCTL
	move    P:(r3)+,x0		;get the Write Pattern for X:MEM
	move		x0,x1

	rep     n0		;fill Y_memory with first patterns
	move    x,L:(r0)+	
	move	r5,x:MEM_PASS_CNT

;-----------------------------------------------------------------------------
;--- check for expected data in each location and then replace with new    ---
;--- ...this also provides an address check since erroneous addressing will---
;--- ...cause the data to be written into incorrect locations and this will---
;--- ...be evident in the next pass reads.                                 ---
;-----------------------------------------------------------------------------
	DO	#PATTN,test_Ym	;test with all patterns
	clr	a	n1,r0  	;r0  points to top of Y_RAM
	clr	b	x1,a1	;save the old value in a1
	move		x0,a0	;save the old value in a0
	move	P:(r3)+,x0	;get the next pattern into x0 
	move		x0,x1
; 
	DO	n0,next_loc	;test all locations
	move	L:(r0),B10	;read X:RAM -> b1, Y:RAM -> b0
	cmp	B,A     	;was the Y- data as expected???
	jsne	<ERR     	;Flag L- error if compare fails
	move	x,L:(r0)+	;write L:RAM
next_loc
	nop
test_Ym
        move	(r5)+
	jmp	<mem_main

;--------------------------------------------------------------------------
;    ERR -- handles error messaging with user
;	DSP asserts HF3 to indicate error message pending...
;	host responds by asserting HF1 to indicate that error msg info
;		may proceed
;Expected        X:DATA in A
;Received        X:DATA in X1
;Failing address in R0
ERR	
	move	r0,x:MEM_FAIL_ADDR
	move	A1,x:MEM_FAIL_EXPECT
	move	X0,x:MEM_FAIL_RECEIVED_0
	move	X1,x:MEM_FAIL_RECEIVED_1
	jmp     *


;
;    static constants - messages
;
					    ;Memory Test Patterns
YPATT	dc	$000000,$FFFFFF,$AAAAAA,$555555
	dc	$800000,$400000,$200000,$100000
	dc	$080000,$040000,$020000,$010000
	dc	$008000,$004000,$002000,$001000
	dc	$000800,$000400,$000200,$000100
	dc	$000080,$000040,$000020,$000010
	dc	$000008,$000004,$000002,$000001
	dc	$7FFFFF,$BFFFFF,$DFFFFF,$EFFFFF
	dc	$F7FFFF,$FBFFFF,$FDFFFF,$FEFFFF
	dc	$FF7FFF,$FFBFFF,$FFDFFF,$FFEFFF
	dc	$FFF7FF,$FFFBFF,$FFFDFF,$FFFEFF
	dc	$FFFF7F,$FFFFBF,$FFFFDF,$FFFFEF
	dc	$FFFFF7,$FFFFFB,$FFFFFD,$FFFFFE
PATTN     equ    *-YPATT

	  END









