/*--------------------------------------------------------------------------*
*   File:  SPEC2.C           Time-Frequency FFT Display  from Printer Port  *
*                            ---for Motorola DSP56002EVM ---                *
*                                                                           *
*   23 Oct. 95  - RLR:  First release                                       *
*                                                                           *
*       Copyright (c) MOTOROLA 1995														 *
*                     Semiconductor Products Sector								 *
*                     Digital Signal Processing Division							 *
*---------------------------------------------------------------------------*/

/* ---- Include files ----- */
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <math.h>
#include <conio.h>
#include <dos.h>
#include <graphics.h>


/** PROTOTYPES **/
void  cft_init (float  f);
void  amp_plot (unsigned char *uc, short x, short y, short k);
void  getbuff  (unsigned char *uc, int i);

/* ----- Static Vars ------ */
unsigned char *buff;                       /* storage for trace data    */


void main(int argc, char *argv[])
{
 short  plotLen,px,py,y_inc,fsamp,fft_size=1024;
 float  f_inc;


 if (argc == 2)                        /* command line parameters?? */
    fsamp = atoi(argv[1]);             /* if yes, get samp freq.    */
 else				       /* if no, advise your needs  */
    {
     system ("cls");
     printf ("   Motorola DSP56002EVM Time-Freq Display  ver.102395\n");
     printf ("    Usage:  \n");
     printf ("         SPEC2 [sample frequency in Hz] \n");
     printf ("   \n\n");
     printf ("     --- after the graph is visible...\n");
     printf ("         hit any key to start the plot...\n\n");
     printf ("         LATER, hit any key to exit... \n\n\n");
     exit(1);
    }

				       /* compute the freq. incr. */
 f_inc = 1.0 / (fft_size * ( 1.0 / fsamp));
 f_inc = f_inc / 2.0;

 plotLen    = 480;
 px         =  20;
 py         =  20;
 y_inc      =   5;

 buff       = (unsigned char *)farcalloc(plotLen+1,2L);
 if( buff == NULL)
    {  printf("\n insufficient memory ");  exit(-1); }

 cft_init(f_inc);			/* initialize the graphics screen */

/*----------------------------------------------------------------------*/
/*----           This is where we do the work.                       ---*/
/*	1. Fill a plot buffer from the printer port...                  */
/*	2. Plot the buffer on the screen...                             */
/*	3. Wrap the plot around to the top...                           */
/*	4. ...Until a key has been hit to exit.                         */
/*----------------------------------------------------------------------*/
 if (kbhit() == 0)                     /* if a character is present...  */
    getch();                           /*...get it clear the buffer     */
 do
    {
     getbuff(buff,plotLen);
     amp_plot(buff,px,py,plotLen);
     py += y_inc;		       /* move down to the next scan    */
     if (py > 365)		       /*...but wrap around a the bottom*/
	 py = 20;

    } while (kbhit() == 0);            /* check for key stroke to exit  */
 closegraph();
 farfree(buff);                        /* de-allocate memory buffers    */
}
/*-----------------------------------------------------------------------*/
/*	This routine gets the bytes from the printer LPT1 port           */
/*	Special efforts are required to accommodate noise                */
/*-----------------------------------------------------------------------*/
void getbuff(unsigned char *buff, int plotLen)
{
  int i;
  unsigned char ack1, ack2, ack3;

   outportb (0x37A,0x21);	       /* select input mode, STR   low   */
   outportb (0x37A,0x25);              /* INI~ high for sync req.        */
   do {                                /* wait here until ack=low        */
	ack1 = (inportb(0x379) & 0x40);  /* read ACK 3 times...          */
	ack2 = (inportb(0x379) & 0x40);  /*...to avoid noise...          */
	ack3 = (inportb(0x379) & 0x40);
	ack1 = ack1 | ack2 | ack3;
       } while (ack1 != 0);
   outportb (0x37A,0x21);              /* INI~ back low to start xfer    */

   for (i=0; i < plotLen; )	       /* now, fill the buffer           */
   {
     outportb (0x37A, 0x20);           /* toggle STR  high               */
     outportb (0x37A, 0x20);           /* toggle STR  high again         */
     outportb (0x37A, 0x20);           /* toggle STR  high               */
     ack1 = inportb (0x378);           /* get data from DSP              */
     if (ack1 > 0x0F)
	 ack1 = 0x0F;
     buff[i++] = ack1;
     outportb (0x37A, 0x21);           /* ...then take STR back low      */
     outportb (0x37A, 0x21);           /* ...then take STR back low      */
     outportb (0x37A, 0x21);           /* ...then take STR back low      */
   }
}
