///
// ct_pento.cpp : Defines the entry point for the console application.
//

#include <stdio.h>
#include <stdlib.h>
//towi #include <sys/time.h>
#include <time.h>

#include <iostream>
#include <string>

#include "Sym22.h"
#include "time.h"

// 0 is quiet, 
// 1 prints result
// 2 prints every solution
// 3 every lage-into-the-box step
// 4 every fill operation
#define VERBOSE 0

// timings
time_t start_backtrack, ttemp;

///////////////////////////////////////////////////////////////////////////////
//
// Class CKoord
//
///////////////////////////////////////////////////////////////////////////////

// TOWI V20: we dont really need to keep track of the
// exact 'history of lagen' of a solution -- the 'picture'
// of the box is enough. but maybe you want to output the
// order of the lagen that were put into the box -- then you
// need the 'schonlagen'-stack.
#undef REMEMBER_SOLUTION_LAGEN


/* TOWI22. news about CLage.

a lage was a list of koords: Lage = [ Koord_0, Koord_1, Koord_2, ... ]
the box was a list of voxels, each voxel a separate cell represented by a char (or int).
so, when a lage was placed inside the box the voxels that the Koords represented
were filled/unfilled in the box.
beside that a Lage carried a "bounding box" around, represened by the fields plus 
and minus. with these it was easy to check if the dimension of the lage would fit
into the box. since v20 these checks are done in the precompute phase and
are not needed later on in the backtracking algorithm.

the basic idea in V22 is the a Lage is represented by a 64bit int, each bit representing
a voxel -- also the box must be of this datatype then: ILAGE.

before the change to V22 the creation of the lagen for one Pento was:
- start with one Lage for a Pento placed at absolute koord=(0,0,0)
- create all 24 rotations of this lage around (0,0,0)
- translate all 24 into a defined position that the "lessest" voxel 
  lies at (0,0,0).
- remove all duplicates resulting from symmetries
- copy the rest of the list to all possible voxels, and tranlate them
  according to the position of their voxel.
- at each voxel remove the lagen that dont fit into the box, using the
  bounding box information.
this results for each Pento to a huge collection of lagen, each already
in the right rotation and translation if they are about to be placed
at a specific voxel.

note that this is a little bit more difficult, since the translate/rotate
operations will create coordinates out of the bounds of the box -- resulting
in to bit values for a 64bit int.
therefore we leave the all the pre-calculations in place and only when we are 
done with everyting -- when we are sure that every ordinate is valid inside
the box -- then we copy it do the "voxel_ilagen". 

the most difficult change is the fill algorithm. in V22 i returned to
an easy-to-implement recursive algorithm to test the suitability of
the ILAGE approach.
the CBox::_rfill() method looks a little bit messy... carfully spoken.
if you want to modify the code the attached excel-sheet might come
in handy as a code-generator. sorry for that.
mainly for this _rfill() method i introduced a datatype (like CombinedKoord 
was) "xyz" which can be interpreted dicectly as a pointer into the bitfield
of the CBox::voxel (which has the type ILAGE).
see CBox::istLeer() for an example how to tranform from the CKoord-system
to the xyz-system.

*/

///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

#define USE_BITMASK32_ARRAY

#ifdef USE_BITMASK32_ARRAY

static unsigned long bitmask32[32];

static void bitmask32Init (void)
{
    for (int i=0; i<32; i++)
    {
	bitmask32[i] = 1 << i;
    }
}

#endif


///////////////////////////////////////////////////////////////////////////////
//
//
//
//////////////////////////////////////////////////////////////////////////////

#define USE_BITMASK64_ARRAY

#ifdef USE_BITMASK64_ARRAY

//towi static unsigned long long bitmask64[MAXX*MAXY*MAXZ];
static __int64  bitmask64[MAXX*MAXY*MAXZ];

static void bitmask64Init (void)
{
    for (int i=0; i<MAXX*MAXY*MAXZ; i++)
    {
//towi	bitmask64[i] = 1LL<<i;
	bitmask64[i] = ((__int64)1)<<i;
    }
}

#endif


///////////////////////////////////////////////////////////////////////////////
//
// ILAGE
//
///////////////////////////////////////////////////////////////////////////////

#ifdef __GNUC__
typedef long long ILAGE;
#else
typedef __int64 ILAGE;
#endif


static inline void ilageOr (ILAGE &left, const ILAGE &right)   // operator|=
{
#if 1   // ++itschere: slightly faster
    ((unsigned long *)&left)[0] |= ((unsigned long *)&right)[0];
    ((unsigned long *)&left)[1] |= ((unsigned long *)&right)[1];
#else
    left |= right;
#endif
}


static inline void ilageXor (ILAGE &left, const ILAGE &right)  // operator^=
{
#if 1   // ++itschere: slightly faster
    ((unsigned long *)&left)[0] ^= ((unsigned long *)&right)[0];
    ((unsigned long *)&left)[1] ^= ((unsigned long *)&right)[1];
#else
    left ^= right;
#endif
}


static inline void ilageSetBit (ILAGE &left, const int bit)
{
    if (bit < 32)
    {
#ifdef USE_BITMASK32_ARRAY
	const int mask = bitmask32[bit];
#else
	const int mask = 1 << bit;
#endif
	((unsigned long *)&left)[0] |= mask;
	return;
    }

#ifdef USE_BITMASK32_ARRAY
    const int mask = bitmask32[bit-32];
#else
    const int mask = 1 << (bit - 32);
#endif
    ((unsigned long *)&left)[1] |= mask;
}


static inline bool ilageTestBit (const ILAGE &left, const int bit)
{
    if (bit < 32)
    {
#ifdef USE_BITMASK32_ARRAY
	return ((unsigned long *)&left)[0] & bitmask32[bit];
#else
	return ((unsigned long *)&left)[0] & (1 << bit);
#endif
    }

#ifdef USE_BITMASK32_ARRAY
    return ((unsigned long *)&left)[1] & bitmask32[bit-32];
#else
    return ((unsigned long *)&left)[1] & (1 << (bit - 32));
#endif
}


static inline bool ilageTestAndSetBit (ILAGE &left, const int bit)
{
    if (bit < 32)
    {
#ifdef USE_BITMASK32_ARRAY
	const register unsigned long mask = bitmask32[bit];
#else
	const unsigned long mask = 1 << bit;
#endif
       	const bool ret = ((unsigned long *)&left)[0] & mask;
	//if (!ret)
	//{
	    ((unsigned long *)&left)[0] |= mask;
	//}
	return ret;
    }

#ifdef USE_BITMASK32_ARRAY
    const register unsigned long mask = bitmask32[bit-32];
#else
    const unsigned long mask = 1 << (bit - 32);
#endif
    const bool ret = ((unsigned long *)&left)[1] & mask;
    //if (!ret)
    //{
	((unsigned long *)&left)[1] |= mask;
    //}
    return ret;
}


static inline bool ilageTestAndSetBit0to31 (ILAGE &left, const int bit)
{
#ifdef USE_BITMASK32_ARRAY
    const unsigned long mask = bitmask32[bit];
#else
    const unsigned long mask = 1 << bit;
#endif
    const bool ret = ((unsigned long *)&left)[0] & mask;
    //if (!ret)
    ((unsigned long *)&left)[0] |= mask;
    return ret;
}


static inline bool ilageTestAndSetBit32to63 (ILAGE &left, const int bit)
{
#ifdef USE_BITMASK32_ARRAY
    const unsigned long mask = bitmask32[bit];
#else
    const unsigned long mask = 1 << bit;
#endif
    const bool ret = ((unsigned long *)&left)[1] & mask;
    //if (!ret)
    ((unsigned long *)&left)[1] |= mask;
    return ret;
}


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

#define USE_INCREMENT_TABLE

#ifdef USE_INCREMENT_TABLE   // ++itschere: ja, JA, JAAA!!! :-)

static int incrementTable[MAXX*MAXY*MAXZ];

static void incrementTableInit (void)
{
    int last = -1;

    for (int z=0; z<MAXZ; z++)
    {
	for (int y=0; y<MAXY; y++)
	{
	    for (int x=0; x<MAXX; x++)
	    {
		int next = z + MAXZ * y + MAXZ * MAXY * x;

		if (last >= 0)
		{
		    incrementTable[last] = next;
		}

		last = next;
	    }
	}
    }
}

#endif


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

#define COMBINE(x,y,z) ((z)+MAXZ*(y)+MAXZ*MAXY*(x))

#define USE_QUICK_XYZ

#ifdef USE_QUICK_XYZ   // ++itschere20030426: this is slower :-(

typedef unsigned int IXYZ;

static bool IncXyz (IXYZ &xyz)
{
#ifdef USE_INCREMENT_TABLE

    if (xyz == MAXX*MAXY*MAXZ-1)
    {
	return true;
    }

    xyz = incrementTable[xyz];

    return false;

#else

    int x = xyz / (MAXZ*MAXY);
    const unsigned int rest = xyz - MAXZ*MAXY*x;
    int y = rest / MAXZ;
    int z = rest - MAXZ*y;

    if (++x >= MAXX)
    {
	x = 0;
	if (++y >= MAXY)
	{
	    y = 0;
	    if (++z >= MAXZ)
	    {
		return true;
	    }
	}
    }

    xyz = z + MAXZ*y + MAXZ*MAXY*x;

    return false;

#endif
}

#else

class IXYZ
{
private:

    unsigned int _xyz;

public:

    IXYZ (void)
	{
	    _xyz = 0;
	}

    IXYZ (const int xyz)
	{
	    _xyz = xyz;
	}

    IXYZ (const int x, const int y, const int z)
	{
	    _xyz = z + MAXZ*y + MAXZ*MAXY*x;
	}

    ~IXYZ (void)
	{
	}

    operator unsigned int (void) const
	{
	    return _xyz;
	}

    void operator= (const unsigned int right)
	{
	    _xyz = right;
	}

#if 0
    void Split (int &x, int &y, int &z) const
	{
	    x = _xyz / (MAXZ*MAXY);
	    const unsigned int rest = _xyz - MAXZ*MAXY*x;
	    y = rest / MAXZ;
	    z = rest - MAXZ*y;
	}
#endif

    bool Inc (void)   // increment x,y,z (in that order)
	{
	    int x = _xyz / (MAXZ*MAXY);
	    const unsigned int rest = _xyz - MAXZ*MAXY*x;
	    int y = rest / MAXZ;
	    int z = rest - MAXZ*y;

	    //printf ("%i %i %i\n", 0, y, z);

	    if (++x >= MAXX)
	    {
		x = 0;
		if (++y >= MAXY)
		{
		    y = 0;
		    if (++z >= MAXZ)
		    {
			return true;
		    }
		}
	    }

	    _xyz = z + MAXZ*y + MAXZ*MAXY*x;

	    return false;
	}

};

#endif


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

/*
Microsoft Specific
  The following table lists the amount of storage required for fundamental types in Microsoft C++. 
  Sizes of Fundamental Types
    == Type ==                          == Size ==
    bool                                1 byte    
    char, unsigned char, signed char    1 byte 
    short, unsigned short               2 bytes 
    int, unsigned int                   4 bytes 
    __intn                              1, 2, 4, or 8 bytes depending on n in [8,16,32,64]
    long, unsigned long                 4 bytes 
    float                               4 bytes 
    double                              8 bytes 
    long double                         8 bytes 
END Microsoft Specific
*/


class CKoord
{
private:

  bool operator==(const CKoord&); // no impl. use equals()
  bool operator>(const CKoord&);  // no impl. use isGreater()

  // fields
  int x, y, z;

public:

  // con- and destruct
  /* not needed: default bitcopy is faster:
     explicit CKoord(const CKoord &k)
     : x(k.x), y(k.y), z(k.z)
     {
     }
  */

  explicit CKoord (void)
  {
    x = y = z = 0;
  }

  explicit CKoord (const int ax, const int ay, const int az)
  {
    x = ax;
    y = ay;
    z = az;
  }

  /* i want to prevent accidently use of assignments. 
   * therefor i dont this implementation!
   CKoord& operator=(const CKoord &k)
   x(k.x), y(k.y), z(k.z)
   {
   return *this;
   }
  */

  ~CKoord(void)
  {
  }

  // methods

    operator int (void) const
	{
	    return z + MAXZ*y + MAXZ*MAXY*x;
	}

  CKoord& operator=(const CKoord &k)
  {
    x = k.x;
    y = k.y;
    z = k.z;

    return *this;
  }

  void set(const int ax, const int ay, const int az)
  { 
    x = ax;
    y = ay;
    z = az; 
  }

  void set(const CKoord &k)
  { 
    x = k.x;
    y = k.y;
    z = k.z; 
  }

  void set (const CKoord &k, const char r)
  {
    switch (r)
      {
      case 'x': set ( k.x,  k.z, -k.y); return;
      case 'X': set ( k.x, -k.z,  k.y); return;
      case 'y': set (-k.z,  k.y,  k.x); return;
      case 'Y': set ( k.z,  k.y, -k.x); return;
      case 'z': set (-k.y,  k.x,  k.z); return;
      case 'Z': set ( k.y, -k.x,  k.z); return;
      }
  }

  bool equals (const CKoord &l) const
  {
    return (x==l.x) && (y==l.y) && (z==l.z);
  }

  bool isGreater (const CKoord &l) const
  {
    return 
      z > l.z ? true :  z < l.z ? false : 
      y > l.y ? true :  y < l.y ? false :
      x > l.x ? true :  x < l.x ? false : 
      false ;
  }

  void translate (const int dx, const int dy, const int dz)
  {
    x += dx;
    y += dy;
    z += dz;
  }

  int GetX (void) const
  {
    return x;
  }
  int GetY (void) const
  {
    return y;
  }
  int GetZ (void) const
  {
    return z;
  }
};


///////////////////////////////////////////////////////////////////////////////
//
// class CLage
//
///////////////////////////////////////////////////////////////////////////////

class CLage
{
private:

public:

  // fields
  char id;
  char cnt;
  int monos;

  std::string orientation;
  CKoord koord[MAXOMINO];
  CKoord plus;  // set in validate()
  CKoord minus; // set in validate()

  // con- and destruct

  explicit CLage (void);

  explicit CLage (const CLage &l);

  explicit CLage (const CLage &l, const int dx, const int dy, const int dz);

  CLage (const char aid, const char acnt, const int amonos);

  CLage (const CLage &l, char r);

  ~CLage(void)
  {
  }

  // methods

  void set (const int n, const int x, const int y, const int z)
  {
    koord[n].set (x, y, z); 
  }

  int width (const char d) const;

  int widthx (void) const;
  int widthy (void) const;
  int widthz (void) const;

  ILAGE final getILage (void) const;

  /* used only to generate all Lagen of one Omino
   * at the start of the prog -- not efficient
   */

  bool equals (const CLage &l) const;

  void validate (void);

  void translate (const int dx, const int dy, const int dz);
};


ILAGE final CLage::getILage (void) const
{
    ILAGE ilage = 0;

    for (int i=0; i<monos; i++)
    {
	ilageSetBit (ilage, koord[i]);
    }

    return ilage;
}


CLage::CLage (const CLage &l)
{
  id = l.id;
  cnt = l.cnt;
  monos = l.monos;

  orientation = l.orientation;

  for (int idx=0; idx<monos; idx++)
    {
      koord[idx] = l.koord[idx];
    }
}


CLage::CLage (const CLage &l, const int dx, const int dy, const int dz)
{
  id = l.id;
  cnt = l.cnt;
  monos = l.monos;

  orientation = l.orientation;

  for (int idx=0; idx<monos; idx++)
    {
      koord[idx] = l.koord[idx];
      koord[idx].translate (dx, dy, dz);
    }
}


CLage::CLage (const char aid, const char acnt, const int amonos)
{
  id = aid;
  cnt = acnt;
  monos = amonos;

  orientation = "";
}


CLage::CLage (const CLage &l, char r)
{
  id = l.id;
  cnt = l.cnt;
  monos = l.monos;

  orientation = l.orientation + r;

  for (int idx=0; idx<monos; idx++)
    {
      koord[idx].set (l.koord[idx], r);
    }
}


int CLage:: width (const char d) const
{
  switch (d)
    {
    case 'x': return widthx(); 
    case 'y': return widthy(); 
    case 'z': return widthz();
    }
  abort ();
}


int CLage::widthx (void) const
{
  return plus.GetX () - minus.GetX () + 1;
} // minus.x is < 0


int CLage::widthy (void) const
{
  return plus.GetY () - minus.GetY () + 1;
}


int CLage::widthz (void) const
{
  return plus.GetZ () - minus.GetZ () + 1;
}


bool CLage::equals (const CLage &l) const
{
  if (monos != l.monos)
    {
      return false; // cant be, cause i only compare Lagen of one Omino, but ynk...
    }

  bool found;

  for (int a=0; a < monos; a++)
    {
      found = false;

      for(int b=a; b < monos; b++)
	{
	  if (koord[a].equals (l.koord[b]))
	    {
	      found = true;
	    }
	}

      if (!found)
	{
	  return false;
	}
    }

  return true;
}


void CLage::validate (void)
{
  // translate so that no koord[0,0,0] be in already in filled space.
  // easiest/surest way to do it in 3 separate steps, although you 
  // are tempted to do it in one, arent you?

  // z-Richtung

  int min = 999;

  for (int k=0; k < monos; k++)
    {
      if (min > koord[k].GetZ ())
	{
	  min = koord[k].GetZ ();
	}
    }

  translate (0, 0, -min);

  // y-Richtung

  min = 999;

  for (int k=0; k < monos; k++)
    {
      if ((koord[k].GetZ () == 0) &&
	  (min > koord[k].GetY ()))
	{
	  min = koord[k].GetY ();
	}
    }

  translate (0, -min, 0);

  // x-Richtung

  min = 999;

  for (int k=0; k < monos; k++) 
    {
      if ((koord[k].GetZ () == 0) &&
	  (koord[k].GetY () == 0) &&
	  (min > koord[k].GetX ()))
	{
	  min = koord[k].GetX();
	}
    }

  translate (-min, 0, 0);

  // Sortieren... bubble over 24... nagut.

  CKoord temp;

  for (int k=0; k < (monos-1); k++)
    {
      for (int j=k+1; j < monos; j++) 
	{
	  if (koord[k].isGreater (koord[j]))
	    {
	      temp = koord[j];
	      koord[j] = koord[k];
	      koord[k] = temp;
	    }
	}
    }
  
  // groesste ausdehung ermitteln

  int minx, miny, minz; minx = miny = minz =  999;
  int maxx, maxy, maxz; maxx = maxy = maxz = -999;

  for (int k=0; k < monos; k++)
    {
      if (koord[k].GetX() < minx) minx = koord[k].GetX();
      if (koord[k].GetY() < miny) miny = koord[k].GetY();
      if (koord[k].GetZ() < minz) minz = koord[k].GetZ();
      if (koord[k].GetX() > maxx) maxx = koord[k].GetX();
      if (koord[k].GetY() > maxy) maxy = koord[k].GetY();
      if (koord[k].GetZ() > maxz) maxz = koord[k].GetZ();
    }

  plus.set (maxx, maxy, maxz);
  minus.set (minx, miny, minz);
}


void CLage::translate (const int dx, const int dy, const int dz) 
{
  for(int k=0; k < monos; k++)
    {
      koord[k].translate (dx, dy, dz);
    }
}
 

///////////////////////////////////////////////////////////////////////////////
//
// class CPento
//
///////////////////////////////////////////////////////////////////////////////

class CPento
{
private:

  explicit CPento(void); // no implementation! compiler error on use!
  CPento& operator= (const CPento &); //
  bool operator== (const CPento&); // no impl. use equals()

public:

  // fields
  char id;
  char cnt;
  int lagen;
  const int monos;
  CLage *lage[MAXLAGEN];
  CLage*      voxel_lagen      [MAXX*MAXY*MAXZ][MAXLAGEN];
  int         voxel_lagen_count[MAXX*MAXY*MAXZ];
  // copied from voxel_lagen after validate()
  ILAGE       voxel_ilagen     [MAXX*MAXY*MAXZ][MAXLAGEN];

  // con- and destruct

  CPento (const char aid, const char acnt, 
	  const int x1, const int y1, const int z1,
	  const int x2, const int y2, const int z2,
	  const int x3, const int y3, const int z3,
	  const int x4, const int y4, const int z4,
	  const int x5, const int y5, const int z5,
	  const bool symetric);

  CPento (const char aid, const char acnt, 
	  const int x1, const int y1, const int z1,
	  const int x2, const int y2, const int z2,
	  const int x3, const int y3, const int z3,
	  const int x4, const int y4, const int z4,
	  const bool symetric);

  CPento (const char aid, const char acnt, 
	  const int x1, const int y1, const int z1,
	  const int x2, const int y2, const int z2,
	  const int x3, const int y3, const int z3,
	  const bool symetric);

  ~CPento (void);

  // methods

  // Neue (fertige) Lage fuer dieses Pentomino

  CLage* addLage (CLage *pLage);

  // hilfsfunktion: macht aus einer lage 4 rotierte

  void addVierLagen (CLage *pLage, const char r);

  // hilfsfunktion: macht aus einer lage 2 rotierte

  void addZweiLagen (CLage *pLage, const char r);

  // hilfsfunktion: macht aus einer lage 24 rotierte

  void addAlleLagen (void);

  // hilfsfunktion: macht aus einer lage ... wieviele? keine rot-syms

  void addAlleLagen_Not180RotSym (void);

  // schmeisst die Lagen heraus, die von vornherein nicht gehen

  void validate (void);
};


CPento::CPento (const char aid, const char acnt, 
		const int x1, const int y1, const int z1,
		const int x2, const int y2, const int z2,
		const int x3, const int y3, const int z3,
		const int x4, const int y4, const int z4,
		const int x5, const int y5, const int z5,
		const bool symetric) :
  id(aid), cnt(acnt), lagen(0), monos(6)
{
  lagen = 0;

  CLage *l = new CLage(aid, acnt, monos);

  l->set (1, x1, y1, z1);
  l->set (2, x2, y2, z2);
  l->set (3, x3, y3, z3);
  l->set (4, x4, y4, z4);
  l->set (5, x5, y5, z5);

  addLage (l);

  if (symetric)
    {
      addAlleLagen_Not180RotSym ();
    }
  else
    {
      addAlleLagen ();
    }
}


CPento::CPento (const char aid, const char acnt, 
		const int x1, const int y1, const int z1,
		const int x2, const int y2, const int z2,
		const int x3, const int y3, const int z3,
		const int x4, const int y4, const int z4,
		const bool symetric)
  : id(aid), cnt(acnt), lagen(0), monos(5)
{
  lagen = 0;

  CLage *l = new CLage (aid, acnt, monos);

  l->set (1, x1, y1, z1);
  l->set (2, x2, y2, z2);
  l->set (3, x3, y3, z3);
  l->set (4, x4, y4, z4);

  addLage (l);

  if (symetric)
    {
      addAlleLagen_Not180RotSym ();
    }
  else
    {
      addAlleLagen ();
    }
}


CPento::CPento (const char aid, const char acnt, 
		const int x1, const int y1, const int z1,
		const int x2, const int y2, const int z2,
		const int x3, const int y3, const int z3,
		const bool symetric)
  : id(aid), cnt(acnt), lagen(0), monos(4)
{
  lagen = 0;

  CLage *l = new CLage(aid, acnt, monos);

  l->set(1, x1,y1,z1);
  l->set(2, x2,y2,z2);
  l->set(3, x3,y3,z3);

  addLage (l);

  if(symetric)
    {
      addAlleLagen_Not180RotSym ();
    }
  else
    {
      addAlleLagen ();
    }
}


CPento::~CPento (void)
{
  for (int i=MAXLAGEN-1; i>=0; i--)
    {
      delete lage[i];
    }
}


CLage* CPento::addLage (CLage *pLage)
{
  pLage->validate ();

  for (int l=0; l<lagen; l++)
    {
      if (lage[l]->equals (*pLage))
	{
	  return pLage;
	}
    }

  lage[lagen++] = pLage;

  return pLage;
}


void CPento::addVierLagen (CLage *pLage, const char r)
{
  CLage *m;

  m = addLage (new CLage (*pLage, r));
  m = addLage (new CLage (*m, r));
  m = addLage (new CLage (*m, r));
}


void CPento::addZweiLagen (CLage *pLage, const char r)
{
  addLage (new CLage (*pLage, r));
}


void CPento::addAlleLagen (void)
{
  CLage *l = lage[0];

  addVierLagen (l, 'z');

  l = addLage (new CLage (*l, 'y'));

  addVierLagen (l, 'x');

  l = addLage (new CLage (*l, 'y'));

  addVierLagen (l, 'z');

  l = addLage (new CLage (*l, 'y'));

  addVierLagen (l, 'x');

  //

  CLage *n = addLage (new CLage (*l, 'z'));

  addVierLagen (n, 'y');

  n = addLage (new CLage (*l, 'Z'));   // Z !!!!!!!!!!!

  addVierLagen (n, 'y');

  // schmeisst unmoegliche Lagen raus

  validate ();
}


void CPento::addAlleLagen_Not180RotSym (void)
{
  CLage *l = lage[0];

  addZweiLagen (l, 'z');

  l = addLage (new CLage (*l, 'y'));

  addZweiLagen (l, 'x');

  //

  CLage *n = addLage (new CLage (*l, 'z'));

  addZweiLagen (n, 'y');

  // schmeisst unmoegliche Lagen raus

  validate ();
}


void CPento::validate (void)
{
    int l = 0;

    //
    // keep only lagen that fit in the box by width and height
    //

    while (l < lagen)
      {
	if ((lage[l]->widthx () > MAXX) ||
	    (lage[l]->widthy () > MAXY) ||
	    (lage[l]->widthz () > MAXZ))
	  {
            // lage loeschen
            delete lage[l];
            lage[l] = lage[--lagen];
	  }
        else
	  {
            // lage behalten
            l++;
	  }
      }

    //
    // ********** TOWI, NEW in Version20 **************
    //
    // store the lagen for _every_ possible voxel that
    // are possible at that position
    //

    int x,y,z;

    for (x=0; x<MAXX; x++)
      {
	for (y=0; y<MAXY; y++)
	  {
	    for (z=0; z<MAXZ; z++)
	      {
		int newcount=0;

		for (l=0; l<lagen;l++)
		  {
		    const CLage *oldl = lage[l];


		    // maxtest

		    const CKoord &plus  = oldl->plus;

		    if (x+plus.GetX()>=MAXX ||
			y+plus.GetY()>=MAXY ||
			z+plus.GetZ()>=MAXZ)
		      {
			continue;
		      }

		    // mintest

		    const CKoord &minus  = oldl->minus;

		    if (x+minus.GetX()<0 ||
			y+minus.GetY()<0 ||
		        z+minus.GetZ()<0)
		      {
			continue;
		      }

		    // passed the test: add this lage at this position

		    CLage *voxelLage = new CLage(*oldl, x, y, z);  // deep copy

#ifdef USE_QUICK_XYZ
		    IXYZ xyz = COMBINE (x, y, z);
#else
		    IXYZ xyz (x, y, z);
#endif
		    voxel_lagen[xyz][newcount] = voxelLage;
		    voxel_ilagen[xyz][newcount] = voxelLage->getILage();
		    newcount++;
		  } // for lagen

		// remember how many lagen are possible at this x,y,z position
#ifdef USE_QUICK_XYZ
		IXYZ xyz = COMBINE (x, y, z);
#else
		IXYZ xyz (x, y, z);
#endif
		voxel_lagen_count[xyz] = newcount;
	      } // for x,y,z
	  }
      }
} // class CPento::validate()


///////////////////////////////////////////////////////////////////////////////
//
// class CPentominos
//
///////////////////////////////////////////////////////////////////////////////

class CPentominos
{
private:

  CPentominos& operator=(const CPentominos &); //
  bool operator==(const CPentominos&); // no impl. use equals()

public:

  CPento *teil[TEILE];

  explicit CPentominos (void);
};


CPentominos::CPentominos (void)
{
  int i= 0;

  if (TEILE5ER==7 && TEILE4ER==1 && TEILE6ER==1)
    {
      /*
       *  BOXDIMENSION: 3 x 3 x 5
       */

      teil[i++] = new CPento ('c','8', 1,0,0, 0,1,0, 0,2,0, 1,2,0, false);
      teil[i++] = new CPento ('Z','7', 1,0,0, 1,1,0, 1,2,0, 2,2,0, false); 
      teil[i++] = new CPento ('L','6', 1,0,0, 2,0,0, 3,0,0, 0,1,0, false); 
      teil[i++] = new CPento ('j','5', 1,0,0, 2,0,0, 3,0,0, 1,1,0, false); 
      teil[i++] = new CPento ('\'','4',1,0,0, 0,1,0, 1,1,0, 0,0,1, false); 
      teil[i++] = new CPento ('T','3', 1,0,0, 2,0,0, 1,1,0, 1,2,0, false); 
      teil[i++] = new CPento ('s','2', 1,0,0, 0,1,0, 1,0,1,        false); 
      teil[i++] = new CPento ('g','1', 1,0,0, 1,1,0, 1,2,0, 2,1,0, true); 
      teil[i++] = new CPento ('t','0', 1,0,0, 2,0,0, 3,0,0, 0,1,0, 2,1,0, false);
    }
  else if (TEILE5ER==10 && TEILE4ER==1 && TEILE6ER==1)
    {
      // ct puzzle
      teil[i++] = new CPento ('c','8', 1,0,0, 0,1,0, 0,2,0, 1,2,0, false);
      teil[i++] = new CPento ('Z','7', 1,0,0, 1,1,0, 1,2,0, 2,2,0, false); 
      teil[i++] = new CPento ('L','6', 1,0,0, 2,0,0, 3,0,0, 0,1,0, false); 
      teil[i++] = new CPento ('j','5', 1,0,0, 2,0,0, 3,0,0, 1,1,0, false); 
      teil[i++] = new CPento ('\'','4',1,0,0, 0,1,0, 1,1,0, 0,0,1, false); 
      teil[i++] = new CPento ('T','3', 1,0,0, 2,0,0, 1,1,0, 1,2,0, false); 
      teil[i++] = new CPento ('d','f', 1,0,0, 2,0,0, 0,1,0, 1,1,0, false); 
      teil[i++] = new CPento ('w','e', 1,0,0, 1,1,0, 2,1,0, 2,2,0, false); 
      teil[i++] = new CPento ('s','2', 1,0,0, 0,1,0, 1,0,1,        false); 
      teil[i++] = new CPento ('g','1', 1,0,0, 1,1,0, 1,2,0, 2,1,0, true); 
      teil[i++] = new CPento ('x','b', 1,0,0, 2,0,0, 1,0,1, 1,0,-1,false); 
      teil[i++] = new CPento ('t','0', 1,0,0, 2,0,0, 3,0,0, 0,1,0, 2,1,0, false);
    }
  else
    {
      exit (-42-1);
    }

  if (i != TEILE)
    {
      exit (-42-2);
    }
}



///////////////////////////////////////////////////////////////////////////////
//
// class CBox
//
///////////////////////////////////////////////////////////////////////////////

class CBox
{
private:

  CBox& operator=(const CBox &); //
  bool operator==(const CBox &); // no impl. use equals()

  // fields

  ILAGE voxel;
  //TOWI V22. VOXELTYPE voxel[1<<XBITS][1<<YBITS][1<<ZBITS];

  int drin;
  int noch4er, noch5er, noch6er;

  //TOWI V22. VOXELTYPE *voxelFlat;

public:
    //long sumrein;

  // con- and destruct

  explicit CBox(void);

  // methods

    inline bool final isFull (const IXYZ &xyz) const
	{
	    return ilageTestBit (voxel, xyz);
	}

  /* Testet ob der freie Block in dem voxel[x][y][z] liegt eine
   * durch Sym.OMINOS teilbare Groesse besitzt 
   */

    bool istPassend (const IXYZ &xyz);

    bool final passtILage (const ILAGE &ilage) const
	{
	    return !(ilage & voxel);
	}

    int final fill (IXYZ xyz);

    // lage in/out

    inline void lageRein (const ILAGE &ilage, const int monos)
	{
	    drin++;
	    //sumrein++;
	    ilageOr (voxel, ilage);
	    if (monos == 5)
		noch5er--;
	    else if (monos == 4)
		noch4er--;
	    else
		noch6er--;
	}

#undef USE_OPTIMIZED_LAGEREINRAUS

#ifdef USE_OPTIMIZED_LAGEREINRAUS   // ++itschere: this is slower

    inline ILAGE lageRein4 (const ILAGE &ilage)
	{
	    drin++;
	    //sumrein++;
	    ILAGE ret = voxel;
	    ilageOr (voxel, ilage);
	    noch4er--;
	    return ret;
	}

    inline ILAGE lageRein5 (const ILAGE &ilage)
	{
	    drin++;
	    //sumrein++;
	    ILAGE ret = voxel;
	    ilageOr (voxel, ilage);
	    noch5er--;
	    return ret;
	}

    inline ILAGE lageRein6 (const ILAGE &ilage)
	{
	    drin++;
	    //sumrein++;
	    ILAGE ret = voxel;
	    ilageOr (voxel, ilage);
	    noch6er--;
	    return ret;
	}

#endif

    // lage out

    inline void lageRaus (const ILAGE &ilage, const int monos)
	{
	    drin--;
	    ilageXor (voxel, ilage);
	    if (monos == 5)
		noch5er++;
	    else if (monos == 4)
		noch4er++;
	    else
		noch6er++;
	}

#ifdef USE_OPTIMIZED_LAGEREINRAUS

    inline void lageRaus4 (const ILAGE &backup)
	{
	    drin--;
	    voxel = backup;
	    noch4er++;
	}

    inline void lageRaus5 (const ILAGE &backup)
	{
	    drin--;
	    voxel = backup;
	    noch5er++;
	}

    inline void lageRaus6 (const ILAGE &backup)
	{
	    drin--;
	    voxel = backup;
	    noch6er++;
	}

#endif

  /// pretty
  std::string toString (std::string &s) const;
  friend std::ostream& operator<<(std::ostream &os, const CBox &box);
};


CBox::CBox(void)
  : drin(0),
    noch4er(TEILE4ER),
    noch5er(TEILE5ER),
    noch6er(TEILE6ER)
    //,sumrein(0)
{
    voxel = 0;
}


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

#undef USE_MOD_TABLE   // ++itschere: oops? i thought a table lookup would be faster than a modulo op?!?

#ifdef USE_MOD_TABLE

//int mod4Table[MAXX*MAXY*MAXZ];
int mod5Table[MAXX*MAXY*MAXZ];
//int mod6Table[MAXX*MAXY*MAXZ];

static void modTableInit (void)
{
    for (int i=0; i<MAXX*MAXY*MAXZ; i++)
    {
	//mod4Table[i] = i % 4;
	mod5Table[i] = i % 5;
	//mod6Table[i] = i % 6;
    }
}

#endif


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

bool CBox::istPassend (const IXYZ &xyz)
{
    //
    return true; //YYYYYYYYYYYYYYYYYYYYYYYYYXCV
    const int count = fill (xyz);

    // special cases with only one kind of ominos

#if 0   // ++itschere: not true with any PENTO_CONFIG

    if (!TEILE4ER && !TEILE5ER)
    {
#ifdef USE_MOD_TABLE
	return mod6Table[count] == 0;
#else
	return count % 6 == 0;
#endif
    }

    if (!TEILE4ER && !TEILE6ER)
    {
#ifdef USE_MOD_TABLE
	return mod5Table[count] == 0;
#else
	return count % 5 == 0;
#endif
    }

    if (!TEILE5ER && !TEILE6ER)
    {
	return (count & 3) == 0;   // ++itschere: `&' should be faster than table lookup
    }

    if (TEILE4ER>1 || TEILE6ER>1)
    {
	return count >= 4 ; // cant handle that well
    }

#endif

    if (count < 4)
    {
	return false;
    }

    //
    // so, here i handle the case that we have max 1 4er/6er    
    //

#ifdef USE_MOD_TABLE
    const int mod5 = mod5Table[count];
#else
    const int mod5 = count % 5;
#endif

  if (mod5 == 2 || mod5 == 3)
    {
      return false;  // [*1]
    }

  const int sw = noch4er + (noch6er<<1) + (noch5er<<2);   // ++itschere: use shifts instead of multiplications

  switch (sw)   // can be a java-asm tableswitch
    {
    case 0x00:
      return false;        // (000) can not happen
    case 0x01:
      return count==4;     // (001)
    case 0x02:
      return count==6;     // (010)
    case 0x03:
      return count==4 || count==6 || count==10; // (011)
    case 0x04:
      return count==5;     // (100)
    case 0x05:
      return count==4 || count==5 || count==9;  // (101)
    case 0x06:
      return count==5 || count==6 || count==11; // (110)
    case 0x07:
#if 0
    {
	__asm__ __volatile__ ("##########################################A" : : : "memory");
	const bool ret = (count>=4 && count<=6) || (count>=9 && count<=11) || count==15; //(111)
	__asm__ __volatile__ ("##########################################B" : : : "memory");
	return ret;
    }
#else
    {
	//__asm__ __volatile__ ("##########################################A" : : : "memory");
	const bool ret = count==4 || count==5 || count==6 || count==9 || count==10|| count==11|| count==15; //(111)
	//__asm__ __volatile__ ("##########################################B" : : : "memory");
	return ret;
    }
#endif

    default: // hat5er>=2
      {
	if (!mod5)   // ++itschere: every case below depends on this
	  {
	    return true;
	  }

	if (!noch4er)
	  {
	    if (!noch6er)
	      {
		return false;                      // (x00)
	      }
	    else
	      {
		return mod5 == 1;           // (x10)
	      }
	  } 
	else
	  {
	    if (!noch6er)
	      {
		return mod5 == 4;            // (x01)
	      }
	    else
	      {
		return mod5 == 1 || mod5 == 4; // (x11) true! handled at [*1]?
	      }
	  }
      }
    }
}


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

#undef USE_NEIGHBOUR_TABLE

// ++itschere: hchste benutze nummer: 45 (60). nchste zweierpotenz:
// 64. anzahl dafr bentigter bits: 6. anzahl maximaler nachbarn: 6. zusammen
// multipliziert: 36. scheisse, ein long reicht nicht... :-(
//
// eigentlich msste es mit 64bit immer noch kompakteren code geben als in
// einem case-switch einfach alles hin zu schreiben, aber *schneller* ist es
// damit leider noch lange nicht

#ifdef USE_NEIGHBOUR_TABLE

typedef long long int64_t;

#if PENTO_CONFIG == 1

#define STUFF1(a) (1|(((int64_t)a)<<8))
#define STUFF2(a,b) (2|(((int64_t)a)<<8)|(((int64_t)b)<<16))
#define STUFF3(a,b,c) (3|(((int64_t)a)<<8)|(((int64_t)b)<<16)|(((int64_t)c)<<24))
#define STUFF4(a,b,c,d) (4|(((int64_t)a)<<8)|(((int64_t)b)<<16)|(((int64_t)c)<<24)|(((int64_t)d)<<32))
#define STUFF5(a,b,c,d,e) (5|(((int64_t)a)<<8)|(((int64_t)b)<<16)|(((int64_t)c)<<24)|(((int64_t)d)<<32)|(((int64_t)e)<<40))
#define STUFF6(a,b,c,d,e,f) (6|(((int64_t)a)<<8)|(((int64_t)b)<<16)|(((int64_t)c)<<24)|(((int64_t)d)<<32)|(((int64_t)e)<<40)|(((int64_t)f)<<48))

static int64_t neighbours[MAXX*MAXY*MAXZ] =
{
    STUFF3 (15,  5,  1),
    STUFF4 (16,  6,  0,  2),
    STUFF4 (17,  7,  1,  3),
    STUFF4 (18,  8,  2,  4),
    STUFF3 (19,  9,  3),
    STUFF4 (20,  0, 10,  6),
    STUFF5 (21,  1, 11,  5,  7),
    STUFF5 (22,  2, 12,  6,  8),
    STUFF5 (23,  3, 13,  7,  9),
    STUFF4 (24,  4, 14,  8),
    STUFF3 (25,  5, 11),
    STUFF4 (26,  6, 10, 12),
    STUFF4 (27,  7, 11, 13),
    STUFF4 (28,  8, 12, 14),
    STUFF3 (29,  9, 13),
    STUFF4 ( 0, 30, 20, 16),
    STUFF5 ( 1, 31, 21, 15, 17),
    STUFF5 ( 2, 32, 22, 16, 18),
    STUFF5 ( 3, 33, 23, 17, 19),
    STUFF4 ( 4, 34, 24, 18),
    STUFF5 ( 5, 35, 15, 25, 21),
    STUFF6 ( 6, 36, 16, 26, 20, 22),
    STUFF6 ( 7, 37, 17, 27, 21, 23),
    STUFF6 ( 8, 38, 18, 28, 22, 24),
    STUFF5 ( 9, 39, 19, 29, 23),
    STUFF4 (10, 40, 20, 26),
    STUFF5 (11, 41, 21, 25, 27),
    STUFF5 (12, 42, 22, 26, 28),
    STUFF5 (13, 43, 23, 27, 29),
    STUFF4 (14, 44, 24, 28),
    STUFF3 (15, 35, 31),
    STUFF4 (16, 36, 30, 32),
    STUFF4 (17, 37, 31, 33),
    STUFF4 (18, 38, 32, 34),
    STUFF3 (19, 39, 33),
    STUFF4 (20, 30, 40, 36),
    STUFF5 (21, 31, 41, 35, 37),
    STUFF5 (22, 32, 42, 36, 38),
    STUFF5 (23, 33, 43, 37, 39),
    STUFF4 (24, 34, 44, 38),
    STUFF3 (25, 35, 41),
    STUFF4 (26, 36, 40, 42),
    STUFF4 (27, 37, 41, 43),
    STUFF4 (28, 38, 42, 44),
    STUFF3 (29, 39, 43)
};

#else

#error "unknown PENTO_CONFIG"

#endif

#endif

///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

#undef USE_FILL_HASHTABLE

#ifdef USE_FILL_HASHTABLE   // ++itschere: nope

struct hashtable
{
    ILAGE origValue;
    int fillCount;
    int trashed;
    int used;
};

#define HASHTABLESIZE 1023   // ++itschere: have fun finding the best value!

struct hashtable hashTable[HASHTABLESIZE];

#endif


///////////////////////////////////////////////////////////////////////////////
//
// USE_NEIGHBOUR_BITMASK_TABLE
//
// a table that contains the bitmask of all neighbours of each voxel. may be
// used to quickly check if all neighbours are either full or empty. usefull in
// catching the case where fillCount==1, i.e. a voxel has no free neighbours.
//
///////////////////////////////////////////////////////////////////////////////

#undef USE_NEIGHBOUR_BITMASK_TABLE   // ++itschere: schade, war so ne schne idee

#ifdef USE_NEIGHBOUR_BITMASK_TABLE

static const ILAGE neighbourBitmaskTable[MAXX*MAXY*MAXZ] =
{
#if PENTO_CONFIG == 1

    1LL<<15 |  1LL<<5 |  1LL<<1,
    1LL<<16 |  1LL<<6 |  1LL<<0 |  1LL<<2,
    1LL<<17 |  1LL<<7 |  1LL<<1 |  1LL<<3,
    1LL<<18 |  1LL<<8 |  1LL<<2 |  1LL<<4,
    1LL<<19 |  1LL<<9 |  1LL<<3,
    1LL<<20 |  1LL<<0 | 1LL<<10 |  1LL<<6,
    1LL<<21 |  1LL<<1 | 1LL<<11 |  1LL<<5 |  1LL<<7,
    1LL<<22 |  1LL<<2 | 1LL<<12 |  1LL<<6 |  1LL<<8,
    1LL<<23 |  1LL<<3 | 1LL<<13 |  1LL<<7 |  1LL<<9,
    1LL<<24 |  1LL<<4 | 1LL<<14 |  1LL<<8,
    1LL<<25 |  1LL<<5 | 1LL<<11,
    1LL<<26 |  1LL<<6 | 1LL<<10 | 1LL<<12,
    1LL<<27 |  1LL<<7 | 1LL<<11 | 1LL<<13,
    1LL<<28 |  1LL<<8 | 1LL<<12 | 1LL<<14,
    1LL<<29 |  1LL<<9 | 1LL<<13,
     1LL<<0 | 1LL<<30 | 1LL<<20 | 1LL<<16,
     1LL<<1 | 1LL<<31 | 1LL<<21 | 1LL<<15 | 1LL<<17,
     1LL<<2 | 1LL<<32 | 1LL<<22 | 1LL<<16 | 1LL<<18,
     1LL<<3 | 1LL<<33 | 1LL<<23 | 1LL<<17 | 1LL<<19,
     1LL<<4 | 1LL<<34 | 1LL<<24 | 1LL<<18,
     1LL<<5 | 1LL<<35 | 1LL<<15 | 1LL<<25 | 1LL<<21,
     1LL<<6 | 1LL<<36 | 1LL<<16 | 1LL<<26 | 1LL<<20 | 1LL<<22,
     1LL<<7 | 1LL<<37 | 1LL<<17 | 1LL<<27 | 1LL<<21 | 1LL<<23,
     1LL<<8 | 1LL<<38 | 1LL<<18 | 1LL<<28 | 1LL<<22 | 1LL<<24,
     1LL<<9 | 1LL<<39 | 1LL<<19 | 1LL<<29 | 1LL<<23,
    1LL<<10 | 1LL<<40 | 1LL<<20 | 1LL<<26,
    1LL<<11 | 1LL<<41 | 1LL<<21 | 1LL<<25 | 1LL<<27,
    1LL<<12 | 1LL<<42 | 1LL<<22 | 1LL<<26 | 1LL<<28,
    1LL<<13 | 1LL<<43 | 1LL<<23 | 1LL<<27 | 1LL<<29,
    1LL<<14 | 1LL<<44 | 1LL<<24 | 1LL<<28,
    1LL<<15 | 1LL<<35 | 1LL<<31,
    1LL<<16 | 1LL<<36 | 1LL<<30 | 1LL<<32,
    1LL<<17 | 1LL<<37 | 1LL<<31 | 1LL<<33,
    1LL<<18 | 1LL<<38 | 1LL<<32 | 1LL<<34,
    1LL<<19 | 1LL<<39 | 1LL<<33,
    1LL<<20 | 1LL<<30 | 1LL<<40 | 1LL<<36,
    1LL<<21 | 1LL<<31 | 1LL<<41 | 1LL<<35 | 1LL<<37,
    1LL<<22 | 1LL<<32 | 1LL<<42 | 1LL<<36 | 1LL<<38,
    1LL<<23 | 1LL<<33 | 1LL<<43 | 1LL<<37 | 1LL<<39,
    1LL<<24 | 1LL<<34 | 1LL<<44 | 1LL<<38,
    1LL<<25 | 1LL<<35 | 1LL<<41,
    1LL<<26 | 1LL<<36 | 1LL<<40 | 1LL<<42,
    1LL<<27 | 1LL<<37 | 1LL<<41 | 1LL<<43,
    1LL<<28 | 1LL<<38 | 1LL<<42 | 1LL<<44,
    1LL<<29 | 1LL<<39 | 1LL<<43
    
#elif  PENTO_CONFIG == 2

#error "PENTO_CONFIG==2 not yet supported (and probably never will be)"

#else
#error "unknown PENTO_CONFIG"
#endif
};

#endif


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

#undef FILLTIMING

#ifdef FILLTIMING

static unsigned long fillTimeUsecs[MAXX*MAXY*MAXZ+1];
static unsigned long fillTimeCount[MAXX*MAXY*MAXZ+1];

#endif


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

static unsigned char stack[MAXX*MAXY*MAXZ];   // 45 for PENTO_CONFIG==1


#define FOO(idx) \
  if (!ilageTestAndSetBit (fillVoxel, idx)) \
    *in++ = idx;
#define FOOA(idx) \
  if (!ilageTestAndSetBit0to31 (fillVoxel, idx)) \
    *in++ = idx;
#define FOOB(idx) \
  if (!ilageTestAndSetBit32to63 (fillVoxel, idx-32)) \
    *in++ = idx;



int final CBox::fill (IXYZ xyz)
{
#ifdef FILLTIMING

    struct timeval start;
    gettimeofday (&start, 0x0);

#endif

#ifdef USE_NEIGHBOUR_BITMASK_TABLE

    const ILAGE &mask = neighbourBitmaskTable[xyz];

    if ((voxel & mask) == mask)
    {
#ifdef FILLTIMING

	struct timeval stop;
	gettimeofday (&stop, 0x0);

	unsigned long usecs = 1000000 * (stop.tv_sec - start.tv_sec) + (stop.tv_usec - start.tv_usec);

	fillTimeUsecs[1] += usecs;
	fillTimeCount[1]++;

#endif
	return 1;   // has no free neighbours, fillCount==1
    }

#endif

#ifdef USE_FILL_HASHTABLE

    const int hash = voxel % HASHTABLESIZE;

    if ((hashTable[hash].origValue == voxel) && hashTable[hash].fillCount)
    {
	hashTable[hash].used++;
	return hashTable[hash].fillCount;
    }

    hashTable[hash].origValue = voxel;

#endif

    //

    register ILAGE fillVoxel = voxel;   // ++itschere: don't unfill, fill temporary and then throw it away

    ilageSetBit (fillVoxel, xyz);

    unsigned char *in = stack;
    const unsigned char *out = stack;

    while (42)
    {
#ifdef USE_NEIGHBOUR_TABLE

	unsigned long *ptr = (unsigned long *)&neighbours[xyz];

	const unsigned long l1 = ptr[0];
	const unsigned long l2 = ptr[1];
	int idx;

	switch (l1 & 0xff)
	{
	    case 6:
		idx = (l2 & 0x00ff0000) >> 16;
		FOO (idx);
	    case 5:
		idx = (l2 & 0x0000ff00) >> 8;
		FOO (idx);
	    case 4:
		idx = l2 & 0x000000ff;
		FOO (idx);
	    case 3:
		idx = (l1 & 0xff000000) >> 24;
		FOO (idx);
	    case 2:
		idx = (l1 & 0x00ff0000) >> 16;
		FOO (idx);
	    case 1:
		idx = (l1 & 0x0000ff00) >> 8;
		FOO (idx);
	}

#else

#if PENTO_CONFIG == 1

#ifdef USE_NEIGHBOUR_BITMASK_TABLE_disabled   // ++itschere: no good having this in the loop

	const ILAGE &mask = neighbourBitmaskTable[xyz];

	if (fillVoxel & mask)
	    // fallthru

#endif
	switch (xyz)
	{
	    case  0: FOOA(15); FOOA( 5); FOOA( 1); break;
	    case  1: FOOA(16); FOOA( 6); FOOA( 0); FOOA( 2); break;
	    case  2: FOOA(17); FOOA( 7); FOOA( 1); FOOA( 3); break;
	    case  3: FOOA(18); FOOA( 8); FOOA( 2); FOOA( 4); break;
	    case  4: FOOA(19); FOOA( 9); FOOA( 3); break;
	    case  5: FOOA(20); FOOA( 0); FOOA(10); FOOA( 6); break;
	    case  6: FOOA(21); FOOA( 1); FOOA(11); FOOA( 5); FOOA( 7); break;
	    case  7: FOOA(22); FOOA( 2); FOOA(12); FOOA( 6); FOOA( 8); break;
	    case  8: FOOA(23); FOOA( 3); FOOA(13); FOOA( 7); FOOA( 9); break;
	    case  9: FOOA(24); FOOA( 4); FOOA(14); FOOA( 8); break;
	    case 10: FOOA(25); FOOA( 5); FOOA(11); break;
	    case 11: FOOA(26); FOOA( 6); FOOA(10); FOOA(12); break;
	    case 12: FOOA(27); FOOA( 7); FOOA(11); FOOA(13); break;
	    case 13: FOOA(28); FOOA( 8); FOOA(12); FOOA(14); break;
	    case 14: FOOA(29); FOOA( 9); FOOA(13); break;
	    case 15: FOOA( 0); FOOA(30); FOOA(20); FOOA(16); break;
	    case 16: FOOA( 1); FOOA(31); FOOA(21); FOOA(15); FOOA(17); break;
	    case 17: FOOA( 2); FOOB(32); FOOA(22); FOOA(16); FOOA(18); break;
	    case 18: FOOA( 3); FOOB(33); FOOA(23); FOOA(17); FOOA(19); break;
	    case 19: FOOA( 4); FOOB(34); FOOA(24); FOOA(18); break;
	    case 20: FOOA( 5); FOOB(35); FOOA(15); FOOA(25); FOOA(21); break;
	    case 21: FOOA( 6); FOOB(36); FOOA(16); FOOA(26); FOOA(20); FOOA(22); break;
	    case 22: FOOA( 7); FOOB(37); FOOA(17); FOOA(27); FOOA(21); FOOA(23); break;
	    case 23: FOOA( 8); FOOB(38); FOOA(18); FOOA(28); FOOA(22); FOOA(24); break;
	    case 24: FOOA( 9); FOOB(39); FOOA(19); FOOA(29); FOOA(23); break;
	    case 25: FOOA(10); FOOB(40); FOOA(20); FOOA(26); break;
	    case 26: FOOA(11); FOOB(41); FOOA(21); FOOA(25); FOOA(27); break;
	    case 27: FOOA(12); FOOB(42); FOOA(22); FOOA(26); FOOA(28); break;
	    case 28: FOOA(13); FOOB(43); FOOA(23); FOOA(27); FOOA(29); break;
	    case 29: FOOA(14); FOOB(44); FOOA(24); FOOA(28); break;
	    case 30: FOOA(15); FOOB(35); FOOA(31); break;
	    case 31: FOOA(16); FOOB(36); FOOA(30); FOOB(32); break;
	    case 32: FOOA(17); FOOB(37); FOOA(31); FOOB(33); break;
	    case 33: FOOA(18); FOOB(38); FOOB(32); FOOB(34); break;
	    case 34: FOOA(19); FOOB(39); FOOB(33); break;
	    case 35: FOOA(20); FOOA(30); FOOB(40); FOOB(36); break;
	    case 36: FOOA(21); FOOA(31); FOOB(41); FOOB(35); FOOB(37); break;
	    case 37: FOOA(22); FOOB(32); FOOB(42); FOOB(36); FOOB(38); break;
	    case 38: FOOA(23); FOOB(33); FOOB(43); FOOB(37); FOOB(39); break;
	    case 39: FOOA(24); FOOB(34); FOOB(44); FOOB(38); break;
	    case 40: FOOA(25); FOOB(35); FOOB(41); break;
	    case 41: FOOA(26); FOOB(36); FOOB(40); FOOB(42); break;
	    case 42: FOOA(27); FOOB(37); FOOB(41); FOOB(43); break;
	    case 43: FOOA(28); FOOB(38); FOOB(42); FOOB(44); break;
	    case 44: FOOA(29); FOOB(39); FOOB(43); break;
	    default: exit(-42-6);
	}

#elif PENTO_CONFIG == 2

	switch (xyz)
	{
	    case 0: FOO(20);FOO(5);FOO(1);  break;
	    case 1:FOO(21);FOO(6); FOO(0); FOO(2);  break;
	    case 2:FOO(22);FOO(7); FOO(1); FOO(3);  break;
	    case 3:FOO(23);FOO(8); FOO(2); FOO(4);  break;
	    case 4:FOO(24);FOO(9); FOO(3); break;
	    case 5:FOO(25); FOO(0); FOO(10);FOO(6);  break;
	    case 6:FOO(26); FOO(1); FOO(11); FOO(5); FOO(7);  break;
	    case 7:FOO(27); FOO(2); FOO(12); FOO(6); FOO(8);  break;
	    case 8:FOO(28); FOO(3); FOO(13); FOO(7); FOO(9);  break;
	    case 9:FOO(29); FOO(4); FOO(14); FOO(8); break;
	    case 10:FOO(30); FOO(5); FOO(15);FOO(11);  break;
	    case 11:FOO(31); FOO(6); FOO(16); FOO(10); FOO(12);  break;
	    case 12:FOO(32); FOO(7); FOO(17); FOO(11); FOO(13);  break;
	    case 13:FOO(33); FOO(8); FOO(18); FOO(12); FOO(14);  break;
	    case 14:FOO(34); FOO(9); FOO(19); FOO(13); break;
	    case 15:FOO(35); FOO(10);FOO(16);  break;
	    case 16:FOO(36); FOO(11);FOO(15); FOO(17);  break;
	    case 17:FOO(37); FOO(12);FOO(16); FOO(18);  break;
	    case 18:FOO(38); FOO(13);FOO(17); FOO(19);  break;
	    case 19:FOO(39); FOO(14);FOO(18); break;
	    case 20: FOO(0); FOO(40);FOO(25);FOO(21);  break;
	    case 21: FOO(1); FOO(41);FOO(26); FOO(20); FOO(22);  break;
	    case 22: FOO(2); FOO(42);FOO(27); FOO(21); FOO(23);  break;
	    case 23: FOO(3); FOO(43);FOO(28); FOO(22); FOO(24);  break;
	    case 24: FOO(4); FOO(44);FOO(29); FOO(23); break;
	    case 25: FOO(5); FOO(45); FOO(20); FOO(30);FOO(26);  break;
	    case 26: FOO(6); FOO(46); FOO(21); FOO(31); FOO(25); FOO(27);  break;
	    case 27: FOO(7); FOO(47); FOO(22); FOO(32); FOO(26); FOO(28);  break;
	    case 28: FOO(8); FOO(48); FOO(23); FOO(33); FOO(27); FOO(29);  break;
	    case 29: FOO(9); FOO(49); FOO(24); FOO(34); FOO(28); break;
	    case 30: FOO(10); FOO(50); FOO(25); FOO(35);FOO(31);  break;
	    case 31: FOO(11); FOO(51); FOO(26); FOO(36); FOO(30); FOO(32);  break;
	    case 32: FOO(12); FOO(52); FOO(27); FOO(37); FOO(31); FOO(33);  break;
	    case 33: FOO(13); FOO(53); FOO(28); FOO(38); FOO(32); FOO(34);  break;
	    case 34: FOO(14); FOO(54); FOO(29); FOO(39); FOO(33); break;
	    case 35: FOO(15); FOO(55); FOO(30);FOO(36);  break;
	    case 36: FOO(16); FOO(56); FOO(31);FOO(35); FOO(37);  break;
	    case 37: FOO(17); FOO(57); FOO(32);FOO(36); FOO(38);  break;
	    case 38: FOO(18); FOO(58); FOO(33);FOO(37); FOO(39);  break;
	    case 39: FOO(19); FOO(59); FOO(34);FOO(38); break;
	    case 40: FOO(20);FOO(45);FOO(41);  break;
	    case 41: FOO(21);FOO(46); FOO(40); FOO(42);  break;
	    case 42: FOO(22);FOO(47); FOO(41); FOO(43);  break;
	    case 43: FOO(23);FOO(48); FOO(42); FOO(44);  break;
	    case 44: FOO(24);FOO(49); FOO(43); break;
	    case 45: FOO(25);FOO(40); FOO(50);FOO(46);  break;
	    case 46: FOO(26);FOO(41); FOO(51); FOO(45); FOO(47);  break;
	    case 47: FOO(27);FOO(42); FOO(52); FOO(46); FOO(48);  break;
	    case 48: FOO(28);FOO(43); FOO(53); FOO(47); FOO(49);  break;
	    case 49: FOO(29);FOO(44); FOO(54); FOO(48); break;
	    case 50: FOO(30);FOO(45); FOO(55);FOO(51);  break;
	    case 51: FOO(31);FOO(46); FOO(56); FOO(50); FOO(52);  break;
	    case 52: FOO(32);FOO(47); FOO(57); FOO(51); FOO(53);  break;
	    case 53: FOO(33);FOO(48); FOO(58); FOO(52); FOO(54);  break;
	    case 54: FOO(34);FOO(49); FOO(59); FOO(53); break;
	    case 55: FOO(35);FOO(50);FOO(56);  break;
	    case 56: FOO(36);FOO(51);FOO(55); FOO(57);  break;
	    case 57: FOO(37);FOO(52);FOO(56); FOO(58);  break;
	    case 58: FOO(38);FOO(53);FOO(57); FOO(59);  break;
	    case 59: FOO(39);FOO(54);FOO(58); break;
	    default: exit(-42-5);
	}
#else
#error "unknown PENTO_CONFIG"
#endif

#endif

	if (in != out)
	{
	    xyz = *out++;
	    continue;
	}

	break;
    }

    const int fillCount = ((unsigned long)out - (unsigned long)stack) + 1;

#ifdef USE_FILL_HASHTABLE

    hashTable[hash].fillCount = fillCount;
    hashTable[hash].trashed++;

#endif

#ifdef FILLTIMING

    struct timeval stop;
    gettimeofday (&stop, 0x0);

    unsigned long usecs = 1000000 * (stop.tv_sec - start.tv_sec) + (stop.tv_usec - start.tv_usec);

    fillTimeUsecs[fillCount] += usecs;
    fillTimeCount[fillCount]++;

#endif

    return fillCount;
}


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

std::string CBox::toString (std::string &s) const
{
    for (int x=0;x<MAXX;x++)
    {
	for (int i=0; i < drin; i++)
	{
	    s += "  ";
	}

	for (int y=0;y<MAXY;y++)
	{
	    for (int z=0;z<MAXZ;z++)
	    {
		const IXYZ xyz = COMBINE(x,y,z);

		if (isFull (xyz))
		    s += '*';
		else
		    s += '.';
	    }
	    s += "  ";
	}
	s += '\n';
    }
    return s;
}


std::ostream& operator<< (std::ostream &os, const CBox &box)
{
  std::string s;
  std::cout << box.toString(s) << std::endl;
  return os;
}


///////////////////////////////////////////////////////////////////////////////
//
// class CState
//
///////////////////////////////////////////////////////////////////////////////

class CState
{
private:

  CState& operator= (const CState &); // no accidental assignments
  bool operator== (const CState &);   // no unwanted comparisions
  explicit CState (void) ;            // no accidental empty creations

public:

  //     static fields

  static long countLoesungen;
  static CPentominos* ps;
#ifdef REMEMBER_SOLUTION_LAGEN
  static CLage** s_schonlagen;
  static int     i_schonlagen;
#endif
  static int     i_nochteile;
  static CBox    box;

  //     fields

  int     i_testteil;
  CPento* p_testteil;
  int     i_testlage;
  IXYZ    free;

  //     con- and destruct

  // called only once.

  CState (CPentominos &aps);

  // called on recurse

  CState (const CState &s);

  //     methods

  // legt die alle moeglichen Lagen fuer aktuelles Teil
  // (TOWI V22: an aktueller voxel position) auf den Arbeitsstack

  void doHoleLagen (void)
  {
    p_testteil = ps->teil[i_testteil];
    //TOWI V20
#if 1
    i_testlage = p_testteil->voxel_lagen_count[free] - 1;
#else
    i_testlage = p_testteil->voxel_lagen_count[free.GetX()][free.GetY()][free.GetZ()] - 1;
#endif
  }

  /* setzt freeX auf die naechste freie koordinate. 
   * Liefert true wenn gefunden. lage ist die letzte plazierte 
   * lage und wird (im moment) nur zur ausgabe gebraucht.
   */

  bool doSucheFree (void);

  void doTestLagen (void);

  void doTestTeile (void);
};             


CState::CState (CPentominos &aps)
  : i_testteil(0),
    p_testteil(),
    i_testlage(0)
#ifdef USE_QUICK_XYZ
    ,free (0)
#endif
{
  ps = &aps; // set static field
}


CState::CState (const CState &s)
  : i_testteil(i_nochteile),
    p_testteil(), // set in doHoleLagen()
    i_testlage(0),
    free(s.free)
{
}


bool CState::doSucheFree (void)
{
    do
    {
	if (!box.isFull (free))
	{ // note: first we hit the just filled voxel.

	    if (box.istPassend (free))
	    {
		return true; 
	    }

	    return false; // kein Platz fuer ganze Pentominos
	}
    }
#ifdef USE_QUICK_XYZ
    while (!IncXyz (free));
#else
    while (!free.Inc ());
#endif

    // we arrive here only when there was no empty voxel
    // in the box.

    countLoesungen++;

#if 0
    if (VERBOSE >= 2)
    {
    	std::string s("");
    	std::cout /* <<  box.toString(s) */ << countLoesungen;
    
    	time(&ttemp);
    	double dtime = difftime(ttemp, start_backtrack);
    	std::cout << "  " << (int)(box.sumrein/dtime) <<" Lagen/s"<< std::endl;
    }
#endif

    return false; // force finding next solution
}


void CState::doTestLagen (void)
{
    const ILAGE *ilagePtr = p_testteil->voxel_ilagen[free];

    while (i_testlage >= 0)
    {
        const ILAGE &ilage = ilagePtr[i_testlage--];

        //
        // ++itschere: where did doTestLage() go? :-)
        //

	if (box.passtILage (ilage))
	{
	    //
	    // diese Lage passt also. Nun rekursiv das naechste Teil unterbringen.
	    //

	    // teil einbauen
	    // - voxel fuellen

#ifdef USE_OPTIMIZED_LAGEREINRAUS

	    ILAGE backup;

	    switch (p_testteil->monos)
	    {
		case 4:
		    backup = box.lageRein4 (ilage); // TESCHE V23
		    break;
		case 5:
		    backup = box.lageRein5 (ilage); // TESCHE V23
		    break;
		case 6:
		    backup = box.lageRein6 (ilage); // TESCHE V23
		    break;
	    }

#else

	    const int monos = p_testteil->monos;

	    box.lageRein (ilage, monos); // TOWI V20. not rel to free anymore

#endif

	  if(VERBOSE>=3)
	    {
	      std::cout << box << std::endl;
	    }

	  // - free merken

	  const IXYZ oldfree = free;

	  // - free setzen

	  if (doSucheFree ())
	    {
	      // - stacks anpassen
	      //   . the swap puts the current testteil to front, 
	      //     so it becomes part of "schonteile" after nochteile++.
	      //     all teile beyond the nochteile pointer will be available
	      //     in the recursion step.
#if 0
	      CPento *swaptemp = ps->teil[i_nochteile];
	      ps->teil[i_nochteile] = ps->teil[i_testteil];
	      ps->teil[i_testteil] = swaptemp;

	      //   . incrementing nochteile adds a teil to "schonteile"
	      i_nochteile++;
#else
	      CPento *swaptemp = ps->teil[i_nochteile];
	      ps->teil[i_nochteile++] = ps->teil[i_testteil];
	      ps->teil[i_testteil] = swaptemp;
#endif

#ifdef REMEMBER_SOLUTION_LAGEN
	      //   . to for remembering the solution we need to put the 
	      //     lage on the solution stack. 
	      //     'schonlagen.push(lage)'
              s_schonlagen[i_schonlagen++] = p_testteil->voxel_lagen[free][i_testlage];
#endif

	      // - prepare state for next teil. we need to clone the current
	      //   so we can come back to it easily on failure.
	      CState clonestate (*this);

	      // - "rekursiv geht meistens schief..."
	      clonestate.doTestTeile ();

	      // - back already? then recursive placing the teil failed.
	      //   (to be exact: "was forced to fail", since if we want to enumarate
	      //   all solutions doSearchFree() fakes not finding a solution.)
	      //   so: adjust stacks back.
	      //   . ok, the current try did not bring us towards a solution,
	      //     so we undo the step where we put it to "schonteile"
#if 0
	      i_nochteile--;
	      swaptemp = ps->teil[i_nochteile];
	      ps->teil[i_nochteile] = ps->teil[i_testteil];
	      ps->teil[i_testteil] = swaptemp;
#else
	      swaptemp = ps->teil[--i_nochteile];
	      ps->teil[i_nochteile] = ps->teil[i_testteil];
	      ps->teil[i_testteil] = swaptemp;
#endif

#ifdef REMEMBER_SOLUTION_LAGEN
	      //   . remove from solution as well.
	      //     'shonlagen.pop()'
	      i_schonlagen--;
#endif
            }

	  // - s_free zuruecksetzen
	  free = oldfree;

	  // teil ausbauen
	  // - voxel leeren

#ifdef USE_OPTIMIZED_LAGEREINRAUS
	    switch (p_testteil->monos)
	    {
		case 4:
		    box.lageRaus4 (backup); // TESCHE V23
		    break;
		case 5:
		    box.lageRaus5 (backup); // TESCHE V23
		    break;
		case 6:
		    box.lageRaus6 (backup); // TESCHE V23
		    break;
	    }	    
#else
	    box.lageRaus (ilage, monos); // TOWI V20. not rel to free anymore
#endif
	}
    }
}


void CState::doTestTeile (void)
{
    while (i_testteil < TEILE)
    {
        // Teste alle Lagen des aktuellen Teils
        doHoleLagen ();
        doTestLagen ();
        // pop
        i_testteil++;
    }
}


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

//     init CState statics 

CBox          CState::box = CBox();
CPentominos*  CState::ps = (CPentominos*)0;
long          CState::countLoesungen = 0;
#ifdef REMEMBER_SOLUTION_LAGEN
  int         CState::i_schonlagen = 0;
  CLage**     CState::s_schonlagen = new CLage*[MAXLAGEN];
#endif
int           CState::i_nochteile = 0;


///////////////////////////////////////////////////////////////////////////////
//
// ++itschere: this is only a separate function because i want to see in in the
// profiler as a separate function. i want to know how much time is spend for
// initialization and for execution.
//
///////////////////////////////////////////////////////////////////////////////

extern CPentominos *GetPentominos (void);


///////////////////////////////////////////////////////////////////////////////
//
// main
//
///////////////////////////////////////////////////////////////////////////////

int main(int argc, char* argv[])
{   
  if(VERBOSE>=2) {
    std::cout << "sizeof(ILAGE): " << sizeof(ILAGE) << std::endl;
    std::cout << " set pixel  1: " << (((ILAGE)1)<< 1) << std::endl;
    std::cout << " set pixel 12: " << (((ILAGE)1)<<12) << std::endl;
    std::cout << " set pixel 23: " << (((ILAGE)1)<<23) << std::endl;
    std::cout << " set pixel 34: " << (((ILAGE)1)<<34) << std::endl;
    std::cout << " set pixel 45: " << (((ILAGE)1)<<45) << std::endl;
    std::cout << " set pixel 56: " << (((ILAGE)1)<<56) << std::endl;
    std::cout << "wrong set pixel 45: " << (((ILAGE)1)<<45) << std::endl;
    std::cout << "wrong set pixel 56: " << (((ILAGE)1)<<56) << std::endl;
  }

#ifdef USE_BITMASK32_ARRAY

  bitmask32Init ();

#endif

#ifdef USE_BITMASK64_ARRAY

  bitmask64Init ();

#endif

#ifdef USE_INCREMENT_TABLE

  incrementTableInit ();

#endif

#ifdef USE_MODE_TABLE

  modTableInit ();

#endif

  //

  CPentominos* ps = GetPentominos ();
  CState state(*ps);

  time(&start_backtrack);

  state.doTestTeile();

#ifdef FILLTIMING

  for (int i=0; i<=MAXX*MAXY*MAXZ; i++)
  {
      if (fillTimeCount[i])
      {
	  printf ("%2i : %6li us @ %6li calls -> %.3f us/call avg\n",
		  i,
		  fillTimeUsecs[i],
		  fillTimeCount[i],
		  fillTimeUsecs[i] / (double)fillTimeCount[i]);
      }
  }

#endif


#ifdef USE_FILL_HASHTABLE

  printf ("hash table used/trashed\n");

  for (int i=0; i<HASHTABLESIZE; i++)
  {
      printf ("%6i : %9i / %9i\n", i, hashTable[i].used, hashTable[i].trashed);
  }

#endif

  std::cout << "\nDONE Loesungen:" << CState::countLoesungen << std::endl; 

#if 0
  if(VERBOSE>=1) {

        time(&ttemp);
        double dtime = difftime(ttemp, start_backtrack);
        // how to output "5.0180"?
#ifndef __GNUC__
	// ++itschere: gcc says "statement with no effect" to this. yeah,
	// that's what you end up with if you're using streams - they suck! :-)
        std::cout.fixed;
#endif
        std::cout.precision(4);
        std::cout << "backtrack time: " << dtime << " = " << (int)(state.box.sumrein/dtime) <<" Lagen/s"<< std::endl;
  }
#endif

  delete ps;

  if(VERBOSE>=1) {
    char c;
    std::cin >> c ;
  }

  return CState::countLoesungen;
};


///////////////////////////////////////////////////////////////////////////////
//
//
//
///////////////////////////////////////////////////////////////////////////////

CPentominos *GetPentominos (void)
{
    CPentominos *pm = new CPentominos ();

    return pm;
}
