
#if !defined(AFX_CTPUZZLE_H__FC7AD349_5D25_11D7_BE08_00D059314673__INCLUDED_)
#define AFX_CTPUZZLE_H__FC7AD349_5D25_11D7_BE08_00D059314673__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000



#define xsize 6 // Grsse + 1 !!!
#define ysize 5 // Grsse +1
#define zsize 3

// Definiert das Mappings x,y,z -> Idx
#define xstep (1) 
#define ystep (xsize)
#define zstep (xsize*ysize)

#define GetIndex(x,y,z) (((x)*xstep)+(y)*ystep+(z)*zstep)
#define GetLowBit(x,y,z) ((x+y*5+z*5*4) < 32 ? 1 << (x+y*5+z*5*4) : 0)
#define GetHighBit(x,y,z) ((x+y*5+z*5*4) < 32 ? 0 : 1 << ((x+y*5+z*5*4)-32))

#define maxIndex xsize*ysize*zsize
#define maxIndex2 ((xsize*ysize*zsize)-xsize)

//#define byte char
#define ftype char
#define VERBOSE

struct FIELD
{
	int fieldLow;
	int fieldHigh;
	ftype field2[xsize*ysize*zsize+1+12];

	__forceinline ftype isHandled(const int nStone) const
	{
		return field2[xsize*ysize*zsize+nStone];
	}
	__forceinline void setHandled(const int nStone)
	{
		field2[xsize*ysize*zsize+nStone] = 1;
	}
	__forceinline void clearHandled(const int nStone)
	{
		field2[xsize*ysize*zsize+nStone] = 0;
	}
	
	__forceinline int GetNextFree(const int nStart) const
	{
		for (int i = nStart; i < xsize*ysize*zsize+1; ++i)
		{
			if (!field2[i]) return i;
		}
		return xsize*ysize*zsize+1;
	}


	
	__forceinline void SetAt(int x, int y, int z,ftype value)
	{
		SetAt(GetIndex(x,y,z),value);
	}

	
	__forceinline ftype GetAt(const int nIndex) const
	{
		return (field2[nIndex]);
	
	}

	__forceinline void SetAt(const int nIndex,const ftype nValue)
	{
		ASSERT(nIndex >= 0 && nIndex < (xsize*ysize*zsize+1));
		field2[nIndex] = nValue;
	}

	__forceinline ftype GetAt(const int x, const int y, const int z) const
	{
		return GetAt(GetIndex(x,y,z));
	}

	void Init() // Initialisiert das feld + die Rnder
	{
		memset(field2,0,sizeof(field2));
		
		// X-Rand markieren
		for (int y = 0; y < ysize; ++y)
			for (int z = 0; z < (zsize); ++z)
			{
				SetAt(5,y,z,15);
			}
	    // y Rand Markieren
		for (int x = 0; x < xsize; ++x)
			for (int z = 0; z < (zsize); ++z)
			{
				SetAt(x,4,z,15);
			}
		//for (int i = 0; i < 12; i++) clearHandled(i);
		SetAt(xsize*ysize*zsize,0);

		toInt64(fieldLow,fieldHigh);
	}

	void Set(const FIELD* pOther) 
	{
		memcpy(field2,pOther->field2,sizeof(field2));
		fieldLow = pOther->fieldLow;
		fieldHigh = pOther->fieldHigh;
	}

	void Set2(const FIELD* pOther) 
	{
		memcpy(field2+maxIndex,pOther->field2+maxIndex,sizeof(field2[0])*12);
		fieldLow = pOther->fieldLow;
		fieldHigh = pOther->fieldHigh;
	}

	void Set3(const FIELD* pOther) 
	{
		memcpy(field2,pOther->field2,sizeof(field2[0])*maxIndex);
	}


	void SwapX()
	{
		for (int z = 0; z < 3; ++z)
			for (int y = 0; y < 4; ++y)
				for (int x = 0; x < 3; ++x)
				{
					int nIndex1 = GetIndex(x,y,z);
					int nIndex2 = GetIndex(4-x,y,z);
					ftype b1 = GetAt(nIndex1);
					SetAt(nIndex1,GetAt(nIndex2));
					SetAt(nIndex2,b1);
				}
	}

	void SwapY()
	{
		for (int z = 0; z < 3; ++z)
			for (int y = 0; y < 2; ++y)
				for (int x = 0; x < 5; ++x)
				{
					int nIndex1 = GetIndex(x,y,z);
					int nIndex2 = GetIndex(x,3-y,z);
					ftype b1 = GetAt(nIndex1);
					SetAt(nIndex1,GetAt(nIndex2));
					SetAt(nIndex2,b1);
				}
	}

	void SwapZ()
	{
		for (int z = 0; z < 1; ++z)
			for (int y = 0; y < 4; ++y)
				for (int x = 0; x < 5; ++x)
				{
					int nIndex1 = GetIndex(x,y,z);
					int nIndex2 = GetIndex(x,y,2-z);
					ftype b1 = GetAt(nIndex1);
					SetAt(nIndex1,GetAt(nIndex2));
					SetAt(nIndex2,b1);
				}
	}

	void RotateX(int nAmount)
	{
		if (nAmount == 0) return;
		SwapY();
		SwapZ();
	}

	void RotateY(int nAmount)
	{
		if (nAmount == 0) return;
		SwapX();
		SwapZ();
	}

	void RotateZ(int nAmount)
	{
		if (nAmount == 0) return;
		SwapX();
		SwapY();
	}

	void toInt64(int& i_low,int& i_high) const
	{
		i_low = 0;
		i_high = 0;
		for (int z = 0; z < 3; ++z)
			for (int y = 0; y < 4; ++y)
				for (int x = 0; x < 5; ++x)
				{
					int nIndex1 = GetIndex(x,y,z);
					int nIndex2 = x+y*5+z*5*4;
					if (GetAt(nIndex1))
					{
						if (nIndex2 < 32)
						{
							i_low |= 1 << nIndex2;
						} else
						{
							i_high |= 1 << (nIndex2-32);
						}
					}
				}
	}

	void toInt64()
	{
		toInt64(fieldLow,fieldHigh);
	}


	bool isEqual(FIELD* pOther) const
	{
		for (int z = 0; z < 3 ; ++z)
			for (int y = 0; y < 4 ; ++y)
				for (int x = 0; x < 5 ; ++x)
				{
					int nIndex1 = GetIndex(x,y,z);
					ftype b1 = GetAt(nIndex1);
					if (pOther->GetAt(nIndex1) != b1)	
					{
						return false;
					}

				}

		return true;
	}


};

struct POS3d
{
	int x;
	int y;
	int z;
};

struct IdxPart;

struct PART3d
{
	int nStones;
	POS3d p[6];
	// Liste der mgliche Steine an Position x,y,z in der Reihenfolge z,y,x
	CList<IdxPart*,IdxPart*>* pLstIndexMap[xsize*ysize*zsize];
	// Reduzierte Liste der mgliche Steine an Position x,y,z in der Reihenfolge z,y,x
	CList<IdxPart*,IdxPart*>* pLstIndexMap2[xsize*ysize*zsize];
	// Liste der mgliche Steine an Position x,y,z in der Reihenfolge x,y,z
	CList<IdxPart*,IdxPart*>* pLstIndexMap3[xsize*ysize*zsize];
	// Reduzierte Liste der mgliche Steine an Position x,y,z in der Reihenfolge x,y,z
	CList<IdxPart*,IdxPart*>* pLstIndexMap4[xsize*ysize*zsize];
	int nOffset[6];
	

	bool IsEqual(PART3d* other) const
	{
		bool bSet[6] = {true,true,true,true,true,true};
		for (int i = 0; i < 6; ++i)
		{
			bool bFound = false;
			for (int j = 0; j < 6; ++j)
			{
				if (bSet[j] && 
					p[i].x == other->p[j].x && 
					p[i].y == other->p[j].y &&
					p[i].z == other->p[j].z)
				{
					bFound = true;
					bSet[j] = false;
					break;
				}
			}
			if (!bFound) return false;

		}
		return true;
	}
};

struct IdxPart
{
	int nValueLow;
	int nValueHigh;
	PART3d* pPart;
	int nIndex;
	IdxPart(int i_nValueLow,int i_nValueHigh,	PART3d* i_pPart,int i_nIndex)
	{
		pPart = i_pPart;
		nValueLow= i_nValueLow;
		nValueHigh= i_nValueHigh;
		nIndex = i_nIndex;
	}
};

void setStone(const PART3d* pPart,const int nIndex,FIELD* pField,const ftype nStone)
{
	int nStones = pPart->nStones;
	switch (nStones)
	{
	case 5:
		{
		#pragma unroll(5)
		for (int j = 0; j < 5; ++j)
		{
			pField->field2[pPart->nOffset[j]+nIndex] = nStone;
		}
		break;
		}
	case 6:
		{
		#pragma unroll(6)
		for (int j = 0; j < 6; ++j)
		{
			pField->field2[pPart->nOffset[j]+nIndex] = nStone;
		}
		break;
		}
	case 4:
		{
		#pragma unroll(4)
		for (int j = 0; j < 4; ++j)
		{
			pField->field2[pPart->nOffset[j]+nIndex] = nStone;
		}
		break;
		}
	}

}

//__forceinline 
bool isValid(const PART3d* pPart,const int nIndex,const FIELD* pField)
{
	int nStones = pPart->nStones;
	bool bValid = true;
	for (int j = 0; j < nStones && bValid; ++j)
	{
		int nIdx = pPart->nOffset[j]+nIndex;
		if (nIdx < 0 || nIdx >= maxIndex || pField->GetAt(pPart->nOffset[j]+nIndex) != 0)
		{
			bValid = false;
		};
	}
	return bValid;


}

#ifdef VERBOSE
static int nRekCount;
struct STAT
{
	int nDone;
	int nStone;
};

static STAT m_arrStat[12];
#endif
int nSolutions;
DWORD nStartTicks;
static FIELD m_Field[12];

CList<PART3d*,PART3d*> m_lstParts[12];


#endif // !defined(AFX_CTPUZZLE_H__FC7AD349_5D25_11D7_BE08_00D059314673__INCLUDED_)
