// ctpuzzle.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "ctpuzzle.h"
#include <conio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

#define POS4Stone 11
#define POS6Stone 1

// Wrfel in Linkshand-Schreibweise
PART3d stones[]={
	{5, 0,1,0, 1,0,0, 1,1,0, 2,1,0, 1,2,0, -1,-1,-1} //9
	,{6, 0,0,0, 1,0,0, 0,1,0, 0,2,0, 1,2,0, 0,3,0} //10
	,{5, 0,0,0, 0,1,0, 0,2,0, 1,2,0, 0,3,0, -1,-1,-1} //3
	,{5, 0,0,0, 1,0,0, 1,1,0, 1,2,0, 1,3,0, -1,-1,-1} //2
	,{5, 0,0,0, 1,0,0, 1,1,0, 2,1,0, 1,2,0, -1,-1,-1} //8
	,{5, 0,0,0, 0,1,0, 1,0,0, 1,1,0, 1,2,0, -1,-1,-1} //6
	,{5, 0,0,0, 0,0,1, 1,0,1, 0,1,0, 0,1,1, -1,-1,-1} //4
	,{5, 0,0,0, 1,0,0, 1,1,0, 2,1,0, 2,2,0, -1,-1,-1} //7
	,{5, 0,0,0, 0,1,0, 1,1,0, 2,1,0, 0,2,0, -1,-1,-1} //5
	,{5, 0,0,0, 1,0,0, 1,1,0, 1,2,0, 2,2,0, -1,-1,-1} //1
	,{5, 0,0,0, 1,0,0, 0,1,0, 0,2,0, 1,2,0, -1,-1,-1} //0
	,{ 4, 0,0,0, 0,1,0, 1,0,0, 1,0,1, -1,-1,-1, -1,-1,-1} //11
	 };

const int nMapPos[] = {

	GetIndex(0,0,0),GetLowBit(0,0,0),GetHighBit(0,0,0),
	GetIndex(0,0,1),GetLowBit(0,0,1),GetHighBit(0,0,1),
	GetIndex(0,0,2),GetLowBit(0,0,2),GetHighBit(0,0,2),
	GetIndex(0,1,0),GetLowBit(0,1,0),GetHighBit(0,1,0),
	GetIndex(0,1,1),GetLowBit(0,1,1),GetHighBit(0,1,1),
	GetIndex(0,1,2),GetLowBit(0,1,2),GetHighBit(0,1,2),
	GetIndex(0,2,0),GetLowBit(0,2,0),GetHighBit(0,2,0),
	GetIndex(0,2,1),GetLowBit(0,2,1),GetHighBit(0,2,1),
	GetIndex(0,2,2),GetLowBit(0,2,2),GetHighBit(0,2,2),
	GetIndex(0,3,0),GetLowBit(0,3,0),GetHighBit(0,3,0),
	GetIndex(0,3,1),GetLowBit(0,3,1),GetHighBit(0,3,1),
	GetIndex(0,3,2),GetLowBit(0,3,2),GetHighBit(0,3,2),

	GetIndex(1,0,0),GetLowBit(1,0,0),GetHighBit(1,0,0),
	GetIndex(1,0,1),GetLowBit(1,0,1),GetHighBit(1,0,1),
	GetIndex(1,0,2),GetLowBit(1,0,2),GetHighBit(1,0,2),
	GetIndex(1,1,0),GetLowBit(1,1,0),GetHighBit(1,1,0),
	GetIndex(1,1,1),GetLowBit(1,1,1),GetHighBit(1,1,1),
	GetIndex(1,1,2),GetLowBit(1,1,2),GetHighBit(1,1,2),
	GetIndex(1,2,0),GetLowBit(1,2,0),GetHighBit(1,2,0),
	GetIndex(1,2,1),GetLowBit(1,2,1),GetHighBit(1,2,1),
	GetIndex(1,2,2),GetLowBit(1,2,2),GetHighBit(1,2,2),
	GetIndex(1,3,0),GetLowBit(1,3,0),GetHighBit(1,3,0),
	GetIndex(1,3,1),GetLowBit(1,3,1),GetHighBit(1,3,1),
	GetIndex(1,3,2),GetLowBit(1,3,2),GetHighBit(1,3,2),

	GetIndex(2,0,0),GetLowBit(2,0,0),GetHighBit(2,0,0),
	GetIndex(2,0,1),GetLowBit(2,0,1),GetHighBit(2,0,1),
	GetIndex(2,0,2),GetLowBit(2,0,2),GetHighBit(2,0,2),
	GetIndex(2,1,0),GetLowBit(2,1,0),GetHighBit(2,1,0),
	GetIndex(2,1,1),GetLowBit(2,1,1),GetHighBit(2,1,1),
	GetIndex(2,1,2),GetLowBit(2,1,2),GetHighBit(2,1,2),
	GetIndex(2,2,0),GetLowBit(2,2,0),GetHighBit(2,2,0),
	GetIndex(2,2,1),GetLowBit(2,2,1),GetHighBit(2,2,1),
	GetIndex(2,2,2),GetLowBit(2,2,2),GetHighBit(2,2,2),
	GetIndex(2,3,0),GetLowBit(2,3,0),GetHighBit(2,3,0),
	GetIndex(2,3,1),GetLowBit(2,3,1),GetHighBit(2,3,1),
	GetIndex(2,3,2),GetLowBit(2,3,2),GetHighBit(2,3,2),

	GetIndex(3,0,0),GetLowBit(3,0,0),GetHighBit(3,0,0),
	GetIndex(3,0,1),GetLowBit(3,0,1),GetHighBit(3,0,1),
	GetIndex(3,0,2),GetLowBit(3,0,2),GetHighBit(3,0,2),
	GetIndex(3,1,0),GetLowBit(3,1,0),GetHighBit(3,1,0),
	GetIndex(3,1,1),GetLowBit(3,1,1),GetHighBit(3,1,1),
	GetIndex(3,1,2),GetLowBit(3,1,2),GetHighBit(3,1,2),
	GetIndex(3,2,0),GetLowBit(3,2,0),GetHighBit(3,2,0),
	GetIndex(3,2,1),GetLowBit(3,2,1),GetHighBit(3,2,1),
	GetIndex(3,2,2),GetLowBit(3,2,2),GetHighBit(3,2,2),
	GetIndex(3,3,0),GetLowBit(3,3,0),GetHighBit(3,3,0),
	GetIndex(3,3,1),GetLowBit(3,3,1),GetHighBit(3,3,1),
	GetIndex(3,3,2),GetLowBit(3,3,2),GetHighBit(3,3,2),

	GetIndex(4,0,0),GetLowBit(4,0,0),GetHighBit(4,0,0),
	GetIndex(4,0,1),GetLowBit(4,0,1),GetHighBit(4,0,1),
	GetIndex(4,0,2),GetLowBit(4,0,2),GetHighBit(4,0,2),
	GetIndex(4,1,0),GetLowBit(4,1,0),GetHighBit(4,1,0),
	GetIndex(4,1,1),GetLowBit(4,1,1),GetHighBit(4,1,1),
	GetIndex(4,1,2),GetLowBit(4,1,2),GetHighBit(4,1,2),
	GetIndex(4,2,0),GetLowBit(4,2,0),GetHighBit(4,2,0),
	GetIndex(4,2,1),GetLowBit(4,2,1),GetHighBit(4,2,1),
	GetIndex(4,2,2),GetLowBit(4,2,2),GetHighBit(4,2,2),
	GetIndex(4,3,0),GetLowBit(4,3,0),GetHighBit(4,3,0),
	GetIndex(4,3,1),GetLowBit(4,3,1),GetHighBit(4,3,1),
	GetIndex(4,3,2),GetLowBit(4,3,2),GetHighBit(4,3,2)

	};

const int nTestX[]=
{
/*	GetLowBit (0,0,0)|GetLowBit (0,0,1)|GetLowBit (0,0,2)|GetLowBit (0,1,0)|GetLowBit (0,1,1)|GetLowBit(0,1,2) |GetLowBit (0,2,0)|GetLowBit (0,2,1),
	GetHighBit(0,0,0)|GetHighBit(0,0,1)|GetHighBit(0,0,2)|GetHighBit(0,1,0)|GetHighBit(0,1,1)|GetHighBit(0,1,2)|GetHighBit(0,2,0)|GetHighBit(0,2,1),
	GetLowBit (0,2,2)|GetLowBit (0,3,0)|GetLowBit (0,3,1)|GetLowBit (0,3,2)|GetLowBit (1,0,0)|GetLowBit(1,0,1) |GetLowBit (1,0,2)|GetLowBit (1,1,0),
	GetHighBit(0,2,2)|GetHighBit(0,3,0)|GetHighBit(0,3,1)|GetHighBit(0,3,2)|GetHighBit(1,0,0)|GetHighBit(1,0,1)|GetHighBit(1,0,2)|GetHighBit(1,1,0),
	GetLowBit (1,1,1)|GetLowBit (1,1,2)|GetLowBit (1,2,0)|GetLowBit (1,2,1)|GetLowBit (1,2,2)|GetLowBit (1,3,0)|GetLowBit (1,3,1)|GetLowBit (1,3,2),
	GetHighBit(1,1,1)|GetHighBit(1,1,2)|GetHighBit(1,2,0)|GetHighBit(1,2,1)|GetHighBit(1,2,2)|GetHighBit(1,3,0)|GetHighBit(1,3,1)|GetHighBit(1,3,2),
	GetLowBit (2,0,0)|GetLowBit (2,0,1)|GetLowBit (2,0,2)|GetLowBit (2,1,0)|GetLowBit (2,1,1)|GetLowBit (2,1,2)|GetLowBit (2,2,0)|GetLowBit (2,2,1),
	GetHighBit(2,0,0)|GetHighBit(2,0,1)|GetHighBit(2,0,2)|GetHighBit(2,1,0)|GetHighBit(2,1,1)|GetHighBit(2,1,2)|GetHighBit(2,2,0)|GetHighBit(2,2,1),
	GetLowBit (2,2,2)|GetLowBit (2,3,0)|GetLowBit (2,3,1)|GetLowBit (2,3,2)|GetLowBit (3,0,0)|GetLowBit (3,0,1)|GetLowBit (3,0,2)|GetLowBit (3,1,0),
	GetHighBit(2,2,2)|GetHighBit(2,3,0)|GetHighBit(2,3,1)|GetHighBit(2,3,2)|GetHighBit(3,0,0)|GetHighBit(3,0,1)|GetHighBit(3,0,2)|GetHighBit(3,1,0),
	GetLowBit (3,1,1)|GetLowBit (3,1,2)|GetLowBit (3,2,0)|GetLowBit (3,2,1)|GetLowBit (3,2,2)|GetLowBit (3,3,0)|GetLowBit (3,3,1)|GetLowBit (3,3,2),
	GetHighBit(3,1,1)|GetHighBit(3,1,2)|GetHighBit(3,2,0)|GetHighBit(3,2,1)|GetHighBit(3,2,2)|GetHighBit(3,3,0)|GetHighBit(3,3,1)|GetHighBit(3,3,2)*/
	nMapPos[3*0+1]|nMapPos[3*1+1]|nMapPos[3*2+1]|nMapPos[3*3+1]|nMapPos[3*4+1]|nMapPos[3*5+1]|nMapPos[3*6+1]|nMapPos[3*7+1],
	nMapPos[3*0+2]|nMapPos[3*1+2]|nMapPos[3*2+2]|nMapPos[3*3+2]|nMapPos[3*4+2]|nMapPos[3*5+2]|nMapPos[3*6+2]|nMapPos[3*7+2],
	nMapPos[3*8+1]|nMapPos[3*9+1]|nMapPos[3*10+1]|nMapPos[3*11+1]|nMapPos[3*12+1]|nMapPos[3*13+1]|nMapPos[3*14+1]|nMapPos[3*15+1],
	nMapPos[3*8+2]|nMapPos[3*9+2]|nMapPos[3*10+2]|nMapPos[3*11+2]|nMapPos[3*12+2]|nMapPos[3*13+2]|nMapPos[3*14+2]|nMapPos[3*15+2],
	nMapPos[3*16+1]|nMapPos[3*17+1]|nMapPos[3*18+1]|nMapPos[3*19+1]|nMapPos[3*20+1]|nMapPos[3*21+1]|nMapPos[3*22+1]|nMapPos[3*23+1],
	nMapPos[3*16+2]|nMapPos[3*17+2]|nMapPos[3*18+2]|nMapPos[3*19+2]|nMapPos[3*20+2]|nMapPos[3*21+2]|nMapPos[3*22+2]|nMapPos[3*23+2],
	nMapPos[3*24+1]|nMapPos[3*25+1]|nMapPos[3*26+1]|nMapPos[3*27+1]|nMapPos[3*28+1]|nMapPos[3*29+1]|nMapPos[3*30+1]|nMapPos[3*31+1],
	nMapPos[3*24+2]|nMapPos[3*25+2]|nMapPos[3*26+2]|nMapPos[3*27+2]|nMapPos[3*28+2]|nMapPos[3*29+2]|nMapPos[3*30+2]|nMapPos[3*31+2],
	nMapPos[3*32+1]|nMapPos[3*33+1]|nMapPos[3*34+1]|nMapPos[3*35+1]|nMapPos[3*36+1]|nMapPos[3*37+1]|nMapPos[3*38+1]|nMapPos[3*39+1],
	nMapPos[3*32+2]|nMapPos[3*33+2]|nMapPos[3*34+2]|nMapPos[3*35+2]|nMapPos[3*36+2]|nMapPos[3*37+2]|nMapPos[3*38+2]|nMapPos[3*39+2],
	nMapPos[3*40+1]|nMapPos[3*41+1]|nMapPos[3*42+1]|nMapPos[3*43+1]|nMapPos[3*44+1]|nMapPos[3*45+1]|nMapPos[3*46+1]|nMapPos[3*47+1],
	nMapPos[3*40+2]|nMapPos[3*41+2]|nMapPos[3*42+2]|nMapPos[3*43+2]|nMapPos[3*44+2]|nMapPos[3*45+2]|nMapPos[3*46+2]|nMapPos[3*47+2],
};




void Rotate(PART3d* pPart,int x, int y, int z)
{
  int nCount = pPart->nStones;
  for (int n = 0; n < nCount; ++n)
  {
	  int nTemp;
	  switch (x)
	  {
	  case 0: break;
	  case 1:
		   // 90 um x --> z = y; y = -z
		  nTemp = pPart->p[n].z;
		  pPart->p[n].z = pPart->p[n].y;
		  pPart->p[n].y = -nTemp;
		  break;
	  case 2:
		  // 180 --> z = -z ; y = -y
		  pPart->p[n].y = -pPart->p[n].y;
		  pPart->p[n].z = -pPart->p[n].z;
		  break;
	  case 3:
		  // 270 --> 90+180
		  nTemp = pPart->p[n].z;
		  pPart->p[n].z = pPart->p[n].y;
		  pPart->p[n].y = -nTemp;
		  pPart->p[n].y = -pPart->p[n].y;
		  pPart->p[n].z = -pPart->p[n].z;
		  break;
	  }
	  switch (y)
	  {
	  case 0: break;
	  case 1:
		   // 90 um y --> z = -x; x = z
		  nTemp = pPart->p[n].z;
		  pPart->p[n].z = -pPart->p[n].x;
		  pPart->p[n].x = nTemp;
		  break;
	  case 2:
		  // 180 --> z = -z ; x = -x
		  pPart->p[n].x = -pPart->p[n].x;
		  pPart->p[n].z = -pPart->p[n].z;
		  break;
	  case 3:
		  nTemp = pPart->p[n].z;
		  pPart->p[n].z = -pPart->p[n].x;
		  pPart->p[n].x = nTemp;
		  pPart->p[n].x = -pPart->p[n].x;
		  pPart->p[n].z = -pPart->p[n].z;
		  break;
	  }
	  switch (z)
	  {
	  case 0:break;
	  case 1:
		   // 90 um z --> x = y; y = -x
		  nTemp = pPart->p[n].y;
		  pPart->p[n].y = -pPart->p[n].x;
		  pPart->p[n].x = nTemp;
		  break;
	  case 2:
		  pPart->p[n].x = -pPart->p[n].x;
		  pPart->p[n].y = -pPart->p[n].y;
		  break;
	  case 3:
		  nTemp = pPart->p[n].y;
		  pPart->p[n].y = -pPart->p[n].x;
		  pPart->p[n].x = nTemp;
		  pPart->p[n].x = -pPart->p[n].x;
		  pPart->p[n].y = -pPart->p[n].y;
		  break;
	  }
  }

}

void Move(PART3d* pPart,int x, int y, int z)
{
	int nStones = pPart->nStones;
	for (int i = 0; i< nStones; ++i)
	{
		pPart->p[i].x += x;
		pPart->p[i].y += y;
		pPart->p[i].z += z;
	}
}

void Normalize(PART3d* pFirst)
{
  // Normalisieren
  int nCount = pFirst->nStones;
  int nMinX = 1024;
  int nMinY = 1024;
  int nMinZ = 1024;
  for (int n = 0; n < nCount; ++n)
  {
	 nMinX = min(pFirst->p[n].x,nMinX);
	 nMinY = min(pFirst->p[n].y,nMinY);
	 nMinZ = min(pFirst->p[n].z,nMinZ);
  }
  bool bFirstIsZero = false;
  for (/*int*/ n = 0; n < nCount; ++n)
  {
	pFirst->p[n].x -= nMinX;
	pFirst->p[n].y -= nMinY;
	pFirst->p[n].z -= nMinZ;
	int nIndex = GetIndex(pFirst->p[n].x,pFirst->p[n].y,pFirst->p[n].z);
	pFirst->nOffset[n] = nIndex;
	if (n == 0 && nIndex == 0) bFirstIsZero = true;
	//nLast = nIndex;
  }
  if (bFirstIsZero)
  {
	pFirst->nOffset[0] = pFirst->nOffset[1];
	pFirst->nOffset[1] = 0;
  }

}



void InitRotationLists()
{
  for (int i = 0; i < 12; ++i)
  {
	memset(stones[i].pLstIndexMap,0,sizeof(stones[i].pLstIndexMap));
	// Rotation um alle Achsen
	for (int x = 0; x < 4; ++x)
		for (int y = 0; y < 4; ++y)
		  for (int z = 0; z < 4; ++z)
		  {
			  PART3d prt = stones[i];
			  Rotate(&prt,x,y,z);
			  Normalize(&prt);
			  // Rotationen sind erfolgt, in der Rotationsliste eintragen & nachschauen ob schon vorhanden
			  bool bFound = false;
			  for (POSITION pos = m_lstParts[i].GetHeadPosition(); pos != NULL ;)
			  {
				PART3d* pPart = m_lstParts[i].GetNext(pos);
				if (pPart->IsEqual(&prt))
				{
					bFound = true;
					break;
				}
			  }
			  if (!bFound)
			  {
				PART3d* pPart = new PART3d(prt);
				m_lstParts[i].AddTail(pPart);
				if (i != 0)
				for (int x1 = 0; x1 < 5; ++x1)
					for (int y1 = 0; y1 < 4; ++y1)
						for (int z1 = 0; z1 < 3; ++z1)
						{
							FIELD field;
							field.Init();
							int nIndex = GetIndex(x1,y1,z1);
							if (isValid(pPart,nIndex,&field))
							{
								setStone(pPart,nIndex,&field,2);
								int nLow,nHigh;
								field.toInt64(nLow,nHigh);
								for (int nIdx2 = 0; nIdx2 < xsize*ysize*zsize; ++nIdx2)
								{
									if (field.GetAt(nIdx2) == 2 )
									{
										CList<IdxPart*,IdxPart*>* pLst = stones[i].pLstIndexMap3[nIdx2];
										if (pLst == NULL)
										{
											pLst = new CList<IdxPart*,IdxPart*>(10);
											stones[i].pLstIndexMap3[nIdx2] = pLst;
										}
										IdxPart* pIdxPart = new IdxPart(nLow,nHigh,pPart,nIndex);
										pLst->AddTail(pIdxPart);
										break;
									}
								}
								for (int nIdx3 = 0; nIdx3 < 5*4*3; ++nIdx3)
								{
									int nIdx2 = nMapPos[3*nIdx3];
									if (field.GetAt(nIdx2) == 2 )
									{
										CList<IdxPart*,IdxPart*>* pLst = stones[i].pLstIndexMap[nIdx2];
										if (pLst == NULL)
										{
											pLst = new CList<IdxPart*,IdxPart*>(10);
											stones[i].pLstIndexMap[nIdx2] = pLst;
										}
										IdxPart* pIdxPart = new IdxPart(nLow,nHigh,pPart,nIndex);
										pLst->AddTail(pIdxPart);
										break;
									}
								}
							}

						}
			  }
		  }
#ifdef VERBOSE
		  printf("Stein Nr. %i : %i/%i Moeglichkeiten \r\n",i,m_lstParts[i].GetCount(),m_lstParts[i].GetCount()*stones[i].nStones);
#endif
  }
}




bool isSym(FIELD* pField)
{
	FIELD tempField;
	tempField.Init();
	for (int x = 0; x < 2; ++x)
		for (int y = 0; y < 2; ++y)
			for (int z = 0; z < 2; ++z)
			{
				if (x == 0 && y == 0 && z == 0) continue;
				if (x == 1 && y == 1 && z == 1) continue;
				tempField.Set(pField);
				tempField.RotateX(x);
				tempField.RotateY(y);
				tempField.RotateZ(z);
				if (tempField.isEqual(pField)) return true;
			}
	return false;
}

int markNoRek(FIELD* tempField,const int nIndex)
{
	int nIndexes[3*4*5];
	int nStart = 0;
	int nEnd = 1;
	int nIdx2 = nIndex;
	nIndexes[0] = nIdx2;
	tempField->SetAt(nIdx2,1);
	while (nStart < nEnd)
	{
		nIdx2 = nIndexes[nStart++];
		int nIdx1;
		if ((nIdx1 = nIdx2-xstep) >= 0 && nIdx1 < maxIndex2 && !tempField->field2[nIdx1]) // Nach links
		{
			nIndexes[nEnd++] = nIdx1;
			tempField->SetAt(nIdx1,1);
		}
		if ((nIdx1 = nIdx2-zstep) >= 0 && nIdx1 < maxIndex2 && !tempField->field2[nIdx1]) // Nach vorne
		{
			nIndexes[nEnd++] = (nIdx1);
			tempField->SetAt(nIdx1,1);
		}
		if ((nIdx1 = nIdx2+xstep) >= 0 && nIdx1 < maxIndex2 && !tempField->field2[nIdx1]) // Nach vorne
		{
			nIndexes[nEnd++] = nIdx1;
			tempField->SetAt(nIdx1,1);
		}
		if ((nIdx1 = nIdx2-ystep) >= 0 && nIdx1 < maxIndex2 && !tempField->field2[nIdx1]) // Nach vorne
		{
			nIndexes[nEnd++] = nIdx1;
			tempField->SetAt(nIdx1,1);
		}
		if ((nIdx1 = nIdx2+ystep) >= 0 && nIdx1 < maxIndex2 && !tempField->field2[nIdx1]) // Nach vorne
		{
			nIndexes[nEnd++] = nIdx1;
			tempField->SetAt(nIdx1,1);
		}
		if ((nIdx1 = nIdx2+zstep) >= 0 && nIdx1 < maxIndex2 && !tempField->field2[nIdx1]) // Nach vorne
		{
			nIndexes[nEnd++] = nIdx1;
			tempField->SetAt(nIdx1,1);
		}

	}

	return nEnd;
}

bool checkHole5(const FIELD* pField)
{
FIELD tempField;
	tempField.Set3(pField);
	int nIndex = 0;
	do
	{
		nIndex = tempField.GetNextFree(nIndex);
		if (nIndex >= xsize*ysize*zsize) break;
		int nCount = markNoRek(&tempField,nIndex);
		if (nCount < 4) { return false;}
		if (pField->isHandled(POS4Stone) && nCount < 5) { return false;}
		bool bPossible = false;
		if (!bPossible && (nCount) % 5 == 0) bPossible = true;
		if (!bPossible && !pField->isHandled(POS4Stone) && (nCount+1) % 5 == 0) bPossible = true;
		if (!bPossible && !pField->isHandled(POS6Stone) && (nCount-1) % 5 == 0) bPossible = true;
		if (!bPossible) { return false;}
	} while (true);
	return true;
}

int GetNextIndex(const FIELD* pField)
{
	if (((pField->fieldLow & nTestX[0]) != nTestX[0])
		||((pField->fieldHigh & nTestX[1]) != nTestX[1]))
	{
		for (int i = 0; i < 8; i++)
		{
			if (((pField->fieldLow & nMapPos[3*i+1]) == 0) && 
			    ((pField->fieldHigh & nMapPos[3*i+2]) == 0)) return nMapPos[3*i];
		}

	} else
	if (((pField->fieldLow & nTestX[2]) != nTestX[2])
		||((pField->fieldHigh & nTestX[3]) != nTestX[3]))
	{
		for (int i = 8; i < 16; i++)
		{
			if (((pField->fieldLow & nMapPos[3*i+1]) == 0) && 
			    ((pField->fieldHigh & nMapPos[3*i+2]) == 0)) return nMapPos[3*i];
		}

	} else
	if (((pField->fieldLow & nTestX[4]) != nTestX[4])
		||((pField->fieldHigh & nTestX[5]) != nTestX[5]))
	{
		for (int i = 16; i < 24; i++)
		{
			if (((pField->fieldLow & nMapPos[3*i+1]) == 0) && 
			    ((pField->fieldHigh & nMapPos[3*i+2]) == 0)) return nMapPos[3*i];
		}

	} else
	if (((pField->fieldLow & nTestX[6]) != nTestX[6])
		||((pField->fieldHigh & nTestX[7]) != nTestX[7]))
	{
		for (int i = 24; i < 32; i++)
		{
			if (((pField->fieldLow & nMapPos[3*i+1]) == 0) && 
			    ((pField->fieldHigh & nMapPos[3*i+2]) == 0)) return nMapPos[3*i];
		}

	} else
	if (((pField->fieldLow & nTestX[8]) != nTestX[8])
		||((pField->fieldHigh & nTestX[9]) != nTestX[9]))
	{
		for (int i = 32; i < 40; i++)
		{
			if (((pField->fieldLow & nMapPos[3*i+1]) == 0) && 
			    ((pField->fieldHigh & nMapPos[3*i+2]) == 0)) return nMapPos[3*i];
		}

	} else
	if (((pField->fieldLow & nTestX[10]) != nTestX[10])
		||((pField->fieldHigh & nTestX[11]) != nTestX[11]))
	{
		for (int i = 40; i < 48; i++)
		{
			if (((pField->fieldLow & nMapPos[3*i+1]) == 0) && 
			    ((pField->fieldHigh & nMapPos[3*i+2]) == 0)) return nMapPos[3*i];
		}

	} else
	for (int i = 48; i < 60; i++)
	{
			if (((pField->fieldLow & nMapPos[3*i+1]) == 0) && 
			    ((pField->fieldHigh & nMapPos[3*i+2]) == 0)) return nMapPos[3*i];
	}
	return -1; 
}


bool createNext(const FIELD* pField)
{
	int nIdx=0;
	do
	{
		nIdx = pField->GetNextFree(nIdx);
		if (nIdx >= xsize*ysize*zsize) break;
		for (int nStone = 1; nStone < 12; ++nStone)
		{
			if (pField->isHandled(nStone)) continue;
			if (stones[nStone].pLstIndexMap[nIdx])
			{
				if (stones[nStone].pLstIndexMap2[nIdx] == NULL)
				{
					stones[nStone].pLstIndexMap2[nIdx] = new CList<IdxPart*,IdxPart*>(5);
				} else
				{
					stones[nStone].pLstIndexMap2[nIdx]->RemoveAll();
				}
				for (POSITION pos = stones[nStone].pLstIndexMap[nIdx]->GetHeadPosition(); pos != NULL; )
				{
					IdxPart* pIdxPart = stones[nStone].pLstIndexMap[nIdx]->GetNext(pos);
					if (((pField->fieldLow & pIdxPart->nValueLow) == 0) && ((pField->fieldHigh & pIdxPart->nValueHigh) == 0))
					{
						stones[nStone].pLstIndexMap2[nIdx]->AddTail(pIdxPart);
					}
				}
			}
			if (stones[nStone].pLstIndexMap3[nIdx])
			{
				if (stones[nStone].pLstIndexMap4[nIdx] == NULL)
				{
					stones[nStone].pLstIndexMap4[nIdx] = new CList<IdxPart*,IdxPart*>(5);
				} else
				{
					stones[nStone].pLstIndexMap4[nIdx]->RemoveAll();
				}
				for (POSITION pos = stones[nStone].pLstIndexMap3[nIdx]->GetHeadPosition(); pos != NULL; )
				{
					IdxPart* pIdxPart = stones[nStone].pLstIndexMap3[nIdx]->GetNext(pos);
					if (((pField->fieldLow & pIdxPart->nValueLow) == 0) && ((pField->fieldHigh & pIdxPart->nValueHigh) == 0))
					{
						stones[nStone].pLstIndexMap4[nIdx]->AddTail(pIdxPart);
					}
				}
			}

		}
		++nIdx;
	} while (true);

	return true;
}


#define nSplitLevel 3
#define nChangeLevel 9
#define nCheckHoleLevel 5


const int nCheck[] =
{
	 1    ,GetIndex(0,0,0)
	,1<<1 ,GetIndex(1,0,0)
	,1<<2 ,GetIndex(2,0,0)
	,1<<3 ,GetIndex(3,0,0)
	,1<<4 ,GetIndex(4,0,0)
	,1<<5 ,GetIndex(0,1,0)
	,1<<6 ,GetIndex(1,1,0)
	,1<<7 ,GetIndex(2,1,0)
	,1<<8 ,GetIndex(3,1,0)
	,1<<9 ,GetIndex(4,1,0)
	,1<<10,GetIndex(0,2,0)
	,1<<11,GetIndex(1,2,0)
	,1<<12,GetIndex(2,2,0)
	,1<<13,GetIndex(3,2,0)
	,1<<14,GetIndex(4,2,0)
	,1<<15,GetIndex(0,3,0)
	,1<<16,GetIndex(1,3,0)
	,1<<17,GetIndex(2,3,0)
	,1<<18,GetIndex(3,3,0)
	,1<<19,GetIndex(4,3,0)
	,1<<20,GetIndex(0,0,1)
	,1<<21,GetIndex(1,0,1)
	,1<<22,GetIndex(2,0,1)
	,1<<23,GetIndex(3,0,1)
	,1<<24,GetIndex(4,0,1)
	,1<<25,GetIndex(0,1,1)
	,1<<26,GetIndex(1,1,1)
	,1<<27,GetIndex(2,1,1)
	,1<<28,GetIndex(3,1,1)
	,1<<29,GetIndex(4,1,1)
	,1<<30,GetIndex(0,2,1)
	,1<<31,GetIndex(1,2,1)
	,1,	   GetIndex(2,2,1)
	,1<<1, GetIndex(3,2,1)
	,1<<2, GetIndex(4,2,1)
	,1<<3, GetIndex(0,3,1)
	,1<<4, GetIndex(1,3,1)
	,1<<5, GetIndex(2,3,1)
	,1<<6, GetIndex(3,3,1)
	,1<<7, GetIndex(4,3,1)
	,1<<8, GetIndex(0,0,2)
	,1<<9, GetIndex(1,0,2)
	,1<<10,GetIndex(2,0,2)
	,1<<11,GetIndex(3,0,2)
	,1<<12,GetIndex(4,0,2)
	,1<<13,GetIndex(0,1,2)
	,1<<14,GetIndex(1,1,2)
	,1<<15,GetIndex(2,1,2)
	,1<<16,GetIndex(3,1,2)
	,1<<17,GetIndex(4,1,2)
	,1<<18,GetIndex(0,2,2)
	,1<<19,GetIndex(1,2,2)
	,1<<20,GetIndex(2,2,2)
	,1<<21,GetIndex(3,2,2)
	,1<<22,GetIndex(4,2,2)
	,1<<23,GetIndex(0,3,2)
	,1<<24,GetIndex(1,3,2)
	,1<<25,GetIndex(2,3,2)
	,1<<26,GetIndex(3,3,2)
	,1<<27,GetIndex(4,3,2)
};

int GetNextFree(const FIELD* pField)
{
	if (pField->fieldLow != 0xFFFFFFFF)
	{
		if ((pField->fieldLow&0x0000FFFF) != 0x0000FFFF)
		{
			if ((pField->fieldLow&0x000000FF) != 0x000000FF)
			{
				for (int i = 0; i < 8; i++)
				{
					if ((pField->fieldLow & nCheck[i*2]) == 0) return nCheck[i*2+1];
				}
			} else
			{
				for (int i = 8; i < 16; i++)
				{
					if ((pField->fieldLow & nCheck[i*2]) == 0) return nCheck[i*2+1];
				}
			}
		} else
		{
			for (int i = 16; i < 32; i++)
			{
				if ((pField->fieldLow & nCheck[i*2]) == 0) return nCheck[i*2+1];
			}
		}
	} else
	{
		for (int i = 32; i < 60; i++)
		{
			if ((pField->fieldHigh & nCheck[i*2]) == 0) return nCheck[i*2+1];
		}

	}
	return 61;
}


#define SolveName SolveI11
#define nLevel 11
#include "ctpuzzle.inl"

#define SolveName SolveI10
#define SolveNext SolveI11
#define nLevel 10
#include "ctpuzzle.inl"

#define SolveName SolveI09
#define SolveNext SolveI10
#define nLevel 9
#include "ctpuzzle.inl"

#define SolveName SolveI08
#define SolveNext SolveI09
#define nLevel 8
#include "ctpuzzle.inl"

#define SolveName SolveI07
#define SolveNext SolveI08
#define nLevel 7
#include "ctpuzzle.inl"

#define SolveName SolveI06
#define SolveNext SolveI07
#define nLevel 6
#include "ctpuzzle.inl"

#define SolveName SolveI05
#define SolveNext SolveI06
#define nLevel 5
#include "ctpuzzle.inl"

#define SolveName SolveI04
#define SolveNext SolveI05
#define nLevel 4
#include "ctpuzzle.inl"

#define SolveName SolveI03
#define SolveNext SolveI04
#define nLevel 3
#include "ctpuzzle.inl"

#define SolveName SolveI02
#define SolveNext SolveI03
#define nLevel 2
#include "ctpuzzle.inl"

#define SolveName SolveI01
#define SolveNext SolveI02
#define nLevel 1
#include "ctpuzzle.inl"

CList<FIELD*,FIELD*> m_lstFirst;
CList<FIELD*,FIELD*> m_lstSecond;

FIELD tempF[8];

void solve1(FIELD* pField) // zweite schleife. // Verschiebt das zweite element, falls vorher symmetrisch war...
{
	m_lstSecond.RemoveAll();
#ifdef VERBOSE
	m_arrStat[1].nStone = 1;
	int nDone = 0;
#endif
	FIELD* pNewField = &m_Field[1];
	for (POSITION pos = m_lstParts[1].GetHeadPosition(); pos != NULL; )
	{
		PART3d* pPart = m_lstParts[1].GetNext(pos);
		for (int x = 0; x < 5; ++x)
			for (int y = 0; y < 4; ++y)
				for (int z = 0; z < 3; ++z)
				{
					int nIndex = GetIndex(x,y,z);
					if (isValid(pPart,nIndex,pField))
					{
						pNewField->Set(pField);
						setStone(pPart,nIndex,pNewField,2);
						pNewField->setHandled(1);
						bool bSym = false;
						int nCount= 0;
						for (int x1 = 0; x1 < 2; ++x1)
							for (int y1 = 0; y1 < 2; ++y1)
								for (int z1 = 0; z1 < 2; ++z1)
								{
									tempF[nCount].Set(pNewField);
									tempF[nCount].RotateX(x1);
									tempF[nCount].RotateY(y1);
									tempF[nCount].RotateZ(z1);
									++nCount;
								}

						for (POSITION pos2 = m_lstSecond.GetHeadPosition(); pos2 != NULL && !bSym; )
						{
							FIELD* pOther = m_lstSecond.GetNext(pos2);
							for (int i = 0; i < 8; ++i)
							{
								bSym = pOther->isEqual(&tempF[i]);
								if (bSym) break;
							}
						}
						if (!bSym)
						{

#ifdef VERBOSE
							m_arrStat[1].nDone = ++nDone;
#endif
							FIELD* pNewField2 = new FIELD();
							pNewField2->Set(pNewField);
							m_lstSecond.AddTail(pNewField2);
							pNewField->toInt64();
							SolveI02();
						}
					}
				}

	}
}

void solve0(FIELD* pField) // erste schleife. // Verschiebt das erste element
{
#ifdef VERBOSE
	int nDone = 0;
	m_arrStat[0].nStone = 0;
#endif
	FIELD* pNewField = &m_Field[0];
	for (POSITION pos = m_lstParts[0].GetHeadPosition(); pos != NULL; )
	{
		PART3d* pPart = m_lstParts[0].GetNext(pos);
		for (int x = 0; x < 5; ++x)
			for (int y = 0; y < 4; ++y)
				for (int z = 0; z < 3; ++z)
				{
					int nIndex = GetIndex(x,y,z);
					if (isValid(pPart,nIndex,pField))
					{
						pNewField->Set(pField);
						setStone(pPart,nIndex,pNewField,1);
						pNewField->setHandled(0);
						bool bSym = false;
						int nCount= 0;
						for (int x1 = 0; x1 < 2; ++x1)
							for (int y1 = 0; y1 < 2; ++y1)
								for (int z1 = 0; z1 < 2; ++z1)
								{
									tempF[nCount].Set(pNewField);
									tempF[nCount].RotateX(x1);
									tempF[nCount].RotateY(y1);
									tempF[nCount].RotateZ(z1);
									++nCount;
								}

						for (POSITION pos2 = m_lstFirst.GetHeadPosition(); pos2 != NULL && !bSym; )
						{
							FIELD* pOther = m_lstFirst.GetNext(pos2);
							for (int i = 0; i < 8; ++i)
							{
								bSym = pOther->isEqual(&tempF[i]);
								if (bSym) break;
							}
						}
						if (!bSym)
						{
							bool bCheckSym =isSym(pNewField);

							bCheckSym ? printf("CheckSym = true\r\n"):printf("CheckSym = false\r\n");

							
							if (bCheckSym)
							{
								solve1(pNewField);
							} else
							{
								pNewField->toInt64();
								SolveI01();

							}
							float nTicks = GetTickCount()-nStartTicks;
							nTicks /= 1000;
							FIELD* pNewField2 = new FIELD();
							pNewField2->Set(pNewField);
							m_lstFirst.AddTail(pNewField2);

							printf("\r\n%i Loesungen %.2f Loesungen / s\r\n",nSolutions,nSolutions/nTicks);
						}
					}
#ifdef VERBOSE
					m_arrStat[0].nStone = ++nDone;
#endif
				}
	}

}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	{
		nStartTicks = GetTickCount();
		FIELD field;
		printf("Starting...\r\n");
		for (int n = 0; n < 12; ++n) {m_Field[n].Init();}
		InitRotationLists();
		nSolutions = 0;
		field.Init();
		solve0(&field);
		float nTicks = GetTickCount()-nStartTicks;
		nTicks /= 1000;
		printf("\r\n Lsungen : %i %.2f Sekunden %.2f Loesungen/Sek",nSolutions,nTicks,nSolutions/nTicks);
	}

	return nRetCode;
}


