/*
 * ctpuzzle.cpp
 *
 * berechnet die Anzahl verschiedener Loesungen des ct-Puzzles aus Heft 7/2003
 *
 *
 * Autor: Wolfgang Ruelfing
 *        Pfarrer-Strerath-Strasse 7
 *        41470 Neuss
 *        <wolfgang@ruelfing.de>
 *
 *
 *
 *
 */

#include "modul.h"




void Timestamp(FILE* pFile)
{
	time_t tt;
	time(&tt);
	struct tm* pLoctime = localtime(&tt);

	char str[50];
	sprintf(str, "\n--------------------- %02d.%02d.%02d %02d:%02d:%02d\n", pLoctime->tm_mday, pLoctime->tm_mon+1, pLoctime->tm_year-100, pLoctime->tm_hour, pLoctime->tm_min, pLoctime->tm_sec);
	printf(str);
	if (pFile)
		fprintf(pFile, str);
}


int main(int argc, char* argv[])
{

	Timestamp(NULL);

	// definition der puzzleteile:

	// x: rechts
	// y: oben
	// z: nach oben aus zeichenebene heraus

	// flache teile in x-y-ebene
	// -1 -> dummy

	SCube moddef[MODULE_COUNT][MAX_CUBES_PER_MODULE] = 
	{
		{ {1,0,0}, {0,1,0}, {1,1,0}, {2,1,0}, {0,2,0}, {-1,-1,-1} }, 
				// *  
				// ***
				//  * 
				// ein unsymmetrisches teil zuerst -> wg. puzzle-symmetrie nur 6 rotationen

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,2,0}, {1,2,0}, {-1,-1,-1} }, 
				// **
				// *
				// **

		{ {0,0,0}, {1,0,0}, {1,1,0}, {1,2,0}, {2,2,0}, {-1,-1,-1} }, 
				//  **
				//  * 
				// ** 

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,2,0}, {0,3,0}, {-1,-1,-1} }, 
				// *  
				// *  
				// *  
				// ** 

		{ {0,0,0}, {0,1,0}, {0,2,0}, {1,2,0}, {0,3,0}, {-1,-1,-1} }, 
				// *  
				// ** 
				// *  
				// *  

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,0,1}, {0,1,1}, {-1,-1,-1} }, 
				// *	*
				// **	*

		{ {1,0,0}, {1,1,0}, {0,2,0}, {1,2,0}, {2,2,0}, {-1,-1,-1} }, 
				// ***
				//  * 
				//  * 

		{ {0,0,0}, {1,0,0}, {0,1,0}, {1,1,0}, {0,2,0}, {-1,-1,-1} }, 
				// *  
				// ** 
				// ** 

		{ {1,0,0}, {2,0,0}, {0,1,0}, {1,1,0}, {0,2,0}, {-1,-1,-1} }, 
				// *  
				// ** 
				//  **

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,1,1}, {-1,-1,-1}, {-1,-1,-1} }, 
				// *	*
				// **	 

		{ {1,0,0}, {0,1,0}, {1,1,0}, {2,1,0}, {1,2,0}, {-1,-1,-1} }, 
				//  * 
				// ***
				//  * 

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,2,0}, {1,2,0}, {0,3,0} }
				// *  
				// ** 
				// *  
				// ** 
	};

	// alle teile auf stack erzeugen
	Modul mod00(moddef[0], 5);
	Modul mod01(moddef[1], 5);
	Modul mod02(moddef[2], 5);
	Modul mod03(moddef[3], 5);
	Modul mod04(moddef[4], 5);
	Modul mod05(moddef[5], 5);
	Modul mod06(moddef[6], 5);
	Modul mod07(moddef[7], 5);
	Modul mod08(moddef[8], 5);
	Modul mod09(moddef[9], 4);
	Modul mod10(moddef[10], 5);
	Modul mod11(moddef[11], 6);

	// pointerarray fuer einfacheres durchlaufen
	Modul* pModules[MODULE_COUNT];
	pModules[0] = &mod00;
	pModules[1] = &mod01;
	pModules[2] = &mod02;
	pModules[3] = &mod03;
	pModules[4] = &mod04;
	pModules[5] = &mod05;
	pModules[6] = &mod06;
	pModules[7] = &mod07;
	pModules[8] = &mod08;
	pModules[9] = &mod09;
	pModules[10] = &mod10;
	pModules[11] = &mod11;


	// erstmal alle rotationen erzeugen, ohne verschiebung, ohne identpruefung, ohne pass-pruefung

	// wegen quadersymmetrie des puzzles fuer erstes teil nur 6 verschiedene rotationen
	// extra ein voellig unsymmetrisches teil gewaehlt!!!
	pModules[0]->GenerateSymFreeTempRotations();

	// fuer restliche teile alle 24 moeglichen rotationen
	for (int nMod=1 ; nMod < MODULE_COUNT ; ++nMod)
		pModules[nMod]->GenerateAllTempRotations();


	// jetzt nochmal alle puzzleteile durchlaufen
	for (int nMod=0 ; nMod < MODULE_COUNT ; ++nMod)
	{
		printf("\nModul %02d:", nMod);
		printf("\nm_nTempRotationCount      = %4d", pModules[nMod]->m_nTempRotationCount);


		// aus dem array mit ALLEN rotationen nur die in das endgueltige array kopieren, 
		// die eindeutig sind und in den puzzlequader passen.
		// dabei alle in "nullstellung" bringen (puzzleteil erstreckt sich von 0,0,0 in den positiven bereich)
		pModules[nMod]->GenerateAllRotations();
		printf("\nm_nRotationCount          = %4d", pModules[nMod]->m_nRotationCount);


		// fuer jede einzelne rotation: alle moeglichen verschiebungen im quader ermitteln
		// und jede moegliche lage als bitvektor speichern (in array m_PossiblePositionsInPuzzle)
		pModules[nMod]->GenerateAllPositionsInPuzzle();
		printf("\nm_nPossiblePositionsCount = %4d\n", pModules[nMod]->m_nPossiblePositionsCount);

	}
	

	// hier beginnt die eigentliche arbeit:
	// alle kombinationen der verschiedenen teile in ihren moeglichen lagen durchlaufen
	// und auf kollision mit schon angelegten teilen untersuchen
	// hier aus performancegruenden nur noch einfache bitmanipulationen und -vergleiche

	// eleganter (aber nicht schneller) waere das ganze sicherlich mit einer rekursion

	DWORD dwSolutionCounter = 0;
	QWORD angelegteTeile[11];	// hier bitweise die puzzleteile aufsummieren
								// index = stellung nach anlegen von teil i

	for (int n00 = 0 ; n00 < pModules[0]->m_nPossiblePositionsCount ; n00++)
	{
		printf("\n%d/%d", n00+1, pModules[0]->m_nPossiblePositionsCount);
		angelegteTeile[0] = pModules[0]->m_PossiblePositionsInPuzzle[n00];

		for (int n01 = 0 ; n01 < pModules[1]->m_nPossiblePositionsCount ; n01++)
		{
			printf("\n          %d/%d", n01+1, pModules[1]->m_nPossiblePositionsCount);

			// kollisionspruefung mit bisher angelegten teilen
			if (angelegteTeile[0] & pModules[1]->m_PossiblePositionsInPuzzle[n01])
				continue;	// kollision -> naechste lage dieses teils

			// puzzleteil anlegen
			angelegteTeile[1] = angelegteTeile[0] | pModules[1]->m_PossiblePositionsInPuzzle[n01];
			
			for (int n02 = 0 ; n02 < pModules[2]->m_nPossiblePositionsCount ; n02++)
			{
				if (angelegteTeile[1] & pModules[2]->m_PossiblePositionsInPuzzle[n02])
					continue;	// kollision
				angelegteTeile[2] = angelegteTeile[1] | pModules[2]->m_PossiblePositionsInPuzzle[n02];

				for (int n03 = 0 ; n03 < pModules[3]->m_nPossiblePositionsCount ; n03++)
				{
					if (angelegteTeile[2] & pModules[3]->m_PossiblePositionsInPuzzle[n03])
						continue;	// kollision
					angelegteTeile[3] = angelegteTeile[2] | pModules[3]->m_PossiblePositionsInPuzzle[n03];

					for (int n04 = 0 ; n04 < pModules[4]->m_nPossiblePositionsCount ; n04++)
					{
						if (angelegteTeile[3] & pModules[4]->m_PossiblePositionsInPuzzle[n04])
							continue;	// kollision
						angelegteTeile[4] = angelegteTeile[3] | pModules[4]->m_PossiblePositionsInPuzzle[n04];

						for (int n05 = 0 ; n05 < pModules[5]->m_nPossiblePositionsCount ; n05++)
						{
							if (angelegteTeile[4] & pModules[5]->m_PossiblePositionsInPuzzle[n05])
								continue;	// kollision
							angelegteTeile[5] = angelegteTeile[4] | pModules[5]->m_PossiblePositionsInPuzzle[n05];

							for (int n06 = 0 ; n06 < pModules[6]->m_nPossiblePositionsCount ; n06++)
							{
								if (angelegteTeile[5] & pModules[6]->m_PossiblePositionsInPuzzle[n06])
									continue;	// kollision
								angelegteTeile[6] = angelegteTeile[5] | pModules[6]->m_PossiblePositionsInPuzzle[n06];
								
								for (int n07 = 0 ; n07 < pModules[7]->m_nPossiblePositionsCount ; n07++)
								{
									if (angelegteTeile[6] & pModules[7]->m_PossiblePositionsInPuzzle[n07])
										continue;	// kollision
									angelegteTeile[7] = angelegteTeile[6] | pModules[7]->m_PossiblePositionsInPuzzle[n07];
									
									for (int n08 = 0 ; n08 < pModules[8]->m_nPossiblePositionsCount ; n08++)
									{
										if (angelegteTeile[7] & pModules[8]->m_PossiblePositionsInPuzzle[n08])
											continue;	// kollision
										angelegteTeile[8] = angelegteTeile[7] | pModules[8]->m_PossiblePositionsInPuzzle[n08];
										
										for (int n09 = 0 ; n09 < pModules[9]->m_nPossiblePositionsCount ; n09++)
										{
											if (angelegteTeile[8] & pModules[9]->m_PossiblePositionsInPuzzle[n09])
												continue;	// kollision
											angelegteTeile[9] = angelegteTeile[8] | pModules[9]->m_PossiblePositionsInPuzzle[n09];
											
											for (int n10 = 0 ; n10 < pModules[10]->m_nPossiblePositionsCount ; n10++)
											{
												if (angelegteTeile[9] & pModules[10]->m_PossiblePositionsInPuzzle[n10])
													continue;	// kollision
												angelegteTeile[10] = angelegteTeile[9] | pModules[10]->m_PossiblePositionsInPuzzle[n10];
												
												for (int n11 = 0 ; n11 < pModules[11]->m_nPossiblePositionsCount ; n11++)
												{
													if (!(angelegteTeile[10] & pModules[11]->m_PossiblePositionsInPuzzle[n11]))
													{
														// immer noch keine kollision -> puzzle geloest
														dwSolutionCounter++;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}


	printf("\n\nAnzahl Loesungen = %ld\n", dwSolutionCounter);


	return 0;
}


