/*
 * modul.h
 *
 * zu ctpuzzle
 *
 * Autor: Wolfgang Ruelfing
 *        Pfarrer-Strerath-Strasse 7
 *        41470 Neuss
 *        <wolfgang@ruelfing.de>
 *
 *
 *
 *
 */


#ifndef _MODUL_H_
#define _MODUL_H_

#include <stdio.h>
#include <string.h>
#include <time.h>


// puzzle-abmessungen (alles multipliziert hoechstens 64!!! wg. int64 als bitvektor)
#define PUZZLELENGTH_0 (5)
#define PUZZLELENGTH_1 (4)
#define PUZZLELENGTH_2 (3)

#define DIM (3)

// anzahl moeglicher rotationen, nur fuer DIM=2 oder DIM=3!!!
#define ALL_ROTATION_COUNT (20*DIM-36)
#define SYMFREE_ROTATION_COUNT (4*DIM-6)

#define MAX_CUBES_PER_MODULE (6)
#define MODULE_COUNT (12)

#define MAX_POSSIBLE_POSITIONS_COUNT (ALL_ROTATION_COUNT * PUZZLELENGTH_0 * PUZZLELENGTH_1 * PUZZLELENGTH_2)
// eines moduls im puzzle


typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;
typedef unsigned __int64 QWORD;

// einzelwuerfel
typedef struct _SCube
{
	char comp[DIM];
} SCube;


// Bitvektorberechnungen
BYTE Cube2BitNo(const SCube* pCube);						// einzelwuerfel -> BitNo
QWORD Modul2BitVector(const SCube* pCubes, int nCubeCount);	// ganzes puzzleteil -> BitVector
// alles zusaetzlich mit verschiebung um vector
BYTE TranslatedCube2BitNo(const SCube* pCube, char* pVector);	// cube = einzelwuerfel VOR verschiebung
QWORD TranslatedModul2BitVector(const SCube* pCubes, int nCubeCount, char* pVector);	// cubes = wuerfelarray VOR verschiebung

// rotationen eines einzelwuerfels um eine Koordinatenachse, bei dim=2: drehung um ursprung
void RotateCube90(const SCube* pCubeIn, SCube* pCubeOut, BYTE nAxis);	// 90-grad-rotation, nAxis = 0,1,2
void RotateCube(const SCube* pCubeIn, SCube* pCubeOut, BYTE nAxis, BYTE nCount);	// nCount rotationen um jeweils 90 Grad


class Modul
{

public:
	BYTE m_nCubeCount;
	SCube* m_pCubes;

	// arrays mit rotationen
	SCube m_TempRotations[ALL_ROTATION_COUNT][MAX_CUBES_PER_MODULE];	// ALLE rotationen inkl. symmetrischen, auch wenn teil so nicht in puzzle passt
	SCube m_Rotations[ALL_ROTATION_COUNT][MAX_CUBES_PER_MODULE];		// nur eindeutige varianten, nur wenn sie in quader passen, alle in nullstellung
	BYTE m_nTempRotationCount;
	BYTE m_nRotationCount;

	QWORD m_PossiblePositionsInPuzzle[MAX_POSSIBLE_POSITIONS_COUNT];	// alle moeglichen lagen des teils im quader
	WORD m_nPossiblePositionsCount;
	

	Modul(SCube* pCubes, BYTE nCubeCount)
	: m_nCubeCount(nCubeCount)
	, m_pCubes(pCubes)
	, m_nRotationCount(0)
	, m_nTempRotationCount(0)
	, m_nPossiblePositionsCount(0)
	{
	}

	
	void GenerateTempRotation(BYTE nRotIn, BYTE nRotOut, BYTE nAxis, BYTE nCount);	// um nAxis (0,1,2), nCount * 90 Grad

	void GenerateSymFreeTempRotations();	// pro koordinatenebene nur 2 lagen wg. quadersymmetrie des puzzles
	void GenerateAllTempRotations();	// erstmal alle, egal ob identisch, oder nicht passend

	void GenerateAllRotations();	// nur die, die nicht identisch

	void GenerateAllPositionsInPuzzle();
};

#endif // _MODUL_H_
