/*
 * ctpuzzle.cpp
 *
 * berechnet die Anzahl verschiedener Loesungen des ct-Puzzles aus Heft 7/2003
 *
 *
 * Autor: Wolfgang Ruelfing
 *        Pfarrer-Strerath-Strasse 7
 *        41470 Neuss
 *        <wolfgang@ruelfing.de>
 *
 *
 *
 *
 */




#include "modul.h"


QWORD g_aBelegung[MODULE_COUNT];
DWORD g_dwSolutionCounter;
FILE* g_pFile;
Modul* g_pModules[MODULE_COUNT];
int g_anPosition[MODULE_COUNT];	// damit loesung angzigt werden kann


void PrintBelegung(const QWORD* pLage)
{
	BYTE halfbyte[16];
	char bin[16][5];
	for (int i=0 ; i<16 ; ++i)
	{
		halfbyte[i] = (BYTE)((*pLage & ((QWORD)0xF << (BYTE)(4*i))) >> (BYTE)(4*i));
		switch (halfbyte[i])
		{
			// !!! von links nach rechts !!!
			case 0x00: strcpy(bin[i], "----"); break;
			case 0x01: strcpy(bin[i], "*---"); break;
			case 0x02: strcpy(bin[i], "-*--"); break;
			case 0x03: strcpy(bin[i], "**--"); break;
			case 0x04: strcpy(bin[i], "--*-"); break;
			case 0x05: strcpy(bin[i], "*-*-"); break;
			case 0x06: strcpy(bin[i], "-**-"); break;
			case 0x07: strcpy(bin[i], "***-"); break;
			case 0x08: strcpy(bin[i], "---*"); break;
			case 0x09: strcpy(bin[i], "*--*"); break;
			case 0x0A: strcpy(bin[i], "-*-*"); break;
			case 0x0B: strcpy(bin[i], "**-*"); break;
			case 0x0C: strcpy(bin[i], "--**"); break;
			case 0x0D: strcpy(bin[i], "*-**"); break;
			case 0x0E: strcpy(bin[i], "-***"); break;
			case 0x0F: strcpy(bin[i], "****"); break;
			default: strcpy(bin[i], "!!!!");
		}
	}
	
	fprintf(g_pFile, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s", bin[0], bin[1], bin[2], bin[3], bin[4], bin[5], bin[6], bin[7], bin[8], bin[9], bin[10], bin[11], bin[12], bin[13], bin[14], bin[15]);
}

void Timestamp()
{
	time_t tt;
	time(&tt);
	struct tm* pLoctime = localtime(&tt);

	char str[50];
	sprintf(str, "\n--------------------- %02d.%02d.%02d %02d:%02d:%02d\n", pLoctime->tm_mday, pLoctime->tm_mon+1, pLoctime->tm_year-100, pLoctime->tm_hour, pLoctime->tm_min, pLoctime->tm_sec);
	printf(str);
	if (g_pFile)
		fprintf(g_pFile, str);
}

void TeileMontieren(int nModuleIndex)
{
	int nOldModuleIndex = nModuleIndex + 1;
	Modul* pModule = g_pModules[nModuleIndex];
	int* pPosIndex = &g_anPosition[nModuleIndex];
	int* pCount = &pModule->m_nPossiblePositionsCount;
	QWORD* pNeueBelegung = &g_aBelegung[nModuleIndex];
	QWORD* pAlteBelegung = &g_aBelegung[nOldModuleIndex];
	QWORD* pPossiblePositions = pModule->m_PossiblePositionsInPuzzle;

	if (nModuleIndex)	// noch nicht letztes teil
	{
		int nNextModuleIndex = nModuleIndex - 1;

		for (*pPosIndex = *pCount - 1 ; *pPosIndex >= 0 ; --(*pPosIndex))
		{
			QWORD* pPosition = &pPossiblePositions[*pPosIndex];
			if (!(*pAlteBelegung & *pPosition))					// pruefen auf kollision
			{
				*pNeueBelegung = *pAlteBelegung | *pPosition;	// keine kollision -> anlegen
				TeileMontieren(nNextModuleIndex);				// weiter mit naechstem teil
			}
		}
	}
	else	// letztes teil
	{
		for (*pPosIndex = *pCount - 1 ; *pPosIndex >= 0 ; --(*pPosIndex))
		{
			if (!(*pAlteBelegung & pPossiblePositions[*pPosIndex]))
			{
				// immer noch keine kollision -> puzzle geloest
				g_dwSolutionCounter++;
				printf
				(
					"%6ld --- %03d/%03d --- %03d/%03d\n", 
					g_dwSolutionCounter,
					1 + g_anPosition[MODULE_COUNT-1],
					g_pModules[MODULE_COUNT-1]->m_nPossiblePositionsCount,
					1 + g_anPosition[MODULE_COUNT-2],
					g_pModules[MODULE_COUNT-2]->m_nPossiblePositionsCount
				);

#ifdef _DEBUG
				fprintf(g_pFile, "\n\n*** Loesung %ld: ***\n", g_dwSolutionCounter);
				for (int mod=0 ; mod < MODULE_COUNT ; ++mod)
				{
					fprintf(g_pFile, "\nTeil %02d:", mod);
					PrintBelegung(&g_pModules[mod]->m_PossiblePositionsInPuzzle[g_anPosition[mod]]);
				}
				fflush(g_pFile);
#endif
			}
		}
	}
}


int main(int argc, char* argv[])
{
#ifdef _DEBUG
	g_pFile = fopen("ctpuzzle.txt", "wt+");
	if (!g_pFile)
	{
		printf("FILE ERROR!\n");
		return 0;
	}
#endif	

	Timestamp();


	// definition der puzzleteile:

	// x: rechts
	// y: oben
	// z: nach oben aus zeichenebene heraus

	// flache teile in x-y-ebene
	// -1 -> dummy


	SCube moddef[MODULE_COUNT][MAX_CUBES_PER_MODULE] = 
	{
		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,0,1}, {0,1,1}, {-1,-1,-1} }, 
				// *	*
				// **	*

		{ {0,0,0}, {1,0,0}, {0,1,0}, {1,1,0}, {0,2,0}, {-1,-1,-1} },
				// *  
				// ** 
				// ** 

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,1,1}, {-1,-1,-1}, {-1,-1,-1} }, 
				// *	*
				// **	 

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,2,0}, {1,2,0}, {-1,-1,-1} }, 
				// **
				// *
				// **

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,2,0}, {1,2,0}, {0,3,0} },
				// *  
				// ** 
				// *  
				// ** 

		{ {0,0,0}, {0,1,0}, {0,2,0}, {1,2,0}, {0,3,0}, {-1,-1,-1} }, 
				// *  
				// ** 
				// *  
				// *  

		{ {0,0,0}, {1,0,0}, {0,1,0}, {0,2,0}, {0,3,0}, {-1,-1,-1} }, 
				// *  
				// *  
				// *  
				// ** 

		{ {1,0,0}, {2,0,0}, {0,1,0}, {1,1,0}, {0,2,0}, {-1,-1,-1} }, 
				// *  
				// ** 
				//  **

		{ {1,0,0}, {1,1,0}, {0,2,0}, {1,2,0}, {2,2,0}, {-1,-1,-1} }, 
				// ***
				//  * 
				//  * 

		{ {0,0,0}, {1,0,0}, {1,1,0}, {1,2,0}, {2,2,0}, {-1,-1,-1} }, 
				//  **
				//  * 
				// ** 

		{ {1,0,0}, {0,1,0}, {1,1,0}, {2,1,0}, {1,2,0}, {-1,-1,-1} }, 
				//  * 
				// ***
				//  * 

		{ {1,0,0}, {0,1,0}, {1,1,0}, {2,1,0}, {0,2,0}, {-1,-1,-1} }
				// *  
				// ***
				//  * 

				// als erstes ein unsymmetrisches teil -> wg. puzzle-symmetrie nur 6 rotationen
				// teile rueckwaerts durchlaufen
				// reihenfolge der anderen 11 teile: die mit den wenigsten moeglichen lagen zuerst anlegen (hinten im array)

	};

	// alle teile auf stack erzeugen
	Modul mod00(moddef[0], 5);
	Modul mod01(moddef[1], 5);
	Modul mod02(moddef[2], 4);
	Modul mod03(moddef[3], 5);
	Modul mod04(moddef[4], 6);
	Modul mod05(moddef[5], 5);
	Modul mod06(moddef[6], 5);
	Modul mod07(moddef[7], 5);
	Modul mod08(moddef[8], 5);
	Modul mod09(moddef[9], 5);
	Modul mod10(moddef[10], 5);
	Modul mod11(moddef[11], 5);

	// pointerarray fuer einfacheres durchlaufen
	g_pModules[0] = &mod00;
	g_pModules[1] = &mod01;
	g_pModules[2] = &mod02;
	g_pModules[3] = &mod03;
	g_pModules[4] = &mod04;
	g_pModules[5] = &mod05;
	g_pModules[6] = &mod06;
	g_pModules[7] = &mod07;
	g_pModules[8] = &mod08;
	g_pModules[9] = &mod09;
	g_pModules[10] = &mod10;
	g_pModules[11] = &mod11;


	// erstmal alle rotationen erzeugen, ohne verschiebung, ohne identpruefung, ohne pass-pruefung

	// wegen quadersymmetrie des puzzles fuer erstes teil nur 6 verschiedene rotationen
	// extra ein voellig unsymmetrisches teil gewaehlt!!!
	g_pModules[MODULE_COUNT-1]->GenerateSymFreeTempRotations();

	// fuer restliche teile alle 24 moeglichen rotationen
	for (int nMod=0 ; nMod < MODULE_COUNT-1 ; ++nMod)
		g_pModules[nMod]->GenerateAllTempRotations();


	// jetzt nochmal alle puzzleteile durchlaufen
	for (int nMod=0 ; nMod < MODULE_COUNT ; ++nMod)
	{
		printf("\nModul %02d:", nMod);
		printf("\nm_nTempRotationCount      = %4d", g_pModules[nMod]->m_nTempRotationCount);

		// aus dem array mit ALLEN rotationen nur die in das endgueltige array kopieren, 
		// die eindeutig sind und in den puzzlequader passen.
		// dabei alle in "nullstellung" bringen (puzzleteil erstreckt sich von 0,0,0 in den positiven bereich)
		g_pModules[nMod]->GenerateAllRotations();
		printf("\nm_nRotationCount          = %4d", g_pModules[nMod]->m_nRotationCount);

		// fuer jede einzelne rotation: alle moeglichen verschiebungen im quader ermitteln
		// und jede moegliche lage als bitvektor speichern (in array m_PossiblePositionsInPuzzle)
		g_pModules[nMod]->GenerateAllPositionsInPuzzle();
		printf("\nm_nPossiblePositionsCount = %4d\n", g_pModules[nMod]->m_nPossiblePositionsCount);
	}


	// hier beginnt die eigentliche arbeit:
	// alle kombinationen der verschiedenen teile in ihren moeglichen lagen durchlaufen
	// und auf kollision mit schon angelegten teilen untersuchen
	// hier aus performancegruenden nur noch einfache bitmanipulationen und -vergleiche

	int nModulIndex = MODULE_COUNT-1;
	Modul* pModule = g_pModules[nModulIndex];
	int* pPosIndex = &g_anPosition[nModulIndex];
	int* pCount = &pModule->m_nPossiblePositionsCount;
	QWORD* pBelegung = &g_aBelegung[nModulIndex];
	QWORD* pPossiblePositions = pModule->m_PossiblePositionsInPuzzle;

	*pBelegung = 0;

	for (*pPosIndex = *pCount - 1 ; *pPosIndex >= 0 ; --(*pPosIndex))
	{
		printf("\n---------- %03d/%03d -----------\n", *pPosIndex + 1, *pCount);
		*pBelegung = pPossiblePositions[*pPosIndex];	// teil anlegen ohne pruefung weil erstes
		TeileMontieren(MODULE_COUNT-2);
	}

	printf("\n\nAnzahl Loesungen = %ld\n", g_dwSolutionCounter);

	Timestamp();

	if (g_pFile)
		fclose(g_pFile);

	return 0;
}



