VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "PuzzleToGraph"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Member0" ,"Vertex"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Type Vector
    x As Integer
    y As Integer
    z As Integer
End Type

Public Sub AddPart(MaxTurns As Integer, JustOdds As Boolean, ParamArray Cubes())
    
    Dim Cube As Variant, Bit As Integer
    Dim MaxX As Integer, MaxY As Integer, MaxZ As Integer
    Dim i As Integer, j As Integer, k As Integer
    Dim NumVectors As Integer
    Dim Vectors(1 To 6) As Vector, Delta As Vector

    NumPartitions = NumPartitions + 1
    Partitions(NumPartitions, 1) = NumVertices + 1

    ' Fr jeden Cube einen Vector erzeugen
    For Each Cube In Cubes
        NumVectors = NumVectors + 1
        With Vectors(NumVectors)
            .z = CInt(Cube)
            .x = .z Mod 5:  .z = .z \ 5
            .y = .z Mod 4:  .z = .z \ 4
            If .x > MaxX Then MaxX = .x
            If .y > MaxY Then MaxY = .y
            If .z > MaxZ Then MaxZ = .z
        End With
    Next Cube
    ' Alle Rotationen des Puzzleteils erzeugen
    For i = 1 To MaxTurns   ' Drehungen um 180 Grad
        For j = 1 To 6      ' Abwechselndes Drehen um die x- und y-Achse
            If Not JustOdds Or Odd(j) Then  ' Alle Verschiebungen generieren
                With Delta
                    For .z = 0 To 2 - MaxZ
                        For .y = 0 To 3 - MaxY
                            For .x = 0 To 4 - MaxX
                                NumVertices = NumVertices + 1
                                For k = 1 To NumVectors
                                    With Vectors(k)
                                        Bit = .x + Delta.x + 5 * (.y + Delta.y + 4 * (.z + Delta.z))
                                        Vertices(NumVertices, Bit \ 32) = Vertices(NumVertices, Bit \ 32) Or Bits(Bit And 31)
                                    End With
                                Next k
                            Next .x
                        Next .y
                    Next .z
                End With
            End If
            If Odd(j) Then  ' Drehung um die x-Achse
                Swap MaxY, MaxZ
                For k = 1 To NumVectors
                    With Vectors(k)
                        Swap .y, .z
                        .z = MaxZ - .z
                    End With
                Next k
            Else            ' Drehung um die y-Achse
                Swap MaxX, MaxZ
                For k = 1 To NumVectors
                    With Vectors(k)
                        Swap .x, .z
                        .x = MaxX - .x
                    End With
                Next k
            End If
        Next j
        If Odd(i) Then      ' 180 Grad-Drehung um die x-Achse
            For k = 1 To NumVectors
                With Vectors(k)
                    .y = MaxY - .y
                    .z = MaxZ - .z
                End With
            Next k
        Else                ' 180 Grad-Drehung um die y-Achse
            For k = 1 To NumVectors
                With Vectors(k)
                    .x = MaxX - .x
                    .y = MaxY - .y
                End With
            Next k
        End If
    Next i
    Partitions(NumPartitions, 2) = NumVertices
End Sub

Public Sub InitNeighbourhood()
    Dim p As Integer, v As Integer
    Dim q As Integer, w As Integer
    For p = 1 To NumPartitions - 1  ' Partition (Puzzleteil) auswhlen
        For v = Partitions(p, 1) To Partitions(p, 2)    ' alle Ecken dieser Partition
            For q = p + 1 To NumPartitions  ' andere Partition auswhlen
                For w = Partitions(q, 1) To Partitions(q, 2)    ' alle Ecken
                    If ((Vertices(v, 0) And Vertices(w, 0)) = 0) And _
                        ((Vertices(v, 1) And Vertices(w, 1)) = 0) Then  ' Teile disjunkt
                        NumNeighbours(v) = NumNeighbours(v) + 1 ' v hat neuen Nachbarn
                        Neighbours(v, NumNeighbours(v)) = w     ' ... nmlich w.
                    End If
                Next w
            Next q
        Next v
    Next p
End Sub

Private Sub Swap(ByRef a As Integer, ByRef b As Integer)
    a = a Xor b:    b = b Xor a:    a = a Xor b
End Sub

Private Function Odd(Zahl As Integer) As Boolean
    Odd = ((Zahl And 1) = 1)
End Function
