Attribute VB_Name = "Code"
Option Explicit
Option Base 1

Public StartTime As Date
Public EndTime As Date
Public NumSolutions As Long

Public P2G As PuzzleToGraph
Public Bits(0 To 31) As Long
Public Vertices(2700, 0 To 1) As Long
Public PartNames(12) As String
Public Partitions(12, 2) As Integer
Public Neighbours(2700, 2700) As Integer
Public NumVertices As Integer
Public NumPartitions As Integer
Public NumNeighbours(2700) As Integer

Private Type VertexList
    v(2700) As Integer
    Count As Integer
End Type

Public Sub InitBits()
    Dim i As Integer, DWord As Long
    DWord = &H80000000
    Bits(31) = DWord
    For i = 30 To 0 Step -1
        DWord = DWord \ 2
        Bits(i) = -DWord
    Next i
End Sub

Public Sub Main()
    StartTime = Now
    InitBits
    Set P2G = New PuzzleToGraph
    With P2G
        .AddPart 2, False, 0, 1, 2, 20, 22  ' c
        .AddPart 4, False, 1, 5, 6, 7, 10   ' ff
        .AddPart 4, False, 0, 1, 2, 3, 6, 8 ' t
        .AddPart 2, False, 0, 1, 2, 21, 41  ' t2
        .AddPart 2, False, 0, 1, 6, 11, 12  ' z
        .AddPart 4, False, 0, 1, 2, 5, 6    ' p
        ' Fr 'q' ist MaxTurns=1, um symmetrische Lsungen auszuschlieen
        .AddPart 1, False, 0, 1, 5, 20, 25  ' q
        .AddPart 1, True, 1, 5, 6, 7, 11    ' plus
        .AddPart 4, True, 0, 1, 5, 25       ' qq
        .AddPart 4, False, 0, 1, 2, 3, 5    ' l
        .AddPart 4, True, 0, 1, 21, 22, 42  ' w
        .AddPart 4, False, 0, 1, 2, 3, 6    ' f
        
        .InitNeighbourhood

    End With
    Set P2G = Nothing   'Initialisierung beendet
    EndTime = Now
    MaxClique
    MsgBox "Anzahl der Lsungen: " & NumSolutions & vbCrLf & _
        "Zeit:" & Format$(EndTime - StartTime, "hh:nn:ss"), vbInformation
End Sub

Public Sub MaxClique()

    Dim v As Integer, n As Integer
    Dim R As VertexList
    For v = Partitions(1, 1) To Partitions(1, 2)
        With R  ' Menge der mglichen Nachbarn
            .Count = NumNeighbours(v)
            For n = 1 To .Count
                .v(n) = Neighbours(v, n)
            Next n
        End With
        MaxCliqueSub Part:=2, Rest:=R
    Next v
End Sub

Private Sub MaxCliqueSub(Part As Integer, Rest As VertexList)

    Dim p As Integer, n As Integer
    Dim i As Integer, j As Integer
    Dim R As VertexList

    ' Abbruchbedingung: Gibt es eine Partition, die keine Ecke aus 'Rest' enthlt?
    n = 1
    With Rest
        For p = Part To NumPartitions
            If n <= .Count Then
                If .v(n) <= Partitions(p, 2) Then
                    While n <= .Count And .v(n) <= Partitions(p, 2)
                        n = n + 1
                    Wend
                Else
                    Exit Sub
                End If
            Else
                Exit Sub
            End If
        Next p
        'Alle Ecken v aus dem Schnitt von Rest mit Partition Part durchlaufen
        n = 1
        While .v(n) <= Partitions(Part, 2)
            'Schnittmenge vom Rest mit den Nachbarn von v(n) in R speichern
            i = 1: j = 1: R.Count = 0
            While i <= .Count And j <= NumNeighbours(.v(n))
                Select Case Neighbours(.v(n), j)
                    Case Is < .v(i): j = j + 1
                    Case Is > .v(i): i = i + 1
                    Case Else
                        R.Count = R.Count + 1
                        R.v(R.Count) = .v(i)
                        i = i + 1: j = j + 1
                End Select
            Wend
            If Part = NumPartitions - 1 And R.Count = 1 Then
                ' Lsung gefunden
                NumSolutions = NumSolutions + 1
            Else
                ' Prozedur rekursiv ausfhren
                MaxCliqueSub Part:=Part + 1, Rest:=R
            End If
            n = n + 1
        Wend
    End With
End Sub

