
#include <iostream>
#include <iomanip>
using namespace std;

//////////////////////////////////////////////////////////////
template<int x, int y, int z>
struct Valid{
	enum {
		yes = x>=0 && x<4 && y>=0 && y<2 && z>=0 && z<3
	};
};

//////////////////////////////////////////////////////////////
// return offset to shift to origin
template<int a1, int a2, int a3, int a4>
struct ShiftToOrigin{
	enum {
		z1 = a1 < a2 ? a1 : a2,
		z2 = z1 < a3 ? z1 : a3,
		z3 = z2 < a4 ? z2 : a4,
		get = z3 < 0 ? -z3 : z3
	};
};

//////////////////////////////////////////////////////////////
template<
	int Posx1, int Posy1, int Posz1,
	int Posx2, int Posy2, int Posz2,
	int Posx3, int Posy3, int Posz3,
	int Posx4, int Posy4, int Posz4,
	int sx,    int sy,    int sz
>
struct ShiftedPiece
{
	enum {
		x1 = Posx1 + sx,
		x2 = Posx2 + sx,
		x3 = Posx3 + sx,
		x4 = Posx4 + sx,
		y1 = Posy1 + sy,
		y2 = Posy2 + sy,
		y3 = Posy3 + sy,
		y4 = Posy4 + sy,
		z1 = Posz1 + sz,
		z2 = Posz2 + sz,
		z3 = Posz3 + sz,
		z4 = Posz4 + sz,
		isValid = (
			   Valid<x1, y1, z1>::yes 
			&& Valid<x2, y2, z2>::yes
			&& Valid<x3, y3, z3>::yes
			&& Valid<x4, y4, z4>::yes
		),
		id = (
			  ((unsigned long)1)<< (x1 + z1*4 + y1*12)
			| ((unsigned long)1)<< (x2 + z2*4 + y2*12)
			| ((unsigned long)1)<< (x3 + z3*4 + y3*12)
			| ((unsigned long)1)<< (x4 + z4*4 + y4*12)
		),
	};
};

//////////////////////////////////////////////////////////////
// es gibt 24 verschiedene orientierungen
template<int rx, int ry, int rz, int rotationNr> struct Rotation;
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  0> { enum {x=  rx, y=  ry, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 19> { enum {x=  rx, y= -ry, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  2> { enum {x= -rx, y=  ry, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 17> { enum {x= -rx, y= -ry, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 22> { enum {x= -rx, y= -rz, z= -ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  5> { enum {x= -rx, y=  rz, z=  ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  7> { enum {x=  rx, y= -rz, z=  ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 20> { enum {x=  rx, y=  rz, z= -ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 14> { enum {x= -ry, y= -rx, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 12> { enum {x= -ry, y=  rx, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  9> { enum {x=  ry, y= -rx, z=  rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 11> { enum {x=  ry, y=  rx, z= -rz }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 18> { enum {x= -rz, y= -ry, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  3> { enum {x= -rz, y=  ry, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 16> { enum {x=  rz, y= -ry, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  1> { enum {x=  rz, y=  ry, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  8> { enum {x=  ry, y=  rz, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 10> { enum {x=  ry, y= -rz, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 13> { enum {x= -ry, y=  rz, z= -rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 15> { enum {x= -ry, y= -rz, z=  rx }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  4> { enum {x=  rz, y=  rx, z=  ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 21> { enum {x=  rz, y= -rx, z= -ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz, 23> { enum {x= -rz, y=  rx, z= -ry }; };
template<int rx, int ry, int rz> struct Rotation<rx, ry, rz,  6> { enum {x= -rz, y= -rx, z=  ry }; };



//////////////////////////////////////////////////////////////
template<
	int Posx1, int Posy1, int Posz1,
	int Posx2, int Posy2, int Posz2,
	int Posx3, int Posy3, int Posz3,
	int Posx4, int Posy4, int Posz4,
	int rotationNr
>
struct Rotate
{
	enum
	{
		zx1 = Rotation<Posx1, Posy1, Posz1, rotationNr>::x,
		zy1 = Rotation<Posx1, Posy1, Posz1, rotationNr>::y,
		zz1 = Rotation<Posx1, Posy1, Posz1, rotationNr>::z,
		zx2 = Rotation<Posx2, Posy2, Posz2, rotationNr>::x,
		zy2 = Rotation<Posx2, Posy2, Posz2, rotationNr>::y,
		zz2 = Rotation<Posx2, Posy2, Posz2, rotationNr>::z,
		zx3 = Rotation<Posx3, Posy3, Posz3, rotationNr>::x,
		zy3 = Rotation<Posx3, Posy3, Posz3, rotationNr>::y,
		zz3 = Rotation<Posx3, Posy3, Posz3, rotationNr>::z,
		zx4 = Rotation<Posx4, Posy4, Posz4, rotationNr>::x,
		zy4 = Rotation<Posx4, Posy4, Posz4, rotationNr>::y,
		zz4 = Rotation<Posx4, Posy4, Posz4, rotationNr>::z,
		sx = ShiftToOrigin<zx1, zx2, zx3, zx4>::get,
		sy = ShiftToOrigin<zy1, zy2, zy3, zy4>::get,
		sz = ShiftToOrigin<zz1, zz2, zz3, zz4>::get,
		x1 = zx1 + sx,
		x2 = zx2 + sx,
		x3 = zx3 + sx,
		x4 = zx4 + sx,
		y1 = zy1 + sy,
		y2 = zy2 + sy,
		y3 = zy3 + sy,
		y4 = zy4 + sy,
		z1 = zz1 + sz,
		z2 = zz2 + sz,
		z3 = zz3 + sz,
		z4 = zz4 + sz,
		id = (
			  ((unsigned long)1)<< (x1 + z1*4 + y1*12)
			| ((unsigned long)1)<< (x2 + z2*4 + y2*12)
			| ((unsigned long)1)<< (x3 + z3*4 + y3*12)
			| ((unsigned long)1)<< (x4 + z4*4 + y4*12)
		),
	};
};


//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int rotationNr,
	int otherRotation
>
struct RedundantHelper
{
		//////////////////////////////////////////////////////////////
		template<
			int x1, int y1, int z1,
			int x2, int y2, int z2,
			int x3, int y3, int z3,
			int x4, int y4, int z4,
			int rotationNr,
			int otherRotation,
			bool yes
		>
		struct RedundantHelper2;

		//////////////////////////////////////////////////////////////
		template<
			int x1, int y1, int z1,
			int x2, int y2, int z2,
			int x3, int y3, int z3,
			int x4, int y4, int z4,
			int rotationNr,
			int otherRotation
		>
		struct RedundantHelper2<
			x1, y1, z1,
			x2, y2, z2,
			x3, y3, z3,
			x4, y4, z4,
			rotationNr,
			otherRotation,
			true
		>
		{
			enum
			{
				with = otherRotation
			};
		};

		//////////////////////////////////////////////////////////////
		template<
			int x1, int y1, int z1,
			int x2, int y2, int z2,
			int x3, int y3, int z3,
			int x4, int y4, int z4,
			int rotationNr,
			int otherRotation
		>
		struct RedundantHelper2<
			x1, y1, z1,
			x2, y2, z2,
			x3, y3, z3,
			x4, y4, z4,
			rotationNr,
			otherRotation,
			false
		>
		{
			enum
			{
				with = RedundantHelper<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, rotationNr, otherRotation-1>::with
			};
		};

	enum
	{
		with = RedundantHelper2
		<
			x1, y1, z1,
			x2, y2, z2,
			x3, y3, z3,
			x4, y4, z4,
			rotationNr,
			otherRotation,
			(	(Rotate<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, rotationNr>::id ==
				Rotate<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, otherRotation>::id )
			)
		>::with
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int rotationNr
>
struct RedundantHelper<
	x1, y1, z1,
	x2, y2, z2,
	x3, y3, z3,
	x4, y4, z4,
	rotationNr,
	-1
>
{
	enum
	{
		with = -1
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int rotationNr
>
struct Redundant
{
	enum
	{
		//==-1 if not redundant
		with = RedundantHelper<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, rotationNr, rotationNr-1>::with
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4
>
struct Redundant<
	x1, y1, z1,
	x2, y2, z2,
	x3, y3, z3,
	x4, y4, z4,
	0
>
{
	enum
	{
		with = -1
	};
};

//////////////////////////////////////////////////////////////
template<
	int Posx1, int Posy1, int Posz1,
	int Posx2, int Posy2, int Posz2,
	int Posx3, int Posy3, int Posz3,
	int Posx4, int Posy4, int Posz4,
	int rotationNr
>
struct RotatedPiece
{
	enum
	{
		x1 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::x1,
		x2 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::x2,
		x3 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::x3,
		x4 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::x4,
		y1 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::y1,
		y2 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::y2,
		y3 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::y3,
		y4 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::y4,
		z1 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::z1,
		z2 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::z2,
		z3 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::z3,
		z4 = Rotate<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::z4,
		redundantWith = Redundant<Posx1, Posy1, Posz1, Posx2, Posy2, Posz2, Posx3, Posy3, Posz3, Posx4, Posy4, Posz4, rotationNr>::with

	};

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 0, 0, 0> s00;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 1, 0, 0> s01;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 2, 0, 0> s02;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 3, 0, 0> s03;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 0, 0, 1> s04;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 1, 0, 1> s05;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 2, 0, 1> s06;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 3, 0, 1> s07;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 0, 0, 2> s08;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 1, 0, 2> s09;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 2, 0, 2> s10;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 3, 0, 2> s11;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 0, 1, 0> s12;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 1, 1, 0> s13;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 2, 1, 0> s14;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 3, 1, 0> s15;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 0, 1, 1> s16;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 1, 1, 1> s17;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 2, 1, 1> s18;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 3, 1, 1> s19;

	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 0, 1, 2> s20;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 1, 1, 2> s21;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 2, 1, 2> s22;
	typedef ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 3, 1, 2> s23;

};



//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4
>
struct Piece
{
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  0> r00;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  1> r01;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  2> r02;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  3> r03;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  4> r04;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  5> r05;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  6> r06;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  7> r07;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  8> r08;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4,  9> r09;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 10> r10;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 11> r11;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 12> r12;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 13> r13;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 14> r14;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 15> r15;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 16> r16;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 17> r17;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 18> r18;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 19> r19;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 20> r20;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 21> r21;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 22> r22;
	typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, 23> r23;
};

//////////////////////////////////////////////////////////////
template<
	class P1,
	class P2,
	class P3,
	class P4,
	class P5,
	class P6,
	unsigned long cube=0,
	bool valid=true
>
struct Puzzle;

//////////////////////////////////////////////////////////////
template<
	class P1,
	class P2,
	class P3,
	class P4,
	class P5,
	class P6,
	unsigned long cube
>
struct Puzzle<P1,P2,P3,P4,P5,P6,cube,false>
{
	enum
	{
		solutions = 0
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	int sx, int sy, int sz,
	class SP2,
	class SP3,
	class SP4,
	class SP5,
	class SP6,
	unsigned long cube
>
struct Puzzle<ShiftedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, sx, sy, sz>,SP2,SP3,SP4,SP5,SP6,cube,true>
{
	enum
	{
		solutions = 1
	};
};

//////////////////////////////////////////////////////////////
template<
	int x1, int y1, int z1,
	int x2, int y2, int z2,
	int x3, int y3, int z3,
	int x4, int y4, int z4,
	class P2,
	class P3,
	class P4,
	class P5,
	class P6,
	unsigned long cube
>
struct Puzzle<Piece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4>,P2,P3,P4,P5,P6,cube,true>
{
		//////////////////////////////////////////////////////////////
		template<
			class P1,
			class P2,
			class P3,
			class P4,
			class P5,
			class P6,
			unsigned long cube,
			bool valid
		>
		struct PuzzleR;

		//////////////////////////////////////////////////////////////
		template<
			class P1,
			class P2,
			class P3,
			class P4,
			class P5,
			class P6,
			unsigned long cube
		>
		struct PuzzleR<P1,P2,P3,P4,P5,P6,cube,false>
		{
			enum
			{
				solutions = 0
			};
		};

		//////////////////////////////////////////////////////////////
		template<
			int x1, int y1, int z1,
			int x2, int y2, int z2,
			int x3, int y3, int z3,
			int x4, int y4, int z4,
			int rotationNr,
			class P2,
			class P3,
			class P4,
			class P5,
			class P6,
			unsigned long cube
		>
		struct PuzzleR<RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, rotationNr>,P2,P3,P4,P5,P6,cube,true>
		{
			typedef RotatedPiece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4, rotationNr> P;
			enum
			{
				solutions = 
				Puzzle<P2,P3,P4,P5,P6,P::s00,(cube|P::s00::id),(P::s00::isValid&&((P::s00::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s01,(cube|P::s01::id),(P::s01::isValid&&((P::s01::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s02,(cube|P::s02::id),(P::s02::isValid&&((P::s02::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s03,(cube|P::s03::id),(P::s03::isValid&&((P::s03::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s04,(cube|P::s04::id),(P::s04::isValid&&((P::s04::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s05,(cube|P::s05::id),(P::s05::isValid&&((P::s05::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s06,(cube|P::s06::id),(P::s06::isValid&&((P::s06::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s07,(cube|P::s07::id),(P::s07::isValid&&((P::s07::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s08,(cube|P::s08::id),(P::s08::isValid&&((P::s08::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s09,(cube|P::s09::id),(P::s09::isValid&&((P::s09::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s10,(cube|P::s10::id),(P::s10::isValid&&((P::s10::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s11,(cube|P::s11::id),(P::s11::isValid&&((P::s11::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s12,(cube|P::s12::id),(P::s12::isValid&&((P::s12::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s13,(cube|P::s13::id),(P::s13::isValid&&((P::s13::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s14,(cube|P::s14::id),(P::s14::isValid&&((P::s14::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s15,(cube|P::s15::id),(P::s15::isValid&&((P::s15::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s16,(cube|P::s16::id),(P::s16::isValid&&((P::s16::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s17,(cube|P::s17::id),(P::s17::isValid&&((P::s17::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s18,(cube|P::s18::id),(P::s18::isValid&&((P::s18::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s19,(cube|P::s19::id),(P::s19::isValid&&((P::s19::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s20,(cube|P::s20::id),(P::s20::isValid&&((P::s20::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s21,(cube|P::s21::id),(P::s21::isValid&&((P::s21::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s22,(cube|P::s22::id),(P::s22::isValid&&((P::s22::id&cube)==0))>::solutions +
				Puzzle<P2,P3,P4,P5,P6,P::s23,(cube|P::s23::id),(P::s23::isValid&&((P::s23::id&cube)==0))>::solutions
			};
		};

	typedef Piece<x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4> P;
	enum
	{
		solutions = 
		PuzzleR<P::r00,P2,P3,P4,P5,P6,cube,P::r00::redundantWith==-1>::solutions +
		PuzzleR<P::r01,P2,P3,P4,P5,P6,cube,P::r01::redundantWith==-1>::solutions +
		PuzzleR<P::r02,P2,P3,P4,P5,P6,cube,P::r02::redundantWith==-1>::solutions +
		PuzzleR<P::r03,P2,P3,P4,P5,P6,cube,P::r03::redundantWith==-1>::solutions +
		PuzzleR<P::r04,P2,P3,P4,P5,P6,cube,P::r04::redundantWith==-1>::solutions +
		PuzzleR<P::r05,P2,P3,P4,P5,P6,cube,P::r05::redundantWith==-1>::solutions +
		PuzzleR<P::r06,P2,P3,P4,P5,P6,cube,P::r06::redundantWith==-1>::solutions +
		PuzzleR<P::r07,P2,P3,P4,P5,P6,cube,P::r07::redundantWith==-1>::solutions +
		PuzzleR<P::r08,P2,P3,P4,P5,P6,cube,P::r08::redundantWith==-1>::solutions +
		PuzzleR<P::r09,P2,P3,P4,P5,P6,cube,P::r09::redundantWith==-1>::solutions +
		PuzzleR<P::r10,P2,P3,P4,P5,P6,cube,P::r10::redundantWith==-1>::solutions +
		PuzzleR<P::r11,P2,P3,P4,P5,P6,cube,P::r11::redundantWith==-1>::solutions +
		PuzzleR<P::r12,P2,P3,P4,P5,P6,cube,P::r12::redundantWith==-1>::solutions +
		PuzzleR<P::r13,P2,P3,P4,P5,P6,cube,P::r13::redundantWith==-1>::solutions +
		PuzzleR<P::r14,P2,P3,P4,P5,P6,cube,P::r14::redundantWith==-1>::solutions +
		PuzzleR<P::r15,P2,P3,P4,P5,P6,cube,P::r15::redundantWith==-1>::solutions +
		PuzzleR<P::r16,P2,P3,P4,P5,P6,cube,P::r16::redundantWith==-1>::solutions +
		PuzzleR<P::r17,P2,P3,P4,P5,P6,cube,P::r17::redundantWith==-1>::solutions +
		PuzzleR<P::r18,P2,P3,P4,P5,P6,cube,P::r18::redundantWith==-1>::solutions +
		PuzzleR<P::r19,P2,P3,P4,P5,P6,cube,P::r19::redundantWith==-1>::solutions +
		PuzzleR<P::r20,P2,P3,P4,P5,P6,cube,P::r20::redundantWith==-1>::solutions +
		PuzzleR<P::r21,P2,P3,P4,P5,P6,cube,P::r21::redundantWith==-1>::solutions +
		PuzzleR<P::r22,P2,P3,P4,P5,P6,cube,P::r22::redundantWith==-1>::solutions +
		PuzzleR<P::r23,P2,P3,P4,P5,P6,cube,P::r23::redundantWith==-1>::solutions
	};
};

void Show(
	unsigned long p1,
	unsigned long p2,
	unsigned long p3,
	unsigned long p4,
	unsigned long p5,
	unsigned long p6
	)
{
	char L[2][3][4]={'.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.','.'};
	int x,y,z,n;

	n=0;
	for(y=0;y<2;++y)
	for(z=0;z<3;++z)
	for(x=0;x<4;++x)
	{
		if (p1&((unsigned long)1 << n))
		{
			if(L[y][z][x]!='.')
			{
				cerr << "solution not valid: piece " << L[y][z][x] << " collides with piece " << 1 << endl;
			}
			L[y][z][x] = '1';
		}
		++n;
	}

	n=0;
	for(y=0;y<2;++y)
	for(z=0;z<3;++z)
	for(x=0;x<4;++x)
	{
		if (p2&((unsigned long)1 << n))
		{
			if(L[y][z][x]!='.')
			{
				cerr << "solution not valid: piece " << L[y][z][x] << " collides with piece " << 2 << endl;
			}
			L[y][z][x] = '2';
		}
		++n;
	}

	n=0;
	for(y=0;y<2;++y)
	for(z=0;z<3;++z)
	for(x=0;x<4;++x)
	{
		if (p3&((unsigned long)1 << n))
		{
			if(L[y][z][x]!='.')
			{
				cerr << "solution not valid: piece " << L[y][z][x] << " collides with piece " << 3 << endl;
			}
			L[y][z][x] = '3';
		}
		++n;
	}

	n=0;
	for(y=0;y<2;++y)
	for(z=0;z<3;++z)
	for(x=0;x<4;++x)
	{
		if (p4&((unsigned long)1 << n))
		{
			if(L[y][z][x]!='.')
			{
				cerr << "solution not valid: piece " << L[y][z][x] << " collides with piece " << 4 << endl;
			}
			L[y][z][x] = '4';
		}
		++n;
	}

	n=0;
	for(y=0;y<2;++y)
	for(z=0;z<3;++z)
	for(x=0;x<4;++x)
	{
		if (p5&((unsigned long)1 << n))
		{
			if(L[y][z][x]!='.')
			{
				cerr << "solution not valid: piece " << L[y][z][x] << " collides with piece " << 5 << endl;
			}
			L[y][z][x] = '5';
		}
		++n;
	}

	n=0;
	for(y=0;y<2;++y)
	for(z=0;z<3;++z)
	for(x=0;x<4;++x)
	{
		if (p6&((unsigned long)1 << n))
		{
			if(L[y][z][x]!='.')
			{
				cerr << "solution not valid: piece " << L[y][z][x] << " collides with piece " << 6 << endl;
			}
			L[y][z][x] = '6';
		}
		++n;
	}

	cerr << "----------------------------------------" << endl;
	cerr          << L[0][0][0]
	              << L[0][0][1]
	              << L[0][0][2]
	              << L[0][0][3]
				  << endl;

	cerr          << L[0][1][0]
	              << L[0][1][1]
	              << L[0][1][2]
	              << L[0][1][3]
				  << endl;

	cerr          << L[0][2][0]
	              << L[0][2][1]
	              << L[0][2][2]
	              << L[0][2][3]
				  << endl;

	cerr << endl;

	cerr          << L[1][0][0]
	              << L[1][0][1]
	              << L[1][0][2]
	              << L[1][0][3]
				  << endl;

	cerr          << L[1][1][0]
	              << L[1][1][1]
	              << L[1][1][2]
	              << L[1][1][3]
				  << endl;

	cerr          << L[1][2][0]
	              << L[1][2][1]
	              << L[1][2][2]
	              << L[1][2][3]
				  << endl;

	cerr << "----------------------------------------" << endl;
	cerr << endl;
};

//////////////////////////////////////////////////////////////
int main(int argc, const char** argv)
{

	typedef Piece<
		0, 0, 0,
		1, 0, 0,
		2, 0, 0,
		3, 0, 0
	> p1;

	typedef Piece<
		0, 0, 0,
		1, 0, 0,
		1, 0, 1,
		0, 0, 1
	> p2;

	typedef Piece<
		0, 0, 1,
		0, 1, 1,
		1, 1, 1,
		0, 1, 0
	> p3;

	typedef Piece<
		0, 0, 0,
		0, 0, 1,
		1, 0, 1,
		1, 1, 1
	> p4;

	typedef Piece<
		0, 0, 1,
		1, 0, 1,
		2, 0, 1,
		1, 0, 0
	> p5;

	typedef Piece<
		0, 0, 0,
		1, 0, 0,
		2, 0, 0,
		2, 0, 1
	> p6;


	// um alle Lsungen zu finden reichen die Kapazitten des compilers nicht aus.
	//cerr << "Gefundene Loesungen: " << Puzzle<p1,p2,p3,p4,p5,p6>::solutions << endl;

	// hier werden die Positionen von 3 Teilen festgehalten
	typedef p1::r00::s12 sp1;
	typedef p2::r00::s18 sp2;
	typedef p3::r00::s04 sp3;
	cerr << "Gefundene Loesungen: " << Puzzle<
		p4,
		p5,
		p6,
		sp1,
		sp2,
		sp3,
		sp1::id|sp2::id|sp3::id
	>::solutions << endl;

	Show(
		p1::r00::s12::id,
		p2::r00::s18::id,
		p3::r00::s04::id,
		p4::r00::s00::id,
		p5::r00::s05::id,
		p6::r00::s01::id);

	Show(
		p1::r00::s12::id,
		p2::r00::s18::id,
		p3::r00::s04::id,
		p4::r00::s00::id,
		p5::r02::s01::id,
		p6::r19::s05::id);


	return 0;
}
