#include "pch.h"
#include <iostream>
#include <algorithm>
#include <set>
#include <ctime>

#include "Piece.h"

int const ASSUMED_SOLUTIONS=400000;

using namespace std;

#define for if(false);else for

inline int getFirstBit(u64 x)
{
        int r=0;
        while(x%2==0)
        {
                x/=2;
                ++r;
        }
        return r;
}
inline int getFirstBit(u32 x)
{
        int r=0;
        while(x%2==0)
        {
                x/=2;
                ++r;
        }
        return r;
}

inline int getFirstFreeBit(u32 x)
{
        u32 r;
        __asm not x
        __asm   bsf eax,x
        __asm mov r,eax
        return r;
}

inline u32 getFirstFreeBit(u64 x)
{
        u32 low=x;
        if(low==-1)
                return 32+getFirstFreeBit(u32(x>>32));
        else
                return getFirstFreeBit(low);
}

u64 reverse(u64 x)
{
        u64 r=0;
        for(int i=0;i<64;++i)
        {
                r<<=1;
                r|=x&1;
                x>>=1;
        }
        return r;
}
struct bettermirror
{
        bool operator()(u64 a,u64 b)
        {
                return reverse(a)<reverse(b);
        }
};

struct betterpattern
{
        bool operator()(u64 a,u64 b)
        {
                return reverse(a)>reverse(b);
        }
};

void getPatterns(vector<u64>* patterns,Piece p)
{
	for(int ts=0;ts<6;++ts)//top side
	{
		for(int fs=0;fs<4;++fs)//front side
		{
			for(int ox=0;ox<WORLDSIZEX-p.maxx;++ox)//offset x
			{
				for(int oy=0;oy<WORLDSIZEY-p.maxy;++oy)//offset y
				{
					for(int oz=0;oz<WORLDSIZEZ-p.maxz;++oz)//offset z
					{
						u64 pattern=p.getPattern();
						patterns->push_back(pattern);
						p.shift(Point(0,0,1));
					}
					p.shift(Point(0,0,p.maxz-WORLDSIZEZ));
					p.shift(Point(0,1,0));
				}
				p.shift(Point(0,p.maxy-WORLDSIZEY,0));
				p.shift(Point(1,0,0));
			}
			p.shift(Point(p.maxx-WORLDSIZEX,0,0));
			p.turnX2Y();
		}
		if(ts%2)
			p.turnY2Z();
		else
			p.turnZ2X();
	}
	sort(patterns->begin(),patterns->end(),betterpattern());
   vector<u64>::iterator end=unique(patterns->begin(),patterns->end());
   patterns->erase(end,patterns->end());
}

void removeMirrors(vector<u64>* patterns)
{
        vector<u64> src(*patterns);
        sort(src.begin(),src.end(),bettermirror());
        patterns->clear();
        set<u64> seen;
        for(vector<u64>::iterator i=src.begin();i!=src.end();++i)
        {
                if(seen.find(*i)==seen.end())
                {
                        seen.insert(*i);
                        seen.insert(mirrorXY(*i));
                        seen.insert(mirrorXZ(*i));
                        seen.insert(mirrorYZ(*i));
                        patterns->push_back(*i);
                }
        }
}

vector<u64> patterns[12][64];
int solutions=0;

time_t start=clock();

template<int DEPTH>
struct Solver
{
	static void countSolutions(u64 usedPlaces,u32 usedPieces)
	{
		u32 firstFreePlace=getFirstFreeBit(usedPlaces);
		for(int piece=0;piece<12;piece++)
		{
			if((1<<piece)&usedPieces)
				continue;
			vector<u64>& pats=patterns[piece][firstFreePlace];
			for(vector<u64>::iterator i=pats.begin();i!=pats.end();++i)
			{
				u64& p=*i;
				if((usedPlaces&p)!=0)
					continue;
				if(firstFreePlace>32)
				{
					u64 t=usedPlaces|p;
					Solver<DEPTH+1>::countSolutions(reinterpret_cast<u32*>(&t)[1],usedPieces|(1<<piece));
				}
				else
					Solver<DEPTH+1>::countSolutions(usedPlaces|p,usedPieces|(1<<piece));
			}
		}
	}
	static void countSolutions(u32 usedPlaces,u32 usedPieces)
	{
		u32 firstFreePlace=getFirstFreeBit(usedPlaces)+32;
		for(int piece=0;piece<12;piece++)
		{
			if((1<<piece)&usedPieces)
				continue;
			vector<u64>& pats=patterns[piece][firstFreePlace];
			for(vector<u64>::iterator i=pats.begin();i!=pats.end();++i)
			{
				u32& p=reinterpret_cast<u32*>(&*i)[1];
				if((usedPlaces&p)!=0)
					continue;
				Solver<DEPTH+1>::countSolutions(usedPlaces|p,usedPieces|(1<<piece));
			}
		}
	}
};

template<>
struct Solver<1>
{
	static void countSolutions(u64 usedPlaces,u32 usedPieces)
	{
		cout<<(clock()-start)/60/CLOCKS_PER_SEC<<" min: "<<solutions<<" solutions found"<<endl;
		cout<<"ca. "<<(clock()-start)*double(ASSUMED_SOLUTIONS)/CLOCKS_PER_SEC/solutions/60<<" min gesamt\r";

		u32 firstFreePlace=getFirstFreeBit(usedPlaces);
		for(int piece=0;piece<12;piece++)
		{
			if((1<<piece)&usedPieces)
				continue;
			vector<u64>& pats=patterns[piece][firstFreePlace];
			for(vector<u64>::iterator i=pats.begin();i!=pats.end();++i)
			{
				u64& p=*i;
				if((usedPlaces&p)!=0)
					continue;
				if(firstFreePlace>32)
				{
					u64 t=usedPlaces|p;
					Solver<DEPTH+1>::countSolutions(reinterpret_cast<u32*>(&t)[1],usedPieces|(1<<piece));
				}
				else
					Solver<DEPTH+1>::countSolutions(usedPlaces|p,usedPieces|(1<<piece));
			}
		}
	}
	static void countSolutions(u32 usedPlaces,u32 usedPieces)
	{
		u32 firstFreePlace=getFirstFreeBit(usedPlaces)+32;
		for(int piece=0;piece<12;piece++)
		{
			if((1<<piece)&usedPieces)
				continue;
			vector<u64>& pats=patterns[piece][firstFreePlace];
			for(vector<u64>::iterator i=pats.begin();i!=pats.end();++i)
			{
				u32& p=reinterpret_cast<u32*>(&*i)[1];
				if((usedPlaces&p)!=0)
					continue;
				Solver<DEPTH+1>::countSolutions(usedPlaces|p,usedPieces|(1<<piece));
			}
		}
	}
};

template<>
struct Solver<12>
{
	static void countSolutions(u64 usedPlaces,u32 usedPieces)
	{
		++solutions;
	}
	static void countSolutions(u32 usedPlaces,u32 usedPieces)
	{
		++solutions;
	}
};

int __cdecl main()
{
	char const* const descriptions[12]=
	{
		"B 100 010 110 210 120",
		"E 100 010 110 210 020",
		"F 100 110 020 120 220",
		"C 000 010 011 012 022",
		"L 000 010 110 120 220",
		"H 000 110 100 200 300 310",
		"I 010 000 100 200 300",
		"J 000 100 200 300 110",
		"G 010 000 100 200 210",
		"K 010 110 001 011",
		"A 000 100 200 010 110",
		"D 000 010 001 011 100",
	};
	for(int i=0;i<12;++i)
	{
		cout<<descriptions[i]<<": ";
		Piece p(descriptions[i]);
		vector<u64> pats;
		getPatterns(&pats,p);
		if(p.type==4)
		{
			cout<<pats.size();
			removeMirrors(&pats);
			cout<<" reduced to ";
		}
		cout<<pats.size()<<endl;
		for(vector<u64>::iterator p=pats.begin();p!=pats.end();++p)
			patterns[i][getFirstBit(*p)].push_back(*p);
	}

	Solver<0>::countSolutions(u64(15),0);

	cout<<endl<<endl<<"Fertig"<<endl;
	cout<<solutions<<" Loesungen"<<endl;

	return 0;
}
