#ifndef GLOBALS_H
#define GLOBALS_H

#include <iosfwd>

int const WORLDSIZEX=3;
int const WORLDSIZEY=4;
int const WORLDSIZEZ=5;

typedef unsigned __int32 u32;
typedef unsigned __int64 u64;

inline int charToDigit(char ch)
{
	return ch-'0';
}

u64 getPattern(int x,int y,int z);

/*inline bool getBit(u64 x,int p)
{
	return (x>>p)&1;
}
inline void setBit(u64* x,int p)
{
	*x|=u64(1)<<p;
}*/

inline u64 mirrorXY(u64 src)
{
	u64 dst=0;
	for(int x=0;x<WORLDSIZEX;++x)
	{
		for(int y=0;y<WORLDSIZEY;++y)
		{
			for(int z=0;z<WORLDSIZEZ;++z)
			{
				u64 psrc=getPattern(x,y,z);
				u64 pdst=getPattern(WORLDSIZEX-1-x,WORLDSIZEY-1-y,z);
				if(src&psrc)
					dst|=pdst;
			}
		}
	}
	return dst;
}

inline u64 mirrorYZ(u64 src)
{
	u64 dst=0;
	for(int x=0;x<WORLDSIZEX;++x)
	{
		for(int y=0;y<WORLDSIZEY;++y)
		{
			for(int z=0;z<WORLDSIZEZ;++z)
			{
				u64 psrc=getPattern(x,y,z);
				u64 pdst=getPattern(x,WORLDSIZEY-1-y,WORLDSIZEZ-1-z);
				if(src&psrc)
					dst|=pdst;
			}
		}
	}
	return dst;
}

inline u64 mirrorXZ(u64 src)
{
	u64 dst=0;
	for(int x=0;x<WORLDSIZEX;++x)
	{
		for(int y=0;y<WORLDSIZEY;++y)
		{
			for(int z=0;z<WORLDSIZEZ;++z)
			{
				u64 psrc=getPattern(x,y,z);
				u64 pdst=getPattern(WORLDSIZEX-1-x,y,WORLDSIZEZ-1-z);
				if(src&psrc)
					dst|=pdst;
			}
		}
	}
	return dst;
}


#endif
