#include "pch.h"
#include "globals.h"

#include "Point.h"
#include <vector>
#include <algorithm>
using namespace std;

struct betterpoint
{
	static int dist(Point const& p)
	{
		return 12*p.x*p.x+11*p.y*p.y+10*p.z*p.z;
	}
	bool operator()(Point const&a,Point const& b)
	{
		return dist(a)<dist(b);
	}
};

u64 (*makePatterns())[WORLDSIZEY][WORLDSIZEZ]
{
	vector<Point> points;
	for(int x=0;x<WORLDSIZEX;++x)
	{
		for(int y=0;y<WORLDSIZEY;++y)
		{
			for(int z=0;z<WORLDSIZEZ;++z)
			{
				points.push_back(Point(x,y,z));
			}
		}
	}
	sort(points.begin(),points.end(),betterpoint());
	static u64 patterns[WORLDSIZEX][WORLDSIZEY][WORLDSIZEZ];
	u64 p=16;
	for(vector<Point>::iterator i=points.begin();i!=points.end();++i)
	{
		patterns[i->x][i->y][i->z]=p;
		p<<=1;
	}
	return patterns;
}

u64 getPattern(int x,int y,int z)
{
	static u64 (*patterns)[WORLDSIZEY][WORLDSIZEZ]=makePatterns();
	return patterns[x][y][z];
}
