#ifndef POINT_H
#define POINT_H

#include "globals.h"

struct Point
{
	int x,y,z;
	Point(int _x,int _y,int _z)
		:x(_x),y(_y),z(_z)
	{
	}
	friend bool operator==(Point const& a,Point const& b)
	{
		return a.x==b.x && a.y==b.y && a.z==b.z;
	}
	Point& operator+=(Point const& p)
	{
		x+=p.x;
		y+=p.y;
		z+=p.z;
		return *this;
	}
};

#endif
