#include "Point.h"
#include "globals.h"

struct Piece
{
public:
        int type;
        std::vector<Point> points;
        int maxx,maxy,maxz;
public:
        Piece(char const* line);//zum beispiel "A 000 100 200 010 110", also name und dann xyz-tripel
        void print();
        u64 getPattern();
        void shift(Point const& p)
        {
                for(std::vector<Point>::iterator i=points.begin();i!=points.end();++i)
                        *i+=p;
        }
        void turnX2Y()
        {
                std::swap(maxx,maxy);
                for(std::vector<Point>::iterator i=points.begin();i!=points.end();++i)
                {
                        std::swap(i->x,i->y);
                        i->x=maxx-i->x;
                }
        }
        void turnY2Z()
        {
                std::swap(maxy,maxz);
                for(std::vector<Point>::iterator i=points.begin();i!=points.end();++i)
                {
                        std::swap(i->y,i->z);
                        i->y=maxy-i->y;
                }
        }
        void turnZ2X()
        {
                std::swap(maxz,maxx);
                for(std::vector<Point>::iterator i=points.begin();i!=points.end();++i)
                {
                        std::swap(i->z,i->x);
                        i->z=maxz-i->z;
                }
        }
};
