#include "pch.h"
#include "Piece.h"
#include "globals.h"

#include <iostream>
#include <algorithm>

using namespace std;

Piece::Piece(char const* line)
{
        maxx=0;
        maxy=0;
        maxz=0;
        char const *pos=line;
        type=*pos++-'A';
        while(*pos!='\0')
        {
                pos++;
                int x=charToDigit(*pos++);
                int y=charToDigit(*pos++);
                int z=charToDigit(*pos++);
                if(x>maxx) maxx=x;
                if(y>maxy) maxy=y;
                if(z>maxz) maxz=z;
                points.push_back(Point(x,y,z));
        }
}

void Piece::print()
{
        for(int y=4;y>=0;--y)
        {
                cout<<'+';
                for(int x=0;x<=4;++x)
                {
                        if(find(points.begin(),points.end(),Point(x,y,0))!=points.end())
                                cout<<'*';
                        else
                                cout<<' ';
                }
                cout<<'\n';
        }
        cout<<"+++++\n";
}

u64 Piece::getPattern()
{
        u64 r=0;
        for(std::vector<Point>::iterator i=points.begin();i!=points.end();++i)
        {
			  r|=::getPattern(i->x,i->y,i->z);
        }
        return r;
}
