/////////////////////////////////////////////////////////////////////////////
//Projectname 	: 
//Filename		: UKPuzzleCore.h 
//Classname		: CUKPuzzleCore
//Author		: Ulrich Kraemer [uk]
//Date			: 25.03.2003
//Changes		: 
//////////////////////////////////////////////////////////////////////////////
//Synchronization and error handling is not implemenmted yet

#ifndef UKPUZZLECORE_H
#define UKPUZZLECORE_H

#include "afxtempl.h"
#include "UKPuzzleDef.h"
#include "UKIniAccess.h"

#define UKPUZ_WRITEOUTPUT

//FASTER THAN LIGHT
#define UKPUZ_FTL

//The FTL mode deactivates also the UKPUZ_WRITEOUTPUT function
//#if defined (UKPUZ_FTL) && defined(UKPUZ_WRITEOUTPUT)
//#undef UKPUZ_WRITEOUTPUT
//#endif


//////////////////////////////////////////////////////////////////////////////
//puzzle core class
// in this class are all calculations done

struct SUKPuzzlePos
{
	SUKPuzzlePos():x(0),y(0),z(0){}
	SUKPuzzlePos(long nXPos,long nYPos,long nZPos):x(nXPos),y(nYPos),z(nZPos){}
	SUKPuzzlePos(const SUKPuzzlePos &r):x(r.x),y(r.y),z(r.z){}

	SUKPuzzlePos operator+(const SUKPuzzlePos &r){SUKPuzzlePos tmp=*this;tmp+=r;return tmp;}
	SUKPuzzlePos operator-(const SUKPuzzlePos &r){SUKPuzzlePos tmp=*this;tmp-=r;return tmp;}

	SUKPuzzlePos& operator+=(const SUKPuzzlePos &r){x+=r.x;y+=r.y;z+=r.z;return *this;}
	SUKPuzzlePos& operator-=(const SUKPuzzlePos &r){x-=r.x;y-=r.y;z-=r.z;return *this;}

	BOOL operator==(const SUKPuzzlePos &r){return x==r.x && y==r.y && z==r.z;}

	//very specialized methodes (the angle of rotation has no effect)
	void RotateX(){long tmp=z;z=y;y=-tmp;}
	void RotateY(){long tmp=z;z=x;x=-tmp;}
	void RotateZ(){long tmp=y;y=x;x=-tmp;}

	long x;
	long y;
	long z;
};

class CUKStone
{
	private:
		CUKStone(const CUKStone&);
		CUKStone& operator= (const CUKStone&);
	public:	
		CUKStone();
		~CUKStone();	

		long GetMaxVariations(){return m_nMaxVariations;}

		BOOL SetStone(SUKPuzzlePos* pStone,long nCubeCount,long nDX,long nDY,long nDZ,long nPosition,long* pBlock);
		BOOL CUKStone::SetStone(CUKStone& rStone,long nDX,long nDY,long nDZ,long nPosition,long* pBlock);

		long GetCubeCount(){return m_nCubeCount;}

		long GetPos(long nCubeNo,long nVariation){return m_pCubes[nVariation][nCubeNo];}
		long* GetStone(long nVariation){return m_pCubes[nVariation];}
	protected:
		enum {enInvalid=MAXLONG};
		virtual BOOL IsInvalid(long nPosition,long* pBlock); //can be overwritten (depends on position order)

		virtual long GetCubeSortPosition(SUKPuzzlePos &rStone);

		void EliminateInvalidStones();
		void EliminateDuplicatedStones();
	private:
		long m_nMaxVariations;

		long m_nCubeCount;
		long**	m_pCubes;//Reference to Correct Cube
};

struct SUKStoneDesc	//Stonedescriptor
{
	long nVariation;
	long nActiveStone;
	long nPosIndex;
	long nPosition;
	long nStoneID;//temporary unique id (m_nUsedStoneCount)
	long nQuickIndex;
	CUKStone* pStones;		//StoneList
};

class CUKPuzzleCore
{
	public:
		CUKPuzzleCore(long nFirstStoneOnPos_0=-1,long nLastStoneOnPos_0=-1,LPCTSTR szIniFileName="",LPCTSTR szOutputFileName="");
		~CUKPuzzleCore();

		BOOL Init(){return Init(m_nFirstStoneOnPos_0,m_nLastStoneOnPos_0,m_strIniFileName,m_strOutputFileName);}
		BOOL Init(LPCTSTR szIniFileName,LPCTSTR szOutputFileName){return Init(m_nFirstStoneOnPos_0,m_nLastStoneOnPos_0,szIniFileName,szOutputFileName);}
		BOOL Init(long nFirstStoneOnPos_0,long nLastStoneOnPos_0,LPCTSTR szIniFileName,LPCTSTR szOutputFileName);
		void Deinit();

		UKPUZ_STATE DoNextStep();
	
		DWORD GetSolutions(){return m_nSolutionsFound;}
		BOOL HasFinished(){return m_bHasFinished;}

	protected:
		/////////////////////////////////////////////////////////
		BOOL ReadCoordinate(CUKIniAccess& theFile,LPCTSTR szSection,LPCTSTR szKey,SUKPuzzlePos &rPos);
		BOOL ReadStone(CUKIniAccess& theFile,LPCTSTR szSection,LPCTSTR szKey,CUKStone &rStone,long &nStoneCount,long nDX,long nDY,long nDZ,long nPosition,long* pBlock);

		/////////////////////////////////////////////////////////
		//Tool Functions
		void WriteOutput(LPCTSTR szFileName);
		void SolutionFound();

		BOOL PreCheck1();
		BOOL PreCheck2();

		BOOL InsertStone();//Check The Stone Described by the Head of UsedStones List

		void RemoveStone();

		long GetNextFreeStone(long nQuickIndex,long nBeginAfter=-1,long nPosition=0);
		long GetNextFreePosIndex();

		void SetStoneIsUsedFALSE(long nStone);
		void SetStoneIsUsedTRUE(long nStone);
		//////////////////////////////////////////////////////////
		
		//////////////////////////////////////////////////////////
		//Basic Steps
		void TryInsertNextStone();
		void TryReplaceStone();
		//////////////////////////////////////////////////////////

	protected:
		virtual BOOL PreInitBlock();
		virtual BOOL InitPositionOrder();
		virtual BOOL PostInitBlock();
		virtual BOOL InitStones();

		virtual void DeinitStones();
		virtual void DeinitPositionOrder();
		virtual void DeinitBlock();

	public:
		enum
		{
			enNextStone=1,
			enReplaceStone=2,
			enFinished=3
		};
		enum
		{
			enMaxCubesPerStone=32,//there are no more allowed at the moment
		};

	protected:
		//dynamic loaded parameters
		long m_nPreCheckLevel;
		long m_nFirstPreCheckStone;
		long m_nLastPreCheckStone;

		CString m_strIniFileName;
		BOOL	m_bLoadFromIni;

		long m_nXSize;
		long m_nYSize;
		long m_nZSize;
		long m_nEdgeZone;
		long m_nDX;
		long m_nDY;
		long m_nDZ;
		long m_nPositionCount;
		long m_nStoneCount;			//Number of Different Stones (ini-File Stone Count)
		long m_nEntireStoneCount;	//Number of Stones

		long m_nSymetriePosCount;
		BOOL m_bEnhancedSymertyCheck;

		CString	m_strOutputFileName;
		long	m_nWriteEveryNSolution;
		BOOL	m_bShowLegend;

	protected:
		//statistics and status
		DWORD	m_nSolutionsFound;	//all Solutions in the 3*4*5 Block
		BOOL	m_bHasFinished;

		//environment
		BOOL			m_bIsInit;

		long*			m_pBlock;
		long*			m_pPositions;

		enum {enPreDefStones=64};
		CUKStone**		m_ppStones[enPreDefStones];
		long*			m_pAvailableStones;

		//dynamic attributes (floating control) 
		long			m_nNextStep;
		long			m_nUsedStoneCount;
		SUKStoneDesc*	m_pUsedStones;//[enStoneCount];
		SUKStoneDesc	m_ActiveStoneDesc;

		//optimizing vars
		long	m_nNextFreeStone;
		long	m_nFirstActiveStone;
		long	m_nNextFreePosIndex;

		long			m_SymetriePos[8];//maximum 8 corners
		SUKPuzzlePos	m_SymetriePuzzlePos[8];//SymetriePos 0 must be first pos

		long	m_nSymetryStones;
		long	m_nSymetryStonesNeeded;

		long	m_nFirstStoneOnPos_0;
		long	m_nLastStoneOnPos_0;

		//long*			m_pBlockPosToPosIndex;
	public:
		//test vars
		LONGLONG m_nTrys;
};

#endif