/////////////////////////////////////////////////////////////////////////////
//Projectname 	: 
//Filename		: UKPuzzleCore.cpp 
//Classname		: CUKPuzzleCore
//Author		: Ulrich Kraemer [uk]
//Date			: 25.03.2003
//Changes		: 
//////////////////////////////////////////////////////////////////////////////
//Synchronization and error handling is not implemenmted yet

#include "stdafx.h"
#include "iostream.h"
#include "UKPuzzleCore.h"
#include "math.h"

inline long __GETQUICKCHECKINDEX(long* pEnv,long nStartPos,long nDX,long nDY,long nDZ)
{		   
	long QI=0;

	long* pEnv2=&pEnv[nStartPos];

/*	QI|=	(pEnv2[nDX]?	0x00000001:0L);
	QI|=	(pEnv2[nDY]?	0x00000002:0L);
	QI|=	(pEnv2[nDZ]?	0x00000004:0L);
*/
	if (pEnv2[nDX]) QI|=0x01;
	if (pEnv2[nDY]) QI|=0x02;
	if (pEnv2[nDZ]) QI|=0x04;

	if (pEnv2[-nDX]) QI|=0x08;
	if (pEnv2[-nDY]) QI|=0x10;
	if (pEnv2[-nDZ]) QI|=0x20;

	return QI;
}

//for PreCheck2
inline long __GETQUICKCHECKINDEX2(long* pEnv,long nStartPos,long nDX,long nDY,long nDZ)
{		   
	long QI=0;

	long* pEnv2=&pEnv[nStartPos];

/*
	QI|=	(pEnv2[nDX]?	0x00000001:0L);
	QI|=	(pEnv2[nDY]?	0x00000002:0L);
	QI|=	(pEnv2[nDZ]?	0x00000004:0L);
*/

	if (pEnv2[nDX]) QI|=0x01;
	if (pEnv2[nDY]) QI|=0x02;
	if (pEnv2[nDZ]) QI|=0x04;

	if (pEnv2[-nDX]) QI|=0x08;
	if (pEnv2[-nDY]) QI|=0x10;
	if (pEnv2[-nDZ]) QI|=0x20;

	switch (QI)
	{
		case 0x3e:
			if (pEnv2[nDX+nDX] &&
				pEnv2[nDX+nDY] &&
				pEnv2[nDX-nDY] &&
				pEnv2[nDX+nDZ] &&
				pEnv2[nDX-nDZ])
			{
				QI|=0x01;
			}
			break;
		case 0x3d:
			if (pEnv2[nDY+nDY] &&
				pEnv2[nDY+nDX] &&
				pEnv2[nDY-nDX] &&
				pEnv2[nDY+nDZ] &&
				pEnv2[nDY-nDZ])
			{
				QI|=0x02;
			}
			break;
		case 0x3b:
			if (pEnv2[nDZ+nDZ] &&
				pEnv2[nDZ+nDY] &&
				pEnv2[nDZ-nDY] &&
				pEnv2[nDZ+nDX] &&
				pEnv2[nDZ-nDX])
			{
				QI|=0x04;
			}
			break;
		case 0x37:
			if (pEnv2[-nDX-nDX] &&
				pEnv2[-nDX+nDY] &&
				pEnv2[-nDX-nDY] &&
				pEnv2[-nDX+nDZ] &&
				pEnv2[-nDX-nDZ])
			{
				QI|=0x08;
			}
			break;
		case 0x2f:
			if (pEnv2[-nDY-nDY] &&
				pEnv2[-nDY+nDX] &&
				pEnv2[-nDY-nDX] &&
				pEnv2[-nDY+nDZ] &&
				pEnv2[-nDY-nDZ])
			{
				QI|=0x10;
			}
			break;
		case 0x1f:
			if (pEnv2[-nDZ-nDZ] &&
				pEnv2[-nDZ+nDY] &&
				pEnv2[-nDZ-nDY] &&
				pEnv2[-nDZ+nDX] &&
				pEnv2[-nDZ-nDX])
			{
				QI|=0x20;
			}
			break;
	}
	return QI;
}

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
// class CUKStone
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

CUKStone::CUKStone()
:m_nMaxVariations(0),
 m_pCubes(0)
{
}
CUKStone::~CUKStone()
{
	SetStone(NULL,0,0,0,0,0,NULL);
}

BOOL CUKStone::SetStone(
	SUKPuzzlePos* pStone,long nCubeCount,
	long nDX,long nDY,long nDZ,
	long nPosition,long* pBlock)
{
	int i,j,k,l;
	if (m_pCubes)
	{
		for (i=0;i<m_nMaxVariations;i++)
		{
			if (m_pCubes[i])
				delete m_pCubes[i];
			m_pCubes[i]=NULL;
		}
		delete[] m_pCubes;
	}
	m_pCubes=NULL;

	m_nMaxVariations=0;
	m_nCubeCount=0;

	if (pStone==0 || nCubeCount==0 || pBlock==NULL)
		return TRUE;

	m_nMaxVariations=nCubeCount*24;
	m_nCubeCount=nCubeCount;

	m_pCubes=new long* [m_nMaxVariations];
	if (!m_pCubes)
	{
		SetStone(NULL,0,0,0,0,0,NULL);
		return FALSE;
	}		
	
	for (i=0;i<m_nMaxVariations;i++)
	{
		m_pCubes[i]=new long[m_nCubeCount];
 		if (!m_pCubes[i])
		{
			SetStone(NULL,0,0,0,0,0,NULL);
			return FALSE;
		}
	}

	long pCubeSort[CUKPuzzleCore::enMaxCubesPerStone];

	SUKPuzzlePos theCube;
	//Fill all variations
	for (i=0;i<m_nMaxVariations;i++)
	{
		for (j=0;j<m_nCubeCount;j++)
		{
			theCube=pStone[j];
			theCube-=pStone[i%m_nCubeCount];

			//rotate stone around x axis
			switch ((i/m_nCubeCount)%4)
			{
				case 3:theCube.RotateX();//no break;
				case 2:theCube.RotateX();//no break;
				case 1:theCube.RotateX();//no break;
				case 0:;//no break;
			}
			//rotate every second stones round 180 Degree around another axis
			switch ((i/(m_nCubeCount*4))%2)
			{
				case 1:
					theCube.RotateZ();
					theCube.RotateZ();
					break;
				case 0:break;
			}
			//the one third part around y and one third part around y axis
			switch (i/(m_nCubeCount*8))
			{
				case 2:theCube.RotateY();break;
				case 1:theCube.RotateZ();break;
				case 0:break;
			}
			//mark invalid stons so that they can be found
			long nInsertPosition=nPosition+theCube.x*nDX+theCube.y*nDY+theCube.z*nDZ;
			if (IsInvalid(nInsertPosition,pBlock))//theCube,))
			{
				pCubeSort[j]=-1;
				m_pCubes[i][j]=enInvalid;
			}
			else
			{
				pCubeSort[j]=GetCubeSortPosition(theCube);
				m_pCubes[i][j]=theCube.x*nDX+theCube.y*nDY+theCube.z*nDZ;
			}
		}

		//a very dirty bubblesort 
		for (k=0;k<m_nCubeCount-1;k++)
			for (l=0;l<m_nCubeCount-1;l++)
				if (pCubeSort[l+1]>pCubeSort[l])
				{
					long nTmp;

					nTmp=pCubeSort[l+1];
					pCubeSort[l+1]=pCubeSort[l];
					pCubeSort[l]=nTmp;

					nTmp=m_pCubes[i][l+1];
					m_pCubes[i][l+1]=m_pCubes[i][l];
					m_pCubes[i][l]=nTmp;
				}
	}

	EliminateInvalidStones();
	EliminateDuplicatedStones();
	return TRUE;
}

BOOL CUKStone::SetStone(
	CUKStone& rStone,
	long nDX,long nDY,long nDZ,
	long nPosition,long* pBlock)
{
	int i,j;
	if (m_pCubes)
	{
		for (i=0;i<m_nMaxVariations;i++)
		{
			if (m_pCubes[i])
				delete m_pCubes[i];
			m_pCubes[i]=NULL;
		}
		delete[] m_pCubes;
	}
	m_pCubes=NULL;

	m_nMaxVariations=0;
	m_nCubeCount=0;

	if (rStone.m_nCubeCount==0 || pBlock==NULL)
		return TRUE;

	m_nMaxVariations=rStone.m_nMaxVariations;
	m_nCubeCount=rStone.m_nCubeCount;

	m_pCubes=new long* [m_nMaxVariations];
	if (!m_pCubes)
	{
		SetStone(NULL,0,0,0,0,0,NULL);
		return FALSE;
	}		
	
	for (i=0;i<m_nMaxVariations;i++)
	{
		m_pCubes[i]=new long[m_nCubeCount];
 		if (!m_pCubes[i])
		{
			SetStone(NULL,0,0,0,0,0,NULL);
			return FALSE;
		}
	}

	//Fill all variations
	for (i=0;i<m_nMaxVariations;i++)
	{
		for (j=0;j<m_nCubeCount;j++)
		{
			long nInsertPosition=nPosition+rStone.m_pCubes[i][j];
			if (IsInvalid(nInsertPosition,pBlock))//theCube,))
				m_pCubes[i][j]=enInvalid;
			else
				m_pCubes[i][j]=rStone.m_pCubes[i][j];
		}
	}

	EliminateInvalidStones();
	//EliminateDuplicatedStones();
	return TRUE;
}

long CUKStone::GetCubeSortPosition(SUKPuzzlePos &rStone)
{
	long nResult=0;

	double fResult=0;

	if (rStone.x<0) fResult+=(pow(-rStone.x,2));
	else			fResult+=(pow(+rStone.x,2));			

	if (rStone.y<0) fResult+=(pow(-rStone.y,2));
	else			fResult+=(pow(+rStone.y,2));

	if (rStone.z<0) fResult+=(pow(-rStone.z,2));
	else			fResult+=(pow(+rStone.z,2));

	nResult=(long)fResult;

	ASSERT(nResult>=0);

	return nResult;
}

BOOL CUKStone::IsInvalid(long nPosition,long* pBlock)//SUKPuzzlePos &rCube)
{
	//we can no have a negativ value in one axis, if no value in another axis is positiov
	if (pBlock[nPosition]!=0)
		return TRUE;

	return FALSE;
}

void CUKStone::EliminateInvalidStones()
{
	int i,j;
	for (i=0;i<m_nMaxVariations;i++)
	{
		BOOL bInvalid=FALSE;
		for (j=0;j<m_nCubeCount;j++)
		{
			if (m_pCubes[i][j]==enInvalid)
			{
				bInvalid=TRUE;
				break;
			}
		}
		if (bInvalid)
		{
			for (j=0;j<m_nCubeCount;j++)
				m_pCubes[i][j]=m_pCubes[m_nMaxVariations-1][j];

			delete[] m_pCubes[m_nMaxVariations-1];
		
			m_nMaxVariations--;
			i--;
		}
	}
}

void CUKStone::EliminateDuplicatedStones()
{
	for (int i1=0;i1<m_nMaxVariations;i1++)
		for (int i2=i1+1;i2<m_nMaxVariations;i2++)
		{
			BOOL bStoneFound=TRUE;
			for (int j1=0;j1<m_nCubeCount;j1++)
			{
				BOOL bCubeFound=FALSE;
				for (int j2=0;j2<m_nCubeCount;j2++)
				{
					if (m_pCubes[i1][j1]==m_pCubes[i2][j2])
					{
						bCubeFound=TRUE;
						break;
					}
				}
				if (!bCubeFound)
				{
					bStoneFound=FALSE;
					break;
				}
			}
			if (bStoneFound)
			{
				for (int j=0;j<m_nCubeCount;j++)
					m_pCubes[i2][j]=m_pCubes[m_nMaxVariations-1][j];

				delete[] m_pCubes[m_nMaxVariations-1];

				m_nMaxVariations--;
				i2--;
			}
		}
}

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
// class CUKPuzzleCore
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

CUKPuzzleCore::CUKPuzzleCore(long nFirstStoneOnPos_0,long nLastStoneOnPos_0,LPCTSTR szIniFileName,LPCTSTR szOutputFileName)
:m_nFirstStoneOnPos_0(0),
 m_nLastStoneOnPos_0(0),
 m_nSolutionsFound(0),
 m_bHasFinished(FALSE),
 m_nNextStep(enNextStone),
 m_nXSize(0),
 m_nYSize(0),
 m_nZSize(0),
 m_nEdgeZone(0),
 m_nDX(0),
 m_nDY(0),
 m_nDZ(0),
 m_nPositionCount(0),
 m_nStoneCount(0),
 m_nEntireStoneCount(0),
 m_pBlock(NULL),
 m_pPositions(NULL),
 m_pAvailableStones(NULL),
 m_pUsedStones(NULL),
 m_strIniFileName(szIniFileName),
 m_strOutputFileName(szOutputFileName)
 //m_pBlockPosToPosIndex(NULL)
{
	for (int nQI=0;nQI<enPreDefStones;nQI++)
	{
		m_ppStones[nQI]=0;
	}

	if (nFirstStoneOnPos_0!=-1)
		m_nFirstStoneOnPos_0=nFirstStoneOnPos_0;

	if (nLastStoneOnPos_0!=-1)
		m_nLastStoneOnPos_0=nLastStoneOnPos_0;
}

CUKPuzzleCore::~CUKPuzzleCore()
{
	Deinit();
}

/////////////////////////////////////////////////////////
//Tool Functions
void CUKPuzzleCore::WriteOutput(LPCTSTR szFileName)
{
	//write the one every 100 results into a file
	CStdioFile theFile(szFileName,CFile::modeWrite|CFile::shareDenyWrite|CFile::typeText|CFile::modeCreate|CFile::modeNoTruncate);
	theFile.SeekToEnd();

	CString strTmp;
	CString strResult;

	strResult.Format("Solution : %d\n",m_nSolutionsFound);

	if (m_bShowLegend)
	{
		strResult+="Stone Legend (Presentation=Stone) : ";
		for (int i=0;i<m_nEntireStoneCount;i++)
		{
			if (i==m_nEntireStoneCount-1)
				strTmp.Format("%2d=%2d; ",m_ActiveStoneDesc.nStoneID,m_ActiveStoneDesc.nActiveStone);
			else
				strTmp.Format("%2d=%2d; ",m_pUsedStones[i].nStoneID,m_pUsedStones[i].nActiveStone);
			strResult+=strTmp;
		}
		strResult+="\n";
	} 
	strTmp.Format("__BEGINBLOCK[%d]; __XYZ[%d,%d,%d];\n",m_nSolutionsFound,m_nXSize,m_nYSize,m_nZSize);
	strResult+=strTmp;//This is for an eventual result parser
	for (int yPos=m_nYSize+m_nEdgeZone-1;yPos>=m_nEdgeZone;yPos--)//Reverse
	{
		for (int zPos=m_nEdgeZone;zPos<m_nZSize+m_nEdgeZone;zPos++)
		{
			for (int xPos=m_nEdgeZone;xPos<m_nXSize+m_nEdgeZone;xPos++)
			{
				long nPos=xPos*m_nDX+yPos*m_nDY+zPos*m_nDZ;
				TCHAR sz[3];
				if (m_pBlock[nPos]>99)
					sprintf(sz,"--");
				else if(m_pBlock[nPos]>0)
					sprintf(sz,"%2d",m_pBlock[nPos]);
				else
					sprintf(sz,"  ");

				strTmp.Format(" %s ",sz);
				for (int i=0;i<m_nSymetriePosCount;i++)
					if (nPos==m_SymetriePos[i])
					{
						if (i==0)
							strTmp.Format("[%s]",sz);
						else
							strTmp.Format("(%s)",sz);
						break;
					}
					
				strResult+=strTmp;
			}
			strResult+="    ";
		}
		strResult+="\n";
	}
	strResult+="__ENDBLOCK;\n\n";

	//cout << endl << strResult << endl;
	//getchar();
	theFile.WriteString(strResult);
	theFile.Close();
}
void CUKPuzzleCore::SolutionFound()
{
	m_nSolutionsFound++;

	//////////////////////////////////////////
#ifdef UKPUZ_WRITEOUTPUT
	//////////////////////////////////////////
	if ((m_nWriteEveryNSolution>0) && (m_nSolutionsFound==1 || m_nSolutionsFound%m_nWriteEveryNSolution==0))
	{
		WriteOutput(m_strOutputFileName);
	}
	//////////////////////////////////////////
#endif
	//////////////////////////////////////////

	return ;
}

BOOL CUKPuzzleCore::PreCheck1()
{
	//
	if (m_nUsedStoneCount < m_nFirstPreCheckStone || m_nUsedStoneCount > m_nLastPreCheckStone)
		return TRUE;
		
	for (int i=m_ActiveStoneDesc.nPosIndex+1;i<m_nPositionCount;i++)
		if (m_pBlock[m_pPositions[i]]==0)
			return (__GETQUICKCHECKINDEX(m_pBlock,m_pPositions[i],m_nDX,m_nDY,m_nDZ)!=0x3f);

	return TRUE;
}

BOOL CUKPuzzleCore::PreCheck2()
{
	//
	if (m_nUsedStoneCount < m_nFirstPreCheckStone || m_nUsedStoneCount > m_nLastPreCheckStone)
		return TRUE;
		
	for (int i=m_ActiveStoneDesc.nPosIndex+1;i<m_nPositionCount;i++)
		if (m_pBlock[m_pPositions[i]]==0)
			return (__GETQUICKCHECKINDEX2(m_pBlock,m_pPositions[i],m_nDX,m_nDY,m_nDZ)!=0x3f);

	return TRUE;
}


BOOL CUKPuzzleCore::InsertStone()//Check The Stone Described by the Head of UsedStones List
{
	int i,j;

	long nPos;

	long nCubeCount=m_ActiveStoneDesc.pStones[m_ActiveStoneDesc.nActiveStone].GetCubeCount();

	BOOL bSymetry=FALSE;

	long* pCubes=m_ActiveStoneDesc.pStones[m_ActiveStoneDesc.nActiveStone].GetStone(m_ActiveStoneDesc.nVariation);
	long nPosition=m_ActiveStoneDesc.nPosition;

	for (i=0;i<nCubeCount;i++)
	{
		nPos=nPosition+pCubes[i];
		if (m_pBlock[nPos]!=0)
			return FALSE;

		if (!bSymetry)
			for (j=1;j<m_nSymetriePosCount;j++)
				if (nPos==m_SymetriePos[j])
				{
					if (m_ActiveStoneDesc.nActiveStone<m_nFirstActiveStone)		
						return FALSE;
					
					bSymetry=TRUE;
					break;
				}
	}							

	if (bSymetry)
		m_nSymetryStonesNeeded--;

	if (m_ActiveStoneDesc.nActiveStone>m_nFirstActiveStone)
	{
		if (m_nSymetryStones<m_nSymetryStonesNeeded)
		{
			if (bSymetry)
				m_nSymetryStonesNeeded++;
			return FALSE;
		}

		m_nSymetryStones--;
	}

	for (i=0;i<nCubeCount;i++)
	{
		nPos=nPosition+pCubes[i];
		m_pBlock[nPos]=m_ActiveStoneDesc.nStoneID;
	}

	//BOOL bRetVal=TRUE;
	switch (m_nPreCheckLevel)
	{
		case 1:
			//bRetVal=PreCheck1();
			return PreCheck1();
			//break;
		case 2:
			//bRetVal=PreCheck2();
			return PreCheck1();
			//break;
		default:
			return TRUE;
			//break;
	}
	//if (bRetVal)
	//	m_nTrys++;
	//return bRetVal;

}

void CUKPuzzleCore::RemoveStone()
{
	long nPosition=m_ActiveStoneDesc.nPosition;
	if (m_pBlock[nPosition]!=m_ActiveStoneDesc.nStoneID)
		return;

	int i,j;

	long nPos;

	BOOL bSymetry=FALSE;

	long nStoneCount=m_ActiveStoneDesc.pStones[m_ActiveStoneDesc.nActiveStone].GetCubeCount();
	long* pCubes=m_ActiveStoneDesc.pStones[m_ActiveStoneDesc.nActiveStone].GetStone(m_ActiveStoneDesc.nVariation);

	for (i=0;i<nStoneCount;i++)
	{
		nPos=nPosition+pCubes[i];
		
		if (!bSymetry)
			for (j=1;j<m_nSymetriePosCount;j++)
				if (nPos==m_SymetriePos[j])
				{
					bSymetry=TRUE;
					break;
				}

		m_pBlock[nPos]=0;
	}

	if (bSymetry)
		m_nSymetryStonesNeeded++;

	if (m_ActiveStoneDesc.nActiveStone>m_nFirstActiveStone)
		m_nSymetryStones++;
}

long CUKPuzzleCore::GetNextFreeStone(long nQuickIndex,long nBeginAfter,long nPosition)
{
	if (m_nUsedStoneCount==0 && nBeginAfter==-1)
		nBeginAfter=m_nFirstStoneOnPos_0-1;

	CUKStone* pStones=m_ppStones[nQuickIndex][nPosition];

	if (nBeginAfter<m_nNextFreeStone && pStones[m_nNextFreeStone].GetMaxVariations()>0)
		return m_nNextFreeStone;
	
	for (int i=nBeginAfter+1;i<m_nStoneCount;i++)
		if (m_pAvailableStones[i]>0 && pStones[i].GetMaxVariations()>0)
			return i;				  

	return -1;
}

long CUKPuzzleCore::GetNextFreePosIndex()
{
	if (!m_nUsedStoneCount)
		return 0;

	for (int i=m_ActiveStoneDesc.nPosIndex+1;i<m_nPositionCount;i++)
		if (m_pBlock[m_pPositions[i]]==0)
			return i;

	return -1;
}

void CUKPuzzleCore::SetStoneIsUsedFALSE(long nStone)
{
	m_pAvailableStones[nStone]++;

	if (m_nNextFreeStone > nStone)
		m_nNextFreeStone=nStone;
}

void CUKPuzzleCore::SetStoneIsUsedTRUE(long nStone)
{
	m_pAvailableStones[nStone]--;
	
	if (m_nNextFreeStone == nStone)
	{
		m_nNextFreeStone=m_nStoneCount;
		for (int i=nStone;i<m_nStoneCount;i++)
			if (m_pAvailableStones[i]>0)
			{
				m_nNextFreeStone=i;
				break;
			}
	}
}
//Tool Functions
/////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
//Basic Evaluation Methodes
void CUKPuzzleCore::TryInsertNextStone()
{
	SUKStoneDesc theStoneDesc;

#ifdef UKPUZ_FTL
	do
	{
#endif
		if (m_nUsedStoneCount==m_nEntireStoneCount)
		{

			SolutionFound();

			RemoveStone();

			SetStoneIsUsedFALSE(m_ActiveStoneDesc.nActiveStone);
			m_nUsedStoneCount--;
			m_ActiveStoneDesc=m_pUsedStones[m_nUsedStoneCount-1];
			m_nNextStep=enReplaceStone;

			return;
		}

		theStoneDesc.nVariation=0;
		theStoneDesc.nPosIndex=GetNextFreePosIndex();
		theStoneDesc.nPosition=m_pPositions[theStoneDesc.nPosIndex];
		theStoneDesc.nQuickIndex=__GETQUICKCHECKINDEX(m_pBlock,theStoneDesc.nPosition,m_nDX,m_nDY,m_nDZ);
		theStoneDesc.nActiveStone=GetNextFreeStone(theStoneDesc.nQuickIndex,-1,theStoneDesc.nPosIndex);
		theStoneDesc.nStoneID=m_nUsedStoneCount+1;
		
		if (theStoneDesc.nActiveStone==-1)
		{
			m_nNextStep=enReplaceStone;
			return;
		}

		theStoneDesc.pStones=m_ppStones[theStoneDesc.nQuickIndex][theStoneDesc.nPosIndex];

		SetStoneIsUsedTRUE(theStoneDesc.nActiveStone);

		/////////////////////////////////////////////
		if (m_nUsedStoneCount==0)
		{
			m_nFirstActiveStone=theStoneDesc.nActiveStone;

			m_nSymetryStones=m_nEntireStoneCount-1-m_nFirstActiveStone;
			m_nSymetryStonesNeeded=m_nSymetriePosCount-1;
		}
		/////////////////////////////////////////////

		if (m_nUsedStoneCount>0)
			m_pUsedStones[m_nUsedStoneCount-1]=m_ActiveStoneDesc;

		m_ActiveStoneDesc=theStoneDesc;
		m_nUsedStoneCount++;

#ifdef UKPUZ_FTL
	}
	while (InsertStone());

	TryReplaceStone();
#else 
	if (InsertStone())
		m_nNextStep=enNextStone;
	else
		m_nNextStep=enReplaceStone;
#endif
}

void CUKPuzzleCore::TryReplaceStone()
{
#ifdef UKPUZ_FTL
	do
	{
#endif
		RemoveStone();
		m_ActiveStoneDesc.nVariation++;

		while (m_ActiveStoneDesc.nVariation>=m_ActiveStoneDesc.pStones[m_ActiveStoneDesc.nActiveStone].GetMaxVariations())
		{
			SetStoneIsUsedFALSE(m_ActiveStoneDesc.nActiveStone);

			m_ActiveStoneDesc.nVariation=0;
			m_ActiveStoneDesc.nActiveStone=GetNextFreeStone(m_ActiveStoneDesc.nQuickIndex,m_ActiveStoneDesc.nActiveStone,m_ActiveStoneDesc.nPosIndex);

			if (m_ActiveStoneDesc.nActiveStone==-1)
			{
				m_nUsedStoneCount--;
				m_nNextStep=enReplaceStone;
				
				if (m_nUsedStoneCount==0)
				{
					m_nNextStep=enFinished;
					return;
				}
				else
				{
					m_ActiveStoneDesc=m_pUsedStones[m_nUsedStoneCount-1];
					RemoveStone();
					m_ActiveStoneDesc.nVariation++;
				}

				continue;
			}

			SetStoneIsUsedTRUE(m_ActiveStoneDesc.nActiveStone);

			/////////////////////////////////////////////
			if (m_nUsedStoneCount==1)
			{
				m_nFirstActiveStone=m_ActiveStoneDesc.nActiveStone;

				m_nSymetryStones=m_nEntireStoneCount-1-m_nFirstActiveStone;
				m_nSymetryStonesNeeded=m_nSymetriePosCount-1;
			}
			/////////////////////////////////////////////
		}
#ifdef UKPUZ_FTL
	}
	while (!InsertStone());
	m_nNextStep=enNextStone;
#else
	if (InsertStone())
		m_nNextStep=enNextStone;
	else
		m_nNextStep=enReplaceStone;
#endif
}
//Basic Evaluation Methodes
//////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
UKPUZ_STATE CUKPuzzleCore::DoNextStep()
{
	if (!m_bIsInit)
		return UKPUZ_UNKNOWNERROR;

	switch (m_nNextStep)
	{
		case enNextStone:
			TryInsertNextStone();
			break;
		case enReplaceStone:
			TryReplaceStone();
			break;
		case enFinished:
			m_bHasFinished=TRUE;
			break;
	}

	if (m_nFirstActiveStone>m_nLastStoneOnPos_0 || m_nFirstActiveStone>m_nStoneCount)
	{
		m_nNextStep=enFinished;
		m_bHasFinished=TRUE;
	}

	return UKPUZ_NOERROR;
}
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////

BOOL CUKPuzzleCore::ReadCoordinate(CUKIniAccess& theFile,LPCTSTR szSection,LPCTSTR szKey,SUKPuzzlePos &rPos)
{
	CLongArray theArray;
	if (!theFile.ReadValue(szSection,szKey,theArray))
		return FALSE;

	if (theArray.GetSize()!=3)
		return FALSE;

	rPos=SUKPuzzlePos(theArray[0],theArray[1],theArray[2]);
	return TRUE;
}

BOOL CUKPuzzleCore::ReadStone(CUKIniAccess& theFile,LPCTSTR szSection,LPCTSTR szKey,CUKStone &rStone,long &nStoneCount,long nDX,long nDY,long nDZ,long nPosition,long* pBlock)
{
	CLongArray theArray;
	if (!theFile.ReadValue(szSection,szKey,theArray))
		return FALSE;

	SUKPuzzlePos theCubes[32];//Max 32 Cubes per Stone at the Moment
	if (theArray.GetSize()>(2+32*3) || theArray.GetSize() < 5 || theArray.GetSize() != (theArray[1]*3+2))
		return FALSE;

	for (int i=0;i<theArray[1];i++)
	{
		theCubes[i].x=theArray[i*3+2];
		theCubes[i].y=theArray[i*3+3];
		theCubes[i].z=theArray[i*3+4];
	}
	rStone.SetStone(theCubes,theArray[1],nDX,nDY,nDZ,nPosition,m_pBlock);
	nStoneCount=theArray[0];
	return TRUE;
}

//////////////////////////////////////////////////////////
//(De)Init Functions
BOOL CUKPuzzleCore::PreInitBlock()
{
	CUKIniAccess theIniFile(m_strIniFileName);

	ASSERT (m_nXSize>0 && m_nYSize>0 && m_nZSize>0 && m_nEdgeZone>0);

	m_pBlock=new long[(m_nXSize+2*m_nEdgeZone)*(m_nYSize+2*m_nEdgeZone)*(m_nZSize+2*m_nEdgeZone)];
	if (!m_pBlock)
		return FALSE;

	//m_pBlockPosToPosIndex=new long[(m_nXSize+2*m_nEdgeZone)*(m_nYSize+2*m_nEdgeZone)*(m_nZSize+2*m_nEdgeZone)];
	//if (!m_pBlockPosToPosIndex)
	//	return FALSE;

	CLongArray theArray;

	for (int zPos=0;zPos<m_nZSize+2*m_nEdgeZone;zPos++)
	{
		for (int yPos=0;yPos<m_nYSize+2*m_nEdgeZone;yPos++)
		{
			if (m_bLoadFromIni &&
				zPos>=m_nEdgeZone && zPos<m_nZSize+m_nEdgeZone &&
				yPos>=m_nEdgeZone && yPos<m_nYSize+m_nEdgeZone)
			{
				CString strTmp;
				strTmp.Format("YZLine_%02d_%02d",yPos-m_nEdgeZone,zPos-m_nEdgeZone);
				if (!theIniFile.ReadValue("BlockInfo",strTmp,theArray))
					return FALSE;

				if (theArray.GetSize()!=m_nXSize)
					return FALSE;
			}

			for (int xPos=0;xPos<m_nXSize+2*m_nEdgeZone;xPos++)
			{			
				if (zPos<m_nEdgeZone || zPos>=m_nZSize+m_nEdgeZone ||
					yPos<m_nEdgeZone || yPos>=m_nYSize+m_nEdgeZone ||
					xPos<m_nEdgeZone || xPos>=m_nXSize+m_nEdgeZone)
					m_pBlock[xPos*m_nDX+yPos*m_nDY+zPos*m_nDZ]=-1;//the Edge Zone
				else if (m_bLoadFromIni)
					m_pBlock[xPos*m_nDX+yPos*m_nDY+zPos*m_nDZ]=(theArray[xPos-m_nEdgeZone]>0)?theArray[xPos-m_nEdgeZone]:-1;
				else
					m_pBlock[xPos*m_nDX+yPos*m_nDY+zPos*m_nDZ]=0;//Not Used
			}
		}
	}

	return TRUE;
}

#define __XYZ(X,Y,Z) ((X+m_nEdgeZone)*m_nDX+(Y+m_nEdgeZone)*m_nDY+(Z+m_nEdgeZone)*m_nDZ);

BOOL CUKPuzzleCore::InitPositionOrder()
{
	CUKIniAccess theIniFile(m_strIniFileName);

	ASSERT(m_nPositionCount>0);

	m_pPositions=new long[m_nPositionCount];
	if (!m_pPositions)
		return FALSE;

	CDWordArray arrPositionOrder;
	arrPositionOrder.SetSize(m_nPositionCount);
	if (arrPositionOrder.GetSize()!=m_nPositionCount)
		return FALSE;

	long nPos=0;

	if (m_bLoadFromIni)
	{
		for (int i=0;i<m_nSymetriePosCount;i++)
		{
			CString strTmp;
			strTmp.Format("SymPos%d",i);
			if (!ReadCoordinate(theIniFile,"SymetryInfo",strTmp,m_SymetriePuzzlePos[i]))
				return FALSE;
		}
	}
	else
	{
		m_SymetriePuzzlePos[0]=SUKPuzzlePos(0,			0,			0);
		m_SymetriePuzzlePos[1]=SUKPuzzlePos(0,			m_nYSize-1,	m_nZSize-1);
		m_SymetriePuzzlePos[2]=SUKPuzzlePos(m_nXSize-1,	0,			m_nZSize-1);
		m_SymetriePuzzlePos[3]=SUKPuzzlePos(m_nXSize-1,	m_nYSize-1,	0);
	}

	for (int x=0;x<m_nXSize;x++)
		for (int y=0;y<m_nYSize;y++)
			for (int z=0;z<m_nZSize;z++)
			{
				long nPosition=(x+m_nEdgeZone)*m_nDX+(y+m_nEdgeZone)*m_nDY+(z+m_nEdgeZone)*m_nDZ;
				if (m_pBlock[nPosition]>=0)
				{
					m_pPositions[nPos]=nPosition;
					arrPositionOrder[nPos]=m_pBlock[nPosition];
					//just test if symetriepos[0] is the first pos
					//if not then there is an error

					nPos++;
					for (int i=0;i<m_nSymetriePosCount;i++)
						if (m_SymetriePuzzlePos[i].x==x && m_SymetriePuzzlePos[i].y==y && m_SymetriePuzzlePos[i].z==z)
							m_SymetriePos[i]=nPosition;	

					//m_pBlockPosToPosIndex[nPosition]=nPos-1;
				}
			}

	m_nPositionCount=nPos;//Decrease the Position Count

	for (int i=1;i<m_nPositionCount;i++)
		for (int j=1;j<m_nPositionCount;j++)
			if (arrPositionOrder[j]<arrPositionOrder[j-1])
			{
				long nTemp;
				nTemp=m_pPositions[j];
				m_pPositions[j]=m_pPositions[j-1];
				m_pPositions[j-1]=nTemp;
				nTemp=(long)arrPositionOrder[j];
				arrPositionOrder[j]=arrPositionOrder[j-1];
				arrPositionOrder[j-1]=(DWORD)nTemp;
			}

	if (m_nSymetriePosCount > 0 )
	{
		long nPosition=(m_SymetriePuzzlePos[0].x+m_nEdgeZone)*m_nDX+(m_SymetriePuzzlePos[0].y+m_nEdgeZone)*m_nDY+(m_SymetriePuzzlePos[0].z+m_nEdgeZone)*m_nDZ;
		if (nPosition != m_pPositions[0])
			return FALSE;
	}

	return TRUE;
}

BOOL CUKPuzzleCore::PostInitBlock()
{
	ASSERT (m_nXSize>0 && m_nYSize>0 && m_nZSize>0 && m_nEdgeZone>0 && m_pBlock);

	for (int x=0;x<m_nXSize;x++)
		for (int y=0;y<m_nYSize;y++)
			for (int z=0;z<m_nZSize;z++)
			{
				long nPosition=(x+m_nEdgeZone)*m_nDX+(y+m_nEdgeZone)*m_nDY+(z+m_nEdgeZone)*m_nDZ;
				if (m_pBlock[nPosition] > 0)
					m_pBlock[nPosition]=0;
			}
	return TRUE;
}

SUKPuzzlePos* __cdecl UKPP(SUKPuzzlePos* P,long nCount,...)
{
	va_list args;
	va_start( args, nCount);
	for (int i=0;i<nCount;i++)
	{
		P[i].x=va_arg( args, long);
		P[i].y=va_arg( args, long);
		P[i].z=va_arg( args, long);
	}
	va_end( args);
	return P;
}

#define SET_STONE_I		m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 0,0,0,  1,0,0, 0,1,0, 0,2,0, 1,2,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_II	m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 0,0,0,  1,0,0, 1,1,0, 1,2,0, 2,2,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_III   m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 0,0,0,  1,0,0, 1,1,0, 1,2,0, 1,3,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_IV	m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 0,0,0,  0,1,0, 0,2,0, 0,3,0, 1,2,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_V		m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 0,0,0,  1,0,0, 0,1,0, 0,0,1, 0,1,1),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_VI	m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 1,0,0,  1,1,0, 0,2,0, 1,2,0, 2,2,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_VII	m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 0,0,0,  1,0,0, 0,1,0, 1,1,0, 1,2,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_VIII	m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 0,0,0,  1,0,0, 1,1,0, 2,1,0, 2,2,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_IX	m_ppStones[nQI][i][j++].SetStone(UKPP(P,4, 0,0,0,  1,0,0, 0,1,0, 0,1,1),4,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_X		m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 1,0,0,  0,1,0, 0,2,0, 1,1,0, 2,1,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);
#define SET_STONE_XI	m_ppStones[nQI][i][j++].SetStone(UKPP(P,5, 1,0,0,  0,1,0, 1,1,0, 1,2,0, 2,1,0),5,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);		
#define SET_STONE_XII	m_ppStones[nQI][i][j++].SetStone(UKPP(P,6, 0,0,0,  1,0,0, 0,1,0, 0,2,0, 1,2,0, 0,3,0),6,m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);

BOOL CUKPuzzleCore::InitStones()
{
	CUKIniAccess theIniFile(m_strIniFileName);

	int i,j;

	ASSERT(m_nXSize>0 && m_nYSize>0 && m_nZSize>0);
	ASSERT(m_nStoneCount>0);
	
	m_nEntireStoneCount=0;

	for (int nQI=0;nQI<enPreDefStones;nQI++)
	{
		m_ppStones[nQI]=new CUKStone* [m_nXSize*m_nYSize*m_nZSize];
		if (!m_ppStones[nQI])
			return FALSE;

		for (i=0;i<m_nXSize*m_nYSize*m_nZSize;i++)
			m_ppStones[nQI][i]=NULL;

		for (i=0;i<m_nXSize*m_nYSize*m_nZSize;i++)
		{
			m_ppStones[nQI][i]=new CUKStone[m_nStoneCount];

			if (!m_ppStones[nQI][i])
				return FALSE;
		}
	}

	m_pAvailableStones=new long[m_nStoneCount];
	if (!m_pAvailableStones)
		return FALSE;

	SUKPuzzlePos P[enMaxCubesPerStone];

	CLongArray theStoneOrder;
	if(m_bLoadFromIni)
	{
		if (!theIniFile.ReadValue("StoneInfo","StoneOrder",theStoneOrder))
			return FALSE;
		if (theStoneOrder.GetSize()!=m_nStoneCount)
			return FALSE;
		for (i=0;i<m_nStoneCount;i++)
			if (theStoneOrder[i]<0 || theStoneOrder[i]>=m_nStoneCount)
				return FALSE;
			else
				for (j=i+1;j<m_nStoneCount;j++)
					if (theStoneOrder[i]==theStoneOrder[j])
						return FALSE;
	}
	
	for (i=0;i<m_nPositionCount;i++)
	{
		nQI=0;
		long nPosition=m_pPositions[i];
		if (m_pBlock[nPosition]==0)
		{
			if(m_bLoadFromIni)
			{
				m_nEntireStoneCount=0;
				for (j=0;j<m_nStoneCount;j++)
				{
					CString strTmp;
					strTmp.Format("Stone_%02d",theStoneOrder[j]);

					if (!ReadStone(theIniFile,"StoneInfo",strTmp,m_ppStones[nQI][i][j],m_pAvailableStones[j],m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock))
						return FALSE;
					m_nEntireStoneCount+=m_pAvailableStones[j];
				}
			}
			else
			{
				//////////////////////////////////////////
				//		(CornerPositions)	(Variations)
				j=0;
				SET_STONE_XI	// (0)		(6)
				SET_STONE_VI	// (2/2)	(18)
				SET_STONE_II	// (2/2)	(18)
				SET_STONE_VIII	// (2/2)	(21)
				SET_STONE_IV	// (2)		(36)
				SET_STONE_X		// (1)		(42)
				SET_STONE_IX	// (4)		(18) (3D)
				SET_STONE_I		// (4/2)	(12)
				SET_STONE_III	// (2)		(30)
				SET_STONE_XII	// (3)		(30)
				SET_STONE_V		// (5)		(33) (3D)
				SET_STONE_VII	// (3)		(30)
				//////////////////////////////////////////
			}
			for (j=0;j<m_nStoneCount;j++)
			{
				for (nQI=1;nQI<enPreDefStones;nQI++)
				{
					if ((nQI&1)==1 && m_pBlock[nPosition+m_nDX]==0)
						m_pBlock[nPosition+m_nDX]=-3;
					if ((nQI&2)==2 && m_pBlock[nPosition+m_nDY]==0)
						m_pBlock[nPosition+m_nDY]=-3;
					if ((nQI&4)==4 && m_pBlock[nPosition+m_nDZ]==0)
						m_pBlock[nPosition+m_nDZ]=-3;

					if ((nQI&8)==8 && m_pBlock[nPosition-m_nDX]==0)
						m_pBlock[nPosition+m_nDX]=-3;
					if ((nQI&16)==16 && m_pBlock[nPosition-m_nDY]==0)
						m_pBlock[nPosition+m_nDY]=-3;
					if ((nQI&32)==32 && m_pBlock[nPosition-m_nDZ]==0)
						m_pBlock[nPosition+m_nDZ]=-3;

					m_ppStones[nQI][i][j].SetStone(m_ppStones[0][i][j],m_nDX,m_nDY,m_nDZ,nPosition,m_pBlock);

					if ((nQI&32)==32 && m_pBlock[nPosition-m_nDZ]==-3)
						m_pBlock[nPosition+m_nDZ]=0;
					if ((nQI&16)==16 && m_pBlock[nPosition-m_nDY]==-3)
						m_pBlock[nPosition+m_nDY]=0;
					if ((nQI&8)==8 && m_pBlock[nPosition-m_nDX]==-3)
						m_pBlock[nPosition+m_nDX]=0;

					if ((nQI&4)==4 && m_pBlock[nPosition+m_nDZ]==-3)
						m_pBlock[nPosition+m_nDZ]=0;
					if ((nQI&2)==2 && m_pBlock[nPosition+m_nDY]==-3)
						m_pBlock[nPosition+m_nDY]=0;
					if ((nQI&1)==1 && m_pBlock[nPosition+m_nDX]==-3)
						m_pBlock[nPosition+m_nDX]=0;					
				}
			}
			m_pBlock[nPosition]=-2;
		}
	}

	if (!m_bLoadFromIni)
	{
		m_nEntireStoneCount=12;
		for (i=0;i<m_nStoneCount;i++)
			m_pAvailableStones[i]=1;
	}

	for (i=0;i<m_nPositionCount;i++)
	{
		long nPosition=m_pPositions[i];
		if (m_pBlock[nPosition]==-2)
			m_pBlock[nPosition]=0;
	}

	m_pUsedStones=new SUKStoneDesc[m_nEntireStoneCount];
	if (!m_pUsedStones)
		return FALSE;

	return TRUE;
}

BOOL CUKPuzzleCore::Init(long nFirstStoneOnPos_0,long nLastStoneOnPos_0,LPCTSTR szIniFileName,LPCTSTR szOutputFileName)
{		
	m_nTrys=0;

	m_strOutputFileName=szOutputFileName;

	m_strIniFileName=szIniFileName;
	if (m_strIniFileName!="")
		m_bLoadFromIni=TRUE;

	Deinit();
	//Init vars

	CUKIniAccess theIniFile(m_strIniFileName);
	BOOL bIniOK=TRUE;
	
	if (m_bLoadFromIni)
	{
		bIniOK = bIniOK && theIniFile.ReadValue("BlockInfo","XSize",&m_nXSize);
		bIniOK = bIniOK && theIniFile.ReadValue("BlockInfo","YSize",&m_nYSize);
		bIniOK = bIniOK && theIniFile.ReadValue("BlockInfo","ZSize",&m_nZSize);
		bIniOK = bIniOK && theIniFile.ReadValue("BlockInfo","EdgeZone",&m_nEdgeZone);

		bIniOK = bIniOK && theIniFile.ReadValue("StoneInfo","StoneCount",&m_nStoneCount);

		bIniOK = bIniOK && theIniFile.ReadValue("SymetryInfo","EnhancedSymetryCheck",&m_bEnhancedSymertyCheck);
		bIniOK = bIniOK && theIniFile.ReadValue("SymetryInfo","SymetryPosCount",&m_nSymetriePosCount);

		if (m_strOutputFileName=="" || !theIniFile.ReadValue("OutputInfo","WriteEveryNSolution",&m_nWriteEveryNSolution))
			m_nWriteEveryNSolution=0;

		m_bShowLegend=theIniFile.ReadValueDef("StoneInfo","ShowLegend",1L);

		m_nPreCheckLevel=theIniFile.ReadValueDef("StoneInfo","PreCheckLevel",(int)0);
		m_nFirstPreCheckStone=theIniFile.ReadValueDef("StoneInfo","FirstPreCheckStone",1);
		m_nLastPreCheckStone=theIniFile.ReadValueDef("StoneInfo","LastPreCheckStone",m_nStoneCount-2);
	}

	if (!bIniOK || !m_bLoadFromIni)
	{
		//Use the Default Parameter
		m_nXSize=5,
		m_nYSize=4,
		m_nZSize=3,
		m_nEdgeZone=3,
		m_nStoneCount=12;
		m_nSymetriePosCount=4;
		m_bEnhancedSymertyCheck=FALSE;

		m_nWriteEveryNSolution=0;
		m_bShowLegend=0;

		m_bLoadFromIni=FALSE;

		m_nPreCheckLevel=2;
		m_nFirstPreCheckStone=3;
		m_nLastPreCheckStone=10;
	}

	m_nDX=1;
	m_nDY=1*(m_nXSize+2*m_nEdgeZone);
	m_nDZ=1*(m_nXSize+2*m_nEdgeZone)*(m_nYSize+2*m_nEdgeZone);
	m_nPositionCount=m_nXSize*m_nYSize*m_nZSize;

	///////////////////////////////////////////////////////////////
	if (nFirstStoneOnPos_0>=0 && nFirstStoneOnPos_0<m_nStoneCount)
		m_nFirstStoneOnPos_0=nFirstStoneOnPos_0;
	else
		m_nFirstStoneOnPos_0=0;
	///////////////////////////////////////////////////////////////
	if (nLastStoneOnPos_0>=0 && nLastStoneOnPos_0<m_nStoneCount)
		m_nLastStoneOnPos_0=min(nLastStoneOnPos_0,m_nStoneCount-m_nSymetriePosCount);
	else
		m_nLastStoneOnPos_0=m_nStoneCount-m_nSymetriePosCount;
	///////////////////////////////////////////////////////////////

	if (m_nXSize<=0 || m_nYSize<=0 || m_nZSize<=0 || m_nEdgeZone<=0)
		return FALSE;

	if (m_nDX<=0 || m_nDY<=0 || m_nDZ<=0)
		return FALSE;

	if (m_nPositionCount<=0 || m_nStoneCount<=0)
		return FALSE;

	if (m_nSymetriePosCount<0 || m_nSymetriePosCount>=8)
		return FALSE;

	//////////////////////////////////////////////////////////

	//////////////////////////////////////////
#ifdef UKPUZ_WRITEOUTPUT
	//////////////////////////////////////////
	if (m_nWriteEveryNSolution >0)
	{
		CStdioFile theFile(m_strOutputFileName,CFile::modeCreate);
		theFile.Close();
	}
	//////////////////////////////////////////
#endif
	//////////////////////////////////////////

	m_nUsedStoneCount=0;
	m_nNextFreeStone=0;
	m_nSolutionsFound=0;
	m_nNextFreePosIndex=0;

	BOOL bOK=TRUE;

	if ((m_nFirstStoneOnPos_0 > m_nStoneCount-m_nSymetriePosCount) ||
		(m_nFirstStoneOnPos_0 > m_nLastStoneOnPos_0))
	{
		//No more initialization needed at this time
		m_bHasFinished=TRUE;
		m_nNextStep=enFinished;
	}
	else
	{
		m_bHasFinished=FALSE;
		m_nNextStep=enNextStone;

		bOK = bOK && PreInitBlock();
		bOK = bOK && InitPositionOrder();
		bOK = bOK && PostInitBlock();
		bOK = bOK && InitStones();
	}

	m_nSymetryStones=m_nEntireStoneCount;
	m_nSymetryStonesNeeded=m_nSymetriePosCount-1;

	if (!bOK)
	{
		Deinit();
		return FALSE;
	}

	m_bIsInit=TRUE;
	return TRUE;
}

void CUKPuzzleCore::DeinitStones()
{
	for (int nQI=0;nQI<enPreDefStones;nQI++)
	{
		if (m_ppStones[nQI])
		{
			for (int i=0;i<m_nXSize*m_nYSize*m_nZSize;i++)
			{
				if (m_ppStones[nQI][i])
					delete[] m_ppStones[nQI][i];
				m_ppStones[nQI][i]=NULL;
			}
			delete[] m_ppStones[nQI];
		}
		m_ppStones[nQI]=NULL;
	}
	if (m_pAvailableStones)
		delete[] m_pAvailableStones;
	m_pAvailableStones=NULL;

	if (m_pUsedStones)
		delete[] m_pUsedStones;
	m_pUsedStones=NULL;
}

void CUKPuzzleCore::DeinitPositionOrder()
{
	if (m_pPositions)
		delete[] m_pPositions;
	m_pPositions=NULL;
}

void CUKPuzzleCore::DeinitBlock()
{
	if (m_pBlock)
		delete m_pBlock;
	m_pBlock=NULL;
	//if (m_pBlockPosToPosIndex)
	//	delete m_pBlockPosToPosIndex;
	//m_pBlockPosToPosIndex=NULL;

}

void CUKPuzzleCore::Deinit()
{
	DeinitStones();
	DeinitPositionOrder();
	DeinitBlock();
	
	m_bIsInit=FALSE;
}
//(De)Init Functions end
//////////////////////////////////////////////////////////
