/////////////////////////////////////////////////////////////////////////////
//Projectname 	: 
//Filename		: UKPuzzleAdmin.h 
//Classname		: CIUKPuzzleAdmin
//				: CUKPuzzleAdmin
//Author		: Ulrich Kraemer [uk]
//Date			: 25.03.2003
//Changes		: 
//////////////////////////////////////////////////////////////////////////////
//Synchronization and error handling is not implemenmted yet

#ifndef UKPUZZLEADMIN_H
#define UKPUZZLEADMIN_H

#include "UKPuzzleDef.h"
#include "UKPuzzleCore.h"

//////////////////////////////////////////////////////////////////////////////
//puzzle administration class
class CIUKPuzzleAdmin
{
	public:
		enum
		{
			enUndefined =0,
			enRunning = 1,
			enPaused = 2,	
			enFinished= 3,
			enError= 4,
		};

		enum 
		{
			enCmd_Start=1,
			enCmd_Pause=2,
			enCmd_Continue=3,
			enCmd_Stop=4,
		};
	protected:
		CIUKPuzzleAdmin(long nFirstStoneOnPos_0=-1,long nLastStoneOnPos_0=-1,LPCTSTR szIniFileName="",LPCTSTR szOutputFileName="");
		~CIUKPuzzleAdmin();

	public:
		DWORD GetSolutions();
		DWORD GetProgressState();

		//Commands
		virtual UKPUZ_STATE StartPuzzle(DWORD nTime2Wait=UKPUZ_MAXWAITINGTIME); //Start Thread or Programm
		virtual UKPUZ_STATE PausePuzzle(DWORD nTime2Wait=UKPUZ_MAXWAITINGTIME);
		virtual UKPUZ_STATE ContinuePuzzle(DWORD nTime2Wait=UKPUZ_MAXWAITINGTIME);
		virtual UKPUZ_STATE StopPuzzle(DWORD nTime2Wait=UKPUZ_MAXWAITINGTIME);

		virtual UKPUZ_STATE CommandSetAndWait(DWORD Cmd,DWORD nTime2Wait);
	protected:
		//Information Services
		virtual void Write(LPCTSTR szOutText)=0;
		virtual void WriteLn(LPCTSTR szOutText)=0;
		virtual void SolutionFound()=0;

		virtual void PuzzleIsRunning();
		virtual void PuzzleHasPaused();
		virtual void PuzzleHasFinished();
		virtual void PuzzleHasStopped();

		///////////////////////
		//must be publicated in a derived class
		virtual void MainLoop();

	protected:
		CUKPuzzleCore m_PuzzleCore;

		DWORD	m_nCmd;
		DWORD	m_nProgressState;
};

//////////////////////////////////////////////////////////////////////////////
//derived administration class
//is used to interact with the Window
class CUKPuzzleAdmin
:public CIUKPuzzleAdmin
{
	private:
		CUKPuzzleAdmin();
		CUKPuzzleAdmin(const CUKPuzzleAdmin&);
		CUKPuzzleAdmin& operator=(const CUKPuzzleAdmin&);

	public:
		CUKPuzzleAdmin(CWnd*,long nFirstStoneOnPos_0=-1,long nLastStoneOnPos_0=-1,LPCTSTR szIniFileName="",LPCTSTR szOutputFileName="");
		~CUKPuzzleAdmin();

	public:
		//Commands
		virtual UKPUZ_STATE StartPuzzle(DWORD nTime2Wait=UKPUZ_MAXWAITINGTIME);//Start thread
	protected:
		//Information Services
		virtual void Write(LPCTSTR szOutText);
		virtual void WriteLn(LPCTSTR szOutText);
		virtual void SolutionFound();

		virtual void PuzzleIsRunning();
		virtual void PuzzleHasPaused();
		virtual void PuzzleHasFinished();
		virtual void PuzzleHasStopped();
	private:
		//Thread Function
		static UINT __cdecl RunPuzzleAdmin(LPVOID pVoid);

		CWnd*	m_pMessageReceiver;
	public:
		//Test and Control functions
};

#endif