/////////////////////////////////////////////////////////////////////////////
//Projectname 	: 
//Filename		: UKIniAccess.cpp 
//Classname		: CUKPuzzleCore
//Author		: Ulrich Kraemer [uk]
//Date			: 04.04.2003
//Changes		: 
//////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "UKIniAccess.h"

CUKIniAccess::CUKIniAccess(LPCTSTR strFileName)
{
	ASSERT(strFileName);
	m_strFileName=strFileName;
}

CUKIniAccess::~CUKIniAccess()
{}

CUKIniAccess::Init(LPCTSTR strFileName)
{
	m_strFileName=strFileName;
}

//Common methodes
BOOL CUKIniAccess::ReadValue(LPCTSTR szSection,LPCTSTR szKey,int* pValue)
{
	if (m_strFileName=="")
		return FALSE;

	ASSERT(pValue);

	CString str;
	if (!ReadValue(szSection,szKey,str))
		return FALSE;

	sscanf(str,"%i",pValue);

	return TRUE;
}

BOOL CUKIniAccess::ReadValue(LPCTSTR szSection,LPCTSTR szKey,long* pValue)
{
	if (m_strFileName=="")
		return FALSE;

	ASSERT(pValue);

	CString str;
	if (!ReadValue(szSection,szKey,str))
		return FALSE;

	sscanf(str,"%i",pValue);

	return TRUE;
}

BOOL CUKIniAccess::ReadValue(LPCTSTR szSection,LPCTSTR szKey,CString& rValue)
{
	if (m_strFileName=="")
		return FALSE;

	TCHAR sz[1024];

	DWORD nValue = GetPrivateProfileString(szSection,szKey,"",sz,1024,m_strFileName);
	if (nValue<=0)//empty or invalid key
	{
#ifdef _DEBUG
		static int nErrorString=0;
		CString str;str.Format("%03d %s",++nErrorString,szSection);
		WritePrivateProfileString("SectionKey_NotFound",str,szKey,m_strFileName);
#endif
		return FALSE;
	}

	if (nValue>=1023)
		sz[1023]='\0';

	rValue=sz;

	return TRUE;
}

BOOL CUKIniAccess::ReadValue(LPCTSTR szSection,LPCTSTR szKey,CLongArray& rValue)
{
	if (m_strFileName=="")
		return FALSE;

	CString str;
	if (!ReadValue(szSection,szKey,str))
		return FALSE;

	TCHAR *psz=str.GetBuffer(20);
	TCHAR *psz2=psz;

	rValue.RemoveAll();

	while (psz2)
	{
		psz2=strchr(psz,',');
		if (psz2)
			*psz2='\0';

		long nVal;
		sscanf(psz,"%i",&nVal);
		rValue.Add(nVal);

		psz=psz2+1;
	}

	str.ReleaseBuffer();

	return TRUE;
}

