// ConsoleApp.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <stdlib.h>
#include "ConsoleApp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "..\UKPuzzleCore.h"

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

#define UKTESTENVIRONMENNT

CWinApp theApp;

using namespace std;

int __cdecl _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
		TCHAR szPATH[_MAX_PATH];
		TCHAR szDRIVE[_MAX_DRIVE];
		TCHAR szDIR[_MAX_DIR];
		TCHAR szFNAME[_MAX_FNAME];
		TCHAR szEXT[_MAX_EXT];


		if (argc>=1)
		{
			//Windows has different behaviors, setting the current directory
			//therefor I set the application path as current directory

			//Application Name and Path
			_splitpath(argv[0],szDRIVE,szDIR,szFNAME,szEXT);
			_makepath(szPATH,szDRIVE,szDIR,NULL,NULL);
			SetCurrentDirectory(szPATH);
		}

		CString strIniFileName="";
		long nStoneCount=12;
		if (argc>=2)
		{
			strIniFileName=argv[1];
			CUKIniAccess theIniFile(strIniFileName);
			theIniFile.ReadValue("StoneInfo","StoneCount",&nStoneCount);
		}

		// TODO: code your application's behavior here.
		CUKPuzzleCore theCore;
		long nStartTime=GetTickCount();
		long nCounter1=0;
		long nCounter2=0;
		long nCounter3=0;
		long nSum=0;

#ifdef UKTESTENVIRONMENNT
		if (!theCore.Init(0,0,strIniFileName,".\\Output.txt"))
			return -1;
#else
		if (!theCore.Init(0,nStoneCount,strIniFileName,".\\Output.txt"))
			return -1;
#endif

		cout << "Initialisierung erfolgreich"<< endl;

#ifdef UKTESTENVIRONMENNT
		while (TRUE)
#else
		while (!theCore.HasFinished())
#endif
		{
			theCore.DoNextStep();
#ifdef UKTESTENVIRONMENNT
			if (theCore.HasFinished())
			{
				nCounter1=MAXLONG-1;//will be incremented later
				nCounter2=MAXLONG-1;//will be incremented later
			}	
#endif

			nCounter1++;

#ifdef _DEBUG
	#ifdef	UKPUZ_FTL
			if (nCounter1>=10000)
	#else
			if (nCounter1>=100000)
	#endif
#else	  
	#ifdef	UKPUZ_FTL
			if (nCounter1>=100000)
	#else
			if (nCounter1>=1000000)
	#endif
#endif
			{
				cout <<	".";
				nCounter1=0;
				nCounter2++;
				if (nCounter2>=74)
				{
					//cout <<".";
					nCounter2=0;
					CString str0;
					CString str1;
					CString str2;
					str0.Format("%6d",nSum+theCore.GetSolutions());
					str1.Format("%7.1f",(GetTickCount()-nStartTime)/1000.0);
					str2.Format("%5.1f",(nSum+theCore.GetSolutions())/((GetTickCount()-nStartTime)/1000.0));
					cout << endl << (LPCTSTR)str0 << " Loesungen in " << (LPCTSTR)str1 <<" sekunden gefunden ";
					cout << "==> " << (LPCTSTR)str2 << " Ergebinsse/sekunde" << endl;
					cout << "Kilo Trys:" << (DWORD)(theCore.m_nTrys/1000) <<endl;
#ifdef UKTESTENVIRONMENNT
					nSum+=theCore.GetSolutions();
					nCounter3++;
					theCore.Init(nCounter3,nCounter3,strIniFileName,"");
#endif
				}
			}
#ifdef UKTESTENVIRONMENNT
		if (nCounter3>=nStoneCount)
			break;
#endif
		}

#ifdef UKTESTENVIRONMENNT
		cout << endl << "Endergebins:" << nSum << " Loesungen in " << (GetTickCount()-nStartTime)/1000 <<" sekunden gefunden" << endl;
#else
		cout << endl << "Endergebins:" << theCore.GetSolutions() << " Loesungen in " << (GetTickCount()-nStartTime)/1000 <<" sekunden gefunden" << endl;
#endif

		cout << "Kilo Trys:" << (DWORD)(theCore.m_nTrys/1000) <<endl;

		cout << endl << "Enter druecken zum beenden:" << endl;
		getchar();
		theCore.Deinit();
	}

	return nRetCode;
}


