#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define TEILE 12
#define BX 3
#define BY 4
#define BZ 5
#define BLOECKE BX*BY*BZ
#define pwr2(x) ((uint64)1 << (x))
#define TEILKOMB ((int) pwr2(TEILE))
#define FELDMASK (pwr2(BLOECKE) - 1)
#define FELDMASKSM ((bitvsm) pwr2(BLOECKE-32) - 1)

typedef unsigned __int64 uint64;
typedef uint64 bitv;

typedef unsigned long bitvsm;
typedef int *vector;

char teile[] =
  "##.. ...." ".##. ...." "#... ...." "###. ...."
  "#... ...." "##.. ...." "##.. ...." ".#.. ...."
  "##.. ...." ".#.. ...." "#... ...." ".#.. ...."
  ".... ...." ".... ...." "##.. ...." ".... ...."

  ".##. ...." "##.. ...." "##.. #..." ".#.. ...."
  ".#.. ...." "##.. ...." "##.. ...." "###. ...."
  "##.. ...." "#... ...." ".... ...." ".#.. ...."
  ".... ...." ".... ...." ".... ...." ".... ...."
  
  "##.. #..." "##.. ...." ".##. ...." "#... ...."
  ".... #..." "#... ...." "##.. ...." "##.. ...."
  ".... ...." "#... ...." "#... ...." "#... ...."
  ".... ...." "#... ...." ".... ...." "#... ....";


clock_t start;
unsigned int loesungen = 0;
unsigned int tries = 0;

bitv teilposits[TEILE][BLOECKE * 24];
int teilpositsnum[TEILE];

bitv *posits[BLOECKE][TEILKOMB];
bitvsm *positssm[BLOECKE][TEILKOMB];

int bitpos[BX][BY][BZ];
bitv vorbelegung = 0;

int M[4][4];

uint64 oneshl[64];

int teilmitmaxposits = TEILE, teilmitmaxpositsnum = 0;
int teilmitminposits = TEILE, teilmitminpositsnum = 10000;

int
bittest (bitv p, int bit)
{
  return (p & oneshl[bit]) != 0;
}


// liefert bitnr. fr koordinaten x,y,z oder -1 wenn koord nicht im wrfel

int
bitpos_checked (int x, int y, int z)
{
  if (x >= BX || y >= BY || z >= BZ || x < 0 || y < 0 || z < 0)
	return -1;

  return bitpos[x][y][z];
}


// vector nach bitv
bitv
bitvec (vector v)
{
  int b;

  b = bitpos_checked (v[0], v[1], v[2]);
  return b == -1 ? 0 : oneshl[b];
}

void
setvector (vector v, int x, int y, int z, int u)
{
  v[0] = x;  v[1] = y;  v[2] = z;  v[3] = u;
}

void
copyvector (vector v, vector w)
{
  v[0] = w[0];  v[1] = w[1];  v[2] = w[2];  v[3] = w[3];
}

// spiegelt einen bitv entlang den koor-achsen
bitv
flip_bitv (bitv p, int sx, int sy, int sz)
{
  int x, y, z;
  int v[4];
  bitv u;

  u = 0;

  for (x = 0; x < BX; x++)
	for (y = 0; y < BY; y++)
	  for (z = 0; z < BZ; z++)
	{
	  setvector (v, x, y, z, 1);
	  if (p & bitvec (v))
		{
		  setvector (v, sx ? BX - x - 1 : x, sy ? BY - y - 1 : y,
			 sz ? BZ - z - 1 : z, 1);
		  u |= bitvec (v);
		}
	}

  return u;
}

// matrix-multiplikation mit M
void
mmul (vector w, vector v)
{
  int i, j;

  for (i = 0; i < 4; i++)
	{
	  w[i] = 0;
	  for (j = 0; j < 4; j++)
	w[i] += v[j] * M[j][i];
	}
}


// projeziert mit M das teil in eine position und fgt es in teilposits,
// wenn es passt
void
doprojteil (int teil)
{
  char c;
  int x, y, z;
  bitv p, pos = 0;
  bitv *pp;
  int v[4], w[4];

  for (x = 0; x < 4; x++)
	for (y = 0; y < 4; y++)
	  for (z = 0; z < 2; z++)
		{
		  c = teile[x + z * 5 + (teil % 4) * 9 + (y + (teil / 4) * 4) * 9 * 4];
		  if (c != '#')	continue;

		  setvector (v, x, y, z, 1);
		  mmul (w, v);
		  p = bitvec (w);
		  if (!p) return;
		  pos |= p;
		}

  if (p & vorbelegung) return;

  pp = teilposits[teil];

  while (p = *pp++)
	{
	  if (p == pos) break;

	  if (teil == teilmitminposits && (
	  		p == flip_bitv (pos, 1, 1, 0) ||
			p == flip_bitv (pos, 1, 0, 1) ||
			p == flip_bitv (pos, 0, 1, 1) ) )
		{
		  if ((pos & -pos) < (p & -p)) *(pp - 1) = pos;
		  break;
		}

	  if (teil == teilmitmaxposits && (
	  	(p == flip_bitv (pos, 1, 1, 0) && vorbelegung == flip_bitv (vorbelegung, 1, 1, 0)) ||
	  	(p == flip_bitv (pos, 1, 0, 1) && vorbelegung == flip_bitv (vorbelegung, 1, 0, 1)) ||
	  	(p == flip_bitv (pos, 0, 1, 1) && vorbelegung == flip_bitv (vorbelegung, 0, 1, 1)) ) )
		{
		  if ((pos & -pos) > (p & -p)) *(pp - 1) = pos;
		  break;
		}
	}

  if (!p)
	{
	  *(pp - 1) = pos;
	  *pp = 0;
	}
}


void
dotransteil (int teil)
{
  int tx, ty, tz;
	  
  for (tz = 0; tz < BZ; tz++)
	for (ty = 0; ty < BY; ty++)
	  for (tx = 0; tx < BX; tx++)
		{
		  setvector (M[3], tx, ty, tz, 1);
		  doprojteil (teil);
		}
}


void
dorotteil (int teil)
{
  int basevec[6][4] = {
	{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0},
	{-1, 0, 0, 0}, {0, -1, 0, 0}, {0, 0, -1, 0}
  };

  int mx, my;

  for (mx = 0; mx < 6; mx++)
	{
	  copyvector (M[0], basevec[mx]);
	  for (my = 0; my < 6; my++)
		{
		  copyvector (M[1], basevec[my]);

		  // px und py mssen l.u. sein
		  if (M[0][0] * M[1][0] + M[0][1] * M[1][1] + M[0][2] * M[1][2] != 0)
			continue;

		  // pz = px kreuz py
		  M[2][0] = M[0][1] * M[1][2] - M[0][2] * M[1][1];
		  M[2][1] = M[0][2] * M[1][0] - M[0][0] * M[1][2];
		  M[2][2] = M[0][0] * M[1][1] - M[0][1] * M[1][0];
		  M[2][3] = 0;
			  
		  dotransteil (teil);
		}
	}
}


void
gen_teilposits (void)
{
  int teil, anz, anzsumme = 0;

  for (teil = 0; teil < TEILE; teil++)
	{
	  // if (teil == teilmitminposits) continue;
	  dorotteil (teil);
	  anz = 0;
	  while (teilposits[teil][anz])	anz++;
	  anzsumme += anz;
	  teilpositsnum[teil] = anz;
	  printf ("%d moegliche Positionen fuer Teil %d\n", anz, teil);
	}
  printf ("insgesamt moegliche Positionen: %d\n", anzsumme);
}


bitv *
gen_posits (int bit, int tb)
{
  int i, teil;
  bitv p;
  bitv *tpos, *t, *pp;

  tpos = (bitv *) malloc ((BLOECKE * 24) * sizeof (bitv));
  t = tpos;

  for (teil = 0; teil < TEILE; teil++)
	{
	  // teil schon benutzt?
	  if ((1 << teil) & tb)	continue;

	  pp = teilposits[teil];
	  while (p = *pp++)
		{
		  // posit muss bit 'bit' gesetzt haben
		  if (!bittest (p, bit)) continue;

		  // alle niedrigeren bits muessen 0 sein
		  if ((oneshl[bit] - 1) & p) continue;

		  *t++ = p | ((bitv) teil << BLOECKE);
		}
	}

  *t++ = 0;

  posits[bit][tb] = (bitv *) realloc (tpos, (t - tpos) * sizeof (bitv));

  // printf("posits   : bit %d  tb %3x  n %d\n", bit, tb, t-tpos);

  return posits[bit][tb];
}


bitvsm *
gen_positssm (int bit, int tb)
{
  int i, teil;
  bitv p, *pp;
  bitvsm *tpos, *t;

  tpos = (bitvsm *) malloc ((BLOECKE * 24) * sizeof (bitvsm));
  t = tpos;

  for (teil = 0; teil < TEILE; teil++)
	{
	  // teil schon benutzt?
	  if ((1 << teil) & tb)	continue;

	  pp = teilposits[teil];
	  while (p = *pp++)
		{
		  // posit muss bit 'bit' gesetzt haben
		  if (!bittest (p, bit)) continue;

		  // alle niedrigeren bits muessen 0 sein
		  if ((oneshl[bit] - 1) & p) continue;
			
		  *t++ = (p | ((bitv) teil << BLOECKE)) >> 32;
		}
	}

  *t++ = 0;

  positssm[bit][tb] = (bitvsm *) realloc (tpos, (t - tpos) * sizeof (bitvsm));

  // printf("positsm  : bit %d  tb %3x  n %d\n", bit, tb, t-tpos);

  return positssm[bit][tb];
}


void
recsolveinner (bitvsm feld, int tb)
{
  bitvsm p, mi;
  bitvsm *pp, *p1, *p2;
  int i, teil, bit;

  if (tb == (1 << TEILE) - 1)
  {
	loesungen++;
	#ifdef DEBUG
	printf("tb %08X  feld %08lX  LOESUNG!!!\n", tb, feld);
	#endif
	if ((loesungen % 737) == 0)
	{
	  double d;

	  d = (double) (clock () - start) / CLOCKS_PER_SEC;
	  printf ("%u Loesungen in %.2fs, %.2f/s, %u Aufrufe...\n",
		  loesungen, d, loesungen / d, tries);
	}
	return;
  }

  __asm
  {
	mov eax, feld
	not eax
	bsf eax, eax
	add eax, 32
	mov bit, eax
  }

  #ifdef DEBUG
  printf("bit %2d  tb %08X  feld %08lX\n", bit, tb, feld);
  #endif

  if (!(pp = positssm[bit][tb]))
	pp = gen_positssm (bit, tb);

  tries++;

  while (1)
	{
	  while ((p = *pp++) & feld);

	  if (!p) break;

	  teil = p >> (BLOECKE - 32);

	  recsolveinner (feld | p & FELDMASKSM, tb | (1 << teil));
	}
}


void
recsolve (bitv feld, int tb)
{
  bitv p, mi;
  bitv *pp, *p1, *p2;
  int i, teil, bit;

  __asm
  {
	mov eax, dword ptr feld
	not eax
	bsf eax, eax
	mov edx, -1
	cmovz eax, edx
	mov bit, eax
  }

  #ifdef DEBUG
  printf("bit %2d  tb %08X  feld %016I64X\n", bit, tb, feld);
  #endif

  if (bit == -1)
	{
	  // alle untern 32 bit sind gesetzt, weiter in der inneren schleife
	  recsolveinner ((int)(feld >> 32), tb);
	  return;
	}

  if (!(pp = posits[bit][tb]))
	pp = gen_posits (bit, tb);

  tries++;

  while (1)
	{
	  while ((p = *pp++) & feld);

	  if (!p) break;

	  teil = p >> BLOECKE;

	  recsolve (feld | p & FELDMASK, tb | (1 << teil));

#ifdef TEST
	if (bit == 0)
	return;
#endif
	}
}


void
gen_bitpos(void)
{
  int x,y,z;
  int ind[BX][BY] = { { 2, 3, 4, 5 },
                 	  { 1,10,11, 6 },
                      { 0, 9, 8, 7 }  };

  for (x=0; x<BX; x++)
    for (y=0; y<BY; y++)
      for (z=0; z<BZ; z++)
      {
      	bitpos[x][y][z] = ind[x][y] + z*BX*BY;
      }
}


void
solve (void)
{
  int anz, i, tb, minteil;

  gen_bitpos();

  gen_teilposits();

  for (i=0; i<TEILE; i++)
  {
  	anz = teilpositsnum[i];

	if (anz > teilmitmaxpositsnum)
	{
		teilmitmaxpositsnum = anz;
		teilmitmaxposits = i;
	}
	if (anz < teilmitminpositsnum)
	{
		teilmitminpositsnum = anz;
		teilmitminposits = i;
	}
  }

  for (i=0; i<TEILE; i++)
  {
  	teilposits[i][0] = 0;
  }
  gen_teilposits();

  printf("max %d teil %d min %d teil %d\n",
    teilmitmaxpositsnum, teilmitmaxposits, teilmitminpositsnum, teilmitminposits);

  for (minteil = 0; minteil < teilpositsnum[teilmitminposits]; minteil++)
  {
  	#ifdef PARA_ODD
  	if (minteil & 1) continue;
  	#endif

  	#ifdef PARA_EVEN
  	if (!(minteil & 1)) continue;
  	#endif

  	for (i=0; i<BLOECKE; i++)
  	  for (tb=0; tb<TEILKOMB; tb++)
  	  {
  	  	if (posits[i][tb])
  	  	{
  	  		free(posits[i][tb]);
  	  		posits[i][tb] = NULL;
  	  	}

  	  	if (positssm[i][tb])
  	  	{
  	  		free(positssm[i][tb]);
  	  		positssm[i][tb] = NULL;
  	  	}
  	  }

  	  for (i=0; i<TEILE; i++)
  	  {
  	  	if (i == teilmitminposits) continue;
  	  	teilposits[i][0] = 0;
  	  }

  	  printf ("Lauf %d von %d\n", minteil+1, teilpositsnum[teilmitminposits]);
  	  vorbelegung = teilposits[teilmitminposits][minteil];
  	  gen_teilposits();
      tb = 1 << teilmitminposits;
  	  recsolve (vorbelegung, tb);
  }
}


int main(int argc, char **argv)
{
  int i;
  double d;

  for (i = 0; i < 64; i++)
	oneshl[i] = pwr2(i);

  start = clock ();

  solve ();

  d = (double) (clock () - start) / CLOCKS_PER_SEC;
  printf ("\n\n**** ENDE ******\n");
  printf ("%u Loesungen gefunden, %.2f Loesungen/s.\n",
  	loesungen, loesungen / d);
  printf ("Laufzeit: %.2fs, %u Aufrufe", d, tries);

  return 0;
}
