// ctpuzzleDlg.cpp : Implementierungsdatei
//

#include "stdafx.h"
#include "ctpuzzle.h"
#include "ctpuzzleDlg.h"

#include "PuzzleClasses.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCtpuzzleDlg Dialogfeld

CCtpuzzleDlg::CCtpuzzleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCtpuzzleDlg::IDD, pParent), m_Output(&m_Solver)
{
	//{{AFX_DATA_INIT(CCtpuzzleDlg)
	m_SolutionStatus = _T("");
	m_SolutionTime = _T("");
	m_SolutionTries = _T("");
	m_SolutionCount = _T("");
	//}}AFX_DATA_INIT
	// Beachten Sie, dass LoadIcon unter Win32 keinen nachfolgenden DestroyIcon-Aufruf bentigt
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCtpuzzleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCtpuzzleDlg)
	DDX_Control(pDX, IDC_FAST_SOLVE_OUT_1, m_FastSolveOut1);
	DDX_Control(pDX, IDC_FAST_SOLVE_OUT_2, m_FastSolveOut2);
	DDX_Control(pDX, IDC_FAST_SOLVE_OUT_0, m_FastSolveOut0);
	DDX_Control(pDX, IDC_BUTTON_CONTINUE_SOLVE, m_ButtonContinueSolve);
	DDX_Control(pDX, IDC_BUTTON_SUSPEND_SOLVE, m_ButtonSuspendSolve);
	DDX_Control(pDX, IDC_OUTPUT, m_Output);
	DDX_Control(pDX, IDC_BUTTON_START_SOLVE, m_ButtonStartSolve);
	DDX_Control(pDX, IDC_BUTTON_ABORT_SOLVE, m_ButtonAbortSolve);
	DDX_Text(pDX, IDC_SOLUTION_STATUS, m_SolutionStatus);
	DDX_Text(pDX, IDC_SOLUTION_TIME, m_SolutionTime);
	DDX_Text(pDX, IDC_SOLUTION_TRIES, m_SolutionTries);
	DDX_Text(pDX, IDC_SOLUTION_COUNT, m_SolutionCount);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCtpuzzleDlg, CDialog)
	//{{AFX_MSG_MAP(CCtpuzzleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_START_SOLVE, OnButtonStartSolve)
	ON_BN_CLICKED(IDC_BUTTON_SUSPEND_SOLVE, OnButtonSuspendSolve)
	ON_BN_CLICKED(IDC_BUTTON_CONTINUE_SOLVE, OnButtonContinueSolve)
	ON_BN_CLICKED(IDC_BUTTON_ABORT_SOLVE, OnButtonAbortSolve)
	ON_BN_CLICKED(IDC_BUTTON_GO_FAST, OnButtonGoFast)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCtpuzzleDlg Nachrichten-Handler

BOOL CCtpuzzleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden
	
	// ZU ERLEDIGEN: Hier zustzliche Initialisierung einfgen
	
	return TRUE;  // Geben Sie TRUE zurck, auer ein Steuerelement soll den Fokus erhalten
}

/////////////////////////////////////////////////////////////////////////////

// Wollen Sie Ihrem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie 
//  den nachstehenden Code, um das Symbol zu zeichnen. Fr MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch fr Sie erledigt.

void CCtpuzzleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext fr Zeichnen

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Symbol in Client-Rechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// Die Systemaufrufe fragen den Cursorform ab, die angezeigt werden soll, whrend der Benutzer
//  das zum Symbol verkleinerte Fenster mit der Maus zieht.
HCURSOR CCtpuzzleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////////////////////////////
/*
	OnCreate/OnDestroy:
	manage timer
*/
int CCtpuzzleDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	SetTimer(1,500,NULL);
	
	return 0;
}

void CCtpuzzleDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	KillTimer(1);
	
}

/////////////////////////////////////////////////////////////////////////////
/*
	OnTimer: 
	reflect status of m_Solver
*/
void CCtpuzzleDlg::OnTimer(UINT nIDEvent) 
{
	/////////////////////////////////////////////////////////////////////////////

	m_Solver.LockPublicData();

	/////////////////////////////////////////////////////////////////////////////

	// enable/disable start/stop button
	m_ButtonAbortSolve.EnableWindow((m_Solver.m_ThreadState == m_Solver.IDLE)?FALSE:TRUE);
	m_ButtonStartSolve.EnableWindow((m_Solver.m_ThreadState == m_Solver.IDLE)?TRUE:FALSE);

	/////////////////////////////////////////////////////////////////////////////

	// update status
	if(m_Solver.m_ThreadState == m_Solver.IDLE)
	{
		m_SolutionStatus = _T("stopped");

		m_ButtonSuspendSolve.EnableWindow(FALSE);
		m_ButtonContinueSolve.EnableWindow(FALSE);
	}
	else if(m_Solver.IsSuspended())
	{
		m_SolutionStatus = _T("suspended");

		m_ButtonSuspendSolve.EnableWindow(FALSE);
		m_ButtonContinueSolve.EnableWindow(TRUE);
	}
	else
	{
		m_SolutionStatus = _T("running");

		m_ButtonSuspendSolve.EnableWindow(TRUE);
		m_ButtonContinueSolve.EnableWindow(FALSE);
	}

	/////////////////////////////////////////////////////////////////////////////

	// update solution time
	signed long SolutionTime = 0;

	if(m_Solver.m_ThreadState == m_Solver.IDLE)
	{
		SolutionTime = m_Solver.m_SolveEnd - m_Solver.m_SolveStart;

		if(SolutionTime>=0)
		{
			m_SolutionTime.Format(_T("%.1f s"),SolutionTime/1000.0);
		}
		else
		{
			m_SolutionTime = _T("---");
		}
	}
	else
	{
		SolutionTime = GetTickCount() - m_Solver.m_SolveStart;
		m_SolutionTime.Format(_T("%.1f s"),SolutionTime/1000.0);
	}

	/////////////////////////////////////////////////////////////////////////////

	// update number of solutions + tries
	if(SolutionTime>0)
	{
		m_SolutionCount.Format(_T("%d (%.1f/s)"),m_Solver.m_Solutions,m_Solver.m_Solutions*1000.0/SolutionTime);
	}
	else
	{
		m_SolutionCount.Format(_T("%d"),m_Solver.m_Solutions);
	}

	m_SolutionTries.Format(_T("%I64d (%I64d/sol.)"),m_Solver.m_NumberOfTries,m_Solver.m_NumberOfTries/max(1,m_Solver.m_Solutions));

	/////////////////////////////////////////////////////////////////////////////

	// update shown solution
	if(m_Solver.m_Solutions != m_Output.m_SolutionDrawn)
	{
		m_Output.InvalidateRect(NULL,TRUE);
	}

	/////////////////////////////////////////////////////////////////////////////

	m_Solver.UnlockPublicData();

	UpdateData(FALSE);

	/////////////////////////////////////////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////

void CCtpuzzleDlg::OnButtonStartSolve() 
{
	/////////////////////////////////////////////////////////////////////////////

	m_Solver.Start();
	
	/////////////////////////////////////////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////

void CCtpuzzleDlg::OnButtonSuspendSolve() 
{
	m_Solver.Suspend();
}

void CCtpuzzleDlg::OnButtonContinueSolve() 
{
	m_Solver.Continue();
}

void CCtpuzzleDlg::OnButtonAbortSolve() 
{
	m_Solver.Terminate();
}

/////////////////////////////////////////////////////////////////////////////

void CCtpuzzleDlg::OnButtonGoFast() 
{
	/////////////////////////////////////////////////////////////////////////////

	m_FastSolveOut0.SetWindowText(_T("start..."));

	DWORD Start = GetTickCount();

	Puzzle::AsmSolver::Start(m_FastSolveOut0.m_hWnd,m_FastSolveOut1.m_hWnd,m_FastSolveOut2.m_hWnd);
	Puzzle::AsmSolver::CreatePatternHeap();

	Puzzle::AsmSolver::Solve(1);
	Puzzle::AsmSolver::DeletePatternHeap();

	DWORD Stop = GetTickCount();

	CString S;
	S.Format(_T("done. total time: %.1f s, total nr of solutions: %d (%.1f/s)"),(Stop-Start)/1000.0,Puzzle::AsmSolver::Solutions,Puzzle::AsmSolver::Solutions*1000.0/max(Stop-Start,1));

	m_FastSolveOut0.SetWindowText(S);
	m_FastSolveOut1.SetWindowText(_T(""));
	m_FastSolveOut2.SetWindowText(_T(""));

	/////////////////////////////////////////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////
