/////////////////////////////////////////////////////////////////////////////
//
// PuzzleSolution.cpp: Implementierungsdatei
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "PuzzleSolution.h"

/////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/*
	CPuzzleSolution
*/
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CPuzzleSolution, CStatic)
	//{{AFX_MSG_MAP(CPuzzleSolution)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////

CPuzzleSolution::CPuzzleSolution(Puzzle::Solver* S)
{
	m_SolverToDisplay = S;
	m_SolutionDrawn = -1;
}

CPuzzleSolution::~CPuzzleSolution()
{
}

/////////////////////////////////////////////////////////////////////////////

void CPuzzleSolution::OnPaint() 
{
	/////////////////////////////////////////////////////////////////////////////

	using namespace Puzzle;

	/////////////////////////////////////////////////////////////////////////////

	CPaintDC dc(this); // device context for painting
	
	/////////////////////////////////////////////////////////////////////////////
	
	CRect R; GetClientRect(&R);
	dc.FillSolidRect(R,RGB(0,0,0));

	/////////////////////////////////////////////////////////////////////////////

	static COLORREF StoneColor[] =
	{
		RGB(255,0,0),
		RGB(0,255,0),
		RGB(0,0,255),

		RGB(255,128,128),
		RGB(128,255,128),
		RGB(128,128,255),

		RGB(255,128,0),
		RGB(255,0,128),
		RGB(128,0,255),
		RGB(128,255,0),
		RGB(0,128,255),
		RGB(0,255,128),
	};
	const int StoneColCount = sizeof(StoneColor)/sizeof(StoneColor[0]);

	/////////////////////////////////////////////////////////////////////////////

	if(m_SolverToDisplay==NULL)return;

	/////////////////////////////////////////////////////////////////////////////

	m_SolverToDisplay->LockPublicData();

	const int StonesPerLine = 6;

	int S = m_SolverToDisplay->m_LastSolution.size();
	if(S != 0)
	{
		int W1 = R.Width()/(BitpatternExtX+BitpatternExtZ/2+2)/StonesPerLine;
		int W2 = R.Height()/(BitpatternExtY+BitpatternExtZ/2+2)/((S+StonesPerLine-1)/StonesPerLine);

		int Width = min(W1,W2);
		for(int i=0;i<S;++i)
		{

			int x = i%StonesPerLine;
			int y = i/StonesPerLine;

			int WX = Width*(BitpatternExtX+BitpatternExtZ/2+2);
			int WY = Width*(BitpatternExtY+BitpatternExtZ/2+2);

			int ShiftX = Width;
			int ShiftY = Width*(BitpatternExtZ/2+1);

			tBitPattern P = m_SolverToDisplay->m_LastSolution[i].Pattern;
			int StNr = m_SolverToDisplay->m_LastSolution[i].StoneNr;

			DrawBitpattern(&dc,ShiftX+x*WX,ShiftY+y*WY,Width,P,StoneColor[StNr%StoneColCount]);
		}
		m_SolutionDrawn = m_SolverToDisplay->m_Solutions;
	}

	m_SolverToDisplay->UnlockPublicData();

	/////////////////////////////////////////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////
