// Fast CT-Wuerfel by Peter Schaeffer (Omoikane) in 2003 (11.04.2003)(GPL)

// 409963 Loesungen, 1042.21s, 3969321502 Tests, 17m22.120s
// 12.59 (ohne mem)
// 12.13 (mit mem6)
// 7.12
// 7.00 (mem7)
// 229426 (<20) 263094 (<25)

#define SORTORDER 0
#define SYMETRIE  10
#define SYMORDER  >
#define FUCKPART  10
#define MAXDEAD   12
#define MINPART   0
#define MAXPART   0
#define MAXMEM    0
#define MAXJUMP   0
#define MINJUMP   0
// MAXDEADPOS 24
#define MAXDEADPOS 24

#define PROFILE
#define SWITCHES

//#define DBGJUMP
//#define DBGRESULT
#define DBGDOT
#define DBGINIT
//#define DBGMAXRES 5000

#define STR1(s) #s
#define STR(s) STR1(s)

#define LONG long long int
#define MIN(a, b) (((a)<(b))?(a):(b))

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#if (MAXMEM)
#include <stl.h>
#include <hash_map.h>
typedef pair<LONG, int> key;
typedef map<const key, int> memory;
memory mem, mem2;
#endif

#define NZI(x, y) (((int)(x))/((y)?(y):(1)))
#define NZL(x, y) (((LONG)(x))/((y)?(y):(1)))
#define NZD(x, y) (((double)(x))/((y)?(y):(1.0)))
#define KMG(x) (((x)>=100000)?(((x)>=100000000)?((x>=100000000000LL)?((x)/1000000000):((x)/1000000)):((x)/1000)):(x)),(((x)>=100000)?(((x)>=100000000)?(((x)>=100000000000LL)?('G'):('M')):('K')):(' '))

#define PART(x) (((x)<0)?('.'):(((x)<=9)?((x)+'0'):((x)+'a'-10)))

int parts[12][6][3]={
  {{{0},{0},{0}}, {{1},{0},{0}}, {{0},{1},{0}}, {{0},{2},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  0 C
  {{{0},{0},{0}}, {{1},{0},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{2},{2},{0}}, {{0},{0},{0}}}, //  1 '
  {{{0},{0},{0}}, {{1},{0},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{1},{3},{0}}, {{0},{0},{0}}}, //  2
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{0},{2},{0}}, {{0},{3},{0}}, {{0},{0},{0}}}, //  3
  {{{0},{0},{0}}, {{0},{1},{0}}, {{0},{0},{1}}, {{0},{1},{1}}, {{1},{1},{0}}, {{0},{0},{0}}}, //  4 '
  {{{0},{0},{0}}, {{1},{0},{0}}, {{2},{0},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  5
  {{{0},{0},{0}}, {{0},{1},{0}}, {{0},{2},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  6
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{2},{2},{0}}, {{0},{0},{0}}}, //  7
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{1},{1},{1}}, {{0},{0},{0}}, {{0},{0},{0}}}, //  8 '
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{2},{1},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  9
  {{{0},{0},{0}}, {{-1},{0},{0}}, {{1},{0},{0}}, {{0},{-1},{0}}, {{0},{1},{0}}, {{0},{0},{0}}}, // 10
  {{{0},{0},{0}}, {{0},{1},{0}}, {{0},{2},{0}}, {{0},{3},{0}}, {{1},{1},{0}}, {{1},{3},{0}}}, // 11 T
};

int dirs[6][3]={
  {{0}, {1}, {2}},
  {{0}, {2}, {1}},
  {{1}, {0}, {2}},
  {{1}, {2}, {0}},
  {{2}, {0}, {1}},
  {{2}, {1}, {0}}
};

int vdirs[4][3]={
  {{ 1},{-1},{-1}},
  {{-1},{ 1},{-1}},
  {{-1},{-1},{ 1}},
  {{ 1},{ 1},{ 1}}
};


int res=0, res2=0;
int sortpos[60];
LONG profile[12][5];
LONG w[12][1000], d[60][2016], dp[60][2016];
int wa[12], da[60][12];
LONG *partpos[12];
LONG *wstart[12][60];
LONG *dpstart[60][13][60];
int mempos=0;
LONG px1=0;

int pcmp(const void* a, const void* b) // Vergleichsfunktion fuer Teile -------
{
  LONG pos=1;
  for(int i=0; i<60; i++)
    {
      if ((*(LONG*)a&pos) && (!(*(LONG*)b&pos))) return -1;
      if ((!(*(LONG*)a&pos)) && (*(LONG*)b&pos)) return 1;
      pos=pos<<1;
    }
  return 0;
}

void switches() // Ausgabe fuer Programmswitches ------------------------------
{
#ifdef SWITCHES
  printf("\nSWITCHES: SORTORDER=%d, SYMETRIE=%d, MAXDEAD=%d, MAXPART=%d, MAXMEM=%d, MAXRES=%d%s, MINJUMP=%d, MAXDEADPOS=%d, FUCKPART=%d, SYMORDER=%s\n", SORTORDER,
#ifdef SYMETRIE
         SYMETRIE,
#else
         -1,
#endif
         MAXDEAD, MAXPART, MAXMEM,
#ifdef MAXRES
         MAXRES,
#else
         0,
#endif
#ifdef PROFILE
         ", PROFILE",
#else
         "",
#endif
         MINJUMP, MAXDEADPOS,
#ifdef FUCKPART
         FUCKPART,
#else
         -1,
#endif
         STR(SYMORDER)
         );
#endif
}

void pprofile() // Ausgabe von Profiling-Informationen -------------------------
{
#ifdef PROFILE
  LONG p0=0, p1=0, p2=0, p3=0, p4=0;
  printf("\n");
  for(int part=0; part<12; part++)
    {
      printf("%4d:%6lld%c x%7.4f%6lld%c x%5.4f%6lld%c x%5.4f%6lld%c x%5.4f%6lld%c x%3lld\n",
	 part,
	 KMG(profile[part][0]),
	 NZD((part==11)?(res):(profile[part+1][0]), profile[part][0]),
	 KMG(profile[part][2]),
	 NZD(profile[part][2], profile[part][0]),
	 KMG(profile[part][3]),
	 NZD(profile[part][3], profile[part][0]-profile[part][2]),
	 KMG(profile[part][4]),
	 NZD(profile[part][4], profile[part][0]-profile[part][2]-profile[part][3]),
	 KMG(profile[part][1]),
	 NZL(profile[part][1], profile[part][0]-profile[part][2]-profile[part][3])
	 );
      p0+=profile[part][0]; p1+=profile[part][1]; p2+=profile[part][2]; p3+=profile[part][3]; p4+=profile[part][4];
    }
  printf("0-11:%6lld%c         %6lld%c x%5.4f%6lld%c x%5.4f%6lld%c x%5.4f%6lld%c x%3lld\n",
         KMG(p0),
         KMG(p2), NZD(p2, p0),
         KMG(p3), NZD(p3, p0-p2),
         KMG(p4), NZD(p4, p0-p2-p3),
         KMG(p1), NZL(p1, p0-p2-p3-p4)
         );
  if (px1) printf("\n%6lld%c\n", KMG(px1));
  fflush(0);
#endif
}

void pfeld() // Ausgabe des Feldzustandes -------------------------------------
{
  int f[60];
  for(int i=0; i<60; i++) f[i]=-1;
  for(int part=0; part<12; part++)
    if (partpos[part])
      for(int i=0; i<60; i++)
        if (*partpos[part]&(1LL<<sortpos[i]))
          f[i]=part;
  for(int y=0; y<4; y++)
    {
      printf("\n ");
      for(int z=0; z<3; z++)
        {
          printf("   ");
          for(int x=0; x<5; x++)
	printf("%c", PART(f[x+y*5+z*20]));
        }
    }
  printf("\n");
#ifdef PROFILE
  pprofile();
#endif
  fflush(0);
}

void jump(int pos, int ppart, LONG ww, LONG xpos) // Eigentlicher Suchalgorithmus
{
#ifdef DBGMAXRES
  if (res>=DBGMAXRES) return;
#endif
  if (ppart==12)
    {
      res++;
#ifdef SYMETRIE
      res2+=(*partpos[SYMETRIE]<0)?(1):(0);
#endif
#ifdef DBGRESULT
      printf("\nLoesungen: %d\n", res);
      pfeld();
#else
#ifdef DBGDOT
      if (!(res%1000)) {printf("."); fflush(0);}
#endif
#endif
      return;
    }
#ifdef DBGJUMP
  pfeld();
#endif
#ifdef PROFILE
  profile[ppart][0]++;
#endif
#if MAXMEM
  if (ppart<MAXMEM)
    {
      key k=key(ww, mempos);
      if (mem.find(k)!=mem.end())
        {
#ifdef PROFILE
          profile[ppart][2]++;
#endif
#ifdef DBGRESULT
          if (mem[k])
	printf("\n%d Loesungen durch Memorieren\n", mem[k]);
#else
#ifdef DBGDOT
          if (mem[k])
	for(int i=0; i<mem[k]; i++)
	  if (!((res+i)%1000)) {printf("."); fflush(0);}
#endif
#endif
          res+=mem[k];
          res2+=mem2[k];
          return;
        }
    }
  int resmerk=res;
  int res2merk=res2;
#endif
  if (MINJUMP)
    {
      if ((ppart>=MAXJUMP) && (ppart<MINJUMP))
        {
          pos=0;
          int mx=10000;
          for(int i=0; i<60; i++)
	{
	  if (ww&(1LL<<i)) continue;
	  int mk=0;
	  LONG *dpos=d[i];
	  for(int part=0; part<12; part++)
	    {
	      if (partpos[part]) {dpos+=da[i][part]; continue;}
	      while(*(++dpos))
	        {
	          if (*dpos&ww) continue;
	          mk++;
	          if (mk>=mx) goto weiter1;
	        }
	    }
	  if (mk<mx)
	    {
	      mx=mk;
	      pos=i;
	    }
	weiter1:;
	}
          //if (ppart==0) pos=0;
        }
      else
        {
          pos=0; xpos=1;
          while(ww&xpos) {pos++; xpos<<=1;}
        }
    }
  else
    {
      while(ww&xpos) {pos++; xpos<<=1;}
    }
  LONG *dpos=d[pos];
#if MAXPART
  if ((ppart>=MINPART) && (ppart<MAXPART))
    {
      for(int part=0; part<12; part++)
        {
          if (partpos[part]) continue;
          LONG *e=wstart[part][pos];
          for(LONG *p=&w[part][wa[part]-1]; p>e; p--)
	{
	  if (!(*p&ww))
	    goto maxpartende;
	}
#ifdef PROFILE
          profile[ppart][3]++;
#endif
          goto weiter;
        maxpartende:;
        }
    }
#endif
#if MAXDEAD
  if (ppart<MAXDEAD)
    {
      LONG tst=ww;
      int mx=MIN(60, pos+MAXDEADPOS);
      for(int p=
#if MINJUMP
	0
#else
	pos
#endif
	; p<mx; p++)
        {
          if (tst&(1LL<<p)) continue;
          // printf("\n%d", p);
          for(int part=0; part<12; part++)
	{
	  /*
	  if (partpos[part]) continue;
	  LONG *d=dpstart[p][part][pos];
	  while(*d)
	    {
#ifdef PROFILE
// px1++;
#endif
	      // printf(".");
	      if (!(*d&ww))
	        {
	          tst|=*d;
	          goto maxdeadweiter;
	        }
	      d++;
	    }
	  */
	  if (partpos[part]) continue;
	  LONG *d=dpstart[p][part+1][0]-1;
#if MINJUMP
	  LONG *e=dpstart[p][part][0];
#else
	  LONG *e=dpstart[p][part][pos];
#endif
	  while(int(--d)>=int(e))
	    {
#ifdef PROFILE
	      //	      px1++;
#endif
	      //printf(".");
	      if (!(*d&ww))
	        {
	          tst|=*d;
	          goto maxdeadweiter;
	        }
	    }
	  
	}
#ifdef PROFILE
          profile[ppart][4]++;
#endif
          goto weiter;
        maxdeadweiter:;
        }
    }
#endif
  for(int part=0; part<12; part++)
    {
      if (partpos[part]) {dpos+=da[pos][part]; continue;}
#if (MAXMEM)
      mempos|=1<<part;
#endif
      while(*(++dpos))
        {
#ifdef PROFILE
          profile[ppart][1]++;
#endif
          if (*dpos&ww) continue;
          partpos[part]=dpos;
          jump(pos, ppart+1, ww|*dpos, xpos);
        }
      partpos[part]=NULL;
#if (MAXMEM)
      mempos^=1<<part;
#endif
    }
 weiter:;
#if MAXMEM
  if (ppart<MAXMEM)
    {
      mem[key(ww, mempos)]=res-resmerk;
      mem2[key(ww, mempos)]=res2-res2merk;
    }
#endif  
}

int main() // Hauptprogramm ---------------------------------------------------
{
  printf("\nCT-Wuerfel by Peter Schaeffer in 2003.\n");
  switches();
  clock_t sclk=clock();
  // Init ---------------------------------------------------------------------
  for(int i=0; i<12; i++)
    {
      partpos[i]=NULL;
      wa[i]=0;
      for(int j=0; j<5; j++)
        profile[i][j]=0;
    }
  for(int i=0; i<60; i++) sortpos[i]=-1;
#if (SORTORDER==0)
  for(int i=0; i<60; i++) sortpos[i]=i/20+((i/5)%4)*3+(i%5)*12;
#elif (SORTORDER==1)
  for(int i=0; i<60; i++) sortpos[i]=i;
#elif (SORTORDER==2)
  sortpos[0]=0;
  sortpos[40]=1;
  sortpos[15]=2;
  sortpos[55]=3;
  sortpos[4]=4;
  sortpos[44]=5;
  sortpos[19]=6;
  sortpos[59]=7;
#elif (SORTORDER==3)
  sortpos[0]=0;
  sortpos[40]=1;
  sortpos[15]=2;
  sortpos[55]=3;
  sortpos[26]=4;
  sortpos[31]=5;
  sortpos[2]=6;
  sortpos[42]=7;
  sortpos[17]=8;
  sortpos[57]=9;
#elif (SORTORDER==4)
  sortpos[0]=0;
  sortpos[4]=1;
  sortpos[57]=2;
  sortpos[26]=3;
  sortpos[28]=4;
  sortpos[15]=5;
  sortpos[19]=6;
  sortpos[52]=7;
  sortpos[31]=8;
  sortpos[33]=9;
#elif (SORTORDER==5)
  sortpos[27]=0;
  sortpos[31]=1;
  sortpos[33]=2;
  sortpos[17]=3;
  sortpos[57]=4;
  sortpos[0]=5;
  sortpos[4]=6;
  sortpos[40]=7;
  sortpos[44]=8;
  sortpos[15]=9;
  sortpos[19]=10;
  sortpos[55]=11;
  sortpos[59]=12;
#elif (SORTORDER==6)
  sortpos[0]=0;
  sortpos[59]=1;
  sortpos[4]=2;
  sortpos[55]=3;
  sortpos[15]=4;
  sortpos[40]=5;
  sortpos[19]=6;
  sortpos[44]=7;
#elif (SORTORDER==7)
  sortpos[0]=0;
  sortpos[40]=1;
  sortpos[15]=2;
  sortpos[55]=3;
  sortpos[26]=4;
  sortpos[31]=5;
#elif (SORTORDER==8)
  sortpos[0]=0;
  sortpos[20]=1;
  sortpos[40]=2;
  sortpos[45]=3;
  sortpos[50]=4;
  sortpos[55]=5;
  sortpos[35]=6;
  sortpos[15]=7;
  sortpos[10]=8;
  sortpos[5]=9;
#elif (SORTORDER==9)
  sortpos[0]=0;
  sortpos[40]=1;
  sortpos[15]=2;
  sortpos[55]=3;
#elif (SORTORDER==10)
  sortpos[0]=0;
  sortpos[40]=1;
  sortpos[15]=2;
  sortpos[55]=3;
  sortpos[26]=4;
  sortpos[31]=5;
#elif (SORTORDER==11)
  sortpos[0]=0;
  sortpos[40]=1;
  sortpos[20]=2;
  sortpos[15]=3;
  sortpos[55]=4;
  sortpos[35]=5;
  sortpos[5]=6;
  sortpos[10]=7;
  sortpos[45]=8;
  sortpos[50]=9;
  sortpos[25]=10;
  sortpos[30]=11;
  sortpos[1]=12;
  sortpos[41]=13;
  sortpos[21]=14;
  sortpos[16]=15;
  sortpos[56]=16;
  sortpos[36]=17;
  sortpos[6]=18;
  sortpos[11]=19;
  sortpos[46]=20;
  sortpos[51]=21;
  sortpos[26]=22;
  sortpos[31]=23;
  sortpos[2]=24;
  sortpos[42]=25;
  sortpos[22]=26;
  sortpos[17]=27;
  sortpos[57]=28;
  sortpos[37]=29;
  sortpos[7]=30;
  sortpos[12]=31;
  sortpos[47]=32;
  sortpos[52]=33;
  sortpos[27]=34;
  sortpos[32]=35;
#else
#error "Unbekannte Sortierreihenfolge.\n"
#endif
  for(int i=0; i<60; i++)
    {
      if (sortpos[(i%3)*20+((i/3)%4)*5+(i/12)]==-1)
        {
          int ok=1;
          int pos=-1;
          while(ok)
	{
	  ok=0; pos++;
	  for(int j=0; j<60; j++)
	    if (sortpos[j]==pos) ok=1;
	}
          sortpos[(i%3)*20+((i/3)%4)*5+(i/12)]=pos;
        }
    }
#ifdef DBGINIT
  printf("\nInit (wa): \n\n");
#endif
  for(int part=0; part<12; part++)
    {
      for(int x=0; x<5; x++)
        for(int y=0; y<4; y++)
          for(int z=0; z<3; z++)
	for(int d=0; d<6; d++)
	  for(int v=0; v<4; v++)
	    {
	      int ok=1;
	      w[part][wa[part]]=0;
	      for(int i=0; i<6; i++)
	        {
	          w[part][wa[part]]|=
		1LL<<sortpos[(x+parts[part][i][dirs[d][0]]*vdirs[v][dirs[d][0]])+
		         (y+parts[part][i][dirs[d][1]]*vdirs[v][dirs[d][1]])*5+
		         (z+parts[part][i][dirs[d][2]]*vdirs[v][dirs[d][2]])*20];
	          if ((x+parts[part][i][dirs[d][0]]*vdirs[v][dirs[d][0]]<0) ||
		  (x+parts[part][i][dirs[d][0]]*vdirs[v][dirs[d][0]]>4) ||
		  (y+parts[part][i][dirs[d][1]]*vdirs[v][dirs[d][1]]<0) ||
		  (y+parts[part][i][dirs[d][1]]*vdirs[v][dirs[d][1]]>3) ||
		  (z+parts[part][i][dirs[d][2]]*vdirs[v][dirs[d][2]]<0) ||
		  (z+parts[part][i][dirs[d][2]]*vdirs[v][dirs[d][2]]>2)
		  ) ok=0;
	        }
	      for(int i=0; i<wa[part]; i++)
	        if ((w[part][i]&0x7fffffffffffffffLL)==w[part][wa[part]]) ok=0;
#ifdef SYMETRIE
	      if ((ok) && (part==SYMETRIE))
	        {
	          LONG tst=0;
	          for(int i=0; i<6; i++)
		tst|=1LL<<sortpos[(4-(x+parts[part][i][dirs[d][0]]*vdirs[v][dirs[d][0]]))+
			  (3-(y+parts[part][i][dirs[d][1]]*vdirs[v][dirs[d][1]]))*5+
			  (z+parts[part][i][dirs[d][2]]*vdirs[v][dirs[d][2]])*20];
	          for(int i=0; i<wa[part]; i++)
		if ((tst&0x7fffffffffffffffLL)==(w[part][i]&0x7fffffffffffffffLL))
		  {
		    if (pcmp(&w[part][i], &w[part][wa[part]]) SYMORDER 0)
		      w[part][i]=w[part][wa[part]];
		    ok=0;
		  }
	          if (tst==w[part][wa[part]]) w[part][wa[part]]|=0x8000000000000000LL;
	          tst=0;
	          for(int i=0; i<6; i++)
		tst|=1LL<<sortpos[(x+parts[part][i][dirs[d][0]]*vdirs[v][dirs[d][0]])+
			  (3-(y+parts[part][i][dirs[d][1]]*vdirs[v][dirs[d][1]]))*5+
			  (2-(z+parts[part][i][dirs[d][2]]*vdirs[v][dirs[d][2]]))*20];
	          for(int i=0; i<wa[part]; i++)
		if ((tst&0x7fffffffffffffffLL)==(w[part][i]&0x7fffffffffffffffLL))
		  {
		    if (pcmp(&w[part][i], &w[part][wa[part]]) SYMORDER 0)
		      w[part][i]=w[part][wa[part]];
		    ok=0;
		  }
	          if (tst==w[part][wa[part]]) w[part][wa[part]]|=0x8000000000000000LL;
	          tst=0;
	          for(int i=0; i<6; i++)
		tst|=1LL<<sortpos[(4-(x+parts[part][i][dirs[d][0]]*vdirs[v][dirs[d][0]]))+
			  (y+parts[part][i][dirs[d][1]]*vdirs[v][dirs[d][1]])*5+
			  (2-(z+parts[part][i][dirs[d][2]]*vdirs[v][dirs[d][2]]))*20];
	          for(int i=0; i<wa[part]; i++)
		if ((tst&0x7fffffffffffffffLL)==(w[part][i]&0x7fffffffffffffffLL))
		  {
		    if (pcmp(&w[part][i], &w[part][wa[part]]) SYMORDER 0)
		      w[part][i]=w[part][wa[part]];
		    ok=0;
		  }
	          if (tst==w[part][wa[part]]) w[part][wa[part]]|=0x8000000000000000LL;
	        }
#endif
	      if (ok)
	        {
	          wa[part]++;
	        }
	    }
#ifdef DBGINIT
      printf("%c%2d:%4d\n",
#ifdef SYMETRIE
	 (SYMETRIE==part)?('*'):(' '),
#else
	 ' ',
#endif
	 part, wa[part]
	 );
#endif
      qsort(&w[part][0], wa[part], sizeof(LONG), pcmp);
      for(int p=0; p<60; p++)
        {
          wstart[part][p]=&w[part][-1];
          if (!(MINJUMP))
	{
	  for(int i=0; i<wa[part]; i++)
	    if (w[part][i]&((1LL<<(p))-1))
	      wstart[part][p]=&w[part][i];
	}
        }
    }
#ifdef DBGINIT
  printf("\nInit (da):\n\n");
#endif
  for(int pos=0; pos<60; pos++)
    {
      LONG *dpos=&d[pos][0];
      for(int part=0; part<12; part++)
        {
          *(dpos++)=0;
          da[pos][part]=1;
          for(int i=0; i<wa[part]; i++)
	{
	  if ((w[part][i]&(1LL<<pos)) && ((!(w[part][i]&((1LL<<pos)-1))) || (MINJUMP)))
	    {
	      *(dpos++)=w[part][i];
	      da[pos][part]++;
	    }
	}
        }
#ifdef DBGINIT
      int m=0;
      for(int i=0; i<12; i++) m+=da[pos][i]-1;
      printf("%5d%c", m, ((pos+1)%10)?(' '):('\n'));
#endif
    }
  for(int pos=0; pos<60; pos++)
    {
      LONG *dpos=&dp[pos][0];
      for(int part=0; part<12; part++)
        {
          *(dpos++)=0;
          for(int j=0; j<60; j++)
	dpstart[pos][part][j]=dpos;
          for(int i=0; i<wa[part]; i++)
	{
	  if (w[part][i]&(1LL<<pos))
	    {
	      *(dpos++)=w[part][i];
	      for(int j=0; j<60; j++)
	        if (w[part][i]&((1LL<<j)-1))
	          dpstart[pos][part][j]=dpos;
	    }
	}
        }
      *(dpos++)=0;
      dpstart[pos][12][0]=dpos;
    }
#ifdef FUCKPART
  //  for(int i=0; i<wa[FUCKPART]; i++)
  for(int i=0; i<wa[FUCKPART]; i++)
    {
#ifdef DBGDOT
      printf("%d", i); fflush(0);
#endif
      //mem.erase(mem.begin(), mem.end());
      //mem2.erase(mem2.begin(), mem2.end());
      partpos[FUCKPART]=&w[FUCKPART][i];
      jump(0, 1, w[FUCKPART][i], 1);
      partpos[FUCKPART]=NULL;
    }
#else
  jump(0, 0, 0, 1);
#endif
  // Fertig -------------------------------------------------------------------
  clock_t sec=(clock()-sclk)/CLOCKS_PER_SEC;
  switches();
#ifdef PROFILE
  pprofile();
#endif
  printf("\n%d Loesungen %s Symmetrien in %ld:%02ld.%02ld (%.1f L/s).\n\n",
#ifdef SYMETRIE
         res-res2/2,
         "ohne",
#else
         res,
         "mit",
#endif
         sec/3600, (sec/60)%60, sec%60,
         NZD(res, sec)
         );
  return 0;
}
