// CT-Wuerfel by Peter Schaeffer (Omoikane) in 2003 (29.04.2003)
// peter@peter-schaeffer.de
// memory, deadend, 'x', swap
// 409963
// gcc-2.95 -O2, Tuleron 1400: 5.47 (1109)
// gcc-2.95 -O2, P4 2200: 4:56 (1385)
// gcc-3.2.3 -O2, P4 2200: 5:11 (1318)
// gcc-3.2.3 -O3++, P4 2200: 5:03 (1353)

#define SYMETRIE 8
#define SYMORDER <
#define UMSYM 28
#define MAXMEM 5

//#define PROFILE
#define ARRAYSIZE 666
#define ARRAYSIZE2 666

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <stl.h>

#define LONG long long int

#define MIN(a, b) (((a)<(b))?(a):(b))
#define MAX(a, b) (((a)>=(b))?(a):(b))

typedef map<LONG, int> memory;

int parts[12][6][3]={ // Teile ------------------------------------------------
  {{{0},{0},{0}}, {{1},{0},{0}}, {{0},{1},{0}}, {{0},{2},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  0 C
  {{{0},{0},{0}}, {{1},{0},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{2},{2},{0}}, {{0},{0},{0}}}, //  1 '
  {{{0},{0},{0}}, {{1},{0},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{1},{3},{0}}, {{0},{0},{0}}}, //  2
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{0},{2},{0}}, {{0},{3},{0}}, {{0},{0},{0}}}, //  3
  {{{0},{0},{0}}, {{0},{1},{0}}, {{0},{0},{1}}, {{0},{1},{1}}, {{1},{1},{0}}, {{0},{0},{0}}}, //  4 '
  {{{0},{0},{0}}, {{1},{0},{0}}, {{2},{0},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  5
  {{{0},{0},{0}}, {{0},{1},{0}}, {{0},{2},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  6
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{1},{2},{0}}, {{2},{2},{0}}, {{0},{0},{0}}}, //  7
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{1},{1},{1}}, {{0},{0},{0}}, {{0},{0},{0}}}, //  8 '
  {{{0},{0},{0}}, {{0},{1},{0}}, {{1},{1},{0}}, {{2},{1},{0}}, {{1},{2},{0}}, {{0},{0},{0}}}, //  9
  {{{0},{0},{0}}, {{0},{1},{0}}, {{0},{2},{0}}, {{0},{3},{0}}, {{1},{1},{0}}, {{1},{3},{0}}}, // 11 T
  {{{0},{0},{0}}, {{-1},{0},{0}}, {{1},{0},{0}}, {{0},{-1},{0}}, {{0},{1},{0}}, {{0},{0},{0}}} // 10 +
};

int dirs[6][3]={
  {{0}, {1}, {2}},
  {{0}, {2}, {1}},
  {{1}, {0}, {2}},
  {{1}, {2}, {0}},
  {{2}, {0}, {1}},
  {{2}, {1}, {0}}
};

int vdirs[4][3]={
  {{ 1},{-1},{-1}},
  {{-1},{ 1},{-1}},
  {{-1},{-1},{ 1}},
  {{ 1},{ 1},{ 1}}
};

int symsym=0;
int resusfaktor=2;
int res=0;
int partpos=0;
LONG moves=0;
LONG prt[12][ARRAYSIZE];
int prta[12], prts[ARRAYSIZE];
LONG w1[60][ARRAYSIZE2], w2[60][ARRAYSIZE2];
LONG *w1p[60][16], *w2p[60][60][16];

memory mem[4096];
int resmerk[12];

int pcmp(const void* a, const void* b) // Vergleichsfunktion fuer Teile -------
{
  LONG pos=1;
  for(int i=0; i<60; i++)
    {
      if ((*(LONG*)a&pos) && (!(*(LONG*)b&pos))) return -1;
      if ((!(*(LONG*)a&pos)) && (*(LONG*)b&pos)) return 1;
      pos=pos<<1;
    }
  return 0;
}

void init(LONG ww, int mp)
{
  for(int pos=0; pos<60; pos++)
    {
      LONG* p=w1[pos];
      for(int part=0; part<mp; part++)
        {
          w1p[pos][part]=p;
          for(int i=0; i<60; i++) w2p[pos][i][part]=p;
          *(p++)=0;
          for(int i=0; i<prta[part]; i++)
	{
	  if ((prt[part][i]&(1LL<<pos)) &&
	      (!(prt[part][i]&ww)))
	    {
	      for(int j=0; j<60; j++)
	        if ((prt[part][i])&((1LL<<j)-1))
	          w2p[pos][j][part]=p;
	      if ((prt[part][i])&((1LL<<pos)-1))
	        w1p[pos][part]=p;
	      *(p++)=prt[part][i];
	    }
	}
        }
      for(int i=0; i<60; i++) w2p[pos][i][mp]=p;
      for(int i=0; i<60; i++) w2p[pos][i][mp+1]=NULL;
      w1p[pos][mp]=NULL;
      *(p++)=0;
    }
}

void initparts(int sym) // Init Parts -----------------------------------------
{
  for(int part=0; part<12; part++)
    {
      prta[part]=0;
      for(int x=0; x<5; x++)
        for(int y=0; y<4; y++)
          for(int z=0; z<3; z++)
	for(int dir=0; dir<6; dir++)
	  for(int vdir=0; vdir<4; vdir++)
	    {
	      int ok=1;
	      prt[part][prta[part]]=0;
	      for(int i=0; i<6; i++)
	        {
	          prt[part][prta[part]]|=
		1LL<<((z+parts[part][i][dirs[dir][0]]*vdirs[vdir][dirs[dir][0]])+
		      (y+parts[part][i][dirs[dir][1]]*vdirs[vdir][dirs[dir][1]])*3+
		      (x+parts[part][i][dirs[dir][2]]*vdirs[vdir][dirs[dir][2]])*12);
	          if (((z+parts[part][i][dirs[dir][0]]*vdirs[vdir][dirs[dir][0]])<0) ||
		  ((y+parts[part][i][dirs[dir][1]]*vdirs[vdir][dirs[dir][1]])<0) ||
		  ((x+parts[part][i][dirs[dir][2]]*vdirs[vdir][dirs[dir][2]])<0) ||
		  ((z+parts[part][i][dirs[dir][0]]*vdirs[vdir][dirs[dir][0]])>2) ||
		  ((y+parts[part][i][dirs[dir][1]]*vdirs[vdir][dirs[dir][1]])>3) ||
		  ((x+parts[part][i][dirs[dir][2]]*vdirs[vdir][dirs[dir][2]])>4)
		  ) ok=0;
	        }
	      for(int i=0; i<prta[part]; i++)
	        if (prt[part][i]==prt[part][prta[part]])
	          ok=0;
	      if ((ok) && (part==sym))
	        {
	          prts[prta[part]]=2;
	          LONG tst;
	          tst=0;
	          for(int i=0; i<6; i++)
		{
		  tst|=1LL<<((2-(z+parts[part][i][dirs[dir][0]]*vdirs[vdir][dirs[dir][0]]))+
			 (3-(y+parts[part][i][dirs[dir][1]]*vdirs[vdir][dirs[dir][1]]))*3+
			 ((x+parts[part][i][dirs[dir][2]]*vdirs[vdir][dirs[dir][2]]))*12);
		}
	          for(int i=0; i<prta[part]; i++)
		{
		  if (tst==prt[part][i])
		    {
		      if (pcmp(&prt[part][i], &prt[part][prta[part]])SYMORDER 0)
		        prt[part][i]=prt[part][prta[part]];
		      ok=0;
		    }
		}
	          if (tst==prt[part][prta[part]]) prts[prta[part]]=1;
	          tst=0;
	          for(int i=0; i<6; i++)
		{
		  tst|=1LL<<(((z+parts[part][i][dirs[dir][0]]*vdirs[vdir][dirs[dir][0]]))+
			 (3-(y+parts[part][i][dirs[dir][1]]*vdirs[vdir][dirs[dir][1]]))*3+
			 (4-(x+parts[part][i][dirs[dir][2]]*vdirs[vdir][dirs[dir][2]]))*12);
		}
	          for(int i=0; i<prta[part]; i++)
		{
		  if (tst==prt[part][i])
		    {
		      if (pcmp(&prt[part][i], &prt[part][prta[part]])SYMORDER 0)
		        prt[part][i]=prt[part][prta[part]];
		      ok=0;
		    }
		}
	          if (tst==prt[part][prta[part]]) prts[prta[part]]=1;
	          tst=0;
	          for(int i=0; i<6; i++)
		{
		  tst|=1LL<<((2-(z+parts[part][i][dirs[dir][0]]*vdirs[vdir][dirs[dir][0]]))+
			 ((y+parts[part][i][dirs[dir][1]]*vdirs[vdir][dirs[dir][1]]))*3+
			 (4-(x+parts[part][i][dirs[dir][2]]*vdirs[vdir][dirs[dir][2]]))*12);
		}
	          for(int i=0; i<prta[part]; i++)
		{
		  if (tst==prt[part][i])
		    {
		      if (pcmp(&prt[part][i], &prt[part][prta[part]])SYMORDER 0)
		        prt[part][i]=prt[part][prta[part]];
		      ok=0;
		    }
		}
	          if (tst==prt[part][prta[part]]) prts[prta[part]]=1;
	        }
	      if (ok) prta[part]++;
	    }
      qsort(prt[part], prta[part], sizeof(LONG), pcmp);
    }
}

void swapsymetrie(int part)
{
  for(int i=0; i<prta[part]; i++)
    {
      LONG m=0;
      for(int p=0; p<60; p++)
        {
          if (prt[part][i]&(1LL<<p))
	m|=1LL<<((p%3)+(3-(p/3)%4)*3+(4-p/12)*12);
        }
      prt[part][i]=m;
    }
  if (part!=11)
    qsort(prt[part], prta[part], sizeof(LONG), pcmp);
  if (part==SYMETRIE)
    for(int i=0; i<4096; i++)
      {
        mem[i].erase(mem[i].begin(), mem[i].end());
      }
}

void jump(int ppart, LONG ww, int pos)
{
#ifdef PROFILE
  moves++;
#endif
  if (ppart<MAXMEM)
    {
      if (mem[partpos].find(ww)!=mem[partpos].end())
        {
          res+=mem[partpos][ww]*resusfaktor;
          return;
        }
      resmerk[ppart]=res;
    }
  else if (ppart==12)
    {
      res+=resusfaktor;
      if (res%2000==0)
        {
          printf(".");fflush(0);
        }
      return;
    }
  LONG posx=1LL<<pos;
  while(ww&posx){posx=posx<<1; pos++;}

  LONG **wpp;
  int pp;
  LONG tst=ww;
  int mx=MIN(60, pos+24);

  if (symsym)
    {
      if (!(partpos&(1<<SYMETRIE)))
        {
          int ok=1;
          LONG* p=prt[SYMETRIE]+prta[SYMETRIE];
          LONG* e=prt[SYMETRIE];
          while(p!=e)
	{
	  if (!(*(--p)&ww)) {ok=0; break;}
	}
          if (ok) goto weiter;
        }
    }

  for(int p=pos; p<mx; p++)
    {
      if (!(tst&posx))
        {
          LONG **wep=w2p[p][pos];
          wpp=w2p[p][0]+1;
          pp=1;
          while(LONG *wp=*(wpp++))
	{
	  LONG *we=*(wep++);
	  int merk=pp;
	  pp=pp<<1;
	  if (partpos&merk) continue;
	  while(we!=(--wp))
	    {
	      if (!(*wp&ww))
	        {
	          tst|=*wp;
	          goto weiter1;
	        }
	    }
	}
          goto weiter;
        }
    weiter1:;
      posx=posx<<1;
    }

  wpp=w1p[pos];
  pp=1;
  while(LONG *wp=*(wpp++))
    {
      int merk=pp;
      pp=pp<<1;
      if (partpos&merk) continue;
      partpos|=merk;
      while(*(++wp))
        {
          if (!(*wp&ww))
	{
	  jump(ppart+1, ww|*wp, pos+1);
	}
        }
      partpos^=merk;
    }
 weiter:;
  if (ppart<MAXMEM)
    {
      mem[partpos][ww]=(res-resmerk[ppart])/resusfaktor;
    }
}

int main() // Hauptprogramm ---------------------------------------------------
{
  clock_t sclk=clock();
  printf("\nCT-Wuerfel by Peter Schaeffer in 2003.\n");

  initparts(SYMETRIE);
  partpos=1<<11;
  for (int i=0; i<MIN(UMSYM,prta[11]); i++)
    {
      int merk=res;
      clock_t mclk=clock();
      resusfaktor=prts[i];
      init(prt[11][i], 11);
      printf("\n%d ", i);
      jump(1, prt[11][i], 0);
      printf(" %ld L/s", ((res-merk)/2)/MAX(1, ((clock()-mclk)/CLOCKS_PER_SEC)));
    }
  swapsymetrie(SYMETRIE);
  swapsymetrie(11);
  symsym=1;
  for (int i=UMSYM; i<prta[11]; i++)
    {
      int merk=res;
      clock_t mclk=clock();
      resusfaktor=prts[i];
      init(prt[11][i], 11);
      printf("\n%d ", i);
      jump(1, prt[11][i], 0);
      printf(" %ld L/s", ((res-merk)/2)/MAX(1, ((clock()-mclk)/CLOCKS_PER_SEC)));
    }

  clock_t sec=(clock()-sclk)/CLOCKS_PER_SEC;
  printf("\n\n%d Loesungen in %ld:%02ld Minuten (%ld L/s).\n\n", res/2, sec/60, sec%60, (res/2)/MAX(sec, 1));
#ifdef PROFILE
  printf("Dazu wurden %lld.%06lld Stellungen getestet.\n\n", moves/1000000, moves%1000000);
#endif
  return 0;
}
