/*
 * Puzzle solver by N.Meine, 2003/03/27
 *
 * compile: gcc -O2 ctpuzzle.c
 * 
 * With solution printout:  gcc -O2 -Dprintsol ctpuzzle.c
 *
 * Compute time: approx. 15 min. on 2.8 GHz Pentium 4
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define uchar	unsigned char
#define uint64	unsigned long long


#define xdim	4
#define ydim	3
#define zdim	5

#define xydim	(xdim*ydim)

#define numstones	12

#define maxgroups	numstones

typedef struct {
	uchar	px,py;
	uchar	dx,dy,dz;
	uint64	m;
} Tstone;

typedef struct {
	int	id,no;
	uint64	*pat[xdim*ydim*zdim];
} Tgroup;

#define max_sorder	6

static Tstone stones[numstones] = {
	{ 0,0, 3,2,1, 0x0057 },
	{ 0,0, 3,3,1, 0x0471 },
	{ 0,0, 4,2,1, 0x001F },
	{ 0,0, 4,2,1, 0x002F },
	{ 0,0, 2,2,2, 0x1033 },
	{ 0,0, 3,3,1, 0x0227 },
	{ 0,0, 3,2,1, 0x0037 },
	{ 0,0, 3,3,1, 0x0463 },
	{ 0,0, 2,2,2, 0x3011 },
	{ 0,0, 3,3,1, 0x0271 },
	{ 1,0, 3,3,1, 0x0272 },
	{ 0,0, 4,2,1, 0x005F }
};

static Tstone	history[numstones];
static long lsg = 0;


static void plot(Tstone *s,long n)
{
	uchar		y[zdim][ydim][xdim];
	int		qi[3];
	register long	i,a,b,c,ix,iy,iz,t;
	register uint64	h;

	for (i=0; i<xdim*ydim*zdim; i++) y[0][0][i]=255;

	for (i=0; i<n; i++)
	{
		h=s[i].m;

		for (c=0; c<zdim; c++)
		{
			for (b=0; b<ydim; b++)
			{
				for (a=0; a<xdim; a++)
				{
					if ( h&1 ) y[c][b][a]=s[i].px;
					h>>=1;
				}
			}
		}
	}

	if ( (xdim<=ydim) && (xdim<=zdim) ) { ix=0; a=xdim; if ( ydim<=zdim ) { iy=1; iz=2; b=ydim; c=zdim; } else { iy=2; iz=1; b=zdim; c=ydim; }  }
	if ( (ydim< xdim) && (ydim<=zdim) ) { iy=0; a=ydim; if ( xdim<=zdim ) { ix=1; iz=2; b=xdim; c=zdim; } else { ix=2; iz=1; b=zdim; c=xdim; }  }
	if ( (zdim< xdim) && (zdim< ydim) ) { iz=0; a=zdim; if ( xdim<=ydim ) { ix=1; iy=2; b=xdim; c=ydim; } else { ix=2; iy=1; b=ydim; c=xdim; }  }

	for (qi[1]=0; qi[1]<b; qi[1]++)
	{
		for (qi[0]=0; qi[0]<a; qi[0]++)
		{
			for (qi[2]=0; qi[2]<c; qi[2]++)
			{
				t=y[qi[iz]][qi[iy]][qi[ix]];
				if ( t==255 ) printf(" --"); else printf("%3li",t);
			}
			if ( qi[0]<a-1 ) printf("  |  ");
		}
		printf("\n");
	}
	printf("\n");
	fflush(stdout);
}

static inline long ctto(register uint64 f,register long i)	/* count trailing ones, at least i */
{

#if 1
	register long	t;

	f>>=i;

	while ( (f&255)==255 ) { i+=8; f>>=8; }

	t=(long) f;

	if ( (t&15)==15 ) { i+=4; t>>=4; }
	if ( (t& 3)== 3 ) { i+=2; t>>=2; }

	return i+(t&1);	

#else

/*	I wish I had an alpha ...	*/

	__asm__("cttz %1,%0" : "=r" (i) : "r" (~f));
	return i;

#endif

}

static void search_l2(register uint64 f,register Tgroup **gp,register long ng,register long d,register long t)
{
	register Tgroup	*tgp;
	register uint64	tf;
	register uint64	*s;
	register long	i;

	d=ctto(f,d);

	for (i=0; i<ng; i++)
	{
		tgp=gp[i];
		s=tgp->pat[d];
		if ( !s ) continue;

label1b:
		tf=*s;
		if ( !tf ) continue;
		s++;
		if ( f & tf ) goto label1b;

		lsg++;

#if plotsol
		history[t].px=tgp->id;
		history[t].m=tf;
		printf("%li:\n",lsg);
		plot(history,t+1);
		fflush(stdout);
#else
		if ( !(lsg&255) )
		{
			printf("%8li\b\b\b\b\b\b\b\b",lsg);
			fflush(stdout);
		}
#endif

		goto label1b;
	}
}

static void search(register uint64 f,register Tgroup **gp,register long ng,register long d,register long t)
{
	register Tgroup	*tgp;
	register uint64	tf;
	register uint64	*s;
	register long	i;

	d=ctto(f,d);

	for (i=0; i<ng; i++)
	{
		tgp=gp[i];
		s=tgp->pat[d];
		if ( !s ) continue;

label0b:
		tf=*s;
		if ( !tf ) continue;
		s++;
		if ( f & tf ) goto label0b;

#if plotsol
		history[t].px=tgp->id;
		history[t].m=tf;
#endif
		gp[i]=gp[ng-1];

		if ( t<numstones-2 ) search(f|tf,gp,ng-1,d+1,t+1); else search_l2(f|tf,gp,ng-1,d+1,t+1);

		gp[ng-1]=gp[i];
		gp[i]=tgp;

		goto label0b;
	}
}

static void search0(Tgroup **gp,long ng)
{
	uint64		f;
	register uint64	*s;
	register Tgroup	*tgp;
	register long	i,j,t;

	j=t=0;

	for (i=0; i<ng; i++)
	{
		s=gp[i]->pat[0];
		if ( !s ) continue;
		for (; (f=*s); s++) t++;
	}

	for (i=0; i<ng; i++)
	{
		tgp=gp[i];
		s=tgp->pat[0];
		if ( !s ) continue;

		gp[i]=gp[ng-1];

		history[0].px=tgp->id;

		for (; (f=*s); s++)
		{
#ifndef plotsol
			printf("\b\b\b\b\b\b\b\b%3li/%3li ",++j,t); fflush(stdout);
#endif
			history[0].m=f;	
			search(f,gp,ng-1,0,1);

// printf("%li\n",lsg); exit(0);

		}

		gp[ng-1]=gp[i];
		gp[i]=tgp;
	}
}


static inline long cmpstone(Tstone *x,Tstone *y)
{
	if ( x->m == y->m ) return 0; else
	if ( x->m  > y->m ) return 1; else return -1;
}

static void transf(int *w,int *v,long n)
{
	register long	t,p,x,y,z;

	x=v[0]; y=v[1]; z=v[2];

	p=0;

	if ( n& 8 ) { p^=1; t=x; x=y; y=t; }
	if ( n&16 ) { p^=1; t=x; x=z; z=t; }

	if ( n& 4 ) { p^=1; t=y; y=z; z=t; }

	if ( n& 1 ) { p^=1; x=-x; }
	if ( n& 2 ) { p^=1; y=-y; }

	if ( p ) z=-z;

	w[0]=x; w[1]=y; w[2]=z;
}

static long gen_ts(Tstone *y,Tstone *x,long t0,long nt)
{
	int		v[max_sorder][3];
	int		w[max_sorder][3];
	register long	i,a,b,c,t,n,q;
	register uint64	ql;

	n=0;
	ql=x->m;

	for (a=0; a<zdim; a++)
	{
		for (b=0; b<ydim; b++)
		{
			for (c=0; c<xdim; c++)
			{
				if ( ql&1 )
				{
					w[n][0]=c; w[n][1]=b; w[n][2]=a;
					n++;
				}
				ql>>=1;
			}
		}
	}

	for (q=0,t=t0; t<t0+nt; t++)
	{
		a=xdim;
		b=ydim;
		c=zdim;
		for (i=0; i<n; i++)
		{
			transf(v[i],w[i],t);
			if ( v[i][0]<a ) a=v[i][0];
			if ( v[i][1]<b ) b=v[i][1];
			if ( v[i][2]<c ) c=v[i][2];
		}
		for (i=0; i<n; i++)
		{
			v[i][0]-=a;
			v[i][1]-=b;
			v[i][2]-=c;
		}
		a=b=c=0;
		for (i=0; i<n; i++)
		{
			if ( v[i][0]>a ) a=v[i][0];
			if ( v[i][1]>b ) b=v[i][1];
			if ( v[i][2]>c ) c=v[i][2];
		}

		if ( (a>=xdim) || (b>=ydim) || (c>=zdim) ) continue;

		y[q].dx=a+1;
		y[q].dy=b+1;
		y[q].dz=c+1;
		y[q].m=0;
		for (i=0; i<n; i++) y[q].m|=((uint64) 1)<<(v[i][0]+xdim*v[i][1]+xydim*v[i][2]);

		for (a=b=0; !(y[q].m&(((uint64) 1)<<(a+xdim*b))); )
		{
			a++;
			if ( a>=xdim ) { a=0; b++; }
		}

		y[q].px=a;
		y[q].py=b;

		q++;
	}
	return q;
}

static long top_eq(Tstone *t,long n,Tstone *x)
{
	while (n--)
	{
		if ( cmpstone(t,x)==0 ) return 1;
		t++;
	}
	return 0;
}

static long select_stones(uint64 *f,Tstone *s,long n,long x,long y,long z)
{
	register long	i,j,dz,sx,sy;

	for (i=j=0; i<n; i++,s++)
	{
		dz=s->dz;
		sx=s->px;
		sy=s->py;
		if ( sx>x ) continue;
		if ( sy>y ) continue;
		sx=x-sx;
		sy=y-sy;
		if ( s->dx>xdim-sx ) continue;
		if ( s->dy>ydim-sy ) continue;
		if ( z+dz>zdim ) continue;

		sx+=xdim*sy+xydim*z;

		f[j] = s->m << sx;
		j++;
	}
	return j;
}

static void group_stones(Tgroup *sg,Tstone *s0,long n,uint64 *buf)
{
	uint64	*buf0;
	uint64	t;
	Tstone	ts[24];
	long	i,j,l,m,x,y,z,s;

	s=0;
	buf0=buf; // =alloca((24+1)*n*xdim*ydim*zdim*sizeof(uint64));

	for (l=0; l<n; l++)
	{
		m=gen_ts(ts,s0+l,0,24);

		for (;;)
		{
			for (i=j=1; i<m; i++)
			{
				if ( !top_eq(ts,j,ts+i) ) ts[j++]=ts[i];		/* eliminate identities */
			}

			if ( s || j<24 ) break;


			for (m=0; m<6; m++) gen_ts(ts+m,s0+l,4*m,1);
			s=1;
			printf("Symmetries reduced for group %li\n",l);
		}

		sg[l].id=l;
		sg[l].no=j;

		for (z=0; z<zdim; z++)
		{
			for (y=0; y<ydim; y++)
			{
				for (x=0; x<xdim; x++)
				{
					i=((ulong) buf)>>3;
					i=7-((i-1)&7);
					buf+=i;

					m=select_stones(buf,ts,j,x,y,z);	/* select fitting stones */

					if ( m )
					{
						sg[l].pat[x+xdim*y+xydim*z]=buf;
						buf+=m;
						*(buf++)=0;
					}
					else
					{
						sg[l].pat[x+xdim*y+xydim*z]=NULL;
					}
				}
			}
		}
	}

	printf("Buffer size: %li quadwords\n",buf-buf0);


/* Umsortieren - bringt nix  */
/*
	i=buf-buf0;
	buf=(uint64 *) malloc(i*sizeof(uint64));


	for (z=0; z<zdim; z++)
	{
		for (y=0; y<ydim; y++)
		{
			for (x=0; x<xdim; x++)
			{
				for (l=0; l<n; l++)
				{
					buf0=sg[l].pat[x+xdim*y+xydim*z];
					if ( buf0 )
					{
						sg[l].pat[x+xdim*y+xydim*z]=buf;
						do
						{
							t=*(buf0++);
							*(buf++)=t;
						}
						while ( t );
					}
				}
			}
		}
	}
*/
}

int main()
{
	long	i,j,k,ng;
	Tgroup	sg[maxgroups];
	Tgroup	*gp[maxgroups];
	uint64	buffer[(24+1)*maxgroups*xdim*ydim*zdim];

	ng=numstones;
	group_stones(sg,stones,numstones,buffer);

	for (j=0,i=24; i>=1; i--)
	{
		for (k=0; k<ng; k++)
		{
			if ( sg[k].no==i ) gp[j++]=sg+k;
		}
	}

	printf("Searching solutions...\n");
	fflush(stdout);

	search0(gp,ng);

	printf("\rTotal: %li solutions\n",lsg);

	exit(0);
}

