// Copyright (C) 2003 by Michael Pichler.
// Partially based on code Copyright (C) 2003 by Harald Bgeholz.
// See copympi.txt for further information.
//
// created: mpichler, 20030411
// changed: mpichler, 20030413


#include "bits.h"

// puzzle dimensions
#ifdef PENTOMINO
# define XLEN 10
# define YLEN 6
# define ZLEN 1
#else
# define XLEN 5
# define YLEN 4
# define ZLEN 3
#endif

// puzzle dependent ...
// hard limit: 24 * XLEN * YLEN * ZLEN
#define MAX_PARTPOS 600

class Point3i;

class Part
{
  public:
    // orientation dirs for twist: zx: z axis up, x axis right etc.
    // z2: 2 directions with z up; z_: all 8 orientations for +/-z axis up;
    // zz: z_ without z2 (internal use); sym on asymmetric part eliminates
    // symmetries in a puzzle where (XLEN, YLEN, ZLEN) are all inequal;
    // none is used on user place calls; all to consider all orientations.
    enum Orientations
    {
      none = 0,  // user place calls
      zx = 0x001, zy = 0x002, z2 = 0x003, zz = 0x004, z_ = 0x007,
      xy = 0x010, xz = 0x020, x2 = 0x030, xx = 0x040, x_ = 0x070,
      yx = 0x100, yz = 0x200, y2 = 0x300, yy = 0x400, y_ = 0x700,
      sym = (x2 | y2 | z2),  // 2 in each up direction
      all = (x_ | y_ | z_)
    };

    // points only needed for twist/turn/move; solution computed solely on pos_ bits
    Part (int partnum, Point3i* point, int numpoints, Orientations orientations /*= all*/);
    // change default name (hex digit)
    void setName (char name)  { name_ = name; }
    char getName () const  { return name_; }
    int getNumberOfPositions () const  { return numpos_; }
    // place the part (already properly oriented) with the specified offset
    const Bitvector* place (const Point3i* xfpt, int dx, int dy, int dz);
    // optional (once only): reorder puzzle bits
    static void shuffleBits (Part part[], int numparts, bool verbose);
    // our friend, the puzzle solver:
    static int solve (Bitvector bvfield, int level, int nextbit, BIT_TYPE nbval);

  private:
    void twist (Orientations dirs);
    void turn (Point3i* xfpt, const Point3i& up, const Point3i& right);
    void move (const Point3i* xfpt, const Point3i& min, const Point3i& max);
    static void printSolution (int solnum);  // for CTLOGO and PENTOMINO puzzles

    // map 3D point to bit (only valid before shuffleBits)
    static int pos2bit (int x, int y, int z)
    { return
#ifdef POS2BIT
      pos2bit_[x][y][z]
#else
      (YLEN*ZLEN)*x + ZLEN*y + z
#endif
      ;
    }

#ifdef POS2BIT
    static int pos2bit_[XLEN][YLEN][ZLEN];
#endif
    char name_;
    const Point3i* point_;
    /*const*/ int numpoints_;
    Bitvector bvpos_[MAX_PARTPOS];
    int numpos_;
    int start_[NUM_BITS];  // pointer into bvpos_ for smallest bit

  friend class Tuple;
};
