// Copyright (C) 2003 by Harald Bgeholz.
// See copympi.txt for further information.
//
// changed: mpichler, 20030412 (using 64 bit type)


#define BIT_TYPE unsigned long long
#define BIT_ONE 1LL
#define NUM_BITS 64

class Bitvector
{
  public:
    // constructors
    Bitvector ()  { w_ = 0; }
    Bitvector (const Bitvector& bv1, const Bitvector& bv2)  // bitwise or
    { w_ = bv1.w_ | bv2.w_; }
    // BIT_TYPE getBits () const  { return w_; }

    void set (const Bitvector& bv)  { w_ |= bv.w_; }
    void set (int bit)  { w_ |= (BIT_ONE << bit); }
    bool test (const Bitvector& bv) const  { return (w_ & bv.w_) != 0; }
    bool testN (const Bitvector& bv) const  { return (w_ & bv.w_) == 0; }
    bool test (int bit) const  { return (w_ & (BIT_ONE << bit)) != 0; }
    bool testValue (BIT_TYPE bval) const  { return (w_ & bval) != 0; }
    bool operator== (const Bitvector& bv) const  { return w_ == bv.w_; }

  private:
    BIT_TYPE w_;
};
