/*
c't-Puzzle-Programmierwettbewerb (c't 7/03)
Version 1.4 (C) 2003 Martin Grieb,  box1@martin-grieb.de
     409963 Lsungen ("ber400.000echtverschiedene Lsungen,Quersumme31")
56057821436 Schleifendurchlaeufe, 7533857228 Teile eingebaut
 1184048941 verbaute Ebenen vorhergesagt

icl -O3 -QaxW ctp.cpp

1.0:
Laufzeit: 20:28 auf P4 2400
1.1:
Laufzeit: 19:40
Voraussage nichtbelegbarer Ebenen
1.2:
Laufzeit: h = 1: 18:48   h = 2: 18:34   h = 3: 18:51
nichtbelegbare Ebenen nach verfgbaren Teilen unterschieden
1.3:
Laufzeit: 16:09
aus Tabellen verfgbarer Teile die Teile mit 0 Positionen ausgeblendet
1.4:
Schleife optimiert
Laufzeit: 
  -O3 -QaxW  (fr alle CPUs)   15:58
  -O3 -QxW   (nur Pentium IV)  15:46


Einteilung Quader: X=3 Y=4 Z=5

Teile: Grundkoordinaten: X kurz, Y lang, Z flach
Bitvektoren: erst X, dann Y. 16 Bit pro Ebene (obwohl nur 12 belegt).
Verschiebung: in X: <<= 1 in Y: <<= 3

Puzzle wird ebenenweise (0-4) aufgefllt. Jede Ebene kann 2^12 = 4096 Zustnde annehmen.
Jedes Teil hat fr jeden dieser 4096 Zustnde eine Liste, welche seiner Positionen an die freie Stelle passen.
Dabei gibt es vier Eintrge fr die Zahl der Positionen, je nach verfgbarer Hhe (0-3)

Vergleiche:
1) Ebene 0:    tabellengetrieben, passt immer
2) Ebenen 1,2: ein Vergleich 32 Bit
3) Ebene 3:    passt immer. Es knnen hier nur Teile 1,2,3 kollidieren. Teil 1 wird zur Symmetrieausblendung verwendet,
               Knick liegt immer in Ebene 0. Teil 2 verzweigt nie auf Ebene 3. Und wenn Teil 3 auf Ebene 3 kollidiert,
               kollidiert es auch auf Ebene 1.

               Teil 1 ####   Teil 2 ####   Teil 3 ####
                      #              #             # #
*/

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

void * error ( char *format, ...);

typedef unsigned int   ibf;
typedef unsigned short sbf;
// Darstellung gedrehtes Teil als Bitvektor
typedef union {
  ibf i;
  sbf s[2];
} ubf;

// Teil, das in eine bestimmte Orientierung gedreht ist (Bitvektor)
class part_bit {
  void print_plane(ibf i);
public:
  ubf e03;  // Ebenen 0 und 3
  ubf e12;  // Ebenen 1 und 2

  int operator == (const part_bit & pb) {
    return e03.i == pb.e03.i && e12.i == pb.e12.i;
  }
  int valid (void) {
    return e03.s[0] != 0;
  }
  void zero(void) {
    e03.i = e12.i = 0;
  }
  void print(void);
};

// Alle dynamischen Bitvektoren in einem groen Array speichern
// (man wei vor dem anlegen meist noch nicht, wie viele man braucht)
class _part_bit_speicher{
  part_bit u[200000];
  int current;
public:
  _part_bit_speicher() {
    current = 0;
  }
  part_bit * get(void) {
    if (256 + current >= 200000)
      error("part_bit_speicher vergroessern !");
    return u + current;
  }
  void alloc(int anzahl) {
    current += anzahl;
  }
  void print(void) {
    printf("part_bit_speicher: %d belegt\n", current);
  }
} part_bit_speicher;


// Liste von Teile-Bitvektoren, sortiert nach Hoehe
class part_list {
public:
  part_bit *p;
  unsigned char zahl[4];  // Anzahl Positionen mit Hoehe 1, <=2, <=3, <=4
  void print(void);
};


// Teil, das in eine bestimmte Orientierung gedreht ist
class part_pos {
  char p[4][4][4];   // Inhalt
  sbf  bitplanecalc(int z);  // eine Bitebene berechnen
public:
  int X,Y,Z;         // aktuelle Ausdehnungen
  part_bit pb;

  void set(char * s1, char * s2, char *s3, char *s4);
  void set_tilt (const part_pos &pp);   // kopieren und dabei nach vorne kippen
  void set_rot  (const part_pos &pp);   // kopieren und dabei um Z-Achse rotieren
  part_pos();
  void print(int mode);
  void bitcalc(void);        // Bitmatrix berechnen
};

class part {
  int orientierungen;  // max 24, je nach Symmetrie
public:
  part_pos p[24];
  part_list pl;          // alle Positionen einschl. Verschiebungen
  part_list plf[4096];   // Tabelle mit den passenden Positionslisten fr jede mgliche Bitplane
  ibf  bit_index;        // fr jedes Teil ist hie ein anderes Bit gesetzt
  part(char * s1, char * s2, char *s3 = NULL, char *s4 = NULL, int speziell = 0);
  void print(int mode = 0);
};

ibf and_bit[32];          // Tabelle, um Einzelbit auszumaskieren
int first_empty[4096];    // Tabelle fr erstes freies Bit einer Plane (12 = voll)
int gesetzte_bits[4096];  // Tabelle, wieviele Bits in einem Bitvektor gesetzt sind

void part_bit :: print_plane(ibf ib) {
  for (int y = 4; y--;) {
    char b[10] = "   ";
    int offset = 3 - y;
    for (int x = 3; x--;)
      b[offset + x] = ib & and_bit[3*y+x] ? '#' : '-';
    b[offset+3] = 0;
    printf("%s\n", b);
  }
}

void part_bit :: print(void) {
//  printf ("e03 %x e12 %x\n", e03.i, e12.i);
  print_plane(e03.s[1]);
  print_plane(e12.s[1]);
  print_plane(e12.s[0]);
  print_plane(e03.s[0]);
}

void part_list :: print(void) {
  int i = 0;
  for (int h = 0; h < 4; h++) {
    printf ("%d Pos mit Hoehe %d\n", h == 0 ? zahl[h] : zahl[h] - zahl[h-1], h+1);
    for (; i < zahl[h]; i++)
      p[i].print();
  }
}

part_pos :: part_pos(void) {
  for (int i = 4; i--;)
    for (int j = 4; j--;)
      for (int k = 4; k--;)
        p[i][j][k] = 0;
  X = Y = Z = 1;
}


void part_pos :: set(char * s1, char * s2, char *s3, char *s4) {
  if (s4) {      // zwei Ebenen, zweispaltig
    X = 2;
    Y = strlen(s1);
    Z = 2;
    for (int i = 0; i < Y; i++) {
      if (s1[i] == '#') p[0][i][0] = 1;
      if (s2[i] == '#') p[1][i][0] = 1;
      if (s3[i] == '#') p[0][i][1] = 1;
      if (s4[i] == '#') p[1][i][1] = 1;
    }
  }
  else if (s3) { // flaches Teil, dreispaltig
    X = 3;
    Y = strlen(s1);
    for (int i = 0; i < Y; i++) {
      if (s1[i] == '#') p[0][i][0] = 1;
      if (s2[i] == '#') p[1][i][0] = 1;
      if (s3[i] == '#') p[2][i][0] = 1;
    }
  }
  else {         // flaches Teil, zweispaltig
    X = 2;
    Y = strlen(s1);
    for (int i = 0; i < Y; i++) {
      if (s1[i] == '#') p[0][i][0] = 1;
      if (s2[i] == '#') p[1][i][0] = 1;
    }
  }
  bitcalc();
}

void part_pos :: print(int modus) {
  if (modus == 0) { // Array
    printf ("X: %d  Y: %d  Z: %d \n", X, Y, Z);
    for (int z = Z; z--;)
      for (int y = Y; y--;) {
        char b[10] = "   ";
        int offset = Y - y - 1;
        for (int x = X; x--;)
          b[offset + x] = p[x][y][z] ? '#' : '-';
        b[offset+X] = 0;
        printf("%d: %s\n", z, b);
      }
  }
  else
    pb.print();
}

sbf part_pos :: bitplanecalc(int z) {
  sbf sb = 0;
  for (int y = 4; y--;)
    for (int x = 3; x--;)
      sb = (sb << 1) + p[x][y][z];
  return sb;
}

void part_pos :: bitcalc(void) {
  if (X > 3) {
    pb.e03.s[0] = 0;
    return;
  }
  pb.e03.s[0] = bitplanecalc(0);
  pb.e12.s[0] = bitplanecalc(1);
  pb.e12.s[1] = bitplanecalc(2);
  pb.e03.s[1] = bitplanecalc(3);
}

void part_pos :: set_tilt (const part_pos &pp) {
  for (int y = pp.Y; y--;)
    for (int x = pp.X; x--;)
      for (int z = pp.Z; z--;)
        p[x][pp.Z - 1 -z][y] = pp.p[x][y][z];
  X = pp.X; Y = pp.Z; Z = pp.Y;
  bitcalc();
}

void part_pos :: set_rot (const part_pos &pp) {
  for (int y = pp.Y; y--;)
    for (int z = pp.Z; z--;)
      for (int x = pp.X; x--;)
        p[pp.Y - 1 - y][x][z] = pp.p[x][y][z];
  X = pp.Y; Y = pp.X; Z = pp.Z;
  bitcalc();
}

part :: part(char * s1, char * s2, char *s3, char *s4, int speziell) {
  p[0].set(s1,s2,s3,s4);
  if (speziell) { // erstes Teil erfhrt Sonderbehandlung: Symmetrieentfernung 24->6
                  // auerdem sind von den 6 verbliebenen Positionen 2 ungltig
    p[1].set_tilt(p[0]);
    p[2].set_rot (p[1]);
    p[4].set_tilt(p[2]);  // temporr, nicht weiterverwendet
    p[5].set_rot (p[4]);  // temporr, nicht weiterverwendet
    p[3].set_rot (p[5]);
    orientierungen = 4;
  }
  else {
  // p[0,4,8,12,16,20] haben die 6 Grundflchen in der X-Ebene,
  // die drei folgenden jeweils die Rotation um die Z-Achse
    for (int i = 1; i <= 3; i++)
      p[i].set_rot(p[i-1]);
    p[4].set_tilt(p[0]);
    for (i = 5; i <= 7; i++)
      p[i].set_rot(p[i-1]);
    p[8].set_tilt(p[1]);
    for (i = 9; i <= 11; i++)
      p[i].set_rot(p[i-1]);
    p[12].set_tilt(p[2]);
    for (i = 13; i <= 15; i++)
      p[i].set_rot(p[i-1]);
    p[16].set_tilt(p[3]);
    for (i = 17; i <= 19; i++)
      p[i].set_rot(p[i-1]);
    p[20].set_tilt(p[4]);
    for (i = 21; i <= 23; i++)
      p[i].set_rot(p[i-1]);
// ungltige (Teil ragt ber Puzzle hinaus) und doppelte entfernen
    orientierungen = 0;
    for (i = 0; i < 24; i++)
      if (p[i].pb.valid()) {
        int doppelt = 0;
        for (int j = 0; j < i; j++)
          if (p[i].pb == p[j].pb) {
            doppelt = 1;
            break;
          }
        if (!doppelt)
          p[orientierungen++] = p[i];
      }
  }
  // Translationen bestimmen
  pl.p = part_bit_speicher.get();
  int translationen = 0;
  for (int hoehe = 1; hoehe <= 4; hoehe++) {
    for (int i = 0; i < orientierungen; i++)
      if (p[i].Z == hoehe) {
        for (int x = 0; x <= 3 - p[i].X; x++)
          for (int y = 0; y <= 4 - p[i].Y; y++) {
            pl.p[translationen  ].e03.i = p[i].pb.e03.i << (x + 3*y);
            pl.p[translationen++].e12.i = p[i].pb.e12.i << (x + 3*y);
          }
      }
    pl.zahl[hoehe - 1] = translationen;
  }
  part_bit_speicher.alloc(translationen);
  // Tabelle mit den passenden Positionslisten fr jede mgliche Bitplane berechnen
  // Da gibts viele identische Listen, die man zusammenfassen knnte, aber es ist schnell genug so.
  for (int i = 0; i < 4096; i++) {
    part_list * plp = plf + i;
    plp->p = part_bit_speicher.get();
    int j = 0, passend = 0;
    for (hoehe = 0; hoehe < 4; hoehe++) {
      for (; j < pl.zahl[hoehe]; j++) {
        if ((i & pl.p[j].e03.s[0]) == 0                      // Kollisionsprfung
            && (pl.p[j].e03.s[0] & and_bit[first_empty[i]])) // erstes freies Bit gefllt ?
          plp->p[passend++] = pl.p[j];
      }
      plp->zahl[hoehe] = passend;
    }
    part_bit_speicher.alloc(passend);

  }
//  printf("Orientierungen: %2d  Translationen:", orientierungen);
//  for (i = 0; i < 4; i++)
//    printf(" %3d", pl.zahl[i]);
//  printf("\n");
}

void part :: print(int modus) {
  if (modus == 2)
    pl.print();
  else for (int i = 0; i < orientierungen; i++)
    p[i].print(modus);
}

void * error ( char *format, ...)
{
  va_list apo;
  char pp_buf[1000];
  int  err = 0;

  va_start (apo, format);
  vsprintf (pp_buf, format, apo);
  va_end   (apo);

  if (pp_buf[0])
  {
    printf("ERROR: %s\n", pp_buf);
    err = 1;
  }
//  if (logfile) fclose(logfile);
  exit (err);
  return NULL;     // dummy, just to allow p = mymalloc (x) || error ("");
}

// Zeitmessung (nur sekundengenau)
class timer {
  time_t start;
public:
  timer() {
    start = time(NULL);
  }
  float zeit(void) {
    time_t end = time(NULL);
    return difftime(end, start);
  }
  ~timer() {
    int sekunden = zeit();
    int minuten = sekunden / 60;
    sekunden = sekunden % 60;
    printf ("Laufzeit: %d:%02d \n", minuten, sekunden);
  }
} stopuhr;

const int h_opt_max = 2;   // Hoehe, bis zu der vorausberechnet wird (0-3)

// Liste noch freier Teile
class teile_tabelle {
public:
  int verfuegbar;
  part * p[12];

  void set (ibf ib, part * parts) {
    int k = 0;
    for (int j = 0; j < 12; j++)
      if (ib & and_bit[j])
        p[k++] = parts + j;
    verfuegbar = k;
  }
};

class puzzle {
  part * parts;

  // Das Puzzle wird iterativ statt rekursiv gespeichert
  class puzzleschritt {
  public:
    teile_tabelle * teile;  // Liste aller verfgbaren Teile
    ibf teile_bit;       // die Liste als Bitvektor
    part * teil;         // das Teil, das gerade gecheckt wird
    int teil_idx;        // das Teil, das gerade gecheckt wird (Index aus Teile)
    int teil_pos;        // dessen aktuelle Position
    part_bit pb;         // aktuelle Wrfelbelegung
    int ebene;           // 0..4 aktuell zu fllende Ebene
    int hoehe;           // 0..3 maximale Teilehoehe - 1
    part_list * pl;      // Positionsliste des Teils, das gerade gecheckt wird
  };

  typedef char c_bigmatrix[4096][4096];
  c_bigmatrix * ebene_verbaut;  // fr jeden Ebeneninhalt ablegen, ob weitergebaut werden kann
                                      // [Hhe][Inhalt][verfgbare Teile]
  int ebene_verbaut_berechnen(int hoehe, ibf ebenen_inhalt, ibf teile);

  teile_tabelle tt_all[4096];    // alle mglichen Listen von Teilen
  ibf teile_verfuegbar[4][4096]; // fuer jede Hoehe und Ebeneninhalt Bitmaske der passenden Teile
public:
  puzzle(part * p);
  void solve(void);
};

puzzle :: puzzle(part * p) {
  parts = p;
  for (int i = 0; i < 12; i++)
    parts[i].bit_index = and_bit[i];
  for (i = 0; i < 4096; i++)   // Teilelisten-Tabelle aufbauen
    tt_all[i].set(i, parts);
  for (int h = 0; h < 4; h++)
    for (int i = 0; i < 4096; i++) {
      ibf verfuegbar = 0;
      for (int k = 0; k < 12; k++)
        if (parts[k].plf[i].zahl[h])
          verfuegbar |= and_bit[k];
      teile_verfuegbar[h][i] = verfuegbar;
    }

  printf("verbaute Ebenen vorausberechnen...\r");
  ebene_verbaut = ( c_bigmatrix *) malloc((h_opt_max+1)*4096*4096); // wenn man das Array statisch anlegt schmiert das Programm ab...
  if (!ebene_verbaut) error("malloc");

  for (h = 0; h <= h_opt_max; h++) {
    int verbaut_sum = 0;
    for (int i = 0; i < 4095; i++) {  // == 4095 ist die volle Ebene und da wirds nicht aufgerufen
      char * e = ebene_verbaut[h][i];
      for (int k = 4096; k--;)
        e[k] = 0;
      int mindest_teile = ((4 - h) * 12 + gesetzte_bits[i] - 1 // Mindestmenge verbauter Wrfel, -1 wg. dem 4er Teil
                            + 4) / 5;                          // + 4: Rest auffllen, / 5: Division ohne Rest
      for (k = 4095; k > 0; k--)
        if (!e[k]                              // nur berechnen, wenn noch nicht als belegt gekennzeichnet
             && gesetzte_bits[k] + mindest_teile <= 12) { // und der Teilevektor hier berhaupt noch auftreten kann
          int verbaut = e[k] = ebene_verbaut_berechnen(h, i, k);
          if (verbaut) {
            verbaut_sum++;
            for (int l = k-1; l--;)  // Alle Teilekombinationen, die keine anderen Teile als die aktuelle
              if ((l | k) == k) {    // Kombination enthalten, gehen auch nicht
                e[l] = 1;
                verbaut_sum++;
              }
          }
        }
    }
//    printf("Hoehe %d : verbaut %d\n", h, verbaut_sum);
  }
}

// Vorausberechnen, ob eine teilvorbelegte Ebene berhaupt noch aufgefllt werden kann.
// Copy-Paste der Hauptiteration, um nicht dort durch zustzliche Abfragen Zeit zu verbraten
int puzzle :: ebene_verbaut_berechnen(int hoehe, ibf ebenen_inhalt, ibf teile) {
  puzzleschritt ps[12];
  int tz = gesetzte_bits[teile] - 1;              // noch verfgbare Teile - 1
  int tz_start = tz;
  puzzleschritt * p = ps + tz;
  p->teile_bit = teile;
  p->teile = tt_all + p->teile_bit;
  p->teil_idx = 0;
  p->pb.zero();
  p->pb.e03.s[0] = ebenen_inhalt;
  p->teil = p->teile->p[p->teil_idx];
  p->pl = p->teil->plf + ebenen_inhalt;
  p->teil_pos = p->pl->zahl[hoehe];
  while (1) {
    if (!p->teil_pos) {                          // keine Position mehr fr aktuelles Teil
      p->teil_idx++;                             // nchstes Teil
      if (p->teil_idx >= p->teile->verfuegbar) { // letztes Teil erreicht
        tz++;                                    // ein Teil zurck
        if (tz > tz_start)                       // fertig !
          break;
        p = ps + tz;                             // letzten Zustand vom Stapel holen
                                                 // und dort nchste Position probieren
      }
      else {                                     // weiter mit nchstem gltigen Teil
        p->teil = p->teile->p[p->teil_idx];      // Teil aus Index berechnen
        p->pl = p->teil->plf
                + p->pb.e03.s[0];                // und Positionsliste passend zur aktuellen Ebene aus Tabelle holen
        p->teil_pos = p->pl->zahl[hoehe];
      }
    }
    else {                                       // wir haben noch gltige Positionen !
      part_bit * pb1 = & p->pl->p[--(p->teil_pos)];  // Bitvektor aktueller Position merken (wird nochmal gebraucht)
      if ((pb1->e12.i                            // Vergleich der Ebenen 1 und 2 (3 passt immer)
           & p->pb.e12.i) == 0) {                // passt ! Teil einbauen und nchstes vorbereiten
        if (tz == 0) {                           // das war schon das letzte Teil
          if ((p->pb.e03.s[0] | pb1->e03.s[0]) == 0xfff)
            return 0;                            // Ebene ist voll !
          else
            continue;                            // passt nicht, letztes Teil fllt Ebene nicht aus.
        }
        tz--;                                  // ein Teil weniger
        puzzleschritt * p1 = ps + tz;          // nchsten Schritt vorbereiten
        p1->teile_bit = p->teile_bit ^ p->teil->bit_index;  // Bit des benutzten Teil mit XOR ausmaskieren
        p1->teil_idx = 0;                      // Anfangen mit erstem verbliebenem Teil
        p1->pb.e03.i = p->pb.e03.i | pb1->e03.i; // Teil einbauen
        p1->pb.e12.i = p->pb.e12.i | pb1->e12.i;
        if (p1->pb.e03.s[0] == 0xfff) {        // Ebene 0 ist voll !
          return 0;
        }
        p1->teile = tt_all + (p1->teile_bit & teile_verfuegbar[hoehe][p1->pb.e03.s[0]]);
        if (p1->teile->verfuegbar == 0) {
              tz++;                            // wieder zurcksetzen
              continue;
        }
        p1->teil = p1->teile->p[0];            // Teil aus Index berechnen
        p1->pl = p1->teil->plf
                + p1->pb.e03.s[0];             // und Positionsliste passend zur aktuellen Ebene aus Tabelle holen
        p1->teil_pos = p1->pl->zahl[hoehe];
        p = p1;                                // ab jetzt Puzzle mit eingebautem Teil benutzen
      }
    }
  }
  return 1;
}

// Die Hauptroutine (Backtracking, iterativ statt rekursiv)
void puzzle :: solve(void) {
  printf ("los gehts !                          \r");
  puzzleschritt ps[12];
  int loesungen = 0;
  double schleifenzaehler = 0.0, einfuegzaehler = 0.0;
  int verbaut_erkannt = 0;
  int ausgabezaehler  = 1000;
  int tz = 11;              // noch verfgbare Teile - 1
  register puzzleschritt * p = ps + tz;
  p->teile_bit = 0xfff;
  p->teile = tt_all + p->teile_bit;
  p->teil_idx = 0;
  p->pb.zero();
  p->ebene = 0;
  p->hoehe = 3;
  p->teil = p->teile->p[p->teil_idx];
  p->pl = p->teil->plf;
  p->teil_pos = p->pl->zahl[p->hoehe];
  while (1) {
//    schleifenzaehler += 1.0;
    if (!p->teil_pos) {                          // keine Position mehr fr aktuelles Teil
      p->teil_idx++;                             // nchstes Teil
      if (p->teil_idx >= p->teile->verfuegbar) { // letztes Teil erreicht
        tz++;                                    // ein Teil zurck
        if (tz == 12)                            // fertig !
          break;
        p = ps + tz;                             // letzten Zustand vom Stapel holen
                                                 // und dort nchste Position probieren
      }
      else {                                     // weiter mit nchstem gltigen Teil
        p->teil = p->teile->p[p->teil_idx];      // Teil aus Index berechnen
        p->pl = p->teil->plf
                + p->pb.e03.s[0];                // und Positionsliste passend zur aktuellen Ebene aus Tabelle holen
        p->teil_pos = p->pl->zahl[p->hoehe];
      }
    }
    else {                                       // wir haben noch gltige Positionen !
      part_bit * pb1 = & p->pl->p[--(p->teil_pos)];  // Bitvektor aktueller Position merken (wird nochmal gebraucht)
      if ((pb1->e12.i                            // Vergleich der Ebenen 1 und 2 (3 passt immer)
           & p->pb.e12.i) == 0) {                // passt !
        if (tz == 0) {                           // war letztes Teil
          loesungen ++;                          // Loesung gefunden !
          if (!--ausgabezaehler) {               // bei jeder xten Ausgabe machen
            ausgabezaehler  = 1000;
            float f = stopuhr.zeit();
            if (f != 0.0)                        // damit das Programm auch noch auf einem P6 mit 10 GHz luft...
              printf ("%d (%.0f / sec)     \r", loesungen, loesungen / f);
          }
          p->teil_pos = 0;                       // die restlichen Positionen knnen wir uns dann schenken
        }
        else {                                   // Teil einbauen und nchstes vorbereiten
//          einfuegzaehler += 1.0;
          tz--;                                  // ein Teil weniger
          register puzzleschritt * p1 = ps + tz; // nchsten Schritt vorbereiten
          p1->teile_bit = p->teile_bit ^ p->teil->bit_index;  // Bit des benutzten Teil mit XOR ausmaskieren
          p1->pb.e03.i = p->pb.e03.i | pb1->e03.i; // Teil einbauen
          p1->pb.e12.i = p->pb.e12.i | pb1->e12.i;
          if (p1->pb.e03.s[0] == 0xfff) {        // Ebene 0 ist voll !
            if (p1->pb.e12.s[0] == 0xfff) {      // Ebene 1 ist auch voll
              if (p1->pb.e12.s[1] == 0xfff) {    // Ebene 2 ist auch voll (Ebene 3 kann nicht sein)
                p1->pb.e03.s[0] = p1->pb.e03.s[1];  // E0 = E3  Ebenen rotieren
                p1->pb.e12.i    = 0;             // E1 = E2 = leer
                p1->pb.e03.s[1] = 0;             // E3 = leer
                p1->ebene = p->ebene + 3;
              }
              else {                             // Ebenen 0 und 1 voll
                p1->pb.e03.s[0] = p1->pb.e12.s[1];   // E0 = E2  Ebenen rotieren
                p1->pb.e12.s[0] = p1->pb.e03.s[1];   // E1 = E3
                p1->pb.e12.s[1] = 0;             // E2 = leer
                p1->pb.e03.s[1] = 0;             // E3 = leer
                p1->ebene = p->ebene + 2;
              }
            }
            else {                               // nur Ebene 0 voll
              if (p->hoehe-1 <= h_opt_max
                  && ebene_verbaut[p->hoehe-1][p1->pb.e12.s[0]][p1->teile_bit]) {
//                verbaut_erkannt ++;
                                                 // nchste Ebene ist schon verbaut, abbrechen
                tz++;                            // wieder zurcksetzen
                continue;
              }
              p1->pb.e03.s[0] = p1->pb.e12.s[0]; // E0 = E1  Ebenen rotieren
              p1->pb.e12.s[0] = p1->pb.e12.s[1]; // E1 = E2
              p1->pb.e12.s[1] = p1->pb.e03.s[1]; // E2 = E3
              p1->pb.e03.s[1] = 0;               // E3 = leer
              p1->ebene = p->ebene + 1;
            }
            p1->hoehe = 4 - p1->ebene;           // Ebenen 1-4 haben Hoehe 3-0 (Ebene 0 hat auch 3, wird hier aber nicht berechnet)
          }
          else {                                 // Ebene ist noch nicht voll
            p1->ebene = p->ebene;
            p1->hoehe = p->hoehe;
          }
          p1->teile = tt_all + (p1->teile_bit & teile_verfuegbar[p1->hoehe][p1->pb.e03.s[0]]);
          p1->teil_idx = 0;                      // Anfangen mit erstem verbliebenem Teil
          if (p1->teile->verfuegbar == 0) {
                                                 // kein passendes Teil mehr, zurck
                tz++;                            // wieder zurcksetzen
                continue;
          }
          p1->teil = p1->teile->p[0];            // Teil aus Index berechnen
          p1->pl = p1->teil->plf
                   + p1->pb.e03.s[0];            // Positionsliste passend zur aktuellen Ebene aus Tabelle holen
          p1->teil_pos = p1->pl->zahl[p1->hoehe];
          p = p1;                                // ab jetzt Puzzle mit eingebautem Teil benutzen
        }
      }
    }
  }
  printf ("\n%d Loesungen\n", loesungen);
//  printf ("%.0f Schleifendurchlaeufe, %.0f Teile eingebaut\n", schleifenzaehler, einfuegzaehler);
//  printf ("%d verbaute Ebenen vorhergesagt\n", verbaut_erkannt);
}

void berechne_tabellen(void) {
  for (int i = 0; i < 32; i++)
    and_bit[i] = 1 << i;
  for (i = 0; i < 4096; i++) {
    for (int j = 0; i & and_bit[j]; j++);
    first_empty[i] = j;
    int k = 0;
    for (j = 0; j < 12; j++)
      if (i & and_bit[j])
        k++;
    gesetzte_bits[i] = k;
  }
}

void main(void) {
  printf ("c't-Puzzle (c't 7/03)  V 1.4 (C) 2003 Martin Grieb\n");

// Tabellen berechnen (fr part-Konstruktoren erforderlich)
  berechne_tabellen();

  part parts[] = {
    part ("####",
          "#---", NULL, NULL, 1),
    part ("#-#",
          "###"),
    part ("#--",
          "###",
          "-#-"),
    part ("-#-#",
          "####"),
    part ("--#",
          "###",
          "--#"),
    part ("#--",
          "###",
          "--#"),
    part ("##-",
          "###"),
    part ("##",
          "##",
          "#-",
          "--"),
    part ("-#-",
          "###",
          "-#-"),
    part ("##",
          "#-",
          "-#",
          "--"),
    part ("-##",
          "##-",
          "#--"),
    part ("-#--",
          "####")
  };
//  parts[0].print(0);
//  parts[0].print(2);
//  parts[4].print();
//  parts[4].print(1);
//  part_bit_speicher.print();

  puzzle pz(parts);
  pz.solve();
}
