#include <stdio.h>
#include <vector>
#include <string>
#include <set>

#define MAX_DREH  (24)		// MAX-mglichen drehnungen von einen Object
#define MAX_TEILE (13)		// Max-anzahl von mglichen teilen
#define MAX_SUBTEILE (12)	// Max-anzahl der teile aus dem ein teil besteht

class Pos;
class Teil;
class Box;

typedef std::vector<Pos>  _Posl;
typedef std::vector<Teil> _Teill;

#ifdef WIN32
typedef unsigned _int64	  _Maske;

#else
typedef unsigned long long _Maske;
#endif

/*************************************************************************/
/* Classe Pos; Speicher eine einzelne Position mit den Korordinaten      */
class Pos {
    public:
        int x;
        int y;
        int z;

		Pos() {
			x = 0;
			y = 0;
			z = 0;
			};

        Pos( int x, int y, int z) {
            this->x = x;
            this->y = y;
            this->z = z;
            };

		void _double() {
			x = x * 2;
			y = y * 2;
			z = z * 2;
			};

		void _half() {
			if ( x % 2 != 0 ||
				 y % 2 != 0 ||
				 z % 2 != 0 ) {
					throw "Fehler beim halbieren";
						};
			x = x / 2;
			y = y / 2;
			z = z / 2;
			};

		Pos operator- (const Pos& pos) const {
			Pos r;
			r.x = x - pos.x;
			r.y = y - pos.y;
			r.z = z - pos.z;
			return r;
			};

		Pos operator+ (const Pos& pos) const {
			Pos r;
			r.x = x + pos.x;
			r.y = y + pos.y;
			r.z = z + pos.z;
			return r;
			};

		// liefert eine die gedrehte Pos zurck; gedreht um 0.0.0
		Pos dreh(int i) const {
			Pos r;
			Pos tmp;
			if ( i >= 0 && i <= 3 ) {           tmp.x =    x;tmp.y = y;tmp.z =  z; };
			if ( i >= 4 && i <= 7 ) { i = i- 4; tmp.x = 0- z;tmp.y = y;tmp.z =  x; };
			if ( i >= 8 && i <=11 ) { i = i- 8; tmp.x = 0- x;tmp.y = y;tmp.z =0-z; };
			if ( i >=12 && i <=15 ) { i = i-12; tmp.x =    z;tmp.y = y;tmp.z =0-x; };

			if ( i >=16 && i <=19 ) { i = i-16; tmp.x =    x;tmp.y =0-z;tmp.z = y; };
			if ( i >=20 && i <=23 ) { i = i-20; tmp.x =    x;tmp.y =  z;tmp.z=0-y; };

			switch( i ) {

			    case 0: r.x =   tmp.x;  r.y =   tmp.y; r.z = tmp.z; break;
				case 1: r.x = 0-tmp.y;  r.y =   tmp.x; r.z = tmp.z; break;
				case 2: r.x = 0-tmp.x;  r.y = 0-tmp.y; r.z = tmp.z; break;
				case 3: r.x =   tmp.y;  r.y = 0-tmp.x; r.z = tmp.z; break;

				default: throw "ungltiger wert zum drehen";
				};
				return r;
			};

        void print() const {
            printf("x = %2d, y= %2d, z =%2d\n", x, y, z);
            }
    };

/*************************************************************************/
/* Classe Posk; speicher die position inerhalb einen krpers			 */
class PosK {
	private:

	public:
		int			l;
		int			b;
		int			h;
		Pos			pos;

		PosK(const int l, const int b, const int h) {
			this->l = l;
			this->b = b;
			this->h = h;
			};

		bool Next() {
			if ( (pos.x == l-1 ) &&
				 (pos.y == b-1 ) &&
				 (pos.z == h-1 ) ) return false;
			pos.x++;
			if (pos.x == l) {
				pos.x = 0;
				pos.y++;
				};
			if (pos.y == b) {
				pos.y = 0;
				pos.z++;
				};
			return true;
			};

		bool IsInner() {
			return ( pos.x < l && pos.x >= 0 &&
				     pos.y < b && pos.y >= 0 &&
					 pos.z < h && pos.z >= 0);
			};

		int GetPosNr() {
			return (( pos.z * b * l ) + ( pos.y * l ) + pos.x);
			};

		void SetPos(int npos) {
			pos.z = npos / ( l * b);
			npos = npos % ( l * b);
			pos.y = npos / l;
			pos.x = npos % l;
			};
	};

/*************************************************************************/
/* Classe Teil; Speicher ein Einzelnes Teil								 */
class Teil {
    private:

		_Posl  posl[MAX_DREH];		// Speichert die einzel Positionen fr
									// jede Drehung
    public:
		int					id;		// id des Teiles
		std::vector<Teil*>  steile;	// die Teile aus dem das Teil besteht;

		// Konstructor
        Teil() {
			Clear();
			};

		// Konstructor
        Teil(const int id) {
			Clear();
			this->id = id;
			};

		// fgt eine neue Position dem Teil hinzu, errechnet gleich alle
		// mglichen drehungen
        void add( const Pos &pos ) {
			for (int i = 0; i < MAX_DREH; ++i) {
				posl[i].push_back( pos.dreh(i) );
				};
            };

		// leert das Teils
        void Clear() {
			for ( int i = 0; i < MAX_DREH; ++i) {
				posl[i].clear();
				};
			id = 0;
			steile.clear();
			};

		// liefert eine PosListe fr die drehungen zurck
		const _Posl& GetPosliste(int drehung) const {
            return posl[drehung];
            };

    };

/************************************************************************/
/* Classe Box															*/
class Box {

	class STeileMog {
		private:

		public:
			_Maske			maske;				// belegt maske
			int				dreh;				// drehung des teiles
			Pos				pos;				// einfge position
			int				teilnr;				// um welches teil es geht
			int				sub[MAX_SUBTEILE];	// pos die das teil belegt
			int				anzsub;				// anzahl der sub teile
		};

	class TeileMog {
		public:
			TeileMog( int maxanz = 1000 ) {
				this->maxanz = maxanz;
				anz = 0;
				l = (STeileMog*)malloc( sizeof(STeileMog) * maxanz);
				if ( l == 0 ) {
					throw "Fehler beim malloc (4)";
					};
				};

			~TeileMog() {
				free(l);
				};

			STeileMog*		l;			
			int				maxanz;
			int				anz;
		};

	class pTeileMog {
		public:
			pTeileMog( int maxanz = 1000 ) {
				this->maxanz = maxanz;
				anz = 0;
				l = (STeileMog**)malloc( sizeof(STeileMog*) * maxanz);
				if ( l == 0 ) {
					throw "Fehler beim malloc (5)";
					};
				};

			~pTeileMog() {
				free(l);
				};

			STeileMog**		l;				
			int				maxanz;
			int				anz;
		};

	class Rest {
		private:
		public:
			TeileMog**		tm;
			int				anz;
			int				maxanzteile;


			Rest( int maxanzteile, int maxanzmog ) {
				anz = 0;
				this->maxanzteile = maxanzteile;
				tm = (TeileMog**)malloc( sizeof(TeileMog*) * maxanzteile );
				if ( tm == 0 ) {
					throw "Fehler beim malloc (5)";
					};
				for ( int i = 0; i < maxanzteile; ++i ) {
					tm[i] = new TeileMog(maxanzmog);
					};
				};

			~Rest() {
				for ( int i = 0; i < maxanzteile; ++i ) {
					delete tm[i];
					};
				free( tm );
				};
		};


	/********************************************************************/
	/* Classe RestSpeicher; speicherplatz fr die restlisten            */
	class RestSpeicher {
		private:
		public:
			pTeileMog*		fliste[65];
			pTeileMog*		mliste[MAX_TEILE];
			int				anzTeile;
			int				minFeld;
			int				minTeil;
			int				xxx;

			RestSpeicher( int max = 1000) {
				xxx = 0;
				int anzfelder = 60;

				int i;
				for ( i = 0; i < anzfelder; ++i ) {
					fliste[i] = new pTeileMog(max);
					};
				for ( i = 0; i < MAX_TEILE; ++i ) {
					mliste[i] = new pTeileMog(max);
					};
				};

			~RestSpeicher() {
				int anzfelder = 60;
				int i;
				for ( i = 0; i < anzfelder; ++i ) {
					delete fliste[i];
					};
				for ( i = 0; i < MAX_TEILE; ++i ) {
					delete mliste[i];
					};
				};

			void PrintFliste() {
				printf("\n");
				for ( int y = 0; y < 4; ++y ) {
					for ( int z = 0; z < 3; ++z) {
						for ( int x = 0; x < 5; ++x) {
							printf("%3d ", fliste[ (z*4*5) + (y * 5) + x]->anz);
							};
						printf("  ");
						};
					printf("\n");
					};

				};
			
			void SortMliste() {
				bool sort = false;
				while ( ! sort) {
					sort = true;
					for ( int i = 0; i < anzTeile-1; ++i ) {
						if ( mliste[i]->anz > mliste[i+1]->anz ) {
							pTeileMog* tmp = mliste[i];
							mliste[i] = mliste[i+1];
							mliste[i+1] = tmp;
							sort = false;
							};
						};
					};
				minTeil = 0;
				};

		};


	/********************************************************************/
	/* Classe Status; verwaltet den aktuellen Satus der suche   	    */
	class Status {
		public:
			int				pos;	// aktuelle position
			int				anz;	// max position
//			int				minTeil;
//			int				anzTeile;
		};

	private:
		int                 h;						// lnge
        int                 b;						// breite
        int                 l;						// hhe
		int					losungen;				// anzahl der gefunden losungen
		_Teill				teile;					// teile die eingefgt werden sollen
        _Maske				belegt;					// aktueller belegtstatus
		Status				status[MAX_TEILE];		// aktueller status je teil
		RestSpeicher		restspeicher[MAX_TEILE];// speicher fr die reste listen
		int					anzfelder;

		int recurse(int stufe ) {
			int				r = 0;
			//restspeicher[stufe].xxx++;

			// ausgabe
			if ( stufe  == 3 ) {
				fprintf(stderr,"\r");
				for (int i = 0; i < stufe; ++i) {
					fprintf(stderr, "%2d(%3d/%3d) ", /*status[i].teil->id */0,status[i].pos, status[i].anz);
					};
				fprintf(stderr,"  (%5d Loesungen)", losungen);
				};

			pTeileMog*	_ptm;
			if ( stufe > 1 ) {
				_ptm = restspeicher[stufe].fliste[restspeicher[stufe].minFeld];
				} else {
					_ptm = restspeicher[stufe].mliste[restspeicher[stufe].minTeil];
					};
			
			pTeileMog& ptm = *_ptm;

			//status[stufe].minTeil  = restspeicher[stufe].minTeil;
			//status[stufe].anzTeile = restspeicher[stufe].anzTeile;
			int& i    = status[stufe].pos;
			int& bis  = status[stufe].anz;
		
			bis = ptm.anz;
			for ( i = 0; i < bis; ++i) {
				_Maske& m = ptm.l[i]->maske;

				belegt ^= m;

				int	teilnr = ptm.l[i]->teilnr;

				if ( CreateRest( restspeicher[stufe], restspeicher[stufe+1], belegt, teilnr) ) {
					if ( restspeicher[stufe+1].anzTeile == 0 ) {
						losungen++;
						} else { 
							r += recurse(stufe+1);
							};
					};
				belegt ^= m;
				};
		return r;
		};

		// erzeugt eine neue Restliste; geht von belegt=0 aus
		void CreateRest(Rest& rest,  RestSpeicher& rsp) {
			rsp.anzTeile = rest.anz;
			rsp.minFeld = 0;

			int min = 99999;

			for ( int i = 0; i < 60; ++i ) {
				rsp.fliste[i]->anz = 0;
				};

			for ( int teilnr = 0; teilnr < rest.anz; ++teilnr) {
				if ( rsp.mliste[teilnr]->maxanz < rest.tm[teilnr]->anz) {
					throw "respeicher zu klein";
					};
				rsp.mliste[teilnr]->anz = rest.tm[teilnr]->anz;
				if ( min > rest.tm[teilnr]->anz ) {
					min = rest.tm[teilnr]->anz;
					rsp.minTeil = teilnr;
					};

				for ( int i = 0; i < rest.tm[teilnr]->anz; ++i ) {
					STeileMog& stm = rest.tm[teilnr]->l[i];
					rsp.mliste[teilnr]->l[i] = &stm;
					for ( int ii = 0; ii < stm.anzsub; ++ii ) {
						rsp.fliste[ stm.sub[ii] ]->l[rsp.fliste[ stm.sub[ii] ]->anz] = &stm;
						++rsp.fliste[ stm.sub[ii] ]->anz;
						};
					};
				};

			rsp.minFeld = -1;
			min = 999999;
			for ( b = 0; b < anzfelder; ++b) {
				if ( rsp.fliste[b]->anz == 0 ) {
					throw "keine loesung";
					};

				if ( rsp.fliste[b]->anz < min) {
					rsp.minFeld = b;
					min = rsp.fliste[b]->anz;
					};
				};

			};


		// erzeugt eine neue Restliste;
		bool CreateRest( RestSpeicher& s_rsp, RestSpeicher& d_rsp, _Maske belegt, int vteilnr) {
				d_rsp.anzTeile = s_rsp.anzTeile-1;
				d_rsp.minTeil = -1;
				int min = 999999;
				
				int b;

				for ( b = 0; b < anzfelder; ++b) {
					if ( (belegt & ((_Maske)1 << b) ) != 0 ) {
						d_rsp.fliste[b]->anz = -1; 
						} else {
							d_rsp.fliste[b]->anz = 0;
							};
					};

				int pos = 0;
				for ( int teilnr = 0; teilnr < s_rsp.anzTeile; teilnr++) {
					if ( s_rsp.mliste[teilnr]->l[0]->teilnr != vteilnr ) {
						int anzahl = 0;
						
						pTeileMog& li = *s_rsp.mliste[teilnr];
						for ( int i = 0; i < li.anz; ++i) {
							STeileMog& stm = *li.l[i];
							if ( (belegt & stm.maske) == (_Maske)0 ) {
								d_rsp.mliste[pos]->l[anzahl] = &stm;
								for ( int p = 0; p < stm.anzsub; ++p ) {
									int subteil = stm.sub[p]; 
								    d_rsp.fliste[subteil]->l[ d_rsp.fliste[subteil]->anz++ ] = &stm;
									//++d_rsp.fliste[subteil]->anz;
									};
								++anzahl;
								};
							};
						if ( anzahl == 0 ) {
							return false;
							};

						if ( min > anzahl ) {
							min = anzahl;
							d_rsp.minTeil = pos;
							};
						d_rsp.mliste[pos++]->anz = anzahl;
						//++pos;
						};
					};

//				if ( pos != d_rsp.anzTeile ) {
//					throw "vTeil war nicht in der liste";
//					};

				d_rsp.minFeld = -1;
				min = 999999;
				for ( b = 0; b < anzfelder; ++b) {
					if ( d_rsp.fliste[b]->anz == 0 ) {
						return false;
						};

					if ( (d_rsp.fliste[b]->anz < min) && (d_rsp.fliste[b]->anz > 0 ) ) {
						d_rsp.minFeld = b;
						min = d_rsp.fliste[b]->anz;
						};
					};
				return true;
				};

		// liefert eine Maske fr eine liste von Positionen
		// return gibt an ab erfolgreich
			bool GetMaske(_Maske& maske,  PosK posk, const _Posl& posl) const {
				maske = (_Maske)0;
				Pos startpos = posk.pos;
				for ( _Posl::const_iterator it = posl.begin(); it != posl.end(); ++it) {
					posk.pos = startpos + *it;
					// bereich berprfen
					if ( posk.IsInner() ) {
							int i = posk.GetPosNr();
							maske |= (_Maske)1 << i;
							} else {
								return false;
								};
						};
				return true;
				};

			// liefert die Maske fr eine liste von positionen fr eine
			// krper der  um die mitte gedreht wurden ist
			bool GetMaske(_Maske& maske, const PosK& posk, const _Posl& posl, int dreh) {
				Teil		teil;
				Pos			mitte;
				PosK		_posk(posk.l ,posk.b, posk.h);

				maske = (_Maske)0;
				mitte.x = posk.l - 1;
				mitte.y = posk.b - 1;
				mitte.z = posk.h - 1;
				for ( _Posl::const_iterator it = posl.begin(); it != posl.end(); ++it) {
					_posk.pos = *it;
					_posk.pos = _posk.pos + posk.pos;
					_posk.pos._double();
					_posk.pos = _posk.pos - mitte;
					_posk.pos = _posk.pos.dreh(dreh);
					_posk.pos = _posk.pos + mitte;
					_posk.pos._half();
					if ( _posk.IsInner() ) {
						int i = _posk.GetPosNr();
						maske |= (_Maske)1 << i;
						} else {
							return false;
							};

					};
				return true;
				};


			// testet ob in der liste die Maske bereits enthalten ist
			const bool MaskeExists(TeileMog& tm, _Maske& m ) {
				for (int i = 0; i < tm.anz; ++i) {
					if (tm.l[i].maske == m) {
						return true;
						};
					};
				return false;
				};

			// erzeugt aus den bergebene Teilen die Moglichkeiten die jedes
			// Teil in den Krper hatt
			void CreateTeileMog(const int l,const int b, const int h, _Teill& teile, Rest& rest) {
				bool drehung[MAX_DREH];
				bool sym[MAX_DREH];
				rest.anz = teile.size();
				int anzTeile = teile.size();
				int teilnr;

				_Maske	m;
				int notsymteil = -1;

				int i;

				// ermittle in welche richtung der Krper gedreht werden kann
				// verhindert gleich doppelte lsungen
				Teil teil(0);
				teil.add(Pos(l,b,h));
				for (i = 0; i < MAX_DREH; ++i) {
					drehung[i] = true;
					_Posl p = teil.GetPosliste(i);
					if ( abs(p[0].x) != l ) drehung[i] = false;
					if ( abs(p[0].y) != b ) drehung[i] = false;
					if ( abs(p[0].z) != h ) drehung[i] = false;
					};

				// ermittelt welches teil nicht symetrisch zur mitte des wrfel sind
				TeileMog	tmpliste(MAX_DREH);
				for ( teilnr = 0; teilnr != anzTeile; ++teilnr) {
					sym[teilnr] = false;
					PosK posk(l, b, h);
					do { //teilnr = 10; posk.pos.x = 2; posk.pos.y = 1; posk.pos.z = 1;
						for ( int dreh = 0; dreh < MAX_DREH; ++dreh) {
							tmpliste.anz = 0;
							for ( int dreh2 = 0; dreh2 < MAX_DREH; ++dreh2 ) {
								// nur wenn der krper seine form nicht ndert
								if ( drehung[dreh2] ) {
									_Posl posl = teile[teilnr].GetPosliste(dreh);
									if ( GetMaske( m, posk, posl, dreh2) ) {
										if ( MaskeExists(tmpliste, m) ) {
											sym[teilnr] = true;
											};
										tmpliste.l[tmpliste.anz].maske = m;
										tmpliste.anz++;
										};
									};
								};
							};
						} while ( posk.Next() );
					if ( (notsymteil < 0) && !sym[teilnr] ) {
						notsymteil = teilnr;
						};

					};

				for ( teilnr = 0; teilnr != anzTeile; ++teilnr) {

					//fuellen der liste
					TeileMog& tm =  *rest.tm[teilnr];
					tm.anz = 0;

					for ( int d = 0; d < MAX_DREH; ++d ) {
						PosK posk(l, b, h);
						do {
							_Posl posl = teile[teilnr].GetPosliste(d);
							if ( GetMaske( m, posk, posl ) ){
								bool	insert = true;

								if ( MaskeExists(tm, m) ) insert = false;

							    // wenn teil dann den ganzen krper drehen und symterien
								// auschliessen
								if ( teilnr == notsymteil ) {
									for ( int i = 0; i < MAX_DREH; ++i ) {
										// wenn sich dir form von gesamt krper nicht ndert
										if ( drehung[i] ) {
											_Maske	m2;
											if (GetMaske( m2, posk, teile[teilnr].GetPosliste(d), i) ) {
												if ( MaskeExists(tm, m2) ) {
													insert = false;
													};
												};
											};
										};
									};

								if ( insert ) {
									STeileMog& stm = tm.l[tm.anz];
									stm.pos = posk.pos;
									stm.maske = m;
									stm.dreh = d;
									stm.teilnr = teilnr;

									// fllen der Subteile
									stm.anzsub = 0;
									PosK tmpposk(l ,b, h);
									for ( _Posl::iterator it = posl.begin(); it != posl.end(); ++it) {
										tmpposk.pos = *it + posk.pos;
										stm.sub[stm.anzsub] = tmpposk.GetPosNr();
										stm.anzsub++;
										if ( stm.anzsub == MAX_SUBTEILE ) {
											throw "Maximale anzahler der SubTeile ueberschritten";
											};
										};

									++tm.anz;
									};
								};
							} while ( posk.Next() );
						};
					};
				// textausgabe
				for ( i = 0; i < anzTeile; ++i) {
					printf("Teil %2d hat %3d Moeglichkeiten (", teile[i].id, rest.tm[i]->anz);
					if (! sym[i] ) printf("nicht ");
					printf("Symterisch)");
					if ( i == notsymteil ) printf("*");
					printf("\n");
					};

			};

    public:
		// konstruktor
        Box(int l, int b, int h) {
            this->h = h;
            this->b = b;
            this->l = l;
			};

        ~Box() {
            };

		void SetTeile(_Teill& teile) {
			this->teile = teile;
			//anzTeile = teile.size();
			};

		// start des suchen der lsungen
		void Start() {
			losungen = 0;
			anzfelder = l*b*h;

			Rest rest1(teile.size(), 1000 );

			CreateTeileMog( l, b, h, teile, rest1 );
			CreateRest( rest1, restspeicher[0] );
			belegt = (_Maske)0;
			recurse(0);
			printf("\n Es wurden %d Loesungen gefunden\n", losungen);
			};

    };

void createTeile(_Teill& teile) {
    Teil teil;

    teil.Clear();
	teil.id = 1;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(1, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(0, 2, 0));
    teil.add(Pos(1, 2, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 2;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(2, 1, 0));
    teil.add(Pos(2, 2, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 3;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(2, 1, 0));
    teil.add(Pos(3, 1, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 4;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(0, 2, 0));
    teil.add(Pos(0, 3, 0));
    teil.add(Pos(1, 1, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 5;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(0, 0, 1));
    teil.add(Pos(0, 1, 1));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 6;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(1, 0, 0));
    teil.add(Pos(2, 0, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(1, 2, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 7;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(1, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(2, 1, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 8;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(1, 2, 0));
    teil.add(Pos(2, 2, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 9;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(0, 0, 1));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 10;
    teil.add(Pos(0, 0, 0));
    teil.add(Pos(0, 1, 0));
    teil.add(Pos(1, 1, 0));
    teil.add(Pos(2, 1, 0));
    teil.add(Pos(1, 2, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 11;
    teil.add(Pos( 0, 0, 0));
    teil.add(Pos(-1, 0, 0));
    teil.add(Pos( 1, 0, 0));
    teil.add(Pos( 0,-1, 0));
    teil.add(Pos( 0, 1, 0));
    teile.push_back(teil);

    teil.Clear();
	teil.id = 12;
    teil.add(Pos( 0, 0, 0));
    teil.add(Pos( 0, 1, 0));
    teil.add(Pos( 0, 2, 0));
    teil.add(Pos( 0, 3, 0));
    teil.add(Pos( 1, 1, 0));
    teil.add(Pos( 1, 3, 0));
    teile.push_back(teil);
    };

int main() {
	try {
		printf("Start\n");

		Box                 box(5, 4, 3);
		_Teill				teile;

		createTeile(teile);
		box.SetTeile(teile);
		box.Start();

		printf("Ende\n");
		} catch (char*& x) {
			printf("----Exception:------\n%s\n--------------\n",x);
			} catch ( ... ) {
				printf("-----unbekannte Excpetion\n");
				};
    return 0;
    };