#pragma once

#include <string>
#include <iostream>
#include <set>
#include "Constants.h"
#include "BitVector.h"

using namespace std;

class Puzzle;
class Projection;

class Part
{
public:
	Part(const string path);
	~Part(void);
	void addToPuzzle(Puzzle* puzzle);
	void turnAxisPositive(char axis, bool insert = true);
	void turnAxisPositive(int times, char axis, bool insert = true);
	void getDimensions(const BitVector& turn, int& x, int& y, int& z);
	void debugOutput();

	int partNo;

private:
	string path;
	set<__int64> turns;
	bool space[maxExpansion][maxExpansion][maxExpansion];
	Puzzle* puzzle;

	static bool foundTotallyAsymetric;
};
