/* puzzle.cpp by me*/
#include <iostream.h>
#include <time.h>
char weiter;            // globale break Variable

  // Voraussetzungen:
  // 1. Eingabe sind 12 Teile fuer einen 3x4x5 Quader in einer der
  //    unteren Quaderformen (Quaderformen bis zur Groesse 4x4x4 sind moeglich)
  // 2. Summe der kleinen Wuerfel in den Teilen ist 60
  //    Der grosse Quader darf nicht mehr als aus 64 kleinen Wuerfeln bestehen
  // 3. Teil 'B' kann nicht durch Spiegelung in sich selbst uebergehen
  //    -> gespiegelte Loesungen werden nicht gesucht
  //    -> wegen der Quaderform sind nur 4 Rotationssymmetrien zu beachten
  // 4. Teil 'A' ist bzgl. der Rotationen immer verschieden
  //    -> durch Reduzierung dieses Teils auf 1/4 seiner max. 576 Lagen
  //       (die anderen Lagen entstehen dann durch Rotationen um die drei
  //       Achsen) entstehen nur unterschiedliche Loesungen

  // Teil   4x4x4                           - ein Teil mit Ansichten
  // QTeil  3x4x5   nach beliebig sortieren - ein Teil mit Ansichten im Quader
  // Puzzle beliebig                        - mehrere Qteile im Quader
  // Deadend enthaelt Infos um Sackgassen zu erkennen
  // Kette1/Offset
  //   Ketten der Form [Header][Teil 1]..[Teil k] fuer jede Bitposition
  //                                [Info 1]..[Info k]
  //   mehere Teile und mehere lagen eines Teils dabei moeglich
  //   Offset[benutzteTeile][ErstBit] zeigt auf Kette mit unben.Teilen die ErstBit haben

  // Vorgehensweise:
  // Permutation und Sackgassen initialisieren
  // Teil initialisieren (alle) 4x4x4 Ansichten
  //      Symmetriehack1 von einem Teil nur 1/4 der Ansichten unterbringen
  // QTeil initialisieren - Ansichten im Quader unterbringen
  //      Symmetriehack2 nur hinterste der 4(8) Ansichten des einen Teils zulassen (!permutierte Bits)
  // Lage nach Teil und Startbit (!permutierte Bits) sortieren
  // DeadEnd/Kette1/Offset
  // Rekursion: fuer naechstes Bit unter den noch verbleibenden Teilen passendes suchen
  //            ablegen , Ende? , Abbruchbedingung
  //
  // zu optimierende Dinge:
  // ok 1. Bitpermutation in Zshg. mit Symhack-Teil (1 oder A oder B)
  //                   normal,schraeg,quader ineinander
  // ok 2. globale strukturierte Tabelle (wenig Grundzeiger mitschleppen)
  //    3. hinterster Wert zuerst vergleichen / um 4 Bit verschieben
  // ok 4. Abbruchbedingung: 0..k Nachbarn testen (k==3)
  //    5. nicht rekursiv
  // ok 6. Next Berechnung in asm
  // ok 7. Spiegelungen von Teil B
  //    8. Hash Table: nein da statich fraglich ob zulaessig und dynamisch zu aufwendig
  // Permutation beeinflusst Bits,Nachbar,symack2(Lage2),solve1

const int nparts=12;                      // Anzahl der Teile
const int qdimx =3;                       // Dimension des Quaders in x-Richtung
const int qdimy =4;                       // Dimension des Quaders in y-Richtung
const int qdimz =5;                       // Dimension des Quaders in Z-Richtung
const int tdim  =4;  // maximale Ausdehnung eines Teils in einer Dimension
enum Quader{Zweix2x2,Dreix2x1,Dreix3x1,Vierx2x1};    // Kleine Quader
const int maxview =24;                    // maximale Anzahl der Ansichten eines Teils
const int subview = 4;                    // Ansichten wenn nur um eine Achse gedreht wird
const char symhack='A';                   // moeglich sind 1 4 5 7 8 9 A B
const int perm=7;    // 1-normal 2-Grosser/Kleiner Quader 3-geschachtelte Quader 4-schraeg
                     // 5-Grosser Quader,Kleiner Quader,Wuerfel
// ******************************* Bitvector64 Anfang ************************
class Bitvector64                                 // Erweiterung von 32 auf 64 Bit kostet 10%
// Operatoren: = , == , |= , &= , ^= , test( & Verknuepfung wird getestet: wenn 0 dann false)
// sowie set(Bit) , Test (Bit) , set (2 Ints) , get (2 Ints)
{
  unsigned int word1,word2;                       // BitVektor besteht aus zwei Words
  unsigned int Bit32toWord (int Bit) const        // !Bit<32
  { return (1<<Bit);}
 public:
  Bitvector64::Bitvector64(void)                  // mit 0 initialisiert
     { word1 = 0; word2 = 0;}
  void operator|=(const Bitvector64& bv)
     { word1 |= bv.word1;  word2 |= bv.word2; }
  void operator&=(const Bitvector64& bv)
     { word1 &= bv.word1;  word2 &= bv.word2; }
  void operator^=(const Bitvector64& bv)
     { word1 ^= bv.word1;  word2 ^= bv.word2; }
  void set(int bit)                               // Bit 0..63 setzen
     { if (bit>=64) {cout << "Error1\n";cin>>weiter;}
       if (bit<32)   { word1 |= Bit32toWord(bit); }
       else          { word2 |= Bit32toWord(bit-32); }  }
  void set (unsigned int a,unsigned int b) {word1=a;word2=b;}
  void get (unsigned int &a, unsigned int &b) {a=word1;b=word2;}
  bool test(const Bitvector64& bv) const                // z.B. bei Kollision zwischen
    { return (((word1 & bv.word1)!=0)                   //      Teil und Puzzle
           || ((word2 & bv.word2)!=0)); }               // true heisst Teil passt nicht
  bool test(int bit) const                              // Bit testen (Ausgabe)
    { if (bit>=64) {cout << "Error2\n";cin>>weiter;}
      if (bit<32) {return (word1 & Bit32toWord(bit   ))!=0;}
      else        {return (word2 & Bit32toWord(bit-32))!=0;}}
  bool operator== (const Bitvector64& bv) const         // Vergleich
    { return ((word1==bv.word1) && (word2==bv.word2)); }
  void operator= (const Bitvector64& bv)                // Zuweisung
    { word1=bv.word1;word2=bv.word2; }
};
// ******************************** Bitvector64 Ende ************************

// ********************************* Globales *******************************

// Permutationen
// auf bit Ebene: NBit64[i] / PBit64[i]  / RBit64[i]
Bitvector64 NBit64[64];
Bitvector64 PBit64[64];
Bitvector64 RBit64[64];

extern "C" {int Next(Bitvector64);}
//int Next(Bitvector64 bv)
//{int nb=0; for (; bv.test(NBit64[nb]);nb++) {;} return nb;}

Bitvector64 PermTeil(Bitvector64 a)    // Teil permutieren
{
  Bitvector64 b;
  for (int i=0;i<64;i++) {if(a.test(PBit64[i])) {b|=NBit64[i];}}
  return b;
}
Bitvector64 RepermTeil(Bitvector64 b)  // Teil zurueck permutieren
{
  Bitvector64 a;
  for (int i=0;i<64;i++) {if(b.test(RBit64[i])) {a|=NBit64[i];}}
  return a;
}
void out60(Bitvector64 bv)             // Ausgabe eines permutierten Bitvectors als PuzzleTeil
{
  bv=RepermTeil(bv);
  cout << endl << "-------   -------   -------"<<endl;
  for (int y=0;y<qdimy;y++){for (int x=0;x<qdimx;x++){cout<<"|";for (int z=0;z<qdimz;z++){
    if (bv.test(x+3*y+12*z)) {cout << "o";} else {cout << " ";}
    }cout << "|   ";}cout << endl;}
}
void out64(Bitvector64 bv)             // Ausgabe eines Bitvectors als (reverse) Hexzahl
{
  char hexziffer[]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
  for (int i=15;i>=0;i--)
  {
    int index=0;
    for (int j=3;j>=0;j--) { if(bv.test(4*i+j)) index+=1<<j; }
    cout << hexziffer[index];
  } cout << endl;
}

const int maxKette=4096*3467;          // Groesse von Kette1 siehe Q
const int teilKomb=4096;               // 2^^12 Teilkombinationen
const int anzLagen=3132;               // Moeglichkeiten ein beliebiges Teil einzubauen
const int maxNachb=25;                 // maximale Anzahl Nachbarn siehe Q
struct Q                               // Daten die in der Rekursion gebraucht werden
{                                      // hintereinander ablegen
// 2700 Teile davon
  // ! 4er Teil genau auszaehlen
  // in x-Richtung:     255
  // in y-Richtung:     682
  // in z-Richtung:     893
  // in xy-Richtung:    234
  // in xz-Richtung:    246
  // in yz-Richtung:    376
  // in xyz-Richtung:    14
  // Baue :                     xyz x xy y yz z zx x
  // Dann wenn -   verbaut:     ------------------
  // Dann wenn x   verbaut:              ------
  // Dann wenn y   verbaut:                   ------
  // Dann wenn z   verbaut:         ------
  // Dann wenn xy  verbaut:                   -
  // Dann wenn xz  verbaut:              -
  // Dann wenn yz  verbaut:         -
  // Dann wenn xyz verbaut:
  // -> ca. wenn eine Richtung verbaut 5/9 Teile zu testen
  //        wenn zwei Richtungen verbaut 1/4 Teile zu testen
  // Header: Offset + Ende fuer - , x , y , z , xy , xz , yz , xyz verbaut

  // Kette1 : 2955 Teile, 64 Header -> 2955*2048*16+64*4096*8*8=113.606.656 - 109 MB =8*4096*3467
  Bitvector64 Kette1[maxKette];
  int Offset[64][teilKomb];
  // pro Teil: Teil , Start/EndOffset in Deadend
  Bitvector64 DeadEnd1[anzLagen*maxNachb*2];      // #Teile , min(6*6-10-3/5*6-8)=23 , Innen/Aussen
  // in 0: Lage2index,AnzahlNachbarn , im letzten: Teilnr

  // Nachbarn    wenn nicht vorhanden dann == 0
  Bitvector64 xNachbar[64];              // Nachbar in x-Richtung als Bitvector64
  Bitvector64 yNachbar[64];              // Nachbar in y-Richtung als Bitvector64
  Bitvector64 zNachbar[64];              // Nachbar in z-Richtung als Bitvector64

  unsigned int sol;
  int benutzt;
  Bitvector64 aktuell;
  Bitvector64 Nachbar[64];               // alle Nachbarn als Bitvector64
  Bitvector64 DeadEnd2[anzLagen*64*2];   // fuer asm Programm
} Dat;

void GlobalInit()
{
  // Permutationen
  // auf int Ebene: i         / BitPerm[i] / RevPerm[i]
  // auf bit Ebene: NBit64[i] / PBit64[i]  / RBit64[i]
  int BitPerm[64];
  int RevPerm[64];

  int p=perm;
  if (p==1)
  {
    for (int i=0; i<64; i++) { BitPerm[i]=i; }
    //   0,12,24,36,48    1,13,25,37,49    2,14,26,38,50
    //   3,15,27,39,51    4,16,28,40,52    5,17,29,41,53
    //   6,18,30,42,54    7,19,31,43,55    8,20,32,44,56       unbenutzt :
    //   9,21,33,45,57   10,22,34,46,58   11,23,35,47,59       60,61,62,63
  }
  if (p==2)
  {
    int BitHPerm[]={ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,
               22,23,24,25,26,36,37,38,48,49,50,27,28,29,39,40,41,51,52,53,30,31,
               32,42,43,44,54,55,56,33,34,35,45,46,47,57,58,59,      60,61,62,63};
    for (int i=0; i<64; i++) { BitPerm[i]=BitHPerm[i]; }
  }
  if (p==6)    // Perm2 nach hinten
  {
    int BitHPerm[]={ 60,61,62,63,
               0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,
               22,23,24,25,26,36,37,38,48,49,50,27,28,29,39,40,41,51,52,53,30,31,
               32,42,43,44,54,55,56,33,34,35,45,46,47,57,58,59};
    for (int i=0; i<64; i++) { BitPerm[i]=BitHPerm[i]; }
  }
  if (p==5)
  {
    int BitHPerm[]={ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,
               22,23,24,25,26,36,37,38,48,49,50,27,28,29,30,31,32,33,34,35,39,40,
               41,42,43,44,45,46,47,51,52,53,54,55,56,57,58,59,      60,61,62,63};
    for (int i=0; i<64; i++) { BitPerm[i]=BitHPerm[i]; }
  }
  if (p==7)    // Perm5 nach hinten
  {
    int BitHPerm[]={ 60,61,62,63,
               0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,
               22,23,24,25,26,36,37,38,48,49,50,27,28,29,30,31,32,33,34,35,39,40,
               41,42,43,44,45,46,47,51,52,53,54,55,56,57,58,59};
    for (int i=0; i<64; i++) { BitPerm[i]=BitHPerm[i]; }
  }
  if (p==3)
  {
    int BitHPerm[]={ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20,21,
               22,23,24,25,26,36,37,38,48,49,50,27,39,51,30,42,54,33,45,57,28,29,
               40,41,52,53,31,32,34,35,43,44,55,56,46,47,58,59,      60,61,62,63};
    for (int i=0; i<64; i++) { BitPerm[i]=BitHPerm[i]; }
  }
  if (p==4)
  {
    int BitHPerm[]={ 0,12, 3, 1,24,15, 6,13, 4, 2,36,27,18, 9,25,16, 7,14, 5,48,39,30,
               21,37,28,19,10,26,17, 8,51,42,33,49,40,31,22,38,29,20,11,54,45,52,
               43,34,50,41,32,23,57,55,46,53,44,35,58,56,47,59,      60,61,62,63};
    for (int i=0; i<64; i++) { BitPerm[i]=BitHPerm[i]; }
  }
  // BitPerm[]={0,4,3,1,2}                        // bp0=0 bp1=4 bp2=3 bp3=1 bp4=2
  for (int i=0;i<64;i++) {RevPerm[BitPerm[i]]=i;} // rp0=0 rp4=1 rp3=2 rp1=3 rp2=4
  for (int i=0;i<64;i++) {NBit64[i].set(i);PBit64[i].set(BitPerm[i]);RBit64[i].set(RevPerm[i]);}
                          // 1 2 4 8 16 ;      1 16 8 2 4 ;              1 8 16 4 2
  // Ende Permutationen

  // Nachbarn & xyz Nachbarn      // fuer p==4  sind die Nachbarn von 15(16):
  for (int i=0;i<64;i++)          //  8(4), 7(13), 5(15), 28(17), 25(19), 24(28)
  {                               //  0A100031
    for(int x=0;x<qdimx;x++)
    {
      for(int y=0;y<qdimy;y++)
      {
        for(int z=0;z<qdimz;z++)
        {
          if(PBit64[i].test(x+qdimx*y+qdimx*qdimy*z))
          {
            if(x-1>=   0){Dat.Nachbar[i].set((x-1)+y*qdimx+z*qdimx*qdimy);}
            if(y-1>=   0){Dat.Nachbar[i].set(x+(y-1)*qdimx+z*qdimx*qdimy);}
            if(z-1>=   0){Dat.Nachbar[i].set(x+y*qdimx+(z-1)*qdimx*qdimy);}
            if(x+1<qdimx){Dat.Nachbar[i].set((x+1)+y*qdimx+z*qdimx*qdimy);
                         Dat.xNachbar[i].set((x+1)+y*qdimx+z*qdimx*qdimy);}
            if(y+1<qdimy){Dat.Nachbar[i].set(x+(y+1)*qdimx+z*qdimx*qdimy);
                         Dat.yNachbar[i].set(x+(y+1)*qdimx+z*qdimx*qdimy);}
            if(z+1<qdimz){Dat.Nachbar[i].set(x+y*qdimx+(z+1)*qdimx*qdimy);
                         Dat.zNachbar[i].set(x+y*qdimx+(z+1)*qdimx*qdimy);}
            Dat.Nachbar[i]=PermTeil(Dat.Nachbar[i]);
            Dat.xNachbar[i]=PermTeil(Dat.xNachbar[i]);
            Dat.yNachbar[i]=PermTeil(Dat.yNachbar[i]);
            Dat.zNachbar[i]=PermTeil(Dat.zNachbar[i]);
          }
        }
      }
    }
  }
  /*// Staebe
  int count=0;                     // in z-Richtung 60-12=48
  for(int x=0;x<3;x++)             // Stab[53]=2 6(3 6)
  {
    for(int y=0;y<4;y++)
    {
      for(int z=0;z<4;z++)
      {
        int i,j;
        for(i=0;i<60;i++) {if(PBit64[i].test(x+3*y+12*z)) {break;}}
        for(j=0;j<60;j++) {if(PBit64[j].test(x+3*y+12*(z+1))) {break;}}
        Stab[count]|=Dat.Nachbar[i];Stab[count]|=Dat.Nachbar[j];
        Stab[count+133]|=NBit64[i];Stab[count+133]|=NBit64[j];
        Stab[count]^=Stab[count+133];
        count++;
      }
    }
  }
  for(int x=0;x<3;x++)            // in y-Richtung 60-15=45
  {
    for(int y=0;y<3;y++)
    {
      for(int z=0;z<5;z++)
      {
        int i,j;
        for(i=0;i<60;i++) {if(PBit64[i].test(x+3*y+12*z)) {break;}}
        for(j=0;j<60;j++) {if(PBit64[j].test(x+3*(y+1)+12*z)) {break;}}
        Stab[count]|=Dat.Nachbar[i];Stab[count]|=Dat.Nachbar[j];
        Stab[count+133]|=NBit64[i];Stab[count+133]|=NBit64[j];
        Stab[count]^=Stab[count+133];
        count++;
      }
    }
  }
  for(int x=0;x<2;x++)            // in x-Richtung 60-20=40
  {
    for(int y=0;y<4;y++)
    {
      for(int z=0;z<5;z++)
      {
        int i,j;
        for(i=0;i<60;i++) {if(PBit64[i].test(x+3*y+12*z)) {break;}}
        for(j=0;j<60;j++) {if(PBit64[j].test((x+1)+3*y+12*z)) {break;}}
        Stab[count]|=Dat.Nachbar[i];Stab[count]|=Dat.Nachbar[j];
        Stab[count+133]|=NBit64[i];Stab[count+133]|=NBit64[j];
        Stab[count]^=Stab[count+133];
        count++;
      }
    }
  }//*/
}

extern "C" {void solve1(Q*);}
// ********************************* Ende Globales **************************

// ********************************* Teil Anfang ****************************
class Teil
{
  public:
    Teil(char,Quader,bool,bool,bool,bool,bool,bool,bool,bool);
    Teil(char,Quader,bool,bool,bool,bool,bool,bool);
    Teil(char,Quader,bool,bool,bool,bool,bool,bool,bool,bool,bool);
    void print();
    void drehz();  // nur bv im 4er Wuerfel wird geaendert
    void drehx();  // nur bv im 4er Wuerfel wird geaendert
    void Symmetriehack1();
    void InitAnsicht();
    void InitAnsichtSub(int);
    Bitvector64 Ansicht[maxview];
    int MAX_x[maxview];
    int MAX_y[maxview];
    int MAX_z[maxview];
    int Anzahl;
    Bitvector64 bv;
    char Kennung;
    int Pos2Bit (int x,int y, int z) {return x+y*tdim+z*tdim*tdim;} // x+y*4+z*16
    // void Bit2Pos (int Bit,int &x,int &y,int &z)
};

Teil::Teil(char K,Quader Q, bool feld0, bool feld1, bool feld2, bool feld3,
           bool feld4, bool feld5, bool feld6, bool feld7)
{
  Teil::Kennung=K;
  if (Q==Zweix2x2)
  {
     if (feld0) {Teil::bv.set(Pos2Bit(0,0,0));}
     if (feld1) {Teil::bv.set(Pos2Bit(1,0,0));}
     if (feld2) {Teil::bv.set(Pos2Bit(0,1,0));}
     if (feld3) {Teil::bv.set(Pos2Bit(1,1,0));}
     if (feld4) {Teil::bv.set(Pos2Bit(0,0,1));}
     if (feld5) {Teil::bv.set(Pos2Bit(1,0,1));}
     if (feld6) {Teil::bv.set(Pos2Bit(0,1,1));}
     if (feld7) {Teil::bv.set(Pos2Bit(1,1,1));}
  }
  if (Q==Vierx2x1)
  {
     if (feld0) {Teil::bv.set(Pos2Bit(0,0,0));}
     if (feld1) {Teil::bv.set(Pos2Bit(1,0,0));}
     if (feld2) {Teil::bv.set(Pos2Bit(2,0,0));}
     if (feld3) {Teil::bv.set(Pos2Bit(3,0,0));}
     if (feld4) {Teil::bv.set(Pos2Bit(0,1,0));}
     if (feld5) {Teil::bv.set(Pos2Bit(1,1,0));}
     if (feld6) {Teil::bv.set(Pos2Bit(2,1,0));}
     if (feld7) {Teil::bv.set(Pos2Bit(3,1,0));}
  }
  InitAnsicht();
  Symmetriehack1();
}

Teil::Teil(char K,Quader Q, bool feld0, bool feld1, bool feld2, bool feld3,
           bool feld4, bool feld5)
{
  Teil::Kennung=K;
  if (Q==Dreix2x1)
  {
     if (feld0) {Teil::bv.set(Pos2Bit(0,0,0));}
     if (feld1) {Teil::bv.set(Pos2Bit(1,0,0));}
     if (feld2) {Teil::bv.set(Pos2Bit(2,0,0));}
     if (feld3) {Teil::bv.set(Pos2Bit(0,1,0));}
     if (feld4) {Teil::bv.set(Pos2Bit(1,1,0));}
     if (feld5) {Teil::bv.set(Pos2Bit(2,1,0));}
  }
  InitAnsicht();
  Symmetriehack1();
}

Teil::Teil(char K,Quader Q, bool feld0, bool feld1, bool feld2, bool feld3,
           bool feld4, bool feld5, bool feld6, bool feld7, bool feld8)
{
  Teil::Kennung=K;
  if (Q==Dreix3x1)
  {
     if (feld0) {Teil::bv.set(Pos2Bit(0,0,0));}
     if (feld1) {Teil::bv.set(Pos2Bit(1,0,0));}
     if (feld2) {Teil::bv.set(Pos2Bit(2,0,0));}
     if (feld3) {Teil::bv.set(Pos2Bit(0,1,0));}
     if (feld4) {Teil::bv.set(Pos2Bit(1,1,0));}
     if (feld5) {Teil::bv.set(Pos2Bit(2,1,0));}
     if (feld6) {Teil::bv.set(Pos2Bit(0,2,0));}
     if (feld7) {Teil::bv.set(Pos2Bit(1,2,0));}
     if (feld8) {Teil::bv.set(Pos2Bit(2,2,0));}
  }
  InitAnsicht();
  Symmetriehack1();
}

void Teil::print()
{
  cout << "Ebene (z=0): Ebene (z=1): Ebene (z=2): Ebene (z=3):\n";
  cout << "#----#       #----#       #----#       #----#\n";
  for (int y=tdim-1;y>=0;y--)
  {
    for (int z=0;z<tdim;z++)
    {
      cout << "|";
      for (int x=0;x<tdim;x++)
      {
        if (Teil::bv.test(Pos2Bit(x,y,z))) {cout << "o";} else {cout << " ";}
      }
      cout << "|       ";
    }
    cout << endl;
  }
  cout << "#----#       #----#       #----#       #----#\n";
}

void Teil::drehz()
{
  bool Gitter1[tdim][tdim][tdim];
  bool Gitter2[tdim][tdim][tdim];
  // Uebertragung in Gitter 1
  for (int x=0;x<tdim;x++)
  {
    for (int y=0;y<tdim;y++)
    {
      for (int z=0;z<tdim;z++)
      {
        if (Teil::bv.test(Pos2Bit(x,y,z))) {Gitter1[x][y][z]=true; }
        else                               {Gitter1[x][y][z]=false;}
      }
    }
  }
  // Beschreiben von Gitter 2
  int min_x=tdim-1;                //    xy
  for (int x=0;x<tdim;x++)         //    03 13 23 33   33 32 31 30
  {                                //    02 12 22 32   23 22 21 20
    for (int y=0;y<tdim;y++)       //    01 11 21 31   13 12 11 10
    {                              //   .00 10 20 30  .03 02 01 00
      for (int z=0;z<tdim;z++)
      {
        int t=tdim-1-y;
        if (Gitter1[x][y][z])
        {
          Gitter2[t][x][z]=true;
          if (t<min_x) {min_x=t;}
        }
        else {Gitter2[t][x][z]=false;}
      }
    }
  }
  // Teil ueberschreiben
  Bitvector64 temp;
  for (int x=0;x<tdim;x++)
  {
    for (int y=0;y<tdim;y++)
    {
      for (int z=0;z<tdim;z++)
      {
        if (Gitter2[x][y][z]) {temp.set(Pos2Bit(x-min_x,y,z));}
      }
    }
  }
  Teil::bv=temp;
}

void Teil::drehx()
{
  bool Gitter1[tdim][tdim][tdim];
  bool Gitter2[tdim][tdim][tdim];
  // Uebertragung in Gitter 1
  for (int x=0;x<tdim;x++)
  {
    for (int y=0;y<tdim;y++)
    {
      for (int z=0;z<tdim;z++)
      {
        if (Teil::bv.test(Pos2Bit(x,y,z))) {Gitter1[x][y][z]=true; }
        else                               {Gitter1[x][y][z]=false;}
      }
    }
  }
  // Beschreiben von Gitter 2
  int min_y=tdim-1;                //    yz
  for (int x=0;x<tdim;x++)         //    03 13 23 33   33 32 31 30
  {                                //    02 12 22 32   23 22 21 20
    for (int y=0;y<tdim;y++)       //    01 11 21 31   13 12 11 10
    {                              //   .00 10 20 30  .03 02 01 00
      for (int z=0;z<tdim;z++)
      {
        int t=tdim-1-z;
        if (Gitter1[x][y][z])
        {
          Gitter2[x][t][y]=true;
          if (t<min_y) {min_y=t;}
        }
        else {Gitter2[x][t][y]=false;}
      }
    }
  }
  // Teil ueberschreiben
  Bitvector64 temp;
  for (int x=0;x<tdim;x++)
  {
    for (int y=0;y<tdim;y++)
    {
      for (int z=0;z<tdim;z++)
      {
        if (Gitter2[x][y][z]) {temp.set(Pos2Bit(x,y-min_y,z));}
      }
    }
  }
  Teil::bv=temp;
}

void Teil::InitAnsicht()
{
  InitAnsichtSub(0*subview);
  drehx();
  InitAnsichtSub(1*subview);
  drehx();
  InitAnsichtSub(2*subview);
  drehx();
  InitAnsichtSub(3*subview);
  drehx();
  drehz();
  drehx();
  InitAnsichtSub(4*subview);
  drehx();
  drehx();
  InitAnsichtSub(5*subview);
  // Vergleich
  Anzahl=maxview;
  for (int i=1;i<Anzahl;i++)
  {
    for (int j=0;j<i;j++)
    {
      if (j==-1) {cout << "Error3\n";}
      if (Ansicht[j]==Ansicht[i])
      {
        Anzahl--;
        Ansicht[i]=Ansicht[Anzahl];
        MAX_x[i]=MAX_x[Anzahl];
        MAX_y[i]=MAX_y[Anzahl];
        MAX_z[i]=MAX_z[Anzahl];
        j=-1;
        if (Anzahl==i) {i=maxview;j=maxview;}
      }
    }
  }
  cout<<"Teil " <<Kennung<< " initialisiert: "<<Anzahl<<" moegliche Lagen\n";
}
void Teil::InitAnsichtSub(int Offset)
{
  for (int i=0;i<subview;i++)
  {
    drehz();Ansicht[i+Offset]=bv;
    int minx=tdim-1;int miny=tdim-1;int minz=tdim-1;
    int maxx=0;     int maxy=0;     int maxz=0;
    for (int x=0;x<tdim;x++)
    {
      for (int y=0;y<tdim;y++)
      {
        for (int z=0;z<tdim;z++)
        {
          if (Teil::bv.test(Pos2Bit(x,y,z)))
          {
            if(x<minx) {minx=x;}
            if(y<miny) {miny=y;}
            if(z<minz) {minz=z;}
            if(x>maxx) {maxx=x;}
            if(y>maxy) {maxy=y;}
            if(z>maxz) {maxz=z;}
          }
        }
      }
    }
    if (minx!=0) {cout << "Error4\n";}
    if (miny!=0) {cout << "Error4\n";}
    if (minz!=0) {cout << "Error4\n";}
    MAX_x[i+Offset]=maxx;
    MAX_y[i+Offset]=maxy;
    MAX_z[i+Offset]=maxz;
  }
}
void Teil::Symmetriehack1() // 3/4 rausschmeissen
{
  if(Kennung==symhack)
  {
    Bitvector64 t1,t2,t3,t4;    // vier symmetrische Teilansichten
    for (int i=0;i<Anzahl;i++)  // t1 eigentlich ueberfluessig
    {
      bv=Ansicht[i];  t1=bv;
      drehx();drehx();t2=bv;
      drehz();drehz();t3=bv;
      drehx();drehx();t4=bv;
      for (int j=i+1;j<Anzahl;j++)
      {
        if (t1==Ansicht[j] || t2==Ansicht[j] || t3==Ansicht[j] || t4==Ansicht[j])
        {
          Anzahl--;
          Ansicht[j]=Ansicht[Anzahl];
          MAX_x[j]=MAX_x[Anzahl];
          MAX_y[j]=MAX_y[Anzahl];
          MAX_z[j]=MAX_z[Anzahl];
          j--;
        }
      }
    }
    cout<<"Teil " <<Kennung<< " reinitialisiert: "<<Anzahl<<" moegliche Lagen\n";
  }
}
// ******************************* Teil Ende ********************************
Bitvector64 Lage2[nparts*64*maxview];  // 64*24=1536 12*1536=18432 8*18432=147456
              // Lage2: Teilnr*1536+firstbit*24+zaehler wobei zaehler<nbv2[Teilnr*64+firstbit]
int nbv2[nparts*64];
// **************************** Quaderteil Anfang ***************************
class QTeil
{
  public:
    QTeil(Teil);
    char Kennung;
    Bitvector64 Lage[576];              // per Hand ausprobiert : 576
    int nbv;
    int Pos3Bit (int x,int y, int z) {return x+y*qdimx+z*qdimx*qdimy;} // x+y*3+z*12
    void Symmetriehack2();
};
QTeil::QTeil(Teil T)
{
  QTeil::Kennung=T.Kennung;
  int counter=0;
  for (int i=0;i<T.Anzahl;i++)
  {
    if(T.MAX_x[i]<qdimx && T.MAX_y[i]<qdimy && T.MAX_z[i]<qdimz)
    {
      for (int x1=0;x1<(qdimx-T.MAX_x[i]);x1++)             // verschieben
      {
        for (int y1=0;y1<(qdimy-T.MAX_y[i]);y1++)
        {
          for (int z1=0;z1<(qdimz-T.MAX_z[i]);z1++)
          {
            Bitvector64 bvq;                                // setzen
            for (int x2=0;x2<=T.MAX_x[i];x2++)
            {
              for (int y2=0;y2<=T.MAX_y[i];y2++)
              {
                for (int z2=0;z2<=T.MAX_z[i];z2++)
                {
                  if(T.Ansicht[i].test(T.Pos2Bit(x2,y2,z2)))
                  {
                    bvq.set(Pos3Bit(x1+x2,y1+y2,z1+z2));    // erst nach 0..59
                  }
                }
              }
            }
            QTeil::Lage[counter]=PermTeil(bvq);             // dann permutieren 0..63
            counter++;
            if (counter>576) {cout << "Error5\n";}
          }
        }
      }
    }
  }
  QTeil::nbv=counter;
  cout<<"Teil " <<Kennung<< " initialisiert: "<<counter<<" moegliche Lagen"<<endl;
  Symmetriehack2();
}
void QTeil::Symmetriehack2()
{
  if (Kennung==symhack)       // nicht mehr B nehmen
  {
    // nur Lage[i] - nbv bleibt gleich
    for(int i=0;i<nbv;i++)
    {
      // die rausgeschmissenen wieder konstruieren
      Bitvector64 t1,t2,t3,t4;      // vier Dreh symmetrische Teile
      //Bitvector64 t5,t6,t7,t8;      // Spiegelungen nur fuer 'B'
      Lage[i]=RepermTeil(Lage[i]);t1=Lage[i];
      for (int x=0;x<3;x++){for (int y=0;y<4;y++){for (int z=0;z<5;z++){
        if (t1.test(Pos3Bit(x,y,z))) {t2.set(Pos3Bit(x,3-y,4-z));}
        if (t1.test(Pos3Bit(x,y,z))) {t3.set(Pos3Bit(2-x,y,4-z));}
        if (t1.test(Pos3Bit(x,y,z))) {t4.set(Pos3Bit(2-x,3-y,z));}
      }}}

      //for (int x=0;x<3;x++){for (int y=0;y<4;y++){for (int z=0;z<5;z++){
      //  if (t1.test(Pos3Bit(x,y,z))) {t5.set(Pos3Bit(x,y,4-z));}
      //  if (t2.test(Pos3Bit(x,y,z))) {t6.set(Pos3Bit(x,y,4-z));}
      //  if (t3.test(Pos3Bit(x,y,z))) {t7.set(Pos3Bit(x,y,4-z));}
      //  if (t4.test(Pos3Bit(x,y,z))) {t8.set(Pos3Bit(x,y,4-z));}
      //}}}

      int fb0,fb1,fb2,fb3,fb4;
      for (fb1 = 0; !t1.test(PBit64[fb1]); fb1++) {;}
      for (fb2 = 0; !t2.test(PBit64[fb2]); fb2++) {;}
      for (fb3 = 0; !t3.test(PBit64[fb3]); fb3++) {;}
      for (fb4 = 0; !t4.test(PBit64[fb4]); fb4++) {;}
      fb0=fb1;
      if (fb2>fb0) {Lage[i]=t2;fb0=fb2;}
      if (fb3>fb0) {Lage[i]=t3;fb0=fb3;}
      if (fb4>fb0) {Lage[i]=t4;fb0=fb4;}

      /*if(Kennung=='B')  //symhack=='B'
      {
        int fb5,fb6,fb7,fb8;
        for (fb5 = 0; !t5.test(PBit64[fb5]); fb5++) {;}
        for (fb6 = 0; !t6.test(PBit64[fb6]); fb6++) {;}
        for (fb7 = 0; !t7.test(PBit64[fb7]); fb7++) {;}
        for (fb8 = 0; !t8.test(PBit64[fb8]); fb8++) {;}
        if (fb5>fb0) {Lage[i]=t5;fb0=fb5;}
        if (fb6>fb0) {Lage[i]=t6;fb0=fb6;}
        if (fb7>fb0) {Lage[i]=t7;fb0=fb7;}
        if (fb8>fb0) {Lage[i]=t8;fb0=fb8;}
      }  //*/
      Lage[i]=PermTeil(Lage[i]);
    }
    cout<<"Teil " <<Kennung<< " reinitialisiert. "<<endl;
  }
  if (Kennung=='A' && symhack=='A')
  {
    for(int i=0;i<nbv;i++)             // xx  oz  xx  zo
    {                                  // oo  oo  oo  oo
      Bitvector64 t1,t2,t3,t4;         // oz  xx  zo  xx
      t1=RepermTeil(Lage[i]);
      for (int x=0;x<qdimx;x++){for (int y=0;y<qdimy;y++){for (int z=0;z<qdimz;z++){
        if (t1.test(Pos3Bit(x,y,z))) {t2.set(Pos3Bit(2-x,y,z));}  // yz-Ebene gespiegelt
        if (t1.test(Pos3Bit(x,y,z))) {t3.set(Pos3Bit(x,3-y,z));}  // xz-Ebene gespiegelt
        if (t1.test(Pos3Bit(x,y,z))) {t4.set(Pos3Bit(2-x,3-y,z));}  //  z-Achse gedreht
      }}}
      t1=PermTeil(t1); t2=PermTeil(t2); t3=PermTeil(t3); t4=PermTeil(t4);

      int i1,i2,i3;i1=i;i2=-1;i3=-1;
      for(int j=0;j<nbv;j++) { if(t2==Lage[j]) {i2=j;} }
      for(int j=0;j<nbv;j++) { if(t3==Lage[j]) {i3=j;} }
      if(i2!=-1) {continue;}
      //if(i3!=-1) {continue;}
      if(i3==-1) {cout<<"Error A\n";cin>>weiter;}
      //if(i2==-1) {cout<<"Error A\n";cin>>weiter;}
      int j1,j2,j3,j4;
      for (j1=0;j1<60;j1++) {if(t1.test(NBit64[j1])){break;}}
      for (j2=0;j2<60;j2++) {if(t2.test(NBit64[j2])){break;}}
      for (j3=0;j3<60;j3++) {if(t3.test(NBit64[j3])){break;}}
      for (j4=0;j4<60;j4++) {if(t4.test(NBit64[j4])){break;}}
      // Entscheidung ob t1,t2 oder t3,t4
      if(j1+j2 < j3+j4) {Lage[i1]=t4;}// t3,t4 besser
      //if(j1+j3 < j2+j4) {Lage[i1]=t4;}// t2,t4 besser
      else              {Lage[i3]=t2;}
      //else              {Lage[i2]=t3;}
    }
    cout<<"Teil " <<Kennung<< " rereinitialisiert. "<<endl;
  }
  if (Kennung=='B' && symhack=='A')
  {
    // nur Lage[i] - nbv bleibt gleich
    for(int i=0;i<nbv;i++)
    {
      Bitvector64 t1,t2;
      t1=RepermTeil(Lage[i]);
      for (int x=0;x<3;x++){for (int y=0;y<4;y++){for (int z=0;z<5;z++){
        if (t1.test(Pos3Bit(x,y,z))) {t2.set(Pos3Bit(2-x,y,z));}  // yz-Ebene gespiegelt
        //if (t1.test(Pos3Bit(x,y,z))) {t2.set(Pos3Bit(x,3-y,z));}  // xz-Ebene gespiegelt
      }}}
      t1=PermTeil(t1); t2=PermTeil(t2);
      int j1,j2;
      for (j1=0;j1<60;j1++) {if(t1.test(NBit64[j1])){break;}}
      for (j2=0;j2<60;j2++) {if(t2.test(NBit64[j2])){break;}}
      if (j1<j2) {Lage[i]=t2;}
    }
    cout<<"Teil " <<Kennung<< " reinitialisiert. "<<endl;
  }
    // nbv2 und Lage2 schreiben fuer ein Teil
    int nr;
    if (Kennung=='0'){nr=0;} if (Kennung=='4'){nr=4;} if (Kennung=='8'){nr=8;}
    if (Kennung=='1'){nr=1;} if (Kennung=='5'){nr=5;} if (Kennung=='9'){nr=9;}
    if (Kennung=='2'){nr=2;} if (Kennung=='6'){nr=6;} if (Kennung=='A'){nr=10;}
    if (Kennung=='3'){nr=3;} if (Kennung=='7'){nr=7;} if (Kennung=='B'){nr=11;}
    for(int i=0;i<64;i++) {nbv2[nr*64+i]=0;}
    for(int i=0;i<nbv;i++)                               // alle Teile
    {
      Bitvector64 bvq=Lage[i];
      int first_bit;
      for (first_bit = 0; !bvq.test(first_bit); first_bit++) {;}
      if  (first_bit>=64) {cout << "Error7\n";cin >> weiter;}
      nbv2[nr*64+first_bit]++;
      int temp=nbv2[nr*64+first_bit];
      if (temp>maxview) {cout <<i<< " Error8 "<<first_bit<<endl;cin >> weiter;}
      //if (first_bit==4){out60(bvq);cin>>weiter;}
      Lage2[(nr*64+first_bit)*maxview+(temp-1)]=bvq;          // global speichern
    }
}
// ********************************** Quaderteil Ende ***********************
int Verweis[nparts*64*maxview];
class Puzzle
{
  QTeil * parts;
  void stop();
 public:
  Puzzle(QTeil *);
  void solve();
};

Puzzle::Puzzle(QTeil * tiq)
{
  Puzzle::parts=tiq;
  // DeadEnd1 / Deadend2
  unsigned int Teilnr[nparts];
  for (int i=0;i<nparts;i++) {Teilnr[i]=1<<i;}
  int anzahlTeile=0;
  for (int i=0;i<nparts;i++)
  {
    for (int ErstBit=0;ErstBit<64;ErstBit++)
    {
      int k=nbv2[i*64+ErstBit];
      //cout<<i<<" "<<ErstBit<<" "<<k;cin>>weiter;
      for (int j=0;j<k;j++)
      {
        Verweis[(i*64+ErstBit)*maxview+j]=anzahlTeile*maxNachb*2;
        Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
        int noNachbarn=0;
        for (int b=ErstBit+1;b<64;b++)
        {
          if(bv.test(Dat.Nachbar[b]) && !bv.test(NBit64[b]))
          {
            noNachbarn++;
            Dat.DeadEnd1[anzahlTeile*maxNachb*2+noNachbarn*2+0]=NBit64[b];    // Inneres
            Dat.DeadEnd2[(anzahlTeile*64+b)*2+0]=NBit64[b];
            Dat.DeadEnd2[(anzahlTeile*64+0)*2+0]|=NBit64[b];
            Bitvector64 bv2=bv;bv2&=Dat.Nachbar[b];bv2^=Dat.Nachbar[b];
            Dat.DeadEnd1[anzahlTeile*maxNachb*2+noNachbarn*2+1]=bv2;   // Aeusseres
            Dat.DeadEnd2[(anzahlTeile*64+b)*2+1]=bv2;
          }
        }
        Dat.DeadEnd1[anzahlTeile*maxNachb*2+0].set((i*64+ErstBit)*maxview+j,noNachbarn);       //..+1 bleibt frei
        Dat.DeadEnd1[anzahlTeile*maxNachb*2+noNachbarn*2+2].set(Teilnr[i],0);    // ..+noN..*2+3 bleibt frei
        Dat.DeadEnd2[(anzahlTeile*64+0)*2+1].set(Teilnr[i],0);
        anzahlTeile++;
      }
    }
  }
  // Kette1 && Offset
  // spaeter: erst setzen dann kopieren
  int setoffheader=0;                                       // Lage2: 12*64*24
  for (int ErstBit=0;ErstBit<64;ErstBit++)                  // nbv2 : 12*64
  {
    for (int benTeile=0;benTeile<teilKomb;benTeile++)
    {
      // Ablagereihenfolge            xyz x xy y yz z zx x
      int countxyz=0;int countx=0; int countxy=0;int county=0;int countyz=0; int countz=0; int countxz=0;
      int setoff=setoffheader+8;
      // Lege xyz
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (bv.test(Dat.xNachbar[ErstBit]) && bv.test(Dat.yNachbar[ErstBit]) && bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;countxyz++;
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Lege x
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (bv.test(Dat.xNachbar[ErstBit]) && !bv.test(Dat.yNachbar[ErstBit]) && !bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;countx++;
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Lege xy
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (bv.test(Dat.xNachbar[ErstBit]) && bv.test(Dat.yNachbar[ErstBit]) && !bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;countxy++;
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Lege y
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (!bv.test(Dat.xNachbar[ErstBit]) && bv.test(Dat.yNachbar[ErstBit]) && !bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;county++;
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Lege yz
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (!bv.test(Dat.xNachbar[ErstBit]) && bv.test(Dat.yNachbar[ErstBit]) && bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;countyz++;
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Lege z
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (!bv.test(Dat.xNachbar[ErstBit]) && !bv.test(Dat.yNachbar[ErstBit]) && bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;countz++;
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Lege xz
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (bv.test(Dat.xNachbar[ErstBit]) && !bv.test(Dat.yNachbar[ErstBit]) && bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;countxz++;
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Lege x
      for (int i=0;i<nparts;i++)
      {
        if( !(benTeile & Teilnr[i]) )      // Teil i kann gelegt werden
        {
          int Anz=nbv2[i*64+ErstBit];
          if(Anz!=0)
          {
            for (int j=0;j<Anz;j++)        // in welchen ErstBit Lagen
            {
              Bitvector64 bv=Lage2[(i*64+ErstBit)*maxview+j];
              if (bv.test(Dat.xNachbar[ErstBit]) && !bv.test(Dat.yNachbar[ErstBit]) && !bv.test(Dat.zNachbar[ErstBit]))
              {
                // ablegen
                if(setoff>=(maxKette-1)) {cout<<"ErrorK1"<<endl;cin>>weiter;}
                Dat.Kette1[setoff]=bv;setoff++;// schon gezaehlt
                int v=Verweis[(i*64+ErstBit)*maxview+j];
                Dat.Kette1[setoff].set((v/(maxNachb*2))*1024,Teilnr[i]);setoff++;
              }
            }
          }
        }
      }
      // Init Header und Offset und neue Headerposition
      // Ablagereihenfolge            xyz x xy y yz z zx x und zwar count mal
      int startxyz=setoffheader+8;int startx=startxyz+2*countxyz;int startxy=startx+2*countx;
      int starty=startxy+2*countxy;int startyz=starty+2*county;int startz=startyz+2*countyz;
      int startxz=startz+2*countz;int startx2=startxz+2*countxz;int endex2=startx2+2*countx;
      if (endex2!=setoff) {cout<<"ErrorK"<<endl;cin>>weiter;}
      Dat.Kette1[setoffheader+0].set((startxyz)*8,(startx2)*8); //     verbaut
      Dat.Kette1[setoffheader+4].set((starty  )*8,(startxz)*8); // x   verbaut
      Dat.Kette1[setoffheader+2].set((startz  )*8,(endex2 )*8); //  y  verbaut
      Dat.Kette1[setoffheader+1].set((startx  )*8,(startyz)*8); //   z verbaut
      Dat.Kette1[setoffheader+6].set((startz  )*8,(startxz)*8); // xy  verbaut
      Dat.Kette1[setoffheader+5].set((starty  )*8,(startyz)*8); // x z verbaut
      Dat.Kette1[setoffheader+3].set((startx  )*8,(startxy)*8); //  yz verbaut
      Dat.Kette1[setoffheader+7].set(0            ,0           ); // xyz verbaut
      Dat.Offset[ErstBit][benTeile]=setoffheader*8;
      setoffheader=setoff;
    }
  }
  if (setoffheader!=maxKette) {cout<<"Error Kette";cin>>weiter;}
}

int Aufrufe1[2],Aufrufe2[2],Aufrufe3[2],Aufrufe4[2],Aufrufe5[2],Aufrufe6[2];
void solve2(Q* D)
{
  //Q* D=&Dat;
  int nb=Next(D->aktuell);                                              // Bitsuche
  //if (nb>=33) {  if((D->benutzt&896)==896){D->sol++;if(!(D->sol%1000000)){cout<<".";}}  return;}             // Ende
  if (nb>=64) {  D->sol++;if(!(D->sol%1000)){cout<<".";}  return;}
  //Bitvector64 temp=D->aktuell; temp|=Dat.Nachbar[nb]; if (temp==D->aktuell) {return;} // Abbruch

//  Aufrufe1[0]++;if (Aufrufe1[0]==1000000) {Aufrufe1[1]++;Aufrufe1[0]=0;}
  unsigned int o=D->Offset[nb][D->benutzt];
  if (D->aktuell.test(D->xNachbar[nb])) {o+=4*8;}
  if (D->aktuell.test(D->yNachbar[nb])) {o+=2*8;}
  if (D->aktuell.test(D->zNachbar[nb])) {o+=1*8;}
  unsigned int c;
  D->Kette1[(o/8)].get(o,c);
  while (o<c)
  {
//    Aufrufe2[0]++;if (Aufrufe2[0]==1000000) {Aufrufe2[1]++;Aufrufe2[0]=0;}
    if( !D->aktuell.test(D->Kette1[(o/8)]) )    // kollidiert nicht
    {
//      Aufrufe3[0]++;if (Aufrufe3[0]==1000000) {Aufrufe3[1]++;Aufrufe3[0]=0;}
      unsigned int v,n;D->Kette1[(o/8)+1].get(v,n);  // if(v>10000000){cout<<"Hallo?";}
      v=v/1024;v=v*maxNachb*2;
      unsigned int u,w;D->DeadEnd1[v].get(u,w);  // w ist Anzahl der Nachbarn
      if(u>=nparts*64*maxview) {cout<<"ErrorK2\n";cin>>weiter;}
      unsigned int o2,c2;o2=(v+2)*8;c2=(v+2+w*2)*8;   // Beginn/Ende der Nachbarn

      int z=0;
      while((o2<c2) && n && z<3)          // wenn n dann aufruf
      {
//        Aufrufe4[0]++;if (Aufrufe4[0]==1000000) {Aufrufe4[1]++;Aufrufe4[0]=0;}
        if(!D->aktuell.test(D->DeadEnd1[(o2/8)]))     // Innen
        {
          z++;o2+=8;
//          Aufrufe5[0]++;if (Aufrufe5[0]==1000000) {Aufrufe5[1]++;Aufrufe5[0]=0;}
          Bitvector64 temp=D->aktuell; temp|=D->DeadEnd1[(o2/8)];  // Aussen
          if (temp==D->aktuell) {n=0;}                            // kein aufruf
          o2+=8;
        }
        else{o2+=16;}
      }        //*/

      if(n)   // aufruf
      {
        D->benutzt=(D->benutzt | n);         // benutzt + aktuell bzw.
        D->aktuell|=D->Kette1[(o/8)];             // n + Lage/Kette zusammenfassen zu 72Bit?
        solve2(D);                      // o,c,n -> Stack
        D->aktuell^=D->Kette1[(o/8)];             // Speicherzugriff vs. push,push,pop,pop bzw.pushaw
        D->benutzt=(D->benutzt ^ n);
      }
    }
    o+=16;
  }
}

void Puzzle::stop()
{
  cout << "A1 " << Aufrufe1[1] << "." << Aufrufe1[0] << " Durchlaeufe\n";
  cout << "A2 " << Aufrufe2[1] << "." << Aufrufe2[0] << " Durchlaeufe\n";
  cout << "A3 " << Aufrufe3[1] << "." << Aufrufe3[0] << " Durchlaeufe\n";
  cout << "A4 " << Aufrufe4[1] << "." << Aufrufe4[0] << " Durchlaeufe\n";
  cout << "A5 " << Aufrufe5[1] << "." << Aufrufe5[0] << " Durchlaeufe\n";
}

void Puzzle::solve()
{
  Aufrufe1[0]=0;Aufrufe1[1]=0;
  Aufrufe2[0]=0;Aufrufe2[1]=0;
  Aufrufe3[0]=0;Aufrufe3[1]=0;
  Aufrufe4[0]=0;Aufrufe4[1]=0;
  Aufrufe5[0]=0;Aufrufe5[1]=0;
  Dat.sol=0;Dat.benutzt=0;Dat.aktuell.set(15,0);
  solve1(&Dat);
  cout << Dat.sol << " Loesungen." << endl;
  //stop();
}

int main( /* int argc, char *argv[] */ )
{
  clock_t s=clock();
  cout << "Puzzle Solver 0.8  (C)2003 by Snej\n";

  // 4 - stufige Initialisierung
  GlobalInit();                                  // Stufe 1
  cout << "Teile:\n";
  Teil teile[] =                                 // Stufe 2
  {
    Teil('0',Dreix2x1,true ,true ,true ,  true ,false,true ),
    Teil('1',Dreix2x1,true ,true ,true ,  true ,true ,false),
    Teil('2',Dreix3x1,true ,false,false,  true ,true ,true ,  false,false,true ),
    Teil('3',Dreix3x1,true ,true ,true ,  false,true ,false,  false,true ,false),
    Teil('4',Dreix3x1,false,true ,true ,  true ,true ,false,  true ,false,false),
    Teil('5',Dreix3x1,false,true ,false,  true ,true ,true ,  true ,false,false),
    Teil('6',Dreix3x1,false,true ,false,  true ,true ,true ,  false,true ,false),
    Teil('7',Vierx2x1,true ,true ,true ,true ,  true ,false,false,false),
    Teil('8',Vierx2x1,true ,true ,true ,true ,  false,true ,false,false),
    Teil('9',Vierx2x1,true ,true ,true ,true ,  true ,false,true ,false),
    Teil('A',Zweix2x2,true ,true ,  true ,true ,  true ,false,  false,false),
    Teil('B',Zweix2x2,true ,false,  true ,true ,  false,false,  false,true )
  };
  cout << "Quaderteile:\n";
  QTeil tiq[] = // Teile im Quader               // Stufe 3
  {
    QTeil(teile[0]), QTeil(teile[1]), QTeil(teile[2]),  QTeil(teile[3]),
    QTeil(teile[4]), QTeil(teile[5]), QTeil(teile[6]),  QTeil(teile[7]),
    QTeil(teile[8]), QTeil(teile[9]), QTeil(teile[10]), QTeil(teile[11])
  };
  cout << endl;
  Puzzle puzzle(tiq);                               // Stufe 4
  // Initialisierung abgeschlossen

  puzzle.solve();

  cout << ((double)((clock()-s)/CLOCKS_PER_SEC))<<" Sec. Ende\n";
  cin >> weiter;
  return 0;
}
