(****************************************************)
(*                                                  *)
(*       c't-Puzzleprogramm von Ingo Warnke         *)
(*              IngoWarnke@gmx.de                   *)
(*                                                  *)
(****************************************************)

{$A+,B-,C-,D-,E-,F-,G+,H+,I-,J+,K-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z1}
{$MINSTACKSIZE $00004000}
{$MAXSTACKSIZE $00100000}
{$IMAGEBASE $00400000}

program Ctpuzz4_RC3;
{$APPTYPE CONSOLE}

uses
  sysutils;

const
  max_x=3;
  max_y=2;
  max_z=4;


type bitvec = record
                l1,l2: LongInt;
                end;
     bvlist = array [1..600] of bitvec;
     PuzzTeilSet = Set of 1..12;

type
     TeilPosition = record
                      Teil: Integer;
                      bvIdx: Integer;
                      end;
     TPList       = array [1..600] of TeilPosition;

(*   TPLIst enthlt Liste von Teilen in bestimmten Position
     Liste ist nach Teilen sortiert; das erste Element fr ein bestimmtes
     Teil enthlt bei bvIdx die Anzahl aller Elemente fr dieses Teil
     (inklusive sich selbst)
     Liste endet, wenn Teil=-1;
*)

type
  point= object
           x,y,z: Integer;
           constructor init (xi,yi,zi:Integer);
           procedure rotate_x;
           procedure rotate_y;
           procedure rotate_z;
           procedure translate (dx,dy,dz: Integer);
           procedure setbitvec (var bv: bitvec);
           end;

var
  Solution_Count: LongInt;

procedure PrintTime;


begin
writeln (TimeToStr (Time));
end;

constructor point.init (xi,yi,zi: Integer);

begin
x:=xi;
y:=yi;
z:=zi;
end;

procedure point.rotate_x;

var
  h: Integer;

begin
h:=z;
z:=y;
y:=-h
end;

procedure point.rotate_y;

var
  h: Integer;

begin
h:=x;
x:=z;
z:=-h
end;

procedure point.rotate_z;

var
  h: Integer;

begin
h:=y;
y:=x;
x:=-h
end;

procedure point.translate (dx,dy,dz: Integer);

begin
x:=x+dx;
y:=y+dy;
z:=z+dz;
end;

procedure point.setbitvec (var bv: bitvec);

var
  i: Integer;
  l: LongInt;

begin
Assert ((max_x=3) and (max_y=2) and (max_z=4), 'BitVec procedure not valid for this cube!');

if (x < 0) or (y < 0) or (z < 0) or
   (x > max_x) or (y > max_y) or (z > max_z) then
   begin
   writeln ('Internal error: Variables out of range in setbitvec!');
   readln;
   halt;
   end;
i:=z*(max_x+1)*(max_y+1)+y*(max_x+1)+x;
l:=longint (1) shl i;
if i < 28 then
  bv.l2:=bv.l2 or l
else
if i < 32 then
  begin
  bv.l2:=bv.l2 or l;
  bv.l1:=bv.l1 or l
  end
else
  begin
  i:=(max_z-z)*(max_x+1)*(max_y+1)+(max_y-y)*(max_x+1)+x;
  Assert (i < 28, 'Rotation should bring us into first case!');
  l:=longint (1) shl i;
  bv.l1:=bv.l1 or l;
  end
end;

procedure Cube2Point (BitIdx: Integer; var tp: point);

var
  Cube,x,y,z: Integer;

begin
Assert ((max_x=3) and (max_y=2) and (max_z=4), 'Cube2Point procedure not valid for this cube!');
Assert ((BitIdx >= 0) and (BitIdx <= 63), 'Bit index out of range in Cube2Point!');

Cube:=BitIdx mod 32;
x:=Cube mod (max_x+1);
y:=(Cube div (max_x+1)) mod (max_y+1);
z:=(Cube div (max_x+1)) div (max_y+1);
Assert ((x>=0) and (x<=max_x) and(y>=0) and (y<=max_y) and (z>=0) and (z<=max_z), 'x,y or z values out of range in Cube2Point!');

if (Cube >= 28) or // doubled part
    (BitIdx < 28)  then       // early part
  tp.init (x,y,z)
else
  tp.init (x,max_y-y,max_z-z)
end;

const
  MaxPoints = 6;

type
  PuzzTeil = object
               PointCount: Integer;
               Points: array [1..MaxPoints] of Point;
               constructor Empty;
               procedure Add (const NewPoint: Point);
               procedure rotate_x;
               procedure rotate_y;
               procedure rotate_z;
               procedure translate (dx,dy,dz: Integer);
               procedure makebitvec (var bv: bitvec);
               function  makebvlist (var bvl: bvlist; Full_Rotations: Boolean): Integer;
               end;

constructor PuzzTeil.Empty;

begin
PointCount:=0;
end;

procedure PuzzTeil.Add (const NewPoint: Point);

begin
if PointCount = MaxPoints then
  begin
  writeln ('Nur ', MaxPoints, ' Punkte pro PuzzleTeil erlaubt!');
  readln;
  halt;
  end;
Inc (PointCount);
Points[PointCount].Init (NewPoint.x, NewPoint.y, NewPoint.z) ;
end;

procedure PuzzTeil.rotate_x;

var
  i: Integer;

begin
for i:=1 to PointCount do
  Points[i].rotate_x;
end;

procedure PuzzTeil.rotate_y;

var
  i: Integer;

begin
for i:=1 to PointCount do
  Points[i].rotate_y;
end;

procedure PuzzTeil.rotate_z;

var
  i: Integer;

begin
for i:=1 to PointCount do
  Points[i].rotate_z;
end;

procedure PuzzTeil.translate (dx,dy,dz: Integer);

var
  i: Integer;

begin
for i:=1 to PointCount do
  Points[i].translate (dx,dy,dz);
end;


procedure PuzzTeil.makebitvec (var bv: bitvec);


var
  i: Integer;

begin
bv.l1:=0;
bv.l2:=0;
for i:=1 to PointCount do
  Points[i].setbitvec(bv);
end;

function PuzzTeil.makebvlist (var bvl: bvlist; Full_Rotations: Boolean): Integer;

var
  bvidx,i,j,k,l,m: Integer;
  pt1, pt2: PuzzTeil;
  min_point, max_point: point;
  bv: bitvec;
  Rotations: Integer;

label
  triple_for_loop_end;

begin
if PointCount=0 then
  begin
  makebvlist:=0;
  exit;
  end;
pt1.Empty;
pt2.Empty;
bvidx:=1;
pt1:=self;
if Full_Rotations then
  Rotations:=24
else
  Rotations:=6;

for i:=1 to Rotations do
  begin
  min_point.init (pt1.Points[1].x,pt1.Points[1].y,pt1.Points[1].z);
  max_point.init (pt1.Points[1].x,pt1.Points[1].y,pt1.Points[1].z);
  for j:=2 to PointCount do
    begin
    if pt1.Points[j].x < min_Point.x then
      min_Point.x:=pt1.Points[j].x;
    if pt1.Points[j].x > max_Point.x then
      max_Point.x:=pt1.Points[j].x;
    if pt1.Points[j].y < min_Point.y then
      min_Point.y:=pt1.Points[j].y;
    if pt1.Points[j].y > max_Point.y then
      max_Point.y:=pt1.Points[j].y;
    if pt1.Points[j].z < min_Point.z then
      min_Point.z:=pt1.Points[j].z;
    if pt1.Points[j].z > max_Point.z then
      max_Point.z:=pt1.Points[j].z;
    end;

  for j:=-min_Point.x to max_x-max_Point.x do
    for k:=-min_Point.y to max_y-max_Point.y do
      for l:=-min_Point.z to max_z-max_Point.z do
        begin
        pt2:=pt1;
        pt2.translate (j,k,l);
        pt2.makebitvec (bv);
        for m:=1 to bvidx-1 do
          if (bvl[m].l1 = bv.l1) and (bvl[m].l2 = bv.l2) then
            goto triple_for_loop_end;

        bvl[bvidx]:=bv;
        Inc (bvidx);
triple_for_loop_end:
        end;

  if Full_Rotations then
    case i of
      1,2,3:   pt1.rotate_z;
      4:       pt1.rotate_x;
      5,6,7:   pt1.rotate_y;
      8:       pt1.rotate_x;
      9,10,11: pt1.rotate_z;
      12:      pt1.rotate_y;
      13,14,15:pt1.rotate_x;
      16:      begin pt1.rotate_z; pt1.rotate_z end;
      17,18,19:pt1.rotate_x;
      20:      pt1.rotate_z;
      21,22,23:pt1.rotate_y;
      end
  else
    case i of
      1: pt1.rotate_x;
      2: pt1.rotate_z;
      3: pt1.rotate_y;
      4: pt1.rotate_x;
      5: pt1.rotate_z;
    end;
  end;
makebvlist:=bvidx-1;
end;

var
  ct_teile: array [1..12] of PuzzTeil;
  ct_bvl: array [1..12] of bvlist;
  ct_bv_count: array [1..12] of Integer;
  ct_TeilPos: array [1..64] of TPList;

procedure FindRelevantTPs (tp: point; InitEarlierCubes: bitvec; var RelevantTP: TPList);

var
  bv_Cube, bv_EarlierCubes: bitvec;
  i,Teil: Integer;
  TeilStartIdx: Integer;
  CurrentIdx: Integer;

begin
bv_Cube.l1:=0;
bv_Cube.l2:=0;
tp.setbitvec(bv_Cube);

bv_EarlierCubes.l1:=0;
bv_EarlierCubes.l2:=0;
for i:=0 to 63 do
  if i < 32 then
    if (bv_Cube.l2 and (longint (1) shl i)) = 0 then
      bv_EarlierCubes.l2:=bv_EarlierCubes.l2 or (longint (1) shl i)
    else
      break
  else
    if (bv_Cube.l1 and (longint (1) shl i)) = 0 then
      bv_EarlierCubes.l1:=bv_EarlierCubes.l1 or (longint (1) shl i)
    else
      break;

bv_EarlierCubes.l1:=bv_EarlierCubes.l1 or InitEarlierCubes.l1;
bv_EarlierCubes.l2:=bv_EarlierCubes.l2 or InitEarlierCubes.l2;

CurrentIdx:=1;
for Teil:=1 to 12 do
  begin
  TeilStartIdx:=CurrentIdx;
  Inc (CurrentIdx);
  for i:=1 to ct_bv_count[Teil] do
    begin
    {Teil deckt in der gewhlten Lage den zu berdeckenden Wrfel nicht ab}
    if ((bv_Cube.l2 and ct_bvl[Teil,i].l2) = 0) and
       ((bv_Cube.l1 and ct_bvl[Teil,i].l1) = 0) then
       continue;

    {Teil berschneidet sich in der gewhlten Lage mit den
    von den bisherigen Puzzelteilen mit Sicherheit berdeckten Wrfeln}
    if ((ct_bvl[Teil,i].l2 and bv_EarlierCubes.l2) <> 0) or
       ((ct_bvl[Teil,i].l1 and bv_EarlierCubes.l1) <> 0) then
       continue;

    {Teil knnte in der gewhlten Lage passen}
    RelevantTP[CurrentIdx].Teil:=Teil;
    RelevantTP[CurrentIdx].bvIdx:=i;
    Inc (CurrentIdx);
    end;
  if CurrentIdx - TeilStartIdx > 1 then
    begin
    RelevantTP[TeilStartIdx].Teil:=Teil;
    RelevantTP[TeilStartIdx].bvIdx:=CurrentIdx - TeilStartIdx;
    end
  else {keine Lage des Teiles passt}
    Dec (CurrentIdx);
  end;
RelevantTP[CurrentIdx].Teil:=-1;
RelevantTP[CurrentIdx].bvIdx:=0;
end;

procedure solve (CurrentPuzzState: bitvec;
                 UsedParts: PuzzTeilSet;
                 LastOrderIdx: Word);

var
  Next_Cube: bitvec;
  i,Teil,MaxIdx,hIdx: Integer;
  NextPuzzstate: bitvec;
  TP: ^TeilPosition;
  TeilList: ^bvlist;
  l2,l1: LongInt;
  OrderIdx: Word;

const
  c1: Integer = 0;
  c2: Integer = 0;
  c4: Integer = 0;
  c8: Integer = 0;

label
  Next_Cube_Found;

begin
{$IfDEF ScreenOut}
for i:=LastOrderIdx+1 to 64 do
  begin
  if i <= 32 then
    begin
    Next_Cube.l1:=0;
    Next_Cube.l2:=longint (1) shl (i-1)
    end
  else
    begin
    Next_Cube.l2:=0;
    Next_Cube.l1:=longint (1) shl (i-33)
    end;
  if ((Next_Cube.l2 and CurrentPuzzState.l2) = 0) and
     ((Next_Cube.l1 and CurrentPuzzState.l1) = 0) then
     goto Next_Cube_Found;
  end;
{$ELSE} // no need to keep Next_Cube
for i:=LastOrderIdx+1 to 64 do
  begin
  if i <= 32 then
    begin
    if ((longint (1) shl (i-1)) and CurrentPuzzState.l2) = 0 then
      goto Next_Cube_Found;
    end
  else
    begin
    if ((longint (1) shl (i-1)) and CurrentPuzzState.l1) = 0 then
      goto Next_Cube_Found;
    end;
  end;
{$ENDIF}

{ no empty cube found, so we must have found a solution!}

{ check: we must have used all parts }
Assert (UsedParts = [1..12], 'Internal Error: solution found but not all parts have been used!');

Inc (Solution_Count);
exit;

Next_Cube_Found:

TP:=@ct_TeilPos[i,1];
OrderIdx:=i;

{$IFDEF SCREENOUT}
if (Next_Cube.l2 and 15) <> 0 then
  begin
  case Next_Cube.l2 of
    1: begin c1:=0; c2:=0; c4:=0; c8:=0; end;
    2: begin c2:=0; c4:=0; c8:=0;  end;
    4: begin c4:=0; c8:=0;  end;
    8: begin c8:=0;  end;
  else
    begin
    writeln ('Internal Error: Cube must be 1,2,4,8!');
    readln;
    halt;
    end;
    end;
  end;
{$ENDIF}

(*
if i > (max_x+1)*(max_y+1)*(max_z+1) div 5 then
  begin
  Inc (Solution_Count);
//  writeln ('Solution no: ',Solution_Count);
//  PrintTime;
  exit;
  end;
*)

while TP^.Teil <> -1 do
  begin
  Teil:=TP^.Teil;
  if Teil in UsedParts then
    begin
    Inc (TP, TP^.bvIdx);
    continue;
    end;
  TeilList:=@ct_bvl[Teil];
  MaxIdx:=TP^.bvIdx-1;
  Inc (TP);
  for i:=1 to MaxIdx do
    begin
    hIdx:=TP^.bvIdx;
    Inc (TP);

    l1:=TeilList[hIdx].l1;
    l2:=TeilList[hIdx].l2;
    {Teil berschneidet sich in der gewhlten Lage mit den bisherigen Puzzelteilen}
    if ((l2 and CurrentPuzzState.l2) <> 0) or
       ((l1 and CurrentPuzzState.l1) <> 0) then
       continue;

    {Teil passt zu den bisherigen Teilen, also Einfgen}
    NextPuzzState.l1:=CurrentPuzzState.l1 or l1;
    NextPuzzState.l2:=CurrentPuzzState.l2 or l2;
{$IFDEF SCREENOUT}
  if (Next_Cube.l2 and 15) <> 0 then
    begin
    case Next_Cube.l2 of
      1: begin Inc (c1); c2:=0; c4:=0; c8:=0; end;
      2: begin Inc (c2); c4:=0; c8:=0; end;
      4: begin Inc (c4); c8:=0; end;
      8: begin Inc (c8);end;
    else
      begin
      writeln ('Internal Error: Cube must be 1,2,4 or 8!');
      readln;
      halt;
      end;
      end;
    writeln ('* ',c1:3,' ',c2:3,' ',c4:3,' ',c8:3,' Solutions: ', Solution_Count);
    PrintTime;
    end;
{$ENDIF}
    Solve (NextPuzzState, UsedParts+[Teil],OrderIdx);
    end;
  end;
end;

var
  tp,tp2: point;
  tpt: PuzzTeil;
  bvl_count: Integer;
  bvl: bvlist;
  i,j: Integer;
  PuzzState: bitvec;
  c1: bitvec;

begin

writeln ('c''t-Puzzleprogramm von Ingo Warnke <IngoWarnke@gmx.de>');
write ('Suche gestartet um: ');
PrintTime;

if (max_x+1)*(max_y+1)*(max_z+1) > 64 then
  begin
  writeln ('Nur Quader mit hchstens 64 Feldern sind zulssig!');
  readln;
  halt;
  end;

(*
for x:=0 to max_x do
  for y:=0 to max_y do
    for z:=0 to max_z do
      begin
      tp.init (x,y,z);
      PuzzState.l1:=0;
      PuzzState.l2:=0;
      tp.setbitvec(PuzzState);
      for i:=0 to 63 do
        begin
        if i < 32 then
          begin
          c1.l1:=0;
          c1.l2:=LongInt (1) shl i
          end
        else
          begin
          c1.l2:=0;
          c1.l1:=LongInt (1) shl i
          end;
        if ((PuzzState.l1 and c1.l1) <> 0) or ((PuzzState.l2 and c1.l2) <> 0) then
          begin
          Cube2point (i, tp2);
         Assert ((tp.x=tp2.x) and (tp.y=tp2.y) and (tp.z=tp2.z),' SetBitVec and Cube2Point not inverse!');
          end
        end;
      end;
readln;
end.
*)

for i:=1 to 12 do
  ct_teile[i].Empty;

{ Teil 1}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (-1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

ct_teile[1]:=tpt;

{ Teil 2}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

ct_teile[2]:=tpt;

{ Teil 3}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

ct_teile[3]:=tpt;

{ Teil 4}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,-1,0);
tpt.Add (tp);

ct_teile[4]:=tpt;

{ Teil 5}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (0,-1,0);
tpt.Add (tp);

tp.translate (0,0,1);
tpt.Add (tp);

ct_teile[5]:=tpt;


{ Teil 6}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (-2,0,0);
tpt.Add (tp);

ct_teile[6]:=tpt;

{ Teil 7}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (0,-1,0);
tpt.Add (tp);

ct_teile[7]:=tpt;

{ Teil 8}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

ct_teile[8]:=tpt;

{ Teil 9}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (-1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,0,1);
tpt.Add (tp);

ct_teile[9]:=tpt;

{ Teil 10}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (-1,1,0);
tpt.Add (tp);

ct_teile[10]:=tpt;

{ Teil 11}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (-1,1,0);
tpt.Add (tp);

tp.translate (-1,-1,0);
tpt.Add (tp);

ct_teile[11]:=tpt;

{ Teil 12}
tpt.empty;
tp.init (0,0,0);
tpt.Add (tp);

tp.translate (-1,0,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (0,1,0);
tpt.Add (tp);

tp.translate (1,0,0);
tpt.Add (tp);

tp.translate (-1,1,0);
tpt.Add (tp);

ct_teile[12]:=tpt;

(*
for i:=1 to 12 do
  writeln (i,' ',ct_teile[i].makebvlist(bvl));
{ Vergleich mit handberechneten Werten }
*)

for i:=1 to 12 do
  if i=5 then
    ct_bv_count[i]:=ct_teile[i].makebvlist (ct_bvl[i],False)
  else
    ct_bv_count[i]:=ct_teile[i].makebvlist (ct_bvl[i],True);

c1.l1:=0;
c1.l2:=0;
for i:=1 to 64 do
  begin
  Cube2Point (i-1,tp);
  FindRelevantTPs (tp,c1,ct_TeilPos[i]);
(*
  j:=1;
  while ct_TeilPos[i,j].Teil <> -1 do
    Inc (j);
  writeln (tp.x:2, tp.y:2, tp.z:2, j:4);
  readln;
*)
  end;

PuzzState.l1:=0;
PuzzState.l2:=0;


Solution_Count:=0;

Solve (PuzzState,[],0);

(*
PuzzState.l2:=$A00E;
PuzzState.l1:=$F00A00;
Solve (PuzzState,[1,12]);
*)
writeln;
write ('Suche vorbei um ');
PrintTime;
writeln;
writeln ('gefundene Lsungen: ',Solution_Count);
writeln ('<ENTER> drcken zum beenden!');
readln;
end.
