/* 
--- todo ---

- Ist es sinnvoll nach jedem(oder die ersten n level) Stein die
  rauszusortieren, die inzwischen nicht mehr moeglich sind? 

- Nimm zur Symmetrienverhinderung einen "3D"-Stein, damit die
  Anzahl der Kombinationen 4 kleiner.

--- erledigt ---

- der fuellUnmoeglichkeitsalgorithmus kann abbrechen nicht nur
  wenn zuwenig raum da ist sondern auch sofort wenn genug raum da ist.
  -> selbst jetzt bringts das nicht, da zu lahm

- Sortiere nicht nur nach der Position (60) sondern nimm nur die die
  nicht bereits unmoeglich sind, da sie die bereits belegten Positionen
  beinhalten.
  -> speed up 2.5

--- anmerkungen ---

- startreihenfolge uninteressant, da alle Kombinationen errechnet werden

*/

#include "stdafx.h"
#include <string>
#include <vector>
#include <time.h>
#include <conio.h>

using namespace std;

typedef unsigned __int64 BitVector;

struct MyInt64 {
    unsigned int highxx;
    unsigned int lowxx;
};

const int FormMax= 12;
const int FormNoSym= 0;
const int IdAll= (1 << FormMax) -1;
const int BVx= 5; // width  from left to right
const int BVy= 4; // depth  from front to back (!!! BVy <= BVx)
const int BVz= 3; // height from bottom to top (!!! BVz <= BVy)

const int BVxO= BVy*BVz;
const int BVyO= BVx*BVz;
const int BVzO= BVx*BVy;

const int Volume= BVz*BVzO;

const int FormsTurnedMax= 3200; // original ohne symmetrie 2964 sonst 3132 

#define COORD2IDX(ax,ay,az) (ax+(ay)*BVx+(az)*BVzO)


// -------------------------------------------------------------------------

struct Form {
    BitVector b;
    int idx;
    int idi;
    int x, y, z;
    int ps;
    bool act;
};

// Nicht wirklich noetig aber vermeidet Programmfehler da Expand notwendig
struct FormMini {
    int id, x, y, z;
    int b;
};

typedef vector<Form> FormVector;

class FormArr
{
public:
    FormVector fv;
    bool CheckAdd(const Form &f) 
    {
        //printf("\n%s", bv2matrix(bv).c_str());
        int l= fv.size();
        for(int i= 0; i < l; i++)
            if(fv[i].b == f.b)
                return false;
        fv.push_back(f);
        fv[l].ps= l;
//        printf("%d %d T\n%s", adds, l, bv2matrix(bv).c_str());
        return true;
    }
};

typedef FormArr FormStore[Volume][FormMax];

struct FormIdxPtr {
    int len;
    int idx;
    BitVector *bvp;
    int dummy;  // align 16 Bytes 
};

typedef FormIdxPtr FormIdxPtrArr[Volume][FormMax+1]; // FormMax+4 ist langsamer(Cashproblem?)

typedef BitVector BitVectorStore[FormsTurnedMax];

// -------------------------------------------------------------------------

// Achtung nur Koerper der Dimensionen kx,ky,kz erlaubt nach folgenden Reglen:
// Bei Missachtung krachts beim Drehen!
// kx <= BVy <= BVx
// ky <= BVz <= BVx
// kz <= BVz <= BVy <= BVx
const FormMini FormInit[FormMax] = { 
                                    ( 0),(4),(2),(1),(0x005f),  // 1111 
                                                                // 1 1

                                    ( 1),(4),(2),(1),(0x001f),  // 1111
                                                                // 1

                                    ( 2),(4),(2),(1),(0x002f),  // 1111
                                                                //  1

                                    ( 3),(3),(2),(1),(0x002f),  // 111
                                                                // 1 1 

                                    ( 4),(3),(3),(1),(0x007c),  //   1
                                                                // 111
                                                                // 1

                                    ( 5),(3),(3),(1),(0x0097),  // 111
                                                                //  1
                                                                //  1

                                    ( 6),(3),(2),(1),(0x001f),  // 111
                                                                // 11

                                    ( 7),(3),(3),(1),(0x0133),  // 11
                                                                //  11
                                                                //   1

                                    ( 8),(3),(3),(1),(0x007a),  //  1  
                                                                // 111
                                                                // 1

                                    ( 9),(3),(3),(1),(0x00ba),  //  1 
                                                                // 111
                                                                //  1

                                    (10),(2),(2),(2),(0x001f),  // 31
                                                                // 11

                                    (11),(2),(2),(2),(0x001b)   // 31
                                                                //  1
};


// -------------------------------------------------------------------------

static FormStore sto;
static FormArr fa[FormMax];
static clock_t myTime= 0;
static clock_t cyclicTime= 0;
static int cnt=0;
static int PosMax=0;
static BitVector BitVectorArr[Volume];
static int NextPosArr[Volume];
static int statops= 0;
static int cmsk= 0xffff;
static int supermsk= 0;
static int supercnt= 0;
static int cntmask= 0;
static int cntcall= 0;
static int cntsol= 0;
static FormIdxPtrArr fipa;
static BitVectorStore bvs;

// -------------------------------------------------------------------------

string bv2matrix(BitVector b);

// -------------------------------------------------------------------------

bool TurnYfromZtoX(Form &d, const Form s)
{
    d= s;
    d.x= s.z;
    d.z= s.x;
    d.b= 0;
    if(d.x > BVz)
        return false;
    for(int z= 0; z < s.z; ++z)
        for(int y= 0; y < s.y; ++y)
            for(int x= 0; x < s.x; ++x)
                if(s.b & ((BitVector)1 << COORD2IDX(x,y,z)))
                    d.b|= ((BitVector)1 << COORD2IDX(z,y,s.x-x-1));
    return true;
}

void TurnXfromYtoZ(Form &d, const Form s)
{
    d= s;
    d.y= s.z;
    d.z= s.y;
    d.b= 0;
    for(int z= 0; z < s.z; ++z)
        for(int y= 0; y < s.y; ++y)
            for(int x= 0; x < s.x; ++x)
                if(s.b & ((BitVector)1 << COORD2IDX(x,y,z)))
                    d.b|= ((BitVector)1 << COORD2IDX(x,s.z-z-1,y));
}

void TurnZfromXtoY(Form &d, const Form s)
{
    d= s;
    d.x= s.y;
    d.y= s.x;
    d.b= 0;
    for(int z= 0; z < s.z; ++z)
        for(int y= 0; y < s.y; ++y)
            for(int x= 0; x < s.x; ++x)
                if(s.b & ((BitVector)1 << COORD2IDX(x,y,z)))
                    d.b|= ((BitVector)1 << COORD2IDX(s.y-y-1,x,z));
}

void InitBitVectorArr(void)
{
    BitVector bv= 1;
    for(int i= 0; i < Volume; ++i)
    {
        BitVectorArr[i]= bv;
        bv<<= 1;
    }
}

string bv2matrix(BitVector b) {
    string s= "";
    for(int z= BVz-1; z >= 0; --z) {
        for(int y= 0; y < BVy; ++y) {
            for(int x= 0; x < BVx; ++x) {
                if(b & ((BitVector)1 << COORD2IDX(x,y,z)))
                    s+= "1";
                else 
                    s+= "0";
            }
            s+= " ";
        }
        s+= "\n";
    }
    return s;
}

bool bvFormInit(BitVector &bv, const Form &f, int x, int y, int z)
{
    bv= 0;
    if((f.x+x > BVx) || (f.y+y > BVy) || (f.z+z > BVz))
        return false;
    BitVector t= f.b;
    for(int c= z; c < z+f.z; ++c) 
        for(int b= y; b < y+f.y; ++b)
            for(int a= x; a < x+f.x; ++a) {
                if(t & (BitVector)1)
                    bv|= ((BitVector)1 << COORD2IDX(a,b,c));
                t>>= 1;
            }
    return true;
}

void FormExpand(Form &d, const FormMini &s)
{
    d.x= s.x;
    d.y= s.y;
    d.z= s.z;
    d.idx= 1<<s.id;
    d.idi= s.id;
    d.act= true;
    d.b= 0;
    BitVector t= s.b;
    for(int c= 0; c < s.z; ++c) 
        for(int b= 0; b < s.y; ++b)
            for(int a= 0; a < s.x; ++a) {
                if(t & (BitVector)1)
                    d.b|= ((BitVector)1 << COORD2IDX(a,b,c));
                t>>= 1;
            }
}

void FormShift(FormArr &b, const Form &f)
{
    Form t= f;
    for(int z= BVz-f.z; z >= 0; --z) 
        for(int y= BVy-f.y; y >= 0; --y) 
            for(int x= BVx-f.x; x >= 0; --x) 
            {
                t.b= f.b << COORD2IDX(x,y,z);
                b.CheckAdd(t);
            }
}

void FormTurn(FormArr &b, Form &f)
{
    FormShift(b, f);
    Form t;
    TurnZfromXtoY(t, f);
    FormShift(b, t);
    if(f.idi == FormNoSym)
        return;
    TurnZfromXtoY(f, t);
    FormShift(b, f);
    TurnZfromXtoY(t, f);
    FormShift(b, t);
}


void FormAll(FormArr &b, const Form &f)
{
    Form t= f;
    Form t1;
    FormTurn(b, t);
    t= f;
    for(int i= 0; i < 3; ++i)
    {
        if((i == 1) && (f.idi == FormNoSym))
            break;
        t1= t;
        TurnXfromYtoZ(t1, t);
        t= t1;
        FormTurn(b, t1);
    }
    if(TurnYfromZtoX(t, f)) 
    {
        t1= t;
        FormTurn(b, t);
        if(f.idi != FormNoSym)
        {    
            TurnYfromZtoX(t, t1);
            TurnYfromZtoX(t1, t);
            FormTurn(b, t1);
        }
    }        
}

void InitNextFreePos(void)
{
    int c= 0;
    int x,y,z,i;
    for(x= 0; x < BVx; ++x) {
        for(y= 0; y < BVy; ++y) {
            for(z= 0; z < BVz; ++z) {
                i= COORD2IDX(x,y,z);
                NextPosArr[c]= i;
                c= i;
            }
        }
    }
    NextPosArr[c]= Volume;
}

void InitFormIdx(void)
{
    int i, j, k, l, d;
    int b= FormsTurnedMax;
    BitVector *bp= bvs;
    
    for(i= 0; i < Volume; ++i) 
    {
        d= 0;
        for(j= 0; j < FormMax; ++j)
        {
            l= sto[i][j].fv.size();
            fipa[i][d].len= l;
            if(l > 0)
            {
                fipa[i][d].idx= sto[i][j].fv[0].idx;
                fipa[i][d++].bvp= bp;
                for(k= 0; k < l; ++k)
                {
                    *bp= sto[i][j].fv[k].b;
                    ++bp;
                    if(!--b)
                    {
                        printf("Mist! Zu viele gedrehte Elemente. Max ist %d!\n", FormsTurnedMax);
                        exit(1);
                    }
                }
            }
        }
        if(d == FormMax)
            fipa[i][d].len= 0;
    }
}
          
int NextFreePos(BitVector bv, int psp)
{
    while(psp < Volume)
    {
        if((bv & BitVectorArr[psp]) == 0)
            return psp;
        psp= NextPosArr[psp];
    }
    return psp;
}

int FormPosAdd(const Form &f)
{
    int stax= 0;
    BitVector bv= 0;
    BitVector av;
    int p= NextFreePos(bv, 0);
    while(p < Volume)
    {
        av= BitVectorArr[p];
        if((av & f.b) && ((bv & f.b) == 0))
        {
            sto[p][f.idi].fv.push_back(f);
            ++stax;
        }
        bv|= av;
        p= NextFreePos(bv, p);
    }
    return stax;
}

#ifdef _DEBUG

bool SolveQ(BitVector bv, int psp, int idx, int c)
{
    int i, m;
    int psi= 0;
    BitVector *bp;
    
    psp= NextFreePos(bv, psp);
    while((m= fipa[psp][psi].len) > 0)
    {
        if((idx & fipa[psp][psi].idx) == 0)
        {
            bp= fipa[psp][psi].bvp;
            for(i= 0; i < m; ++i)
            {
                if((bv & *bp) == 0) // 12778
                {
                    if(c < (FormMax-1))
                    {
                        if(SolveQ(bv|*bp, psp, idx|fipa[psp][psi].idx, c+1))
                            return true;
                    }
                    else
                    {
                        ++cnt;
                        if(cnt == 100) return true;
                    }
                }
                ++bp;
            }
        }
        ++psi;
    }
    return false;
}

#else

void SolveQ(BitVector bv, int psp, int idx, int c)
{
    int i, m;
    int psi= 0;
    BitVector *bp;
    
    psp= NextFreePos(bv, psp);
    while((m= fipa[psp][psi].len) > 0)
    {
        if((idx & fipa[psp][psi].idx) == 0)
        {
            bp= fipa[psp][psi].bvp;
            for(i= 0; i < m; ++i)
            {
                if((bv & *bp) == 0) // 12778
                {
                    if(c < (FormMax-1))
                        SolveQ(bv|*bp, psp, idx|fipa[psp][psi].idx, c+1);
                    else
                        ++cnt;
                }
                ++bp;
            }
        }
        ++psi;
    }
}

#endif

int main(int argc, char* argv[])
{
#ifdef _DEBUG
    printf("Solve Initializing...\n");
#endif 
    InitNextFreePos();
    InitBitVectorArr();
    Form f;
    FormArr y;
    int s= 0;    
    int n= 0;
    int x= 0;
    int i;
    for(i= 0; i < FormMax; ++i) 
    {
        FormExpand(f, FormInit[i]);
        y.fv.push_back(f); // nur fuellen egal wie damit kein read undef error
        FormAll(fa[i], f);
        int l= fa[i].fv.size();
        s+= l;
        for(int j= 0;j < l; j++)
        {
            fa[i].fv[j].ps= n++;
            x+= FormPosAdd(fa[i].fv[j]);
        }
    }
    InitFormIdx();

    PosMax= --n;
#ifdef _DEBUG
    printf("sum=%d,  average=%d, sumsort=%d \n\n\n", s, s/FormMax, x);

    printf("Start Solve()  ---------------------------------\n");
    _flushall();
#endif 
    cyclicTime= clock();
    statops= cntmask= cntcall= 0;
    myTime= clock();
    cnt= 0;
    SolveQ(0,0,0,0);
    printf("Anzahl Kombinationen=%d\n", cnt);
#ifndef x_DEBUG
    myTime= clock()-myTime;
    printf("Timediff=%d   Seconds=%5.3f    Minutes=%5.3f\n", 
           myTime, ((double)myTime)/CLOCKS_PER_SEC,
           ((double)myTime)/CLOCKS_PER_SEC/60);
#endif 
    return 0;
}

