//
//  Part.java
//  Cube
//
//  Created by Gunter Blache on Sun Dec 15 2002.
//  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
//


import Part;
import java.util.*;

public class Part {
    //protected boolean cubelets[][][];
    protected int cubelets[][];
    protected int packed[];
    protected int sizeX,sizeY,sizeZ;
    protected int translationStep=1;

    public Part(boolean c[][][],int t) {
        this(c);
        translationStep=t;
    }
    
    protected int[][] booleanToInt(boolean c[][][],int count) {
        int cubelets[][]=new int[count][];
        count=0;
        for (int x=0;x<sizeX;x++) {
            for (int y=0;y<sizeY;y++) {
                for (int z=0;z<sizeZ;z++) if (c[x][y][z]) cubelets[count++] = new int[] {x,y,z};
            }
        }
        return cubelets;
    }

    public Part(boolean c[][][]) {
        sizeX=c.length;
        sizeY=c[0].length;
        sizeZ=c[0][0].length;
        int count=0;
        for (int x=0;x<sizeX;x++) {
            if (c[x].length!=sizeY) throw new IllegalArgumentException("argument["+x+"].length must be "+sizeY);
            for (int y=0;y<sizeY;y++) {
                if (c[x][y].length!=sizeZ) throw new IllegalArgumentException("argument["+x+"]["+y+"].length must be "+sizeZ);
                for (int z=0;z<sizeZ;z++) if (c[x][y][z]) count++;
            }
        }
        cubelets=booleanToInt(c,count);
        packed=pack();
    }
    
    public Part(int c[][],int x,int y,int z,int t) {
        sizeX=x;
        sizeY=y;
        sizeZ=z;
        cubelets=c;
        translationStep=t;
        packed=pack();
    }

    public Part(int c[][],int x,int y,int z) {
        sizeX=x;
        sizeY=y;
        sizeZ=z;
        cubelets=c;
        packed=pack();
    }
        
    public int getSizeX() {
        return sizeX;
    }
    
    public int getSizeY() {
        return sizeY;
    }
    
    public int getSizeZ() {
        return sizeZ;
    }
    
    public boolean isCubelet(int x,int y,int z) {
        for (int i=0;i<cubelets.length;i++)
            if ((cubelets[i][0]==x) && (cubelets[i][1]==y) && (cubelets[i][2]==z)) return true;
        return false;
    }
    
    public int getTranslationStep() {
        return translationStep;
    }
    
    public void setTranslationStep(int s) {
        translationStep=s;
    }
    
    private int[] pack() {
        int part[] = new int[(sizeX*sizeY*sizeZ+31)/32];
        for (int i=0;i<cubelets.length;i++) {
            int m=cubelets[i][0]+(cubelets[i][1]+cubelets[i][2]*sizeY)*sizeX;
            part[m/32]|=1<<(m & 31);
        }
        return part;
    }
    
    public int[] getPacked() {
        return packed;
    }
    
    public int[] getPacked(int mapping[]) {
        int part[] = new int[(sizeX*sizeY*sizeZ+31)/32];
        for (int i=0;i<cubelets.length;i++) {
            int m=mapping[cubelets[i][0]+(cubelets[i][1]+cubelets[i][2]*sizeY)*sizeX];
            part[m/32]|=1<<(m & 31);
        }
        return part;
    }
    
    public int size() {
        return cubelets.length;
    }
    
    private int[][][] rotateAll() {
        return new int[][][] {
            {{ 0, 1, 0,      0},{-1, 0, 0,sizeX-1},{ 0, 0, 1,      0}},
            {{-1, 0, 0,sizeX-1},{ 0,-1, 0,sizeY-1},{ 0, 0, 1,      0}},
            {{ 0,-1, 0,sizeY-1},{ 1, 0, 0,      0},{ 0, 0, 1,      0}},
            {{ 0, 0,-1,sizeZ-1},{ 0, 1, 0,      0},{ 1, 0, 0,      0}},
            {{ 0, 0,-1,sizeZ-1},{-1, 0, 0,sizeX-1},{ 0, 1, 0,      0}},
            {{ 0, 0,-1,sizeZ-1},{ 0,-1, 0,sizeY-1},{-1, 0, 0,sizeX-1}},
            {{ 0, 0,-1,sizeZ-1},{ 1, 0, 0,      0},{ 0,-1, 0,sizeY-1}},
            {{-1, 0, 0,sizeX-1},{ 0, 1, 0,      0},{ 0, 0,-1,sizeZ-1}},
            {{ 0,-1, 0,sizeY-1},{-1, 0, 0,sizeX-1},{ 0, 0,-1,sizeZ-1}},
            {{ 1, 0, 0,      0},{ 0,-1, 0,sizeY-1},{ 0, 0,-1,sizeZ-1}},
            {{ 0, 1, 0,      0},{ 1, 0, 0,      0},{ 0, 0,-1,sizeZ-1}},
            {{ 0, 0, 1,      0},{ 0, 1, 0,      0},{-1, 0, 0,sizeX-1}},
            {{ 0, 0, 1,      0},{-1, 0, 0,sizeX-1},{ 0,-1, 0,sizeY-1}},
            {{ 0, 0, 1,      0},{ 0,-1, 0,sizeY-1},{ 1, 0, 0,      0}},
            {{ 0, 0, 1,      0},{ 1, 0, 0,      0},{ 0, 1, 0,      0}},
            {{ 1, 0, 0,      0},{ 0, 0, 1,      0},{ 0,-1, 0,sizeY-1}},
            {{ 0, 1, 0,      0},{ 0, 0, 1,      0},{ 1, 0, 0,      0}},
            {{-1, 0, 0,sizeX-1},{ 0, 0, 1,      0},{ 0, 1, 0,      0}},
            {{ 0,-1, 0,sizeY-1},{ 0, 0, 1,      0},{-1, 0, 0,sizeX-1}},
            {{-1, 0, 0,sizeX-1},{ 0, 0,-1,sizeZ-1},{ 0,-1, 0,sizeY-1}},
            {{ 0,-1, 0,sizeY-1},{ 0, 0,-1,sizeZ-1},{ 1, 0, 0,      0}},
            {{ 1, 0, 0,      0},{ 0, 0,-1,sizeZ-1},{ 0, 1, 0,      0}},
            {{ 0, 1, 0,      0},{ 0, 0,-1,sizeZ-1},{-1, 0, 0,sizeX-1}}
        };
    }
    
    private int[][][] rotate() {
        if ((sizeX==sizeY) && (sizeX==sizeZ)) // && sizeY==sizeZ
            return rotateAll();
        else if (sizeY==sizeX) // && sizeX!=sizeZ && sizeY!=sizeZ
            return new int[][][] {
                {{ 0, 1, 0,      0},{-1, 0, 0,sizeX-1},{ 0, 0, 1,      0}},
                {{-1, 0, 0,sizeX-1},{ 0,-1, 0,sizeY-1},{ 0, 0, 1,      0}},
                {{ 0,-1, 0,sizeY-1},{ 1, 0, 0,      0},{ 0, 0, 1,      0}},
                {{-1, 0, 0,sizeX-1},{ 0, 1, 0,      0},{ 0, 0,-1,sizeZ-1}},
                {{ 0,-1, 0,sizeY-1},{-1, 0, 0,sizeX-1},{ 0, 0,-1,sizeZ-1}},
                {{ 1, 0, 0,      0},{ 0,-1, 0,sizeY-1},{ 0, 0,-1,sizeZ-1}},
                {{ 0, 1, 0,      0},{ 1, 0, 0,      0},{ 0, 0,-1,sizeZ-1}}
            };
        else if (sizeZ==sizeX) // && sizeX!=sizeY && sizeZ!=sizeY
            return new int[][][] {
                {{-1, 0, 0,sizeX-1},{ 0,-1, 0,sizeY-1},{ 0, 0, 1,      0}},
                {{ 0, 0,-1,sizeZ-1},{ 0, 1, 0,      0},{ 1, 0, 0,      0}},
                {{ 0, 0,-1,sizeZ-1},{ 0,-1, 0,sizeY-1},{-1, 0, 0,sizeX-1}},
                {{-1, 0, 0,sizeX-1},{ 0, 1, 0,      0},{ 0, 0,-1,sizeZ-1}},
                {{ 1, 0, 0,      0},{ 0,-1, 0,sizeY-1},{ 0, 0,-1,sizeZ-1}},
                {{ 0, 0, 1,      0},{ 0, 1, 0,      0},{-1, 0, 0,sizeX-1}},
                {{ 0, 0, 1,      0},{ 0,-1, 0,sizeY-1},{ 1, 0, 0,      0}}
            };
        else if (sizeY==sizeZ) // && sizeX!=sizeY && sizeX!=sizeZ
            return new int[][][] {
                {{-1, 0, 0,sizeX-1},{ 0,-1, 0,sizeY-1},{ 0, 0, 1,      0}},
                {{-1, 0, 0,sizeX-1},{ 0, 1, 0,      0},{ 0, 0,-1,sizeZ-1}},
                {{ 1, 0, 0,      0},{ 0,-1, 0,sizeY-1},{ 0, 0,-1,sizeZ-1}},
                {{ 1, 0, 0,      0},{ 0, 0, 1,      0},{ 0,-1, 0,sizeY-1}},
                {{-1, 0, 0,sizeX-1},{ 0, 0, 1,      0},{ 0, 1, 0,      0}},
                {{-1, 0, 0,sizeX-1},{ 0, 0,-1,sizeZ-1},{ 0,-1, 0,sizeY-1}},
                {{ 1, 0, 0,      0},{ 0, 0,-1,sizeZ-1},{ 0, 1, 0,      0}}
            };
        else // sizeX!=sizeY && sizeX!=sizeZ && sizeY!=sizeZ
            return new int[][][] {
                {{-1, 0, 0,sizeX-1},{ 0,-1, 0,sizeY-1},{ 0, 0, 1,      0}},
                {{-1, 0, 0,sizeX-1},{ 0, 1, 0,      0},{ 0, 0,-1,sizeZ-1}},
                {{ 1, 0, 0,      0},{ 0,-1, 0,sizeY-1},{ 0, 0,-1,sizeZ-1}}
            };
    }
    
    private int transformRow(int row[],int x,int y, int z) {
        return x*row[0]+y*row[1]+z*row[2]+row[3];
    }
    
    protected int[][] transform(int c[][],int r[][]) throws Exception {
        int tr[][] = new int[c.length][3];
        for (int i=0;i<c.length;i++) {
            int x=c[i][0],y=c[i][1],z=c[i][2];
            int xs = transformRow(r[0],x,y,z);
            int ys = transformRow(r[1],x,y,z);
            int zs = transformRow(r[2],x,y,z);
            if ((xs>=0) && (xs<sizeX) && (ys>=0) && (ys<sizeY) && (zs>=0) && (zs<sizeZ))
                {tr[i][0]=xs;tr[i][1]=ys;tr[i][2]=zs;}
            else throw new Exception();
        
        }
        return tr;        
    }
    
    protected Part transform(int r[][]) throws Exception {
        return new Part(transform(cubelets,r),sizeX,sizeY,sizeZ,translationStep);
    }
    
    private Part[] rotateCube() {
        Vector r = new Vector();
        int rot[][][] = rotate();
        for (int i=0;i<rot.length;i++) {
            try {
                r.add(transform(rot[i]));
            } catch (Exception e) {
            }
        }
        Part p[] = new Part[r.size()];
        r.copyInto(p);
        return p;
    }
    
    protected int[][] rotateNormalised(int cubelets[][],int r[][],int xmin,int ymin,int zmin) 
        throws Exception {
        int tr[][] = new int[cubelets.length][3];
        for (int i=0;i<cubelets.length;i++) {
            int x=cubelets[i][0],y=cubelets[i][1],z=cubelets[i][2];
            tr[i][0] = transformRow(r[0],x,y,z)-xmin;
            tr[i][1] = transformRow(r[1],x,y,z)-ymin;
            tr[i][2] = transformRow(r[2],x,y,z)-zmin;
        }
        return tr;
    }

    protected Part rotateNormalised(int r[][],int xmin,int ymin,int zmin) throws Exception {
        return new Part(rotateNormalised(cubelets,r,xmin,ymin,zmin),sizeX,sizeY,sizeZ,translationStep);
    }

    private Part rotateNormalised(int r[][]) throws Exception {
        int xmin=sizeX,ymin=sizeY,zmin=sizeZ,xmax=0,ymax=0,zmax=0;
        for (int i=0;i<cubelets.length;i++) {
            int x=cubelets[i][0],y=cubelets[i][1],z=cubelets[i][2];
            int xs = transformRow(r[0],x,y,z);
            int ys = transformRow(r[1],x,y,z);
            int zs = transformRow(r[2],x,y,z);
            if (xs>xmax) xmax=xs;
            if (ys>ymax) ymax=ys;
            if (zs>zmax) zmax=zs;
            if (xs<xmin) xmin=xs;
            if (ys<ymin) ymin=ys;
            if (zs<zmin) zmin=zs;
        }
        if ((xmax-xmin>=sizeX) || (ymax-ymin>=sizeY) || (zmax-zmin>=sizeZ)) throw new Exception();
        return rotateNormalised(r,xmin,ymin,zmin);
    }
    
    private Part[] rotateNormalised() {
        HashSet t = new HashSet();
        t.add(this);
        int rot[][][]=rotateAll();
        for (int r=0;r<rot.length;r++) {
            try {
            	t.add(rotateNormalised(rot[r]));
            } catch (Exception e) {
            }
        }
        return (Part[])t.toArray(new Part[t.size()]);
    }
    
    protected int[][] move(int cubelets[][],int mx,int my,int mz) {
        int c[][] = new int[cubelets.length][3];
        for (int i=0;i<cubelets.length;i++) {
            c[i][0]=cubelets[i][0]+mx;
            c[i][1]=cubelets[i][1]+my;
            c[i][2]=cubelets[i][2]+mz;
        }
        return c;
    }
    
    protected Part move(int mx,int my,int mz) throws Exception {
        return new Part(move(cubelets,mx,my,mz),sizeX,sizeY,sizeZ,translationStep);
    }
    
    private Part[] move() {
        int xmin=sizeX,ymin=sizeY,zmin=sizeZ,xmax=0,ymax=0,zmax=0;
        for (int i=0;i<cubelets.length;i++) {
            int x=cubelets[i][0],y=cubelets[i][1],z=cubelets[i][2];
            if (x>xmax) xmax=x;
            if (y>ymax) ymax=y;
            if (z>zmax) zmax=z;
            if (x<xmin) xmin=x;
            if (y<ymin) ymin=y;
            if (z<zmin) zmin=z;
        }
        Vector t=new Vector((sizeX-xmax)*(sizeY-ymax)*(sizeZ-zmax)-1);
        for (int x=0;x<sizeX-xmax+xmin;x+=translationStep)
            for (int y=0;y<sizeY-ymax+ymin;y+=translationStep)
                for (int z=0;z<sizeZ-zmax+zmin;z+=translationStep)
                    try {
                        t.add(move(x-xmin,y-ymin,z-zmin));
                    } catch (Exception ex) {
                    }
        Part[] r = new Part[t.size()];
        t.copyInto(r);
        return r;
    }

    public Part[] transformedParts() {
        Part[] r = rotateNormalised();
        HashSet t=new HashSet();
        for (int i=0;i<r.length;i++) {
            Part m[] = r[i].move();
            for (int j=0;j<m.length;j++)
                t.add(m[j]);
        }
        return (Part[])t.toArray(new Part[t.size()]);
    }
    
    public Part[] transformedUnrotatedParts() {
        return transformedUnrotatedParts(transformedParts());
    }
    
    public static Part[] transformedUnrotatedParts(Part p[]) {
        HashSet t = new HashSet();
        for (int i=0;i<p.length;i++) {
            Part r[]=p[i].rotateCube();
            boolean found = false;
            for (int j=0;(!found) && (j<r.length);j++) 
                found|=t.contains(r[j]);
            if (!found) t.add(p[i]);
        }
        return (Part[])t.toArray(new Part[t.size()]);
    }
    
    public boolean equals(Object o) {
        if (!(o instanceof Part)) return false;
        Part p = (Part)o;
        if ((p.sizeX!=sizeX) || (p.sizeY!=sizeY) || (p.sizeZ!=sizeZ)) return false;
        int p1[]=packed,p2[]=((Part)o).packed;
        for (int i=0;i<p1.length;i++)
            if (p1[i]!=p2[i]) return false;
        return true;
    }
    
    public int hashCode() {
        int h=0;
        for (int i=0;i<packed.length;i++) h+=packed[i];
        return h;
    }

    protected void box(StringBuffer b,double x1,double y1,double z1,double x2,double y2,double z2,String colour) {
        b.append("box { <");
        b.append(x1);
        b.append(",");
        b.append(y1);
        b.append(",");
        b.append(z1);
        b.append(">, <");
        b.append(x2);
        b.append(",");
        b.append(y2);
        b.append(",");
        b.append(z2);
        b.append("> "+colour+" }\n");
    }

    public String povRay() {
        StringBuffer b= new StringBuffer();
        for (int i=0;i<cubelets.length;i++) {
            int x=cubelets[i][0],y=cubelets[i][1],z=cubelets[i][2];
            box(b,x,y,z,x+1,y+1,z+1," texture{pigment { color red 1 green 1 blue 1 }}");
        }
        return b.toString();
    }
}
