//
//  CubeGUI.java
//  Cube
//
//  Created by Gunter Blache on Sun Feb 02 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import java.util.Random;

public class CubeGUI extends JFrame {

    private static void setCubelet(boolean c[][][],int x1,int y1,int z1,int x2,int y2,int z2) {
        for (int x=x1;x<x2;x++)
            for (int y=y1;y<y2;y++)
                for (int z=z1;z<z2;z++)
                    c[x][y][z]=true;
    }
    
    private static Part[] ctCubeCommon() {
        Part p[] = new Part[12];
        boolean c[][][]; 
        // omit c of c't
        // omit first apostrophe
        c = new boolean[5][3][4];
        setCubelet(c,0,0,0,1,1,1);
        setCubelet(c,1,0,0,2,1,4);
        p[2] = new Part(c);    
        c = new boolean[5][3][4];
        setCubelet(c,0,0,0,1,1,4);
        setCubelet(c,1,0,2,2,1,3);
        p[3] = new Part(c);
        // omit second apostrope
        c = new boolean[5][3][4];
        setCubelet(c,1,0,0,2,1,2);
        setCubelet(c,0,0,2,3,1,3);
        p[5] = new Part(c);
        c = new boolean[5][3][4];
        setCubelet(c,0,0,0,2,1,2);
        setCubelet(c,1,0,2,2,1,3);
        p[6] = new Part(c);
        c = new boolean[5][3][4];
        setCubelet(c,0,0,0,1,1,1);
        setCubelet(c,1,0,0,2,1,2);
        setCubelet(c,2,0,1,3,1,3);
        p[7] = new Part(c);
        // omit third apostrophe
        c = new boolean[5][3][4];
        setCubelet(c,0,0,0,1,1,1);
        setCubelet(c,1,0,0,2,1,3);
        setCubelet(c,2,0,1,3,1,2);
        p[9] = new Part(c);
        c = new boolean[5][3][4];
        setCubelet(c,0,0,1,3,1,2);
        setCubelet(c,1,0,0,2,1,3);
        p[10] = new Part(c);
        // omit t of c't
        return p;
    }

    private static Part[] ctCubeCommonUnpainted() {
        Part p[] = ctCubeCommon();
        boolean c[][][] = new boolean[5][3][4]; // c of c't
        setCubelet(c,0,2,0,1,3,3);
        setCubelet(c,1,2,0,2,3,1);
        setCubelet(c,1,2,2,2,3,3);
        p[0] = new Part(c);
        c = new boolean[5][3][4]; // first apostrophe
        setCubelet(c,2,2,3,3,3,4);
        setCubelet(c,2,0,2,3,3,3);
        setCubelet(c,2,0,1,3,1,2);
        p[1] = new Part(c);
        c = new boolean[5][3][4]; // second apostrophe
        setCubelet(c,2,1,2,3,3,4);
        setCubelet(c,3,1,2,4,2,3);
        p[4] = new Part(c);
        c = new boolean[5][3][4]; // third apostrophe
        setCubelet(c,2,2,2,3,3,4);
        setCubelet(c,2,1,3,4,2,4);
        p[8] = new Part(c);
        c = new boolean[5][3][4]; // t of c't
        setCubelet(c,3,2,0,4,3,4);
        setCubelet(c,4,2,0,5,3,1);
        setCubelet(c,4,2,2,5,3,3);
        p[11] = new Part(c);
        return p;
    }


    private static Part[] ctCubeCommonPainted() {
        Part p[] = ctCubeCommon();
        boolean c[][][] = new boolean[5][3][4]; // c of c't
        setCubelet(c,0,2,0,1,3,3);
        setCubelet(c,1,2,0,2,3,1);
        setCubelet(c,1,2,2,2,3,3);
        p[0] = new PaintedPart(c,'y',3);
        c = new boolean[5][3][4]; // first apostrophe
        setCubelet(c,2,2,3,3,3,4);
        setCubelet(c,2,0,2,3,3,3);
        setCubelet(c,2,0,1,3,1,2);
        p[1] = new Part(c);
        c = new boolean[5][3][4]; // second apostrophe
        setCubelet(c,2,1,2,3,3,4);
        setCubelet(c,3,1,2,4,2,3);
        p[4] = new Part(c);
        c = new boolean[5][3][4]; // third apostrophe
        setCubelet(c,2,2,2,3,3,4);
        setCubelet(c,2,1,3,4,2,4);
        p[8] = new Part(c);
        c = new boolean[5][3][4]; // t of c't
        setCubelet(c,3,2,0,4,3,4);
        setCubelet(c,4,2,0,5,3,1);
        setCubelet(c,4,2,2,5,3,3);
        p[11] = new PaintedPart(c,'y',3);
        return p;
    }

    private static CubeSolver ctCubeUnpainted() {
        Part p[] = ctCubeCommonUnpainted();
//        (new Cube(p)).povRay("ctParts.txt");
//        return new BruteForceSolver(p);
        return new FirstBitSolver(p);
    }
    
    private static CubeSolver ctCubePainted1() {
        Part p[] = ctCubeCommonPainted();
        boolean c[][][];
        c = new boolean[5][3][4]; // first apostrophe
        setCubelet(c,2,2,3,3,3,4);
        setCubelet(c,2,0,2,3,3,3);
        setCubelet(c,2,0,1,3,1,2);
        p[1] = new PaintedPart(c,'y',3);
        Part q[] = new Part[9];
        Part r[] = new Part[3];
        r[0]=p[0];
        r[1]=p[1];
        q[0]=p[2];
        q[1]=p[3];
        q[2]=p[4];
        q[3]=p[5];
        q[4]=p[6];
        q[5]=p[7];
        q[6]=p[8];
        q[7]=p[9];
        q[8]=p[10];
        r[2]=p[11];
        (new Cube(p)).povRay("ctPartsPainted1.txt");
        return new BruteForceSolver(q,r);
    }

    private static CubeSolver ctCubePainted2() {
        Part p[] = ctCubeCommonPainted();
        boolean c[][][];
        c = new boolean[5][3][4]; // second apostrophe
        setCubelet(c,2,1,2,3,3,4);
        setCubelet(c,3,1,2,4,2,3);
        p[4] = new PaintedPart(c,'y',3);
        Part q[] = new Part[9];
        Part r[] = new Part[3];
        r[0]=p[0];
        q[0]=p[1];
        q[1]=p[2];
        q[2]=p[3];
        r[1]=p[4];
        q[3]=p[5];
        q[4]=p[6];
        q[5]=p[7];
        q[6]=p[8];
        q[7]=p[9];
        q[8]=p[10];
        r[2]=p[11];
        (new Cube(p)).povRay("ctPartsPainted2.txt");
        return new BruteForceSolver(q,r);
    }

    private static CubeSolver ctCubePainted3() {
        Part p[] = ctCubeCommonPainted();
        boolean c[][][];
        c = new boolean[5][3][4]; // third apostrophe
        setCubelet(c,2,2,2,3,3,4);
        setCubelet(c,2,1,3,4,2,4);
        p[8] = new PaintedPart(c,'y',3);
        Part q[] = new Part[9];
        Part r[] = new Part[3];
        r[0]=p[0];
        q[0]=p[1];
        q[1]=p[2];
        q[2]=p[3];
        q[3]=p[4];
        q[4]=p[5];
        q[5]=p[6];
        q[6]=p[7];
        r[1]=p[8];
        q[7]=p[9];
        q[8]=p[10];
        r[2]=p[11];
        (new Cube(p)).povRay("ctPartsPainted3.txt");
        return new BruteForceSolver(q,r);
    }

    private static void printSolver(CubeSolver cubeSolver) {
        try {
            FileWriter f = new FileWriter("SolveCube.java");
            PrintWriter pw = new PrintWriter(f);
            ((FirstBitSolver)cubeSolver).generateSolverClass(pw,2);
            pw.flush();
            f.close();
        } catch (IOException e) {
            System.out.println(e);
        }
    }

    public static void main(String args[]) {
        long startTime = System.currentTimeMillis();
        printSolver(ctCubeUnpainted());
        System.out.println("Duration : "+(System.currentTimeMillis()-startTime));
    }
}
